#ifndef __CRCFileTmpl_h
#define __CRCFileTmpl_h

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CRCFileTmpl.h : _xZkqqHx_iDhHiDgCiDfPiBfL_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

#include "stdafx.h"
#include "UtilErr.h"	// For FFThrowMiscUnknown.
#include "UtilMisc.h"	// For FFCalcCRC.

/////////////////////////////////////////////////////////////////////////////
// FCCRCFileTmpl32 _xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCCRCFileTmpl32
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CRC_xZkqqHx_iCmMiMhGiOfKiCpA_xHqqkZx_Read64/Write64_xZkqqHx_iOjOiCmJiOkJjDkOjDeJiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER> class FCCRCFileTmpl32 : public SUPER
{
// FCCRCFileTmpl32_xZkqqHx_iMmFjHeMiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_
public:
	FCCRCFileTmpl32 ();
	virtual flint	Seek64 (flint fliOff, DWORD dwFrom);
	virtual flint	Read64 (void* lpBuf, flint fliCount);
	virtual void	Write64 (const void* lpBuf, flint fliCount);
	virtual void	StartCRC (flint fliCount = FLINT_MAX);
	virtual WORD	StopCRC ();

// _xZkqqHx_iMmFjHeMiDiBiDjDiDgPjFmPjAjEiBeC_xHqqkZx_
protected:
	BOOL	m_bIsCalcCRC;					// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
	WORD	m_wCRC;							// CRC_xZkqqHx_jCgMiBeC_xHqqkZx_
	flint	m_fliCRCCount;					// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
	flint	m_fliCRCPosition;				// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
}; // FCCRCFileTmpl32.

template<class SUPER, class T> void operator << (FCCRCFileTmpl32<SUPER>& file, const T data)
{
	file.Write64(&data, sizeof(data));
} // template<class T> void operator <<.

template<class SUPER, class T> void operator >> (FCCRCFileTmpl32<SUPER>& file, T& data)
{
	file.Read64(&data, sizeof(data));
} // template<class T> void operator >>.

/////////////////////////////////////////////////////////////////////////////
// FCCRCFileTmpl _xZkqqHx_iDeOiDiJiDfIiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	FCCRCFileTmpl
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	CRC_xZkqqHx_iCmMiMhGiOfKiCpA_xHqqkZx_Read64/Write64_xZkqqHx_iOjOiCmJiOkJjDkOjDeJiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	04.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class SUPER> class FCCRCFileTmpl : public SUPER
{
// FCCRCFileTmpl_xZkqqHx_iMmFjHeMiDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_
public:
	FCCRCFileTmpl ();
//----- 05.12.31 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	virtual flint	Seek64 (flint fliOff, DWORD dwFrom);
//	virtual flint	Read64 (void* lpBuf, flint fliCount);
//	virtual void	Write64 (const void* lpBuf, flint fliCount);
//----- 05.12.31 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	virtual LONG	Seek (LONG lOff, UINT nFrom);
	virtual UINT	Read (void* lpBuf, UINT nCount);
	virtual void	Write (const void* lpBuf, UINT nCount);
//----- 05.12.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	virtual void	StartCRC (flint fliCount = FLINT_MAX);
	virtual WORD	StopCRC ();

// _xZkqqHx_iMmFjHeMiDiBiDjDiDgPjFmPjAjEiBeC_xHqqkZx_
protected:
	BOOL	m_bIsCalcCRC;					// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
	WORD	m_wCRC;							// CRC_xZkqqHx_jCgMiBeC_xHqqkZx_
	flint	m_fliCRCCount;					// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
	flint	m_fliCRCPosition;				// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
}; // FCCRCFileTmpl.

template<class SUPER, class T> void operator << (FCCRCFileTmpl<SUPER>& file, const T data)
{
	file.Write(&data, sizeof(data));
} // template<class T> void operator <<.

template<class SUPER, class T> void operator >> (FCCRCFileTmpl<SUPER>& file, T& data)
{
	file.Read(&data, sizeof(data));
} // template<class T> void operator >>.

/////////////////////////////////////////////////////////////////////////////
// FCCRCFileTmpl32_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

template<class SUPER>
FCCRCFileTmpl32<SUPER>::FCCRCFileTmpl32 ()
					:	SUPER(),
				 		m_bIsCalcCRC(FALSE)		// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
{
} // FCCRCFileTmpl32<SUPER>::FCCRCFileTmpl32.

template<class SUPER>
flint FCCRCFileTmpl32<SUPER>::Seek64 (flint fliOff, DWORD dwFrom)
{
	if (!m_bIsCalcCRC)
	//----- CRC_xZkqqHx_iMhGiOfKjCiGiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return SUPER::Seek64(fliOff, dwFrom);
	} else
	//----- CRC_xZkqqHx_iMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iInKjDkOiMoDiCmMjAfGiClFiCkCiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
		flint fliNewPosition;
		switch (dwFrom)
		{
		case FILE_BEGIN:
			fliNewPosition = fliOff;
			break;
		case FILE_CURRENT:
			fliNewPosition = SUPER::GetPosition64() + fliOff;
			break;
		case FILE_END:
			fliNewPosition = SUPER::GetLength64() + fliOff;
			break;
		default:
			FFThrowMiscUnknown();
		}
		if (m_fliCRCPosition < fliNewPosition)
		//------ _xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiCoGiCoIiCoAjAoGiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfIiDeMiDgCiDhGiClHiCoJiDgPiDeDiDgHjAjEiCpAiMhGiOfKiBeC_xHqqkZx_
			flint fliCount = fliNewPosition - SUPER::GetPosition64();
			//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDfIiDeMiDgCiDhG_xHqqkZx_ -----
			BYTE buff[1000];
			flint fliTmp = sizeof(buff);
			while (fliCount != 0 && fliTmp != 0)
			{
				fliTmp = (fliCount < sizeof(buff)) ? fliCount : sizeof(buff);
				fliTmp = Read64(buff, fliTmp);
				fliCount -= fliTmp;
			}
			return SUPER::GetPosition64();
		} else
		//------ _xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiCoGiCoIiCoAjBePiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			return SUPER::Seek64(fliOff, dwFrom);
		}
	}
} // FCCRCFileTmpl32<SUPER>::Seek64.

template<class SUPER>
flint FCCRCFileTmpl32<SUPER>::Read64 (void* lpBuf, flint fliCount)
{
	fliCount = SUPER::Read64(lpBuf, fliCount);

	if (m_bIsCalcCRC)
	//----- CRC_xZkqqHx_iCmMiMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//
		// m_fliCRCPosition :_xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
		//                   Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClN_xHqqkZx_
		//                   _xZkqqHx_iPoKiNiHiCmJiBeBiClBiCmMjFmPjAjEiCkKjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
		// fliCRCCount      :CRC_xZkqqHx_iCmMiMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
		// lpBufCRCTop      :CRC_xZkqqHx_iCmMiMhGiOfKiCpAiOgOiCnPiCoJiImKjChFiBeC_xHqqkZx_
		//
		//-------------------------------------------------------------------------------------
		// CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCmFiCmNiBeB_xHqqkZx_Seek64(+n)_xZkqqHx_iCoAiPoNiCmJ_xHqqkZx_Read64_xZkqqHx_iCpAiOmAiNhDiClHiCoJiClNiCnPiBeBiImIiJlKiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
		//
		//                  lpBufTop
		//                     _xZkqqHx_iBkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//                     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//           _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_
		//           _xZkqqHx_iEkA_xHqqkZx_   fliTopPosition         GetPosition64() 
		//           _xZkqqHx_iEkA_xHqqkZx_
		//      m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCnMiCmFjCeCiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeB_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClFiCmIiCkCiBeC_xHqqkZx_
		//
		//         lpBufTop
		//            _xZkqqHx_iBkL_xHqqkZx_                         _xZkqqHx_iCkJiCmCiCmEjDmHiCnNiNjOiCpBiClOiClBiCmGiCkKiCkAiCoJiDgGiBfLiDfO_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition         GetPosition64()  _xZkqqHx_iEkA_xHqqkZx_
		//                                               _xZkqqHx_iEkA_xHqqkZx_
		//                                         m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCpAjClEiCkGiCmEiCkCiCoJiCmMiCmFiBeBjClEiCkGiClNjFkKiClOiCkP_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		//
		//         lpBufTop     lpBufCRCTop
		//            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkJiBkJiEjPiEjPiBkIiEkJ_xHqqkZx_ fliCRCCount 
		//            _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_            _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition     _xZkqqHx_iEkA_xHqqkZx_   GetPosition64()
		//                          _xZkqqHx_iEkA_xHqqkZx_
		//                  m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		//
		const flint fliCRCCount = SUPER::GetPosition64() - m_fliCRCPosition;
		if (0 < fliCRCCount)
		//----- CRC_xZkqqHx_iMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			const fliTopPosition = SUPER::GetPosition64() - fliCount;
			const BYTE* lpBufTop = (const BYTE*)lpBuf;
			// CRC_xZkqqHx_iCmMiMhGiOfKiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
			const BYTE* lpBufCRCTop = lpBufTop + (m_fliCRCPosition - fliTopPosition);
			// CRC_xZkqqHx_iCmMiMhGiOfKiDgPiDeDiDgHjAjEiCmJiPoDiMmAiCkKiCkAiCoJiCmMiCmFiBeBiClLiCmMiPoDiMmAjCgMiCpAjClEiCkGiCmIiCkCiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			flint fliTmp = (m_fliCRCCount < fliCRCCount) ? m_fliCRCCount : fliCRCCount;
			m_wCRC = FFCalcCRC(fliTmp, lpBufCRCTop, m_wCRC);
			// CRC_xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
			m_fliCRCCount -= fliTmp;
			// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
			m_fliCRCPosition += fliTmp;
			// _xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCpAiPeJjHlJiBeC_xHqqkZx_
			if (m_fliCRCCount == 0) StopCRC();
		}
	}

	return fliCount;
} // FCCRCFileTmpl32<SUPER>::Read64.

template<class SUPER>
void FCCRCFileTmpl32<SUPER>::Write64 (const void* lpBuf, flint fliCount)
{
	SUPER::Write64(lpBuf, fliCount);
	if (m_bIsCalcCRC)
	//----- CRC_xZkqqHx_iCmMiMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//
		// m_fliCRCPosition :_xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
		//                   Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClN_xHqqkZx_
		//                   _xZkqqHx_iPoKiNiHiCmJiBeBiClBiCmMjFmPjAjEiCkKjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
		// fliCRCCount      :CRC_xZkqqHx_iCmMiMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
		// lpBufCRCTop      :CRC_xZkqqHx_iCmMiMhGiOfKiCpAiOgOiCnPiCoJiImKjChFiBeC_xHqqkZx_
		//
		//-------------------------------------------------------------------------------------
		// CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCmFiCmNiBeB_xHqqkZx_Seek64(+n)_xZkqqHx_iCoAiPoNiCmJ_xHqqkZx_Read64_xZkqqHx_iCpAiOmAiNhDiClHiCoJiClNiCnPiBeBiImIiJlKiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
		//
		//                  lpBufTop
		//                     _xZkqqHx_iBkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//                     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//           _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_
		//           _xZkqqHx_iEkA_xHqqkZx_   fliTopPosition         GetPosition64() 
		//           _xZkqqHx_iEkA_xHqqkZx_
		//      m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCnMiCmFjCeCiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeB_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClFiCmIiCkCiBeC_xHqqkZx_
		//
		//         lpBufTop
		//            _xZkqqHx_iBkL_xHqqkZx_                         _xZkqqHx_iCkJiCmCiCmEjDmHiCnNiNjOiCpBiClOiClBiCmGiCkKiCkAiCoJiDgGiBfLiDfO_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition         GetPosition64()  _xZkqqHx_iEkA_xHqqkZx_
		//                                               _xZkqqHx_iEkA_xHqqkZx_
		//                                         m_fliCRCPosition
		// _xZkqqHx_iBkGiClBiCmMiPoKiNiHiCmNiClNiCnEiCpBiCnMiClIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDeHiDiJiBfLiPeJjHlJiClDiClJiCoJjFeLjHhGiCkKiCkAiCoJiCkKiBeBiMoDiJpBiClFiBeC_xHqqkZx_
		//
		//-------------------------------------------------------------------------------------
		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCpAjClEiCkGiCmEiCkCiCoJiCmMiCmFiBeBjClEiCkGiClNjFkKiClOiCkP_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		//
		//         lpBufTop     lpBufCRCTop
		//            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkJiBkJiEjPiEjPiBkIiEkJ_xHqqkZx_ fliCRCCount 
		//            _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_            _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition     _xZkqqHx_iEkA_xHqqkZx_   GetPosition64()
		//                          _xZkqqHx_iEkA_xHqqkZx_
		//                  m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		//
		const flint fliCRCCount = SUPER::GetPosition64() - m_fliCRCPosition;
		if (0 < fliCRCCount)
		//----- CRC_xZkqqHx_iMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			const fliTopPosition = SUPER::GetPosition64() - fliCount;
			const BYTE* lpBufTop = (const BYTE*)lpBuf;
			// CRC_xZkqqHx_iCmMiMhGiOfKiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
			const BYTE* lpBufCRCTop = lpBufTop + (m_fliCRCPosition - fliTopPosition);
			// CRC_xZkqqHx_iCmMiMhGiOfKiDgPiDeDiDgHjAjEiCmJiPoDiMmAiCkKiCkAiCoJiCmMiCmFiBeBiClLiCmMiPoDiMmAjCgMiCpAjClEiCkGiCmIiCkCiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			flint fliTmp = (m_fliCRCCount < fliCRCCount) ? m_fliCRCCount : fliCRCCount;
			m_wCRC = FFCalcCRC(fliTmp, lpBufCRCTop, m_wCRC);
			// CRC_xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
			m_fliCRCCount -= fliTmp;
			// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
			m_fliCRCPosition += fliTmp;
			// _xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCpAiPeJjHlJiBeC_xHqqkZx_
			if (m_fliCRCCount == 0) StopCRC();
		}
	}
} // FCCRCFileTmpl32<SUPER>::Write64.

template<class SUPER>
void FCCRCFileTmpl32<SUPER>::StartCRC (flint fliCount)
{
	m_bIsCalcCRC = TRUE;						// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
	m_wCRC = FD_CRC_INIT_VALUE;					// CRC_xZkqqHx_jCgMiBeC_xHqqkZx_
	m_fliCRCCount = fliCount;					// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
	m_fliCRCPosition = SUPER::GetPosition64();	// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
} // FCCRCFileTmpl32<SUPER>::StartCRC.

template<class SUPER>
WORD FCCRCFileTmpl32<SUPER>::StopCRC ()
{
	m_bIsCalcCRC = FALSE;	// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
	return m_wCRC;			// CRC_xZkqqHx_jCgMiBeC_xHqqkZx_
} // FCCRCFileTmpl32<SUPER>::StopCRC.

/////////////////////////////////////////////////////////////////////////////
// FCCRCFileTmpl_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

template<class SUPER>
FCCRCFileTmpl<SUPER>::FCCRCFileTmpl ()
					:	SUPER(),
				 		m_bIsCalcCRC(FALSE)		// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
{
} // FCCRCFileTmpl<SUPER>::FCCRCFileTmpl.

//----- 05.12.31 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//template<class SUPER>
//flint FCCRCFileTmpl<SUPER>::Seek64 (flint fliOff, DWORD dwFrom)
//{
//	if (!m_bIsCalcCRC)
//	//----- CRC_xZkqqHx_iMhGiOfKjCiGiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
//	{
//		return SUPER::Seek64(fliOff, dwFrom);
//	} else
//	//----- CRC_xZkqqHx_iMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		// _xZkqqHx_iInKjDkOiMoDiCmMjAfGiClFiCkCiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
//		flint fliNewPosition;
//		switch (dwFrom)
//		{
//		case FILE_BEGIN:
//			fliNewPosition = fliOff;
//			break;
//		case FILE_CURRENT:
//			fliNewPosition = SUPER::GetPosition64() + fliOff;
//			break;
//		case FILE_END:
//			fliNewPosition = SUPER::GetLength64() + fliOff;
//			break;
//		default:
//			FFThrowMiscUnknown();
//		}
//		if (m_fliCRCPosition < fliNewPosition)
//		//------ _xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiCoGiCoIiCoAjAoGiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			// _xZkqqHx_iDfIiDeMiDgCiDhGiClHiCoJiDgPiDeDiDgHjAjEiCpAiMhGiOfKiBeC_xHqqkZx_
//			flint fliCount = fliNewPosition - SUPER::GetPosition64();
//			//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDfIiDeMiDgCiDhG_xHqqkZx_ -----
//			BYTE buff[1000];
//			flint fliTmp = sizeof(buff);
//			while (fliCount != 0 && fliTmp != 0)
//			{
//				fliTmp = (fliCount < sizeof(buff)) ? fliCount : sizeof(buff);
//				fliTmp = Read64(buff, fliTmp);
//				fliCount -= fliTmp;
//			}
//			return SUPER::GetPosition64();
//		} else
//		//------ _xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiCoGiCoIiCoAjBePiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			return SUPER::Seek64(fliOff, dwFrom);
//		}
//	}
//} // FCCRCFileTmpl<SUPER>::Seek64.
//
//template<class SUPER>
//flint FCCRCFileTmpl<SUPER>::Read64 (void* lpBuf, flint fliCount)
//{
//	fliCount = SUPER::Read64(lpBuf, fliCount);
//
//	if (m_bIsCalcCRC)
//	//----- CRC_xZkqqHx_iCmMiMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		//
//		// m_fliCRCPosition :_xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
//		//                   Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClN_xHqqkZx_
//		//                   _xZkqqHx_iPoKiNiHiCmJiBeBiClBiCmMjFmPjAjEiCkKjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
//		// fliCRCCount      :CRC_xZkqqHx_iCmMiMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
//		// lpBufCRCTop      :CRC_xZkqqHx_iCmMiMhGiOfKiCpAiOgOiCnPiCoJiImKjChFiBeC_xHqqkZx_
//		//
//		//-------------------------------------------------------------------------------------
//		// CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCmFiCmNiBeB_xHqqkZx_Seek64(+n)_xZkqqHx_iCoAiPoNiCmJ_xHqqkZx_Read64_xZkqqHx_iCpAiOmAiNhDiClHiCoJiClNiCnPiBeBiImIiJlKiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
//		//
//		//                  lpBufTop
//		//                     _xZkqqHx_iBkL_xHqqkZx_
//		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
//		//                     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
//		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
//		//           _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_
//		//           _xZkqqHx_iEkA_xHqqkZx_   fliTopPosition         GetPosition64() 
//		//           _xZkqqHx_iEkA_xHqqkZx_
//		//      m_fliCRCPosition
//		//
//		//-------------------------------------------------------------------------------------
//		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCnMiCmFjCeCiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeB_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClFiCmIiCkCiBeC_xHqqkZx_
//		//
//		//         lpBufTop
//		//            _xZkqqHx_iBkL_xHqqkZx_                         _xZkqqHx_iCkJiCmCiCmEjDmHiCnNiNjOiCpBiClOiClBiCmGiCkKiCkAiCoJiDgGiBfLiDfO_xHqqkZx_
//		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
//		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
//		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
//		//            _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_
//		//       fliTopPosition         GetPosition64()  _xZkqqHx_iEkA_xHqqkZx_
//		//                                               _xZkqqHx_iEkA_xHqqkZx_
//		//                                         m_fliCRCPosition
//		//
//		//-------------------------------------------------------------------------------------
//		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCpAjClEiCkGiCmEiCkCiCoJiCmMiCmFiBeBjClEiCkGiClNjFkKiClOiCkP_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//		//
//		//         lpBufTop     lpBufCRCTop
//		//            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkJiBkJiEjPiEjPiBkIiEkJ_xHqqkZx_ fliCRCCount 
//		//            _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
//		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
//		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
//		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
//		//            _xZkqqHx_iBkK_xHqqkZx_            _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
//		//       fliTopPosition     _xZkqqHx_iEkA_xHqqkZx_   GetPosition64()
//		//                          _xZkqqHx_iEkA_xHqqkZx_
//		//                  m_fliCRCPosition
//		//
//		//-------------------------------------------------------------------------------------
//		//
//		const flint fliCRCCount = SUPER::GetPosition64() - m_fliCRCPosition;
//		if (0 < fliCRCCount)
//		//----- CRC_xZkqqHx_iMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			const fliTopPosition = SUPER::GetPosition64() - fliCount;
//			const BYTE* lpBufTop = (const BYTE*)lpBuf;
//			// CRC_xZkqqHx_iCmMiMhGiOfKiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
//			const BYTE* lpBufCRCTop = lpBufTop + (m_fliCRCPosition - fliTopPosition);
//			// CRC_xZkqqHx_iCmMiMhGiOfKiDgPiDeDiDgHjAjEiCmJiPoDiMmAiCkKiCkAiCoJiCmMiCmFiBeBiClLiCmMiPoDiMmAjCgMiCpAjClEiCkGiCmIiCkCiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//			flint fliTmp = (m_fliCRCCount < fliCRCCount) ? m_fliCRCCount : fliCRCCount;
//			m_wCRC = FFCalcCRC(fliTmp, lpBufCRCTop, m_wCRC);
//			// CRC_xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
//			m_fliCRCCount -= fliTmp;
//			// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
//			m_fliCRCPosition += fliTmp;
//			// _xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCpAiPeJjHlJiBeC_xHqqkZx_
//			if (m_fliCRCCount == 0) StopCRC();
//		}
//	}
//
//	return fliCount;
//} // FCCRCFileTmpl<SUPER>::Read64.
//
//template<class SUPER>
//void FCCRCFileTmpl<SUPER>::Write64 (const void* lpBuf, flint fliCount)
//{
//	SUPER::Write64(lpBuf, fliCount);
//	if (m_bIsCalcCRC)
//	//----- CRC_xZkqqHx_iCmMiMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
//	{
//		//
//		// m_fliCRCPosition :_xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
//		//                   Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClN_xHqqkZx_
//		//                   _xZkqqHx_iPoKiNiHiCmJiBeBiClBiCmMjFmPjAjEiCkKjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
//		// fliCRCCount      :CRC_xZkqqHx_iCmMiMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
//		// lpBufCRCTop      :CRC_xZkqqHx_iCmMiMhGiOfKiCpAiOgOiCnPiCoJiImKjChFiBeC_xHqqkZx_
//		//
//		//-------------------------------------------------------------------------------------
//		// CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCmFiCmNiBeB_xHqqkZx_Seek64(+n)_xZkqqHx_iCoAiPoNiCmJ_xHqqkZx_Read64_xZkqqHx_iCpAiOmAiNhDiClHiCoJiClNiCnPiBeBiImIiJlKiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
//		//
//		//                  lpBufTop
//		//                     _xZkqqHx_iBkL_xHqqkZx_
//		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
//		//                     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
//		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
//		//           _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_
//		//           _xZkqqHx_iEkA_xHqqkZx_   fliTopPosition         GetPosition64() 
//		//           _xZkqqHx_iEkA_xHqqkZx_
//		//      m_fliCRCPosition
//		//
//		//-------------------------------------------------------------------------------------
//		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCnMiCmFjCeCiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeB_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClFiCmIiCkCiBeC_xHqqkZx_
//		//
//		//         lpBufTop
//		//            _xZkqqHx_iBkL_xHqqkZx_                         _xZkqqHx_iCkJiCmCiCmEjDmHiCnNiNjOiCpBiClOiClBiCmGiCkKiCkAiCoJiDgGiBfLiDfO_xHqqkZx_
//		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
//		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
//		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
//		//            _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_
//		//       fliTopPosition         GetPosition64()  _xZkqqHx_iEkA_xHqqkZx_
//		//                                               _xZkqqHx_iEkA_xHqqkZx_
//		//                                         m_fliCRCPosition
//		//
//		//-------------------------------------------------------------------------------------
//		// Seek64(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
//		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCpAjClEiCkGiCmEiCkCiCoJiCmMiCmFiBeBjClEiCkGiClNjFkKiClOiCkP_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
//		//
//		//         lpBufTop     lpBufCRCTop
//		//            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkJiBkJiEjPiEjPiBkIiEkJ_xHqqkZx_ fliCRCCount 
//		//            _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
//		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
//		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
//		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
//		//            _xZkqqHx_iBkK_xHqqkZx_            _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
//		//       fliTopPosition     _xZkqqHx_iEkA_xHqqkZx_   GetPosition64()
//		//                          _xZkqqHx_iEkA_xHqqkZx_
//		//                  m_fliCRCPosition
//		//
//		//-------------------------------------------------------------------------------------
//		//
//		const flint fliCRCCount = SUPER::GetPosition64() - m_fliCRCPosition;
//		if (0 < fliCRCCount)
//		//----- CRC_xZkqqHx_iMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
//		{
//			const fliTopPosition = SUPER::GetPosition64() - fliCount;
//			const BYTE* lpBufTop = (const BYTE*)lpBuf;
//			// CRC_xZkqqHx_iCmMiMhGiOfKiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
//			const BYTE* lpBufCRCTop = lpBufTop + (m_fliCRCPosition - fliTopPosition);
//			// CRC_xZkqqHx_iCmMiMhGiOfKiDgPiDeDiDgHjAjEiCmJiPoDiMmAiCkKiCkAiCoJiCmMiCmFiBeBiClLiCmMiPoDiMmAjCgMiCpAjClEiCkGiCmIiCkCiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
//			flint fliTmp = (m_fliCRCCount < fliCRCCount) ? m_fliCRCCount : fliCRCCount;
//			m_wCRC = FFCalcCRC(fliTmp, lpBufCRCTop, m_wCRC);
//			// CRC_xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
//			m_fliCRCCount -= fliTmp;
//			// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
//			m_fliCRCPosition += fliTmp;
//			// _xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCpAiPeJjHlJiBeC_xHqqkZx_
//			if (m_fliCRCCount == 0) StopCRC();
//		}
//	}
//} // FCCRCFileTmpl<SUPER>::Write64.
//----- 05.12.31 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
template<class SUPER>
LONG FCCRCFileTmpl<SUPER>::Seek (LONG lOff, UINT nFrom)
{
	if (!m_bIsCalcCRC)
	//----- CRC_xZkqqHx_iMhGiOfKjCiGiCmFiCmNiCmIiCkCiPoKiNiH_xHqqkZx_ -----
	{
		return SUPER::Seek(lOff, nFrom);
	} else
	//----- CRC_xZkqqHx_iMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		// _xZkqqHx_iInKjDkOiMoDiCmMjAfGiClFiCkCiImKjChFiCpAiMhGiOfKiBeC_xHqqkZx_
		flint fliNewPosition;
		switch (nFrom)
		{
		case CFile::begin:
			fliNewPosition = lOff;
			break;
		case CFile::current:
			fliNewPosition = SUPER::GetPosition() + lOff;
			break;
		case CFile::end:
			fliNewPosition = SUPER::GetLength() + lOff;
			break;
		default:
			FFThrowMiscUnknown();
		}
		if (m_fliCRCPosition < fliNewPosition)
		//------ _xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiCoGiCoIiCoAjAoGiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			// _xZkqqHx_iDfIiDeMiDgCiDhGiClHiCoJiDgPiDeDiDgHjAjEiCpAiMhGiOfKiBeC_xHqqkZx_
			flint fliCount = fliNewPosition - SUPER::GetPosition();
			//----- _xZkqqHx_iDhEiDeAiDeDiDiLiCpAiDfIiDeMiDgCiDhG_xHqqkZx_ -----
			BYTE buff[1000];
			flint fliTmp = sizeof(buff);
			while (fliCount != 0 && fliTmp != 0)
			{
				fliTmp = (fliCount < sizeof(buff)) ? fliCount : sizeof(buff);
				fliTmp = Read(buff, fliTmp);
				fliCount -= fliTmp;
			}
			return SUPER::GetPosition();
		} else
		//------ _xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiCoGiCoIiCoAjBePiCmJiInKjDkOiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			return SUPER::Seek(lOff, nFrom);
		}
	}
} // FCCRCFileTmpl<SUPER>::Seek.

template<class SUPER>
UINT FCCRCFileTmpl<SUPER>::Read (void* lpBuf, UINT nCount)
{
	nCount = SUPER::Read(lpBuf, nCount);
	if (m_bIsCalcCRC)
	//----- CRC_xZkqqHx_iCmMiMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//
		// m_fliCRCPosition :_xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
		//                   Seek(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClN_xHqqkZx_
		//                   _xZkqqHx_iPoKiNiHiCmJiBeBiClBiCmMjFmPjAjEiCkKjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
		// fliCRCCount      :CRC_xZkqqHx_iCmMiMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
		// lpBufCRCTop      :CRC_xZkqqHx_iCmMiMhGiOfKiCpAiOgOiCnPiCoJiImKjChFiBeC_xHqqkZx_
		//
		//-------------------------------------------------------------------------------------
		// CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCmFiCmNiBeB_xHqqkZx_Seek(+n)_xZkqqHx_iCoAiPoNiCmJ_xHqqkZx_Read64_xZkqqHx_iCpAiOmAiNhDiClHiCoJiClNiCnPiBeBiImIiJlKiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
		//
		//                  lpBufTop
		//                     _xZkqqHx_iBkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//                     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//           _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_
		//           _xZkqqHx_iEkA_xHqqkZx_   fliTopPosition         GetPosition() 
		//           _xZkqqHx_iEkA_xHqqkZx_
		//      m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		// Seek(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCnMiCmFjCeCiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeB_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClFiCmIiCkCiBeC_xHqqkZx_
		//
		//         lpBufTop
		//            _xZkqqHx_iBkL_xHqqkZx_                         _xZkqqHx_iCkJiCmCiCmEjDmHiCnNiNjOiCpBiClOiClBiCmGiCkKiCkAiCoJiDgGiBfLiDfO_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition         GetPosition()    _xZkqqHx_iEkA_xHqqkZx_
		//                                               _xZkqqHx_iEkA_xHqqkZx_
		//                                         m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		// Seek(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCpAjClEiCkGiCmEiCkCiCoJiCmMiCmFiBeBjClEiCkGiClNjFkKiClOiCkP_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		//
		//         lpBufTop     lpBufCRCTop
		//            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkJiBkJiEjPiEjPiBkIiEkJ_xHqqkZx_ fliCRCCount 
		//            _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_            _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition     _xZkqqHx_iEkA_xHqqkZx_   GetPosition()
		//                          _xZkqqHx_iEkA_xHqqkZx_
		//                  m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		//
		const flint fliCRCCount = SUPER::GetPosition() - m_fliCRCPosition;
		if (0 < fliCRCCount)
		//----- CRC_xZkqqHx_iMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			const fliTopPosition = SUPER::GetPosition() - nCount;
			const BYTE* lpBufTop = (const BYTE*)lpBuf;
			// CRC_xZkqqHx_iCmMiMhGiOfKiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
			const BYTE* lpBufCRCTop = lpBufTop + (m_fliCRCPosition - fliTopPosition);
			// CRC_xZkqqHx_iCmMiMhGiOfKiDgPiDeDiDgHjAjEiCmJiPoDiMmAiCkKiCkAiCoJiCmMiCmFiBeBiClLiCmMiPoDiMmAjCgMiCpAjClEiCkGiCmIiCkCiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			flint fliTmp = (m_fliCRCCount < fliCRCCount) ? m_fliCRCCount : fliCRCCount;
			m_wCRC = FFCalcCRC(fliTmp, lpBufCRCTop, m_wCRC);
			// CRC_xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
			m_fliCRCCount -= fliTmp;
			// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
			m_fliCRCPosition += fliTmp;
			// _xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCpAiPeJjHlJiBeC_xHqqkZx_
			if (m_fliCRCCount == 0) StopCRC();
		}
	}

	return nCount;
} // FCCRCFileTmpl<SUPER>::Read.

template<class SUPER>
void FCCRCFileTmpl<SUPER>::Write (const void* lpBuf, UINT nCount)
{
	SUPER::Write(lpBuf, nCount);
	if (m_bIsCalcCRC)
	//----- CRC_xZkqqHx_iCmMiMhGiOfKjCiGiCmMiPoKiNiH_xHqqkZx_ -----
	{
		//
		// m_fliCRCPosition :_xZkqqHx_iKpJiCmJiMhGiOfKiCkKiPeJiCoNiCmBiClNiDhEiDeAiDeDiDiLiImKjChFiBeC_xHqqkZx_
		//                   Seek(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClN_xHqqkZx_
		//                   _xZkqqHx_iPoKiNiHiCmJiBeBiClBiCmMjFmPjAjEiCkKjFeLjHhGiCmGiCmIiCoJiBeC_xHqqkZx_
		// fliCRCCount      :CRC_xZkqqHx_iCmMiMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
		// lpBufCRCTop      :CRC_xZkqqHx_iCmMiMhGiOfKiCpAiOgOiCnPiCoJiImKjChFiBeC_xHqqkZx_
		//
		//-------------------------------------------------------------------------------------
		// CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCmFiCmNiBeB_xHqqkZx_Seek(+n)_xZkqqHx_iCoAiPoNiCmJ_xHqqkZx_Read64_xZkqqHx_iCpAiOmAiNhDiClHiCoJiClNiCnPiBeBiImIiJlKiCmNiCkAiCoIjDlOiCmIiCkCiBeC_xHqqkZx_
		//
		//                  lpBufTop
		//                     _xZkqqHx_iBkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//                     _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//     _xZkqqHx_iBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgDiEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//           _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_
		//           _xZkqqHx_iEkA_xHqqkZx_   fliTopPosition         GetPosition() 
		//           _xZkqqHx_iEkA_xHqqkZx_
		//      m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		// Seek(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCnMiCmFjCeCiClFiCmEiCkCiCmIiCkCiCmMiCmFiBeB_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClFiCmIiCkCiBeC_xHqqkZx_
		//
		//         lpBufTop
		//            _xZkqqHx_iBkL_xHqqkZx_                         _xZkqqHx_iCkJiCmCiCmEjDmHiCnNiNjOiCpBiClOiClBiCmGiCkKiCkAiCoJiDgGiBfLiDfO_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkNiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkOiBgDiBgDiBgDiBgDiBgDiBgDiBgDiBgD_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_                      _xZkqqHx_iBkK_xHqqkZx_         _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition         GetPosition()    _xZkqqHx_iEkA_xHqqkZx_
		//                                               _xZkqqHx_iEkA_xHqqkZx_
		//                                         m_fliCRCPosition
		// _xZkqqHx_iBkGiClBiCmMiPoKiNiHiCmNiClNiCnEiCpBiCnMiClIiCkCiBeC_xHqqkZx_
		// _xZkqqHx_iDeHiDiJiBfLiPeJjHlJiClDiClJiCoJjFeLjHhGiCkKiCkAiCoJiCkKiBeBiMoDiJpBiClFiBeC_xHqqkZx_
		//
		//-------------------------------------------------------------------------------------
		// Seek(-n)_xZkqqHx_iCmFiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCpAjGnPiClFiClNiPoKiNiHiCmNiBeBiImIiJlKiCkKiCkAiCoIjDlOiCoJiBeC_xHqqkZx_
		// _xZkqqHx_iClBiCmMiPoKiNiHiCmNiBeBiDhEiDeAiDeDiDiLiDhMiDeDiDjDiDfOiCkK_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiNmPiCnNiImKjChFiCpAjClEiCkGiCmEiCkCiCoJiCmMiCmFiBeBjClEiCkGiClNjFkKiClOiCkP_xHqqkZx_CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiBeC_xHqqkZx_
		//
		//         lpBufTop     lpBufCRCTop
		//            _xZkqqHx_iEkA_xHqqkZx_            _xZkqqHx_iEkJiBkJiEjPiEjPiBkIiEkJ_xHqqkZx_ fliCRCCount 
		//            _xZkqqHx_iBkL_xHqqkZx_            _xZkqqHx_iBkL_xHqqkZx_        _xZkqqHx_iEkA_xHqqkZx_
		//            _xZkqqHx_iEkMiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkN_xHqqkZx_
		//            _xZkqqHx_iEkL_xHqqkZx_   _xZkqqHx_jDmHiCnNiNjOiCpBiClOiDgGiBfLiDfO_xHqqkZx_   _xZkqqHx_iEkL_xHqqkZx_
		//            _xZkqqHx_iEkPiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkKiEkO_xHqqkZx_
		//            _xZkqqHx_iBkK_xHqqkZx_            _xZkqqHx_iBkK_xHqqkZx_        _xZkqqHx_iBkK_xHqqkZx_
		//       fliTopPosition     _xZkqqHx_iEkA_xHqqkZx_   GetPosition()
		//                          _xZkqqHx_iEkA_xHqqkZx_
		//                  m_fliCRCPosition
		//
		//-------------------------------------------------------------------------------------
		//
		const flint fliCRCCount = SUPER::GetPosition() - m_fliCRCPosition;
		if (0 < fliCRCCount)
		//----- CRC_xZkqqHx_iMhGiOfKjBmOiPnLiCmGiCmIiCoJiDgGiBfLiDfOiCkKjBlGiNnNiClHiCoJiPoKiNiH_xHqqkZx_ -----
		{
			const fliTopPosition = SUPER::GetPosition() - nCount;
			const BYTE* lpBufTop = (const BYTE*)lpBuf;
			// CRC_xZkqqHx_iCmMiMhGiOfKiKeKiOgOiImKjChFiCpAiOfKiPgPiBeC_xHqqkZx_
			const BYTE* lpBufCRCTop = lpBufTop + (m_fliCRCPosition - fliTopPosition);
			// CRC_xZkqqHx_iCmMiMhGiOfKiDgPiDeDiDgHjAjEiCmJiPoDiMmAiCkKiCkAiCoJiCmMiCmFiBeBiClLiCmMiPoDiMmAjCgMiCpAjClEiCkGiCmIiCkCiCkJiDgAiDeGiDgCiDeOiBeC_xHqqkZx_
			flint fliTmp = (m_fliCRCCount < fliCRCCount) ? m_fliCRCCount : fliCRCCount;
			m_wCRC = FFCalcCRC(fliTmp, lpBufCRCTop, m_wCRC);
			// CRC_xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
			m_fliCRCCount -= fliTmp;
			// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
			m_fliCRCPosition += fliTmp;
			// _xZkqqHx_iMhGiOfKiOgDiCoIiDgPiDeDiDgHjAjEiCkKjGlDiCkCiPoKiNiHiCmNiBeB_xHqqkZx_CRC_xZkqqHx_iMhGiOfKiDiCiBfLiDgIiCpAiPeJjHlJiBeC_xHqqkZx_
			if (m_fliCRCCount == 0) StopCRC();
		}
	}
} // FCCRCFileTmpl<SUPER>::Write.
//----- 05.12.31 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

template<class SUPER>
void FCCRCFileTmpl<SUPER>::StartCRC (flint fliCount)
{
	m_bIsCalcCRC = TRUE;						// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
	m_wCRC = FD_CRC_INIT_VALUE;					// CRC_xZkqqHx_jCgMiBeC_xHqqkZx_
	m_fliCRCCount = fliCount;					// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiDgPiDeDiDgHjAjEiBeC_xHqqkZx_
	m_fliCRCPosition = SUPER::GetPosition();	// CRC_xZkqqHx_iMhGiOfKiNmPiCnNiCmMiImKjChFiBeC_xHqqkZx_
} // FCCRCFileTmpl<SUPER>::StartCRC.

template<class SUPER>
WORD FCCRCFileTmpl<SUPER>::StopCRC ()
{
	m_bIsCalcCRC = FALSE;	// CRC_xZkqqHx_iCpAiMhGiOfKiClHiCoJiCkJiBeI_xHqqkZx_
	return m_wCRC;			// CRC_xZkqqHx_jCgMiBeC_xHqqkZx_
} // FCCRCFileTmpl<SUPER>::StopCRC.

#endif//__CRCFileTmpl_h
