#ifndef __WStringConst_h
#define __WStringConst_h

#pragma warning(disable: 4786)	// C4786_xZkqqHx_iMhIiNjAiCpAiPgPiCmIiCkNiClHiCoJiBeC_xHqqkZx_
#pragma warning(disable: 4503)	// C4503_xZkqqHx_iMhIiNjAiCpAiPgPiCmIiCkNiClHiCoJiBeC_xHqqkZx_

#include <algorithm>	// For find.

template<class T>
class _WStringConst
{
public:
	_WStringConst ();
	_WStringConst (const wchar_t* wcpBuffTop);
	_WStringConst (const wchar_t* wcpBuffTop, int iBuffLength);
	_WStringConst (	const wchar_t* wcpBuffTop, const wchar_t* wcpBuffEnd,
					const wchar_t* wcpBegin = NULL, const wchar_t* wcpEnd = NULL);
	void	Initialize (const wchar_t* wcpBuffTop);
	void	Initialize (const wchar_t* wcpBuffTop, int iBuffLength);
	void	Initialize (const wchar_t* wcpBuffTop, const wchar_t* wcpBuffEnd,
						const wchar_t* wcpBegin = NULL, const wchar_t* wcpEnd = NULL);

	const wchar_t*	GetBegin () const;
	const wchar_t*	GetEnd () const;
	const wchar_t*	GetBufferTop () const;
	const wchar_t*	GetBufferEnd () const;
	void	SetBegin (const wchar_t* wcpBegin);
	void	SetEnd (const wchar_t* wcpEnd);
	void	SetRange (const wchar_t* wcpBegin, wchar_t wcSep = L'\n');

	void	Clear ();
	BOOL	IsEmpty () const;
	operator const wchar_t* () const;
	wchar_t	GetAt (int index) const;
	int		GetLength () const;
	const wchar_t*	Find (wchar_t wc) const;

protected:
	const wchar_t*	m_wcpBuffTop;
	const wchar_t*	m_wcpBuffEnd;
	const wchar_t*	m_wcpBegin;
	const wchar_t*	m_wcpEnd;
}; // class WStringConst.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::_WStringConst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_WStringConst<T>::_WStringConst ()
				:	m_wcpBuffTop(NULL),
					m_wcpBuffEnd(NULL),
					m_wcpBegin(NULL),
					m_wcpEnd(NULL)
{
} // _WStringConst<T>::_WStringConst ();

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::_WStringConst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_WStringConst<T>::_WStringConst (const wchar_t* wcpBuffTop)
				:	m_wcpBuffTop(NULL),
					m_wcpBuffEnd(NULL),
					m_wcpBegin(NULL),
					m_wcpEnd(NULL)
{
	Initialize(wcpBuffTop);
} // _WStringConst<T>::_WStringConst (const wchar_t* wcpBuffTop);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::_WStringConst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_WStringConst<T>::_WStringConst (const wchar_t* wcpBuffTop, int iBuffLength)
				:	m_wcpBuffTop(NULL),
					m_wcpBuffEnd(NULL),
					m_wcpBegin(NULL),
					m_wcpEnd(NULL)
{
	Initialize(wcpBuffTop, iBuffLength);
} // _WStringConst<T>::_WStringConst (const wchar_t* wcpBuffTop, int iBuffLength);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::_WStringConst
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_WStringConst<T>::_WStringConst (	const wchar_t* wcpBuffTop, const wchar_t* wcpBuffEnd,
									const wchar_t* wcpBegin, const wchar_t* wcpEnd)
				:	m_wcpBuffTop(NULL),
					m_wcpBuffEnd(NULL),
					m_wcpBegin(NULL),
					m_wcpEnd(NULL)
{
	Initialize(wcpBuffTop, wcpBuffEnd, wcpBegin, wcpEnd);
} // _WStringConst<T>::_WStringConst (const wchar_t* wcpBuffTop, const wchar_t* wcpBuffEnd, const wchar_t* wcpBegin, const wchar_t* wcpEnd);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _WStringConst<T>::Initialize (const wchar_t* wcpBuffTop)
{
	Initialize(wcpBuffTop, wcpBuffTop + wcslen(wcpBuffTop));
} // void _WStringConst<T>::Initialize (const wchar_t* wcpBuffTop);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _WStringConst<T>::Initialize (const wchar_t* wcpBuffTop, int iBuffLength)
{
	Initialize(wcpBuffTop, wcpBuffTop + iBuffLength);
} // void _WStringConst<T>::Initialize (const wchar_t* wcpBuffTop, int iBuffLength);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _WStringConst<T>::Initialize (	const wchar_t* wcpBuffTop, const wchar_t* wcpBuffEnd,
									const wchar_t* wcpBegin, const wchar_t* wcpEnd)
{
	m_wcpBuffTop = wcpBuffTop;
	m_wcpBuffEnd = wcpBuffEnd;
	if (wcpBegin == NULL)
		wcpBegin = wcpBuffTop;
	if (wcpEnd == NULL)
		wcpEnd = wcpBuffEnd;
	SetBegin(wcpBegin);
	SetEnd(wcpEnd);
} // void _WStringConst<T>::Initialize (const wchar_t* wcpBuffTop, const wchar_t* wcpBuffEnd, const wchar_t* wcpBegin, const wchar_t* wcpEnd);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::GetBegin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
const wchar_t* _WStringConst<T>::GetBegin () const
{
	return m_wcpBegin;
} // _WStringConst<T>::GetBegin () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::GetEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
const wchar_t* _WStringConst<T>::GetEnd () const
{
	return m_wcpEnd;
} // _WStringConst<T>::GetEnd () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::GetBufferTop
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
const wchar_t* _WStringConst<T>::GetBufferTop () const
{
	return m_wcpBuffTop;
} // _WStringConst<T>::GetBufferTop () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::GetBufferEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
const wchar_t* _WStringConst<T>::GetBufferEnd () const
{
	return m_wcpBuffEnd;
} // _WStringConst<T>::GetBufferEnd () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::SetBegin
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _WStringConst<T>::SetBegin (const wchar_t* wcpBegin)
{
	m_wcpBegin = wcpBegin;
} // _WStringConst<T>::SetBegin (const wchar_t* wcpBegin);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::SetEnd
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _WStringConst<T>::SetEnd (const wchar_t* wcpEnd)
{
	m_wcpEnd = wcpEnd;
} // _WStringConst<T>::SetEnd (const wchar_t* wcpEnd);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::SetRange
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _WStringConst<T>::SetRange (const wchar_t* wcpBegin, wchar_t wcSep)
{
	SetBegin(wcpBegin);
	SetEnd(GetBufferEnd());
	const wchar_t* wcpSepPoint = Find(wcSep);
	if (wcpSepPoint != GetEnd())
		SetEnd(wcpSepPoint + 1);
} // _WStringConst<T>::SetRange (const wchar_t* wcpBegin, wchar_t wcSep);

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
void _WStringConst<T>::Clear ()
{
	SetBegin(NULL);
	SetEnd(NULL);
	m_wcpBuffTop = NULL;
	m_wcpBuffEnd = NULL;
} // void _WStringConst<T>::Clear ();

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::IsEmpty
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
BOOL _WStringConst<T>::IsEmpty () const
{
	return (GetBegin() == GetEnd());
} // BOOL _WStringConst<T>::IsEmpty () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::operator const wchar_t* ()
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
_WStringConst<T>::operator const wchar_t* () const
{
	return GetBegin();
} // _WStringConst<T>::operator const wchar_t* () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::GetAt
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
wchar_t _WStringConst<T>::GetAt (int index) const
{
	const wchar_t* wcpAt = GetBegin() + index;
	if (wcpAt < GetBufferTop() || GetEnd() <= wcpAt) return 0;
	return *wcpAt;
} // wchar_t _WStringConst<T>::GetAt (int index) const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::GetLength
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
int _WStringConst<T>::GetLength () const
{
	return int(GetEnd() - GetBegin());
} // wchar_t _WStringConst<T>::GetLength () const;

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	_WStringConst<T>::Find
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	
 *
 * <_xZkqqHx_iPnKiNnH_xHqqkZx_>	
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
template<class T>
const wchar_t* _WStringConst<T>::Find (wchar_t wc) const
{
	return std::find(GetBegin(), GetEnd(), wc);
} // _WStringConst<T>::Find (wchar_t wc) const.

typedef _WStringConst<void> WStringConst;

#endif __WStringConst_h
