#include <windows.h>
#include <tchar.h>
#include "General.h"

#ifdef _UNICODE

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myUnicodeToSubset
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKiDfCiBfLiDgIiCkKiBeB_xHqqkZx_UNICODE_xZkqqHx_iCmMiCmHiCmMiDfEiDhFiDfKiDgCiDgHiCmJiCkAiClNiCoJiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDfKiDgCiDgHiBeC_xHqqkZx_MSDN_xZkqqHx_iCmM_xHqqkZx_Unicode Subset Bitfields _xZkqqHx_iCpAiOfBiPmGiBeCiCmHiCmM_xHqqkZx_
 *			_xZkqqHx_iDfEiDhFiDfKiDgCiDgHiCmJiCoAjDjGiCmEiCmNiCnMiCoHiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ -1_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static int myUnicodeToSubset (wchar_t wChar)
{
	if (0x0020 <= wChar && wChar <= 0x007e) return  0;   // Basic Latin .
	if (0x00a0 <= wChar && wChar <= 0x00ff) return  1;   // Latin-1 Supplement .
	if (0x0100 <= wChar && wChar <= 0x017f) return  2;   // Latin Extended-A .
	if (0x0180 <= wChar && wChar <= 0x024f) return  3;   // Latin Extended-B .
	if (0x0250 <= wChar && wChar <= 0x02af) return  4;   // IPA Extensions .
	if (0x02b0 <= wChar && wChar <= 0x02ff) return  5;   // Spacing Modifier Letters .
	if (0x0300 <= wChar && wChar <= 0x036f) return  6;   // Combining Diacritical Marks .
	if (0x0370 <= wChar && wChar <= 0x03ff) return  7;   // Basic Greek .
	if (0x0400 <= wChar && wChar <= 0x04ff) return  9;   // Cyrillic .
	if (0x0530 <= wChar && wChar <= 0x058f) return 10;   // Armenian .
	if (0x0590 <= wChar && wChar <= 0x05ff) return 11;   // Basic Hebrew .
	if (0x0600 <= wChar && wChar <= 0x06ff) return 13;   // Basic Arabic .
	if (0x0700 <= wChar && wChar <= 0x074f) return 71;   // Syriac .
	if (0x0780 <= wChar && wChar <= 0x07bf) return 72;   // Thaana .
	if (0x0900 <= wChar && wChar <= 0x097f) return 15;   // Devanagari .
	if (0x0980 <= wChar && wChar <= 0x09ff) return 16;   // Bengali .
	if (0x0a00 <= wChar && wChar <= 0x0a7f) return 17;   // Gurmukhi .
	if (0x0a80 <= wChar && wChar <= 0x0aff) return 18;   // Gujarati .
	if (0x0b00 <= wChar && wChar <= 0x0b7f) return 19;   // Oriya .
	if (0x0b80 <= wChar && wChar <= 0x0bff) return 20;   // Tamil .
	if (0x0c00 <= wChar && wChar <= 0x0c7f) return 21;   // Telugu .
	if (0x0c80 <= wChar && wChar <= 0x0cff) return 22;   // Kannada .
	if (0x0d00 <= wChar && wChar <= 0x0d7f) return 23;   // Malayalam .
	if (0x0d80 <= wChar && wChar <= 0x0dff) return 73;   // Sinhala .
	if (0x0e00 <= wChar && wChar <= 0x0e7f) return 24;   // Thai .
	if (0x0e80 <= wChar && wChar <= 0x0eff) return 25;   // Lao .
	if (0x0f00 <= wChar && wChar <= 0x0fcf) return 70;   // Tibetan .
	if (0x1000 <= wChar && wChar <= 0x109f) return 74;   // Myanmar .
	if (0x10a0 <= wChar && wChar <= 0x10ff) return 26;   // Basic Georgian .
	if (0x1100 <= wChar && wChar <= 0x11ff) return 28;   // Hangul Jamo .
	if (0x1200 <= wChar && wChar <= 0x12bf) return 75;   // Ethiopic .
	if (0x13a0 <= wChar && wChar <= 0x13ff) return 76;   // Cherokee .
	if (0x1400 <= wChar && wChar <= 0x14df) return 77;   // Canadian Aboriginal Syllabics .
	if (0x1680 <= wChar && wChar <= 0x169f) return 78;   // Ogham .
	if (0x16a0 <= wChar && wChar <= 0x16ff) return 79;   // Runic .
	if (0x1780 <= wChar && wChar <= 0x17ff) return 80;   // Khmer .
	if (0x1800 <= wChar && wChar <= 0x18af) return 81;   // Mongolian .
	if (0x1e00 <= wChar && wChar <= 0x1eff) return 29;   // Latin Extended Additional .
	if (0x1f00 <= wChar && wChar <= 0x1fff) return 30;   // Greek Extended .
	if (0x2000 <= wChar && wChar <= 0x206f) return 31;   // General Punctuation .
	if (0x2070 <= wChar && wChar <= 0x209f) return 32;   // Subscripts and Superscripts .
	if (0x20a0 <= wChar && wChar <= 0x20cf) return 33;   // Currency Symbols .
	if (0x20d0 <= wChar && wChar <= 0x20ff) return 34;   // Combining Diacritical Marks for Symbols .
	if (0x2100 <= wChar && wChar <= 0x214f) return 35;   // Letter-like Symbols .
	if (0x2150 <= wChar && wChar <= 0x218f) return 36;   // Number Forms .
	if (0x2190 <= wChar && wChar <= 0x21ff) return 37;   // Arrows .
	if (0x2200 <= wChar && wChar <= 0x22ff) return 38;   // Mathematical Operators .
	if (0x2300 <= wChar && wChar <= 0x23ff) return 39;   // Miscellaneous Technical .
	if (0x2400 <= wChar && wChar <= 0x243f) return 40;   // Control Pictures .
	if (0x2440 <= wChar && wChar <= 0x245f) return 41;   // Optical Character Recognition .
	if (0x2460 <= wChar && wChar <= 0x24ff) return 42;   // Enclosed Alphanumerics .
	if (0x2500 <= wChar && wChar <= 0x257f) return 43;   // Box Drawing .
	if (0x2580 <= wChar && wChar <= 0x259f) return 44;   // Block Elements .
	if (0x25a0 <= wChar && wChar <= 0x25ff) return 45;   // Geometric Shapes .
	if (0x2600 <= wChar && wChar <= 0x26ff) return 46;   // Miscellaneous Dingbats .
	if (0x2700 <= wChar && wChar <= 0x27bf) return 47;   // Dingbats .
	if (0x2800 <= wChar && wChar <= 0x28ff) return 82;   // Braille .
	if (0x3000 <= wChar && wChar <= 0x303f) return 48;   // "Chinese, Japanese, and Korean (CJK) Symbols and Punctuation ".
	if (0x3040 <= wChar && wChar <= 0x309f) return 49;   // Hiragana .
	if (0x30a0 <= wChar && wChar <= 0x30ff) return 50;   // Katakana .
	if (0x3100 <= wChar && wChar <= 0x312f) return 51;   // Bopomofo .
	if (0x3130 <= wChar && wChar <= 0x318f) return 52;   // Hangul Compatibility Jamo .
	if (0x3190 <= wChar && wChar <= 0x319f) return 53;   // CJK Miscellaneous .
	if (0x3200 <= wChar && wChar <= 0x32ff) return 54;   // Enclosed CJK Letters and Months .
	if (0x3300 <= wChar && wChar <= 0x33ff) return 55;   // CJK Compatibility .
	if (0x4e00 <= wChar && wChar <= 0x9fff) return 59;   // CJK Unified Ideographs .
	if (0xa000 <= wChar && wChar <= 0xa48c) return 83;   // Yi .
	if (0xac00 <= wChar && wChar <= 0xd7a3) return 56;   // Hangul .
	if (0xd800 <= wChar && wChar <= 0xdfff) return 57;   // Surrogates  .
	if (0xe000 <= wChar && wChar <= 0xf8ff) return 60;   // Private Use Area .
	if (0xf900 <= wChar && wChar <= 0xfaff) return 61;   // CJK Compatibility Ideographs .
	if (0xfb00 <= wChar && wChar <= 0xfb4f) return 62;   // Alphabetic Presentation Forms .
	if (0xfb50 <= wChar && wChar <= 0xfdff) return 63;   // Arabic Presentation Forms-A .
	if (0xfe20 <= wChar && wChar <= 0xfe2f) return 64;   // Combining Half Marks .
	if (0xfe30 <= wChar && wChar <= 0xfe4f) return 65;   // CJK Compatibility Forms .
	if (0xfe50 <= wChar && wChar <= 0xfe6f) return 66;   // Small Form Variants .
	if (0xfe70 <= wChar && wChar <= 0xfefe) return 67;   // Arabic Presentation Forms-B .
	if (0xff00 <= wChar && wChar <= 0xffef) return 68;   // Halfwidth and Fullwidth Forms .
	if (0xfff0 <= wChar && wChar <= 0xfffd) return 69;   // Specials .
	return -1;
} // myUnicodeToSubset.

#endif//_UNICODE

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetWChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	tcpStr_xZkqqHx_iCmMjAoGjDkKiCkJiCoHiCfAjFlGiOjKiCpAiOoGjDlOiClFiBeBiOjPiCmMjFlGiOjKiCmMiDhMiDeDiDjDiDfOiCpA_xHqqkZx_tcpStrNext_xZkqqHx_iCmJ_xHqqkZx_
 *			_xZkqqHx_jAnNjCoIiClFiBeBjFlGiOjKiDfCiBfLiDgIiCpAjFnEiClHiBeCiBgJiCfBiDgPiDeDiDgHiDfCiBfLiDgIiCmJjBmOiJjOiBgK_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpStrNext	: _xZkqqHx_iOjPiCmMjFlGiOjKiCmMiDhMiDeDiDjDiDfOiCpAjFnEiClHiBeC_xHqqkZx_
 *			tcpStr		: _xZkqqHx_iCfAjFlGiOjKiCpAiOoGjDlOiClHiCoJiClNiCnPiCmMiDhMiDeDiDjDiDfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *			tcpStrEnd	: tcpStr_xZkqqHx_iCmMiPeJjCfLiCpAiOhHjCoIiBeCiOhHjCoIiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiDfCiBfLiDgI_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.04.18 Fukushiro M. FastDraw/UtilStr.cpp_xZkqqHx_iCkJiCoHiInKjAeBiBeC_xHqqkZx_
 *************************************************************************/
WORD GetWChar (CTCP& tcpStrNext, CTCP tcpStr, CTCP tcpStrEnd)
{
	// _xZkqqHx_iPeJjCfLiCmJiOiKiCmBiClNiPoKiNiHiCmN_xHqqkZx_'\0'_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (tcpStr == tcpStrEnd) return 0;
#ifdef  _WIDE_CHAR
	if (*tcpStr == WORD(_T('\0')))
	{
		tcpStrNext = tcpStr;
		return 0;
	}
	tcpStrNext = tcpStr + 1;
	return *tcpStr;
#else //_WIDE_CHAR
	tcpStrNext = ::CharNext(tcpStr);
	// _xZkqqHx_jFlGiOjKjHpBiCmMiNmFiMoD_xHqqkZx_.
	if (tcpStrNext == tcpStr) return 0;
	/*----- _xZkqqHx_iCfAjFlGiOjKjHpBiCkJiCoHiCfAjFlGiOjKiDfCiBfLiDgIiCpAjAlGjAkM_xHqqkZx_ -----*/
	WORD wChar = 0;
	do
	{
		wChar = (wChar << 8) + _TUCHAR(*tcpStr);
		tcpStr++;
	} while (tcpStr != tcpStrNext);
	return wChar;
#endif//_WIDE_CHAR
} // GetWChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetExpChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLjFlGiOjKjHpBiCkJiCoHiCfAjFlGiOjKjFkKiCpAiOoGjDlOiClFiBeBiClLiCmMiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpStr	:_xZkqqHx_jAlDiLeLjFfMiMlLjFlGiOjKjHpBiCpAjAnNjCoIiBeCiOjPiCmMiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *			wChar	:_xZkqqHx_iCfAjFlGiOjKjFkKiCmMiPoOjFpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	wc_xZkqqHx_iCmMiOoNjHnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iMlLiNnNiCmMiDfEiDhMiBfLiDgHjFlGiOjKiOoNiCmNiImIiJlKiBeC_xHqqkZx_
 *			'\0'	:_xZkqqHx_iLpDjFlGiOjK_xHqqkZx_.
 *			'*'		:Quantifier(_xZkqqHx_jHmKiOhHjCoIiOhB_xHqqkZx_)_xZkqqHx_iBeCiCePiJpBiImIiPoDiBeC_xHqqkZx_
 *			'+'		:Quantifier(_xZkqqHx_jHmKiOhHjCoIiOhB_xHqqkZx_)_xZkqqHx_iBeCiCfAiJpBiImIiPoDiBeC_xHqqkZx_
 *			'?'		:Quantifier(_xZkqqHx_jHmKiOhHjCoIiOhB_xHqqkZx_)_xZkqqHx_iBeCiCePiJpBiIlNiCkCiCmNiCfAiJpBiBeC_xHqqkZx_
 *			'^'		:Assertion(_xZkqqHx_iMlOjGlOiOhB_xHqqkZx_)_xZkqqHx_iBeCiNhDjDkKiBeC_xHqqkZx_
 *			'$'		:Assertion(_xZkqqHx_iMlOjGlOiOhB_xHqqkZx_)_xZkqqHx_iBeCiNhDjGjGiBeC_xHqqkZx_
 *			'\b'	:Assertion(_xZkqqHx_iMlOjGlOiOhB_xHqqkZx_)_xZkqqHx_iBeCjCfAiMoKiLkLiKeFiBeC_xHqqkZx_
 *			'-'		:_xZkqqHx_jEmNiImNiOhHjCoIiOhBiBeC_xHqqkZx_
 *			'['		:_xZkqqHx_iDeJiBfLiDhGiDjDjHpBiLjDiOhBiBeC_xHqqkZx_
 *			']'		:_xZkqqHx_iDeOiDiNiBfLiDfJjHpBiLjDiOhBiBeC_xHqqkZx_
 *			'('		:_xZkqqHx_iDeJiBfLiDhGiDjDiKnLiKiHiMmKiBeC_xHqqkZx_
 *			')'		:_xZkqqHx_iDeOiDiNiBfLiDfJiKnLiKiHiMmKiBeC_xHqqkZx_
 *			'.'		:Ambiguity(_xZkqqHx_jOeCjGiGjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeCjBfDiCmEiCmMiCfAjFlGiOjKiBeC_xHqqkZx_
 *			'\d'	:Ambiguity(_xZkqqHx_jOeCjGiGjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeCjElMiKhAjAjEiOjKiCfAjFlGiOjKiBeC_xHqqkZx_
 *			'\w'	:Ambiguity(_xZkqqHx_jOeCjGiGjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeCjElMiKhAiJhAjAjEiOjKiCfAjFlGiOjKiBeC_xHqqkZx_
 *			'\s'	:Ambiguity(_xZkqqHx_jOeCjGiGjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeCiLpDjEjCiCfAjFlGiOjKiBeC_xHqqkZx_
 *			'\n'	:_xZkqqHx_iJpMiNhDiDfCiBfLiDgI_xHqqkZx_(_xZkqqHx_jCmKiPoNjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
 *			'\r'	:_xZkqqHx_jFjMiLeBiDfCiBfLiDgI_xHqqkZx_(_xZkqqHx_jCmKiPoNjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
 *			'\t'	:_xZkqqHx_iDfOiDhFiDfCiBfLiDgI_xHqqkZx_(_xZkqqHx_jCmKiPoNjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
 *					:General char(_xZkqqHx_jCmKiPoNjFlGiOjKiBgKiBeC_xHqqkZx_
 *					:Invalid char(_xZkqqHx_iDeHiDiJiBfLjFlGiOjK_xHqqkZx_)_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iDfCiBfLiDgIiCmMjCmHiJmBiCmNiBeBiKgFiDeHiDiMiDiBiDjDiDgHiDeOiDiJiDfIiCmGjDkPiKpKiClFiCmEiNhDiCkEiClBiCmGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.12.12 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
CHAR_KIND GetExpChar (CTCP& tcpStr, WORD& wChar)
{
	switch (*tcpStr)
	/*----- _xZkqqHx_jDmBiOoKiCmIiLeMiNiGiCmMiCnNiCpAiClBiClBiCmFiPiIjHjN_xHqqkZx_ -----*/
	{
	case _T('\0'):
		wChar = _T('\0');
		return KND_NULL_CHR;

	case _T('*'):
	case _T('+'):
	case _T('?'):
		wChar = *tcpStr;
		tcpStr++;
		return KND_QUANT_COD;

	case _T('^'):
	case _T('$'):
		wChar = *tcpStr;
		tcpStr++;
		return KND_ASSERT_COD;

	case _T('-'):
		wChar = *tcpStr;
		tcpStr++;
		return KND_RANGE_COD;

	case _T('['):
		wChar = *tcpStr;
		tcpStr++;
		return KND_ENUM_OPEN_COD;

	case _T(']'):
		wChar = *tcpStr;
		tcpStr++;
		return KND_ENUM_CLOSE_COD;

	case _T('('):
		wChar = *tcpStr;
		tcpStr++;
		return KND_RPARE_OPEN_COD;

	case _T(')'):
		wChar = *tcpStr;
		tcpStr++;
		return KND_RPARE_CLOSE_COD;

	case _T('.'):
		wChar = *tcpStr;
		tcpStr++;
		return KND_AMBIG_CHR;

	case _T('\\'):
		switch (tcpStr[1])
		{
		case _T('b'):	// _xZkqqHx_jCfAiMoKiLkLiKeF_xHqqkZx_.\b.
			wChar = tcpStr[1];
			tcpStr += 2;
			return KND_ASSERT_COD;

		case _T('d'):	// _xZkqqHx_jAjEiOjK_xHqqkZx_.\d.
		case _T('w'):	// _xZkqqHx_iJhAjAjEiOjK_xHqqkZx_.\w.
		case _T('s'):	// _xZkqqHx_iLpDjEjC_xHqqkZx_.\s.
			wChar = tcpStr[1];
			tcpStr += 2;
			return KND_AMBIG_CHR;

		case _T('n'):	// _xZkqqHx_iJpMiNhDjFlGiOjK_xHqqkZx_.\n.
			wChar = _T('\n');
			tcpStr += 2;
			return KND_GENERAL_CHR;

		case _T('r'):	// _xZkqqHx_jFjMiLeBjFlGiOjK_xHqqkZx_.\r.
			wChar = _T('\r');
			tcpStr += 2;
			return KND_GENERAL_CHR;

		case _T('t'):	// _xZkqqHx_iDfOiDhFjFlGiOjK_xHqqkZx_.\t.
			wChar = _T('\t');
			tcpStr += 2;
			return KND_GENERAL_CHR;

		case _T('\0'):	// _xZkqqHx_iDeHiDiJiBfL_xHqqkZx_. \_xZkqqHx_iCmJiLpDjFlGiOjKiCkKjBlBiCkCiClNiBeC_xHqqkZx_
			return KND_INVALID_CHR;

		default:
			tcpStr++;
			// \_xZkqqHx_iCmJjBlBiCkNjFlGiOjKiCmNiBeBiCnDiCmCiCkEiCmMjFlGiOjKiCmGiClFiCmEiImIiNhOiCmFiPiIjHjNiBeC_xHqqkZx_
		}
	}
	/*----- _xZkqqHx_iCnDiCmCiCkEiCmMjFlGiOjKiCpAiPiIjHjN_xHqqkZx_ -----*/
	wChar = GetWChar(tcpStr, tcpStr, NULL);
	return KND_GENERAL_CHR;
} // GetExpChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	WCharKind
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iCfBiDgPiDeDiDgHjFlGiOjKiCmMiOoNjHnOiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFlGiOjKiOoNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WCHAR_KIND WCharKind (WORD wChar)
{
#ifdef _UNICODE
	if (wChar < L' ')		return FDCK_ANSI_ETC;
	else
	if (wChar < L'0')		return FDCK_ANSI_MARK;
	else
	if (wChar < L':')		return FDCK_ANSI_NUM_ALPHABET;
	else
	if (wChar < L'A')		return FDCK_ANSI_MARK;
	else
	if (wChar < L'[')		return FDCK_ANSI_NUM_ALPHABET;
	else
	if (wChar < L'a')		return FDCK_ANSI_MARK;
	else
	if (wChar < L'{')		return FDCK_ANSI_NUM_ALPHABET;
	else
	if (wChar < 0x00c0)		return FDCK_ANSI_MARK;
	else
	if (wChar < 0x0250)		return FDCK_ANSI_NUM_ALPHABET;	// _xZkqqHx_jAlDiKgNiCmJiCmNiBeBiDiJiDgFiDjDiKgHjCkD_xHqqkZx_A,B_xZkqqHx_iBeC_xHqqkZx_
	else
	if (0xff21 <= wChar && wChar <= 0xff3a || 0xff41 <= wChar && wChar <= 0xff5a)
							return FDCK_ZENK_ALPHABET;	// _xZkqqHx_jBfDiKhAiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_
	else
		return WCHAR_KIND(FDCK_OTHER_BEGIN + myUnicodeToSubset(wChar));

#else  // _UNICODE

	if (wChar <= 0xff)
	{
		if (wChar <= 0x1f)			return FDCK_ANSI_ETC;
		else if (wChar <= 0x2f)		return FDCK_ANSI_ETC;
		else if (wChar <= 0x39)		return FDCK_ANSI_NUM_ALPHABET;
		else if (wChar <= 0x40)		return FDCK_ANSI_ETC;
		else if (wChar <= 0x5a)		return FDCK_ANSI_NUM_ALPHABET;
		else if (wChar <= 0x60)		return FDCK_ANSI_ETC;
		else if (wChar <= 0x7a)		return FDCK_ANSI_NUM_ALPHABET;
		else if (wChar <= 0x7e)		return FDCK_ANSI_ETC;
		else if (wChar <= 0x7f)		return FDCK_ANSI_ETC;
		else if (wChar <= 0xa0)		return FDCK_HANK_ETC;
		else if (wChar <= 0xa5)		return FDCK_HANK_MARK;
		else if (wChar <= 0xdf)		return FDCK_HANK_KATAKANA;
		else						return FDCK_HANK_ETC;
	} else
	{
		if ((0x8140 <= wChar && wChar <= 0x81fc) ||
			(0x84af <= wChar && wChar <= 0x84be) ||
			(0x8740 <= wChar && wChar <= 0x879c))
			return FDCK_ZENK_MARK;		// _xZkqqHx_jBfDiKhAiLeMiNiGiBeC_xHqqkZx_
		else if (0x824f <= wChar && wChar <= 0x8258)
			return FDCK_ZENK_NUMBER;	// _xZkqqHx_jBfDiKhAjAjEiOjKiBeC_xHqqkZx_
		else if ((0x8260 <= wChar && wChar <= 0x8279) ||
				 (0x8281 <= wChar && wChar <= 0x829a))
			return FDCK_ZENK_ALPHABET;	// _xZkqqHx_jBfDiKhAiDeBiDiLiDhEiDeAiDhIiDgCiDgHiBeC_xHqqkZx_
		else if (0x829f <= wChar && wChar <= 0x82f1)
			return FDCK_ZENK_HIRAGANA;	// _xZkqqHx_jBfDiKhAiCkJiCmIiBeC_xHqqkZx_
		else if (0x8340 <= wChar && wChar <= 0x8396)
			return FDCK_ZENK_KATAKANA;	// _xZkqqHx_jBfDiKhAiDeKiDgJiBeC_xHqqkZx_
		else if ((0x839f <= wChar && wChar <= 0x83b6) ||
				 (0x83bf <= wChar && wChar <= 0x83d6))
			return FDCK_ZENK_GREEK;		// _xZkqqHx_jBfDiKhAiDeNiDiKiDfGiDiDiBeC_xHqqkZx_
		else if ((0x8440 <= wChar && wChar <= 0x8460) ||
				 (0x8470 <= wChar && wChar <= 0x8491))
			return FDCK_ZENK_RUSSIAN;	// _xZkqqHx_jBfDiKhAiDiNiDfGiDeBiBeC_xHqqkZx_
		else if (0x8890 <= wChar)
			return FDCK_ZENK_KANJI;		// _xZkqqHx_jBfDiKhAiKlPiOjKiBeC_xHqqkZx_
		else
			return FDCK_ZENK_ETC;		// _xZkqqHx_jBfDiKhAiClLiCmMjBlMiBeC_xHqqkZx_
	}
#endif // _UNICODE
} // WCharKind.
