#include "General.h"
#include "RegNodeEnumChar.h"		// This header.

/////////////////////////////////////////////////////////////////////////
// RegEnumAtom_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegEnumAtom::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKiCmJiBeBiClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhNiDgCiDgAiClFiCmEiCkCiCoJiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:_xZkqqHx_jFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegEnumAtom::IsMatch (WORD wChar)
{
	if (m_wCharUntil == 0)
	//----- _xZkqqHx_jOeCjGiGjFlGiOjKiCmMiPoKiNiH_xHqqkZx_ -----
	{
		switch (m_wCharFrom)
		{
		case _T('.'):	// _xZkqqHx_jBfDiCmEiBeC_xHqqkZx_
			return TRUE;
		case _T('d'):	// _xZkqqHx_jAjEiOjK_xHqqkZx_.\d.
			if (IsDigit(wChar)) return TRUE;
			break;
		case _T('w'):	// _xZkqqHx_iJhAjAjEiOjK_xHqqkZx_.\w.
			if (IsWordAtom(wChar)) return TRUE;
			break;
		case _T('s'):	// _xZkqqHx_iLpDjEjC_xHqqkZx_.\s.
			if (IsSpace(wChar)) return TRUE;
			break;
		default:
			return FALSE;
		}
	} else
	//----- _xZkqqHx_jFlGiOjKjEmNiImNiCmMiPoKiNiH_xHqqkZx_ -----
	{
		if (m_wCharFrom <= wChar && wChar <= m_wCharUntil) return TRUE;
	}
	return FALSE;
} // RegEnumAtom::IsMatch.

/////////////////////////////////////////////////////////////////////////
// RegNodeEnumChar_xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgHiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeEnumChar::RegNodeEnumChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wFlags	:_xZkqqHx_jFmPiKlHiOjOiCmMiDhEiDiJiDePiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
RegNodeEnumChar::RegNodeEnumChar (WORD wFlags)
{
	m_wFlags = wFlags;
	m_bInvert = FALSE;	// _xZkqqHx_jElNjDfNiBeIiBgJ_xHqqkZx_[^_xZkqqHx_iBgK_xHqqkZx_
} // RegNodeEnumChar::RegNodeEnumChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeEnumChar::SetExpression
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAlDiLeLjFfMiMlLiCmMjHpBiLjDjFlGiOjKiCpAiJpAjAmNiClFiBeBjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcsHead	:_xZkqqHx_jAlDiLeLjFfMiMlLiOkOjFlGiOjKjHpBiCpAjAnNjCoIiClHiCoJiBeCiDeOiDiNiBfLiDfJjHpBiLjDiOhBiCmMiOjPiCmM_xHqqkZx_
 *					 _xZkqqHx_jFlGiOjKiImKjChFiCnMiCmFiInKjDkOiClHiCoJiBeCiDeHiDiJiBfLiOjOiCmNiDeHiDiJiBfLjEkNjAlGiImKjChFiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAlDiPoNiCmIiCoHiCmO_xHqqkZx_ TRUE_xZkqqHx_iBeBiDeHiDiJiBfLiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeEnumChar::SetExpression (CTCP& tcpHead)
{
	CHAR_KIND kindPrev = KND_NONE;	// _xZkqqHx_jBePiJpBiCmMjFlGiOjKiOoNiBeC_xHqqkZx_
	for (;;)
	{
		WORD wChar;
		// _xZkqqHx_iNmFiPiJiCmMiCfAjFlGiOjK_xHqqkZx_(\_xZkqqHx_iCmMiPoKiNiHiCmNiCfBjFlGiOjK_xHqqkZx_)_xZkqqHx_iCpAiOoGiCoIiPgPiClHiBeCjFlGiOjKiOoNiCoAjElLjCoIiBeC_xHqqkZx_
		CHAR_KIND kind = GetExpChar(tcpHead, wChar);
		switch (kind)
		{
		case KND_NULL_CHR:		// '\0' _xZkqqHx_iLpDjFlGiOjKiBeC_xHqqkZx_
			return FALSE;

		case KND_ASSERT_COD:	// ^,$,\b _xZkqqHx_iMlOjGlOiOhBiBeC_xHqqkZx_
			if (kindPrev == KND_NONE && wChar == _T('^'))
			{
				m_bInvert = TRUE;
				wChar = 0;
			}
			break;

		case KND_RANGE_COD:		// - _xZkqqHx_jEmNiImNiOhHjCoIiOhBiBeC_xHqqkZx_
			// _xZkqqHx_jEmNiImNiCmMjBePiCkKjGlDiCkCiBeBjOeCjGiGjFlGiOjKiBeBjEmNiImNiOhHjCoIiOhBiCmMiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
			if (kindPrev == KND_NONE ||
				kindPrev == KND_AMBIG_CHR ||
				kindPrev == KND_RANGE_COD) return FALSE;
			wChar = 0;
			break;

		case KND_ENUM_CLOSE_COD:// ] _xZkqqHx_iDeOiDiNiBfLiDfJjHpBiLjDiOhBiBeC_xHqqkZx_
			// _xZkqqHx_jEmNiImNiCmMjBePiCkKjGlDiCkCiBeBjEmNiImNiOhHjCoIiOhBiCmMiPoKiNiHiCmNiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
			if (kindPrev == KND_NONE ||
				kindPrev == KND_RANGE_COD) return FALSE;
			return TRUE;

		case KND_INVALID_CHR:	// Error. _xZkqqHx_iDeHiDiJiBfLiBeC_xHqqkZx_
			return FALSE;

		case KND_AMBIG_CHR:		// .,\d,\w,\s, _xZkqqHx_jOeCjGiGjFlGiOjKiBeC_xHqqkZx_
			// _xZkqqHx_jEmNiImNjBeJjBpAjCiGiCmIiCoHiCmOiBeBiDeHiDiJiBfLiBeC_xHqqkZx_
			if (kindPrev == KND_RANGE_COD) return FALSE;
			break;

		// case KND_QUANT_COD:			// +,*,? _xZkqqHx_jHmKiOhHjCoIiOhBiBeC_xHqqkZx_
		// case KND_ENUM_OPEN_COD:		// [ _xZkqqHx_iDeJiBfLiDhGiDjDjHpBiLjDiOhBiBeC_xHqqkZx_
		// case KND_GENERAL_CHR:		// a,A,1,, _xZkqqHx_jCmKiPoNjFlGiOjKiBeC_xHqqkZx_
		// case KND_RPARE_OPEN_COD:		// ( _xZkqqHx_iDeJiBfLiDhGiDjDiKnLiKiHiMmKiBeC_xHqqkZx_
		// case KND_RPARE_CLOSE_COD:	// ) _xZkqqHx_iDeOiDiNiBfLiDfJiKnLiKiHiMmKiBeC_xHqqkZx_
		}
		if (wChar != 0)
		{
			if (kindPrev != KND_RANGE_COD)
			{
				if (kind != KND_AMBIG_CHR)		// .,\d,\w,\s, _xZkqqHx_jOeCjGiGjFlGiOjKiBeC_xHqqkZx_
				{
					if (m_wFlags & DREX_EXP_TO_UPCASE)
					//----- _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiPiIjHjN_xHqqkZx_ -----
					{
						// _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiBeC_xHqqkZx_
						if (_T('a') <= wChar && wChar <= _T('z'))
							wChar -= int(_T('a')) - int(_T('A'));
					}
					m_vElement.push_back(RegEnumAtom(wChar, wChar));
				} else
				{
					m_vElement.push_back(RegEnumAtom(wChar, 0));
				}
			} else
			{
				if (m_wFlags & DREX_EXP_TO_UPCASE)
				//----- _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiPiIjHjN_xHqqkZx_ -----
				{
					// _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiBeC_xHqqkZx_
					if (_T('a') <= wChar && wChar <= _T('z'))
						wChar -= int(_T('a')) - int(_T('A'));
				}
				m_vElement.back().m_wCharUntil = wChar;
			}
		}
		kindPrev = kind;
	}
} // RegNodeEnumChar::SetExpression.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeEnumChar::IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCkKiBeBiOhHjCoIiCmMiDeOiDiJiDfIiCmMiDfEiDhFiDeOiDiJiDfIiCmFiCkAiCoJiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	type	:_xZkqqHx_jClCiCnHiCoJiDeOiDiJiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeEnumChar::IsKindOf (NODE_TYPE type)
{
	if (type == NODE_ENUM_CHAR) return TRUE;
	return RegNodeAnyChar::IsKindOf(type);
} // RegNodeEnumChar::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegNodeEnumChar::IsMatch
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMjFlGiOjKjHpBiCmMjAoGjDkKjFlGiOjKiCmJiBeBiClBiCmMiDeJiDhFiDfHiDeGiDeOiDgHiCkKiDhNiDgCiDgAiClFiCmEiCkCiCoJiCkJ_xHqqkZx_
 *			_xZkqqHx_iCmHiCkEiCkJiCpAjClCiCnHiCoJiBeCiDhNiDgCiDgAiClFiCmEiCkCiCoJiPoKiNiHiCmNiBeBiOjPiCmMiDgNiBfLiDgIiCmJiPiIjHjNiCpA_xHqqkZx_
 *			_xZkqqHx_jBjHiCoJiCmMiCmFiBeBjIeBiNlNjDeJiCmJjFlGiOjKjHpBjBfDjBmMiCmMiDhNiDgCiDgAiDjDiDePiCpAjClCiCnHiCoJiClBiCmGiCkKiPgPjHiIiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wPreChar	:tcpStr_xZkqqHx_iCmMjFlGiOjKiImKjChFiCmMiIoKiCmCjBePiCmMjFlGiOjKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiNmFiMoDiCmMjFlGiOjKiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *			tcpStr		:_xZkqqHx_iClBiCoKiCkJiCoHjClCiCnHiCoJjFlGiOjKjHpBiCmMjAoGjDkKiCpAiOhHjCoIiBeC_xHqqkZx_
 *						 _xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmNiBeBiIoKjChGiClFiClNjEmNiImNiCmMiOjPiCmMjFlGiOjKiImKjChFiCpA_xHqqkZx_
 *						 _xZkqqHx_jFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhNiDgCiDgAiClFiClNiPoKiNiHiCmN_xHqqkZx_ TRUE_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
BOOL RegNodeEnumChar::IsMatch (WORD& wPreChar, CTCP& tcpStr, CTCP tcpStrEnd)
{
	CTCP tcpNext;
	WORD wChar = GetWChar(tcpNext, tcpStr, tcpStrEnd);
	// _xZkqqHx_jFlGjGjGiCmIiCoHiCmOiBeB_xHqqkZx_FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (wChar == _T('\0')) return FALSE;
	if (m_wFlags & DREX_EXP_TO_UPCASE)
	//----- _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_jBoFjFlGiOjKiCnGjFmPiKlHiBeC_xHqqkZx_
		if (_T('a') <= wChar && wChar <= _T('z'))
			wChar -= int(_T('a')) - int(_T('A'));
	}
	//----- _xZkqqHx_iNfMjAkMjHhGjBgGiCmGjBmOiPnLiCmMjFlGiOjKiCpAjEoEiKhC_xHqqkZx_ -----
	RegEnumAtomVector::iterator iEl;
	for (iEl = m_vElement.begin(); iEl != m_vElement.end(); iEl++)
	{
		if ((*iEl).IsMatch(wChar)) break;
	}
	if (!m_bInvert)
	//----- _xZkqqHx_jElNjDfNiCmFiCmNjGlDiCkCiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_jFlGiOjKiCkKiIoKiCmCiCoAiIoKjChGiClFiCmIiCkCiCmIiCoHiCmO_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
		if (iEl == m_vElement.end()) return FALSE;
	} else
	//----- _xZkqqHx_jElNjDfNiCmMiPoKiNiHiCmMiPiIjHjN_xHqqkZx_ -----
	{
		// _xZkqqHx_jFlGiOjKiCkKiIoKiCmCiCmFiCoAiIoKjChGiClFiClNiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
		if (iEl != m_vElement.end()) return FALSE;
	}
	// _xZkqqHx_iMhAjBlBiCmMiOkOiCkKiIoKjChGiClFiCmIiCkCiPoKiNiHiCmN_xHqqkZx_ FALSE _xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	if (m_pNodeNext != NULL)
		if (!m_pNodeNext->IsMatch(wChar, tcpNext, tcpStrEnd)) return FALSE;
	// _xZkqqHx_iIoKjChGiClFiClNiImKjChFiCnMiCmFjFlGiOjKiCpAjAgJiCnPiCoJiBeC_xHqqkZx_
	wPreChar = wChar;
	tcpStr = tcpNext;
	return TRUE;
} // RegNodeEnumChar::IsMatch.

