#ifndef __CPalette_h
#define __CPalette_h

class MfcPalette : public MfcGdiObject
{
public:
	static MfcPalette* New ();
	static void Delete (MfcPalette* pPalette);
	static MfcPalette* FromHandle (HPALETTE hPalette);
	BOOL CreatePalette (LPLOGPALETTE lpLogPalette);
	BOOL CreateHalftonePalette (MfcDC* pDC);
	operator HPALETTE () const;
	int GetEntryCount ();
	UINT GetPaletteEntries (UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors) const;
	UINT SetPaletteEntries (UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors);
	void AnimatePalette (UINT nStartIndex, UINT nNumEntries, LPPALETTEENTRY lpPaletteColors);
	UINT GetNearestPaletteIndex (COLORREF crColor) const;
	BOOL ResizePalette (UINT nNumEntries);

	virtual MfcRuntimeClass* GetRuntimeClass() const;
	virtual ~MfcPalette();
};

#endif//__CPalette_h
