#ifndef __CRgn_h
#define __CRgn_h

class MfcRgn : public MfcGdiObject
{
public:
	static MfcRgn* New ();
	static void Delete (MfcRgn* pRgn);
	static MfcRgn* FromHandle (HRGN hRgn);
	operator HRGN () const;
	BOOL CreateRectRgn (int x1, int y1, int x2, int y2);
	BOOL CreateRectRgnIndirect (LPCRECT lpRect);
	BOOL CreateEllipticRgn (int x1, int y1, int x2, int y2);
	BOOL CreateEllipticRgnIndirect (LPCRECT lpRect);
	BOOL CreatePolygonRgn (LPPOINT lpPoints, int nCount, int nMode);
	BOOL CreatePolyPolygonRgn (LPPOINT lpPoints, LPINT lpPolyCounts, int nCount, int nPolyFillMode);
	BOOL CreateRoundRectRgn (int x1, int y1, int x2, int y2, int x3, int y3);
	BOOL CreateFromPath (MfcDC* pDC);
	BOOL CreateFromData (const XFORM* lpXForm, int nCount, const RGNDATA* pRgnData);
	void SetRectRgn (int x1, int y1, int x2, int y2);
	void SetRectRgn (LPCRECT lpRect);
	int CombineRgn (MfcRgn* pRgn1, MfcRgn* pRgn2, int nCombineMode);
	int CopyRgn (MfcRgn* pRgnSrc);
	BOOL EqualRgn (MfcRgn* pRgn) const;
	int OffsetRgn (int x, int y);
	int OffsetRgn (POINT point);
	int GetRgnBox (LPRECT lpRect) const;
	BOOL PtInRegion (int x, int y) const;
	BOOL PtInRegion (POINT point) const;
	BOOL RectInRegion (LPCRECT lpRect) const;
	int GetRegionData (LPRGNDATA lpRgnData, int nCount) const;

	virtual MfcRuntimeClass* GetRuntimeClass() const;
	virtual ~MfcRgn();
};

#endif//__CRgn_h
