#ifndef __CView_h
#define __CView_h

class MfcView : public MfcWnd
{
protected:
public:
	virtual MfcRuntimeClass* GetRuntimeClass() const;

// Constructors
protected:

// Attributes
public:

// Operations
public:
	// for standard printing setup (override OnPreparePrinting)

// Overridables
public:
	virtual BOOL IsSelected(const MfcObject* pDocItem) const; // support for OLE

	// OLE scrolling support (used for drag/drop as well)
	virtual BOOL OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll = TRUE);
	virtual BOOL OnScrollBy(MfcSize sizeScroll, BOOL bDoScroll = TRUE);

	// OLE drag/drop support
	virtual DROPEFFECT OnDragEnter(MfcOleDataObject* pDataObject,
		DWORD dwKeyState, MfcPoint point);
	virtual DROPEFFECT OnDragOver(MfcOleDataObject* pDataObject,
		DWORD dwKeyState, MfcPoint point);
	virtual void OnDragLeave();
	virtual BOOL OnDrop(MfcOleDataObject* pDataObject,
		DROPEFFECT dropEffect, MfcPoint point);
	virtual DROPEFFECT OnDropEx(MfcOleDataObject* pDataObject,
		DROPEFFECT dropDefault, DROPEFFECT dropList, MfcPoint point);
	virtual DROPEFFECT OnDragScroll(DWORD dwKeyState, MfcPoint point);

	virtual void OnPrepareDC(MfcDC* pDC, MfcPrintInfo* pInfo = NULL);

	virtual void OnInitialUpdate(); // called first time after construct

protected:
	// Activation
	virtual void OnActivateView(BOOL bActivate, MfcView* pActivateView,
					MfcView* pDeactiveView);
	virtual void OnActivateFrame(UINT nState, MfcFrameWnd* pFrameWnd);

	// General drawing/updating
	virtual void OnUpdate(MfcView* pSender, LPARAM lHint, MfcObject* pHint);
	virtual void OnDraw(MfcDC* pDC) = 0;

	// Printing support
	virtual BOOL OnPreparePrinting(MfcPrintInfo* pInfo);
		// must override to enable printing and print preview

	virtual void OnBeginPrinting(MfcDC* pDC, MfcPrintInfo* pInfo);
	virtual void OnPrint(MfcDC* pDC, MfcPrintInfo* pInfo);
	virtual void OnEndPrinting(MfcDC* pDC, MfcPrintInfo* pInfo);

	// Advanced: end print preview mode, move to point
	virtual void OnEndPrintPreview(MfcDC* pDC, MfcPrintInfo* pInfo, POINT point,
		MfcPreviewView* pView);

// Implementation
public:
	virtual ~MfcView();
#ifdef _DEBUG
	virtual void Dump(MfcDumpContext&) const;
	virtual void AssertValid() const;
#endif //_DEBUG

	// Advanced: for implementing custom print preview

	virtual void CalcWindowRect(LPRECT lpClientRect,
		UINT nAdjustType = adjustBorder);
	virtual MfcScrollBar* GetScrollBarCtrl(int nBar) const;

protected:

public:
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra,
		AFX_MFC_CMDHANDLERINFO* pHandlerInfo);
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void PostNcDestroy();
	virtual const AFX_MFC_MSGMAP* GetMessageMap() const;
};

#endif//__CView_h
