#ifndef __CWnd_cpp
#define __CWnd_cpp

BOOL MfcWnd::operator == (const MfcWnd& wnd) const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_Eq(this, &wnd);
} // MfcWnd::operator.

BOOL MfcWnd::operator != (const MfcWnd& wnd) const
{
	return !FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_Eq(this, &wnd);
} // MfcWnd::operator.

HWND MfcWnd::GetSafeHwnd () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_GetSafeHwnd(this);
} // MfcWnd::GetSafeHwnd.

DWORD MfcWnd::GetStyle () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_GetStyle(this);
} // MfcWnd::GetStyle.

DWORD MfcWnd::GetExStyle () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_GetExStyle(this);
} // MfcWnd::GetExStyle.

BOOL MfcWnd::ModifyStyle (DWORD dwRemove, DWORD dwAdd, UINT nFlags)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_ModifyStyle(this, dwRemove, dwAdd, nFlags);
} // MfcWnd::ModifyStyle.

BOOL MfcWnd::ModifyStyleEx (DWORD dwRemove, DWORD dwAdd, UINT nFlags)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_ModifyStyleEx(this, dwRemove, dwAdd, nFlags);
} // MfcWnd::ModifyStyleEx.

MfcWnd* MfcWnd::GetOwner () const
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_GetOwner(this);
} // MfcWnd::GetOwner.

void MfcWnd::SetOwner (MfcWnd* pOwnerWnd)
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_SetOwner(this, pOwnerWnd);
} // MfcWnd::SetOwner.

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
MfcWnd* MfcWnd::FromHandle (HWND hWnd)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_FromHandle(hWnd);
} // MfcWnd::FromHandle.

MfcWnd* MfcWnd::FromHandlePermanent (HWND hWnd)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_FromHandlePermanent(hWnd);
} // MfcWnd::FromHandlePermanent.

void MfcWnd::DeleteTempMap ()
{
	FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_DeleteTempMap();
} // MfcWnd::DeleteTempMap.

BOOL MfcWnd::Attach (HWND hWndNew)
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_Attach(this, hWndNew);
} // MfcWnd::Attach.

HWND MfcWnd::Detach ()
{
	return FMpgGetModule()->GetMolipBaseI()->GetMfcClassI()->MfcWndI()->_Detach(this);
} // MfcWnd::Detach.
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

LRESULT MfcWnd::SendMessage (UINT message, WPARAM wParam, LPARAM lParam)
{
	return ::SendMessage(GetSafeHwnd(), message, wParam, lParam);
} // MfcWnd::SendMessage.

BOOL MfcWnd::PostMessage (UINT message, WPARAM wParam, LPARAM lParam)
{
	return ::PostMessage(GetSafeHwnd(), message, wParam, lParam);
} // MfcWnd::PostMessage.

#endif//__CWnd_cpp
