#ifndef __CWnd_h
#define __CWnd_h

class MfcWnd : public MfcCmdTarget
{
protected:

// Attributes
public:
	BOOL operator==(const MfcWnd& wnd) const;
	BOOL operator!=(const MfcWnd& wnd) const;

	HWND GetSafeHwnd() const;
	DWORD GetStyle() const;
	DWORD GetExStyle() const;
	BOOL ModifyStyle(DWORD dwRemove, DWORD dwAdd, UINT nFlags = 0);
	BOOL ModifyStyleEx(DWORD dwRemove, DWORD dwAdd, UINT nFlags = 0);

	MfcWnd* GetOwner() const;
	void SetOwner(MfcWnd* pOwnerWnd);

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	static MfcWnd* FromHandle (HWND hWnd);
	static MfcWnd* FromHandlePermanent (HWND hWnd);
	static void DeleteTempMap ();
	BOOL Attach (HWND hWndNew);
	HWND Detach ();
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	// subclassing/unsubclassing functions
	virtual void PreSubclassWindow();

public:
	// for child windows, views, panes etc
	virtual BOOL Create(LPCTSTR lpszClassName,
		LPCTSTR lpszWindowName, DWORD dwStyle,
		const RECT& rect,
		MfcWnd* pParentWnd, UINT nID,
		MfcCreateContext* pContext = NULL);

	// advanced creation (allows access to extended styles)

	virtual BOOL DestroyWindow();

	// special pre-creation and window rect adjustment hooks
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

	// Advanced: virtual AdjustWindowRect
	enum AdjustType { adjustBorder = 0, adjustOutside = 1 };
	virtual void CalcWindowRect(LPRECT lpClientRect,
		UINT nAdjustType = adjustBorder);

// Window tree access

// Message Functions

	LRESULT SendMessage(UINT message, WPARAM wParam = 0, LPARAM lParam = 0);
	BOOL PostMessage(UINT message, WPARAM wParam = 0, LPARAM lParam = 0);

	// for command hit testing (used for automatic tooltips)
	virtual int OnToolHitTest(MfcPoint point, TOOLINFO* pTI) const;

	virtual MfcScrollBar* GetScrollBarCtrl(int nBar) const;
			// return sibling scrollbar control (or NULL if none)

	virtual void WinHelp(DWORD dwData, UINT nCmd = HELP_CONTEXT);

	virtual BOOL ContinueModal();
	virtual void EndModalLoop(int nResult);

	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);

	virtual WNDPROC* GetSuperWndProcAddr();

	// for dialog data exchange and validation
	virtual void DoDataExchange(MfcDataExchange* pDX);

public:
	// for modality
	virtual void BeginModalState();
	virtual void EndModalState();

	// for translating Windows messages in main message pump
	virtual BOOL PreTranslateMessage(MSG* pMsg);

#ifndef _AFX_MFC_NO_OCC_SUPPORT
	// for ambient properties exposed to contained OLE controls
	virtual BOOL OnAmbientProperty(MfcOleControlSite* pSite, DISPID dispid,
		VARIANT* pvar);
#endif

protected:
	// for processing Windows messages
	virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	virtual BOOL OnWndMsg(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult);

	// for handling default processing
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);

	// for custom cleanup after WM_NCDESTROY
	virtual void PostNcDestroy();

	// for notifications from parent
	virtual BOOL OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pResult);
		// return TRUE if parent should not process this message

// Implementation
public:
	virtual ~MfcWnd();
	virtual BOOL CheckAutoCenter();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(MfcDumpContext& dc) const;
#endif

	virtual BOOL IsFrameWnd() const; // IsKindOf(RUNTIME_CLASS(MfcFrameWnd)))
	virtual void OnFinalRelease();
#ifndef _AFX_MFC_NO_OCC_SUPPORT
	virtual BOOL SetOccDialogInfo(struct _AFX_MFC_OCC_DIALOG_INFO* pOccDialogInfo);
public:
#endif

protected:
	virtual const AFX_MFC_MSGMAP* GetMessageMap() const;
};

#endif//__CWnd_h
