#ifndef __MpgModule_h
#define __MpgModule_h

//_xZkqqHx_iDiMiDfHiDfIiDgHiDiKjHhAiBeC_xHqqkZx_
#define REG_COMPANY_NAME		_T("Fukushiro Soft")
#define REG_COMPAPP_NAME		_T("Software\\Fukushiro Soft\\DynamicDraw4")
#define REG_APP_DYNAMICDRAW		_T("Dynamic Draw")
#define REG_APP_HISTORICDRAW	_T("Historic Draw")
#define REG_APP_HISTORYVIEWER	_T("History Viewer")
#define REG_APP_CHIPEDITOR		_T("Chip Editor")
#define REG_APP_ARROWEDITOR		_T("Arrow Editor")

#define CANUNLOADNOW(a)	if (##a::##GetInstanceCount() != 0) return S_FALSE;

#define MOLIPGETCLASSOBJECT(a, b) \
		case a: \
		  { \
			b* pCA = new b; \
			if (pCA == NULL) \
			{ \
				return E_OUTOFMEMORY; \
			} \
			HRESULT hr = pCA->QueryInterface(iid, ppv); \
			pCA->Release(); \
			return hr; \
		  } \
 \

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	CMpgModule
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLiCmMiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiL_xHqqkZx_(DLL)_xZkqqHx_iCmJiIoKiCmCiClOiCkPiBeBiClBiCmMiDeOiDiJiDfIiDeDiDjDiDfIiDfOiDjDiDfIiCkK_xHqqkZx_
 *			_xZkqqHx_iNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmM_xHqqkZx_MolipGetClassObject_xZkqqHx_iKnGjAjEiCmJiCoGiCmBiCmEiBeBiDhGiDiJiDePiDeDiDjDiCmM_xHqqkZx_
 *			_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiCkKiNoMjAkMiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class CMpgModule
{
protected:
	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DefaultFuncAllocate
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmMiDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sz	:_xZkqqHx_iKgNjFnLiClHiCoJiDiBiDiCiDiKiBfLiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKgNjFnLiClDiCoKiClNjHmMiIoGiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLiCkKiPiJiKpKiJlLiClDiCoKiClNiMoDiCmNiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCmM_xHqqkZx_
	 *			Allocate_xZkqqHx_iKnGjAjEiCkKiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_regsvr32.exe_xZkqqHx_iCkJiCoHiOmAiNhDiClHiCoJiPoKiNiHiBgKiCmNiBeB_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiDgGiDhEiDeIiDiLiDgHiKnGjAjEiCpAiOgHiCkEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	static void* DefaultFuncAllocate (size_t sz)
	{
		return ::operator new(sz);
	} // DefaultFuncAllocate.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	DefaultFuncFree
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDhEiDeIiDiLiDgHiCmMiDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	p	:_xZkqqHx_iJpAjFpKiClHiCoJiDiBiDiCiDiKiBfLiCmMjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	static_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLiCkKiPiJiKpKiJlLiClDiCoKiClNiMoDiCmNiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCmM_xHqqkZx_
	 *			Free_xZkqqHx_iKnGjAjEiCkKiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
	 *			_xZkqqHx_iPiJiKpKiJlLiClDiCoKiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_regsvr32.exe_xZkqqHx_iCkJiCoHiOmAiNhDiClHiCoJiPoKiNiHiBgKiCmNiBeB_xHqqkZx_
	 *			_xZkqqHx_iClBiCmMiDgGiDhEiDeIiDiLiDgHiKnGjAjEiCpAiOgHiCkEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	static void DefaultFuncFree (void* p)
	{
		::operator delete(p);
	} // DefaultFuncFree.

public:
	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CMpgModule
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	CMpgModule () :	m_pfnAllocate(NULL),	// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
					m_pfnFree(NULL),		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
					m_pIMolipBase(NULL),	// DynamicDraw_xZkqqHx_jGhLjBmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
					m_hModule(NULL) {}		// Module Handle..

//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	/*************************************************************************
//	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetLocalAllocation
//	 *
//	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DLL_xZkqqHx_iCmMiDiNiBfLiDeKiDiLiCmIiDiBiDiCiDiKiBfLiCpAiOgHiCkEiCoGiCkEiCmJiClHiCoJiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLiCkKiPiJiKpKiJlLiClDiCoKiCoJiCmGiBeB_xHqqkZx_DynamicDraw_xZkqqHx_jGhLjBmMiCmM_xHqqkZx_
//	 *			_xZkqqHx_iDiBiDiCiDiKiBfLiCkKiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
//	 *			_xZkqqHx_iDhGiDiJiDePiDeDiDjDiDiCiDfHiDiFiBfLiDiLiCkKiPiJiKpKiJlLiClDiCoKiCmIiCkCiPoKiNiHiBgJ_xHqqkZx_regsvr32.exe_xZkqqHx_iCkJiCoHiOmAiNhDiBgK_xHqqkZx_
//	 *			_xZkqqHx_iCmNiBeBiClBiCmMiKnGjAjEiCmFiDiBiDiCiDiKiBfLiKgNjFnLiCpAiDiNiBfLiDeKiDiLiCmJjAnNjCoIiClFiCmEiCkIiCkNiBeC_xHqqkZx_
//	 *
//	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
//	 *************************************************************************/
//	void SetLocalAllocation ()
//	{
//		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
//		m_pfnAllocate = DefaultFuncAllocate;
//		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
//		m_pfnFree = DefaultFuncFree;
//	} // SetLocalAllocation.
//----- 06.03.18 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Allocate
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	sz	:_xZkqqHx_iKgNjFnLiClHiCoJiDiBiDiCiDiKiBfLiCmMiDfEiDeDiDfJiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iKgNjFnLiClDiCoKiClNjHmMiIoGiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	void* Allocate (size_t sz)
	{
		return (*m_pfnAllocate)(sz);
	} // Allocate.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Free
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	p	:_xZkqqHx_iJpAjFpKiClHiCoJiDiBiDiCiDiKiBfLiCmMjHmMiIoGiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.18 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	void Free (void* p)
	{
		(*m_pfnFree)(p);
	} // Free.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetFuncAllocate
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Dynamic Draw _xZkqqHx_jGhLjBmMiCmMiDiBiDiCiDiKiBfLiDeBiDiNiDfAiBfLiDfGiDiHiDjDiKnGjAjEiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfLiDeBiDiNiDfAiBfLiDfGiDiHiDjDiKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	FuncAllocate GetFuncAllocate ()
	{
		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
		return m_pfnAllocate;
	} // GetFuncAllocate ().

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetFuncFree
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Dynamic Draw _xZkqqHx_jGhLjBmMiCmMiDiBiDiCiDiKiBfLiDhEiDiKiBfLiKnGjAjEiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiBiDiCiDiKiBfLiDhEiDiKiBfLiKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.05.11 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	FuncFree GetFuncFree ()
	{
		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
		return m_pfnFree;
	} // GetFuncFree ().

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetMolipBaseI
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DynamicDraw_xZkqqHx_jGhLjBmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	DynamicDraw_xZkqqHx_jGhLjBmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	06.03.21 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	IMpgMolipBase* GetMolipBaseI ()
	{
		return m_pIMolipBase;		// DynamicDraw_xZkqqHx_jGhLjBmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	} // GetMolipBaseI.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetModuleHandle
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgOiDjDiDgIiDiLiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.05 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	HANDLE GetModuleHandle ()
	{
		return m_hModule;
	} // GetModuleHandle.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	SetModuleHandle
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgOiDjDiDgIiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	hModule	:_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	void SetModuleHandle (HANDLE hModule)
	{
		m_hModule = hModule;
	} // SetModuleHandle.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetModulePath
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCmMiDhEiDiLiDhAiDfIiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcsPath	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			lBuffSz	:tcsPath_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiBeB_xHqqkZx__TCHAR_xZkqqHx_jFlGiOjKjAjEiCmFiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.28 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	void	GetModulePath (_TCHAR* tcsPath, long lBuffSz)
	{
		// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
		::GetModuleFileName(HMODULE(m_hModule), tcsPath, lBuffSz);
	} // GetModulePath.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetModulePathName
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKjFhEiCkLjGlMjBePiBgJiKgHjCkDiOhBjGlDiClFiBgKiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcsPath	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			lBuffSz	:tcsPath_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiBeB_xHqqkZx__TCHAR_xZkqqHx_jFlGiOjKjAjEiCmFiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	void	GetModulePathName (_TCHAR* tcsPath, long lBuffSz)
	{
		GetModulePath(tcsPath, lBuffSz);
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		_TCHAR szExt[_MAX_EXT];
//		_tsplitpath(tcsPath, NULL, NULL, NULL, szExt);
//		tcsPath[_tcslen(tcsPath) - _tcslen(szExt)] = _T('\0');
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiPoDiCmMjHjNjHfCiCmF_xHqqkZx__MAX_EXT_xZkqqHx_iCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		const size_t iPathLen = _tcslen(tcsPath);
		_TCHAR* tcpExt = new _TCHAR[iPathLen + 1];
		_tsplitpath(tcsPath, NULL, NULL, NULL, tcpExt);
		tcsPath[iPathLen - _tcslen(tcpExt)] = _T('\0');
		delete tcpExt;
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} // GetModulePathName.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	GetModuleDirPath
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDgGiDeCiDiMiDeOiDgHiDiKjGlMiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcsPath	:_xZkqqHx_iDhEiDeAiDeDiDiLjGlMiCpAiOpDiCkPiOoGiCoJiDgPiDgCiDhEiDeAiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			lBuffSz	:tcsPath_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiDfEiDeDiDfJiCpAiBeB_xHqqkZx__TCHAR_xZkqqHx_jFlGiOjKjAjEiCmFiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.06.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	void	GetModuleDirPath (_TCHAR* tcsPath, long lBuffSz)
	{
		GetModulePath(tcsPath, lBuffSz);
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		_TCHAR szFName[_MAX_FNAME];
//		_TCHAR szExt[_MAX_EXT];
//		_tsplitpath(tcsPath, NULL, NULL, szFName, szExt);
//		tcsPath[_tcslen(tcsPath) - _tcslen(szExt) - _tcslen(szFName)] = _T('\0');
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		// _xZkqqHx_iDfKiDeMiDiFiDiKiDgFiDeCiPoDiCmMjHjNjHfCiCmF_xHqqkZx__MAX_EXT_xZkqqHx_iCmNiOgHiCoNiCmIiCkCiBeC_xHqqkZx_
		const size_t iPathLen = _tcslen(tcsPath);
		_TCHAR* tcpFName = new _TCHAR[iPathLen + 1];
		_TCHAR* tcpExt = new _TCHAR[iPathLen + 1];
		_tsplitpath(tcsPath, NULL, NULL, tcpFName, tcpExt);
		tcsPath[iPathLen - _tcslen(tcpExt) - _tcslen(tcpFName)] = _T('\0');
		delete tcpExt;
		delete tcpFName;
//----- 06.10.03 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	} // GetModuleDirPath.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	Main
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DLL_xZkqqHx_iCmMiDiBiDeDiDjDiKnGjAjEiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_iDhHiDiLiDhGiOfBiPmGiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	BOOL	Main (HANDLE hModule, DWORD ul_reason_for_call)
	{
		switch (ul_reason_for_call)
		{
			case DLL_PROCESS_ATTACH:
				SetModuleHandle(hModule);
				break;
			case DLL_THREAD_ATTACH:
				break;
			case DLL_THREAD_DETACH:
				break;
			case DLL_PROCESS_DETACH:
				SetModuleHandle(NULL);
				break;
		}
		return TRUE;
	} // Main.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MolipInitialize
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DLL_xZkqqHx_iCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	pfnAllocate	:_xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			pfnFree		:_xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_S_OK_xZkqqHx_iBeBiOlIjEhDiCmIiCoHiCmO_xHqqkZx_S_FALSE_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	HRESULT	MolipInitialize (	FuncAllocate pfnAllocate,	// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
								FuncFree pfnFree,			// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
								IMpgMolipBase* pI)			// DynamicDraw_xZkqqHx_jGhLjBmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	{
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
		m_pfnAllocate = pfnAllocate;
		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
		m_pfnFree = pfnFree;
		// DynamicDraw_xZkqqHx_jGhLjBmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
		m_pIMolipBase = pI;
//----- 06.03.18 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----
		// DllRegisterServer_xZkqqHx_iCkJiCoHiMmEiCmOiCoKiCoJiPoKiNiHiBeB_xHqqkZx_DLL_xZkqqHx_iCmMiNoMjAkMjFpLjGeAiCmJiCoGiCmBiCmE_xHqqkZx_
		// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiDgOiDjDiDgIiDiLiCmMjAnNjCoIjFpLjGeAiCkKiInJiCmIiCoJiBeC_xHqqkZx_
		// MFC DLL(_xZkqqHx_jEpBiKgHjCkD_xHqqkZx_DLL) _xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_
		//   AfxGetApp() _xZkqqHx_iCmN_xHqqkZx_ NULL _xZkqqHx_iCpAjFnEiClHiClNiCnPiBeB_xHqqkZx_AfxGetStaticModuleState() _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_
		// MFC DLL(_xZkqqHx_iKgHjCkD_xHqqkZx_DLL) _xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_
		//   AfxGetApp() _xZkqqHx_iCmNjCgMiCpAjFnEiClHiCkKiBeBiClLiCoKiCmNjGhLjBmMiCmM_xHqqkZx_App_xZkqqHx_iBeC_xHqqkZx_AfxGetStaticModuleState()_xZkqqHx_iCoA_xHqqkZx_
		//   _xZkqqHx_iOgHiCkGiCoJiCkKiBeB_xHqqkZx_AfxGetStaticModuleState_xZkqqHx_iCpAiOgHiCkEiCmG_xHqqkZx_MFC_xZkqqHx_jDoAjFjEiCmM_xHqqkZx_DllMain_xZkqqHx_iCkKiOkJjDkOiCmFjBgHiCnNiNjOiCnMiCoKiBeB_xHqqkZx_
		//   _xZkqqHx_jDpBiPgEiCmJjCoIiLgAiClDiCoKiCmEiClFiCnMiCkEiBeCiClBiCmMiClNiCnPiBeB_xHqqkZx_DllMain _xZkqqHx_iCmFiDiCiDfHiDiFiBfLiDiLiDgOiDjDiDgIiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
		// MFC _xZkqqHx_iCpA_xHqqkZx_ _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiDiKiDjDiDeOiClHiCoJiPoKiNiH_xHqqkZx_
		//   AfxGetApp() _xZkqqHx_iCpAiOgHiCkEiBeC_xHqqkZx_AfxGetStaticModuleState() _xZkqqHx_iCmNjBgHiCnNiNjOiCnMiCoKiCmIiCkCiBeC_xHqqkZx_
		// MFC _xZkqqHx_iCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_
		//   DllMain _xZkqqHx_iCmFiDiCiDfHiDiFiBfLiDiLiDgOiDjDiDgIiDiLiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
//----- 06.03.17 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//#if defined(_AFXDLL) && !defined(_AFXEXT)
//	// MFC DLL(_xZkqqHx_jEpBiKgHjCkD_xHqqkZx_DLL) _xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_
//	SetModuleHandle(HANDLE(AfxGetStaticModuleState()->m_hCurrentInstanceHandle));
//#elif defined(_AFXEXT)
//	// MFC DLL(_xZkqqHx_iKgHjCkD_xHqqkZx_DLL) _xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_
//#elif defined(_AFX) && !defined(_AFXDLL)
//	// MFC _xZkqqHx_iCpA_xHqqkZx_ _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiDiKiDjDiDeOiClHiCoJiPoKiNiH_xHqqkZx_
//	SetModuleHandle(HANDLE(AfxGetApp()->m_hInstance));
//#elif !defined(_AFX)
//	// MFC _xZkqqHx_iCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_
//#else
//	_xZkqqHx_iClBiClBiCmJiCkNiCoJiClBiCmGiCmNiCkAiCoIiCkGiCmIiCkCiBeC_xHqqkZx_
//#endif
//----- 06.03.17 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----

#if defined(_AFX)
//----- MFC_xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_ -----
#if defined(_AFXDLL)
//----- MFC DLL_xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_ -----
#if defined(_AFXEXT)
//----- MFC _xZkqqHx_iKgHjCkD_xHqqkZx_DLL_xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_ -----

	// DllMain_xZkqqHx_iCkJiCoHjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_

#else // _AFXEXT.
//----- MFC _xZkqqHx_jEpBiKgHjCkD_xHqqkZx_DLL_xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_ -----

	// MFC DLL(_xZkqqHx_jEpBiKgHjCkD_xHqqkZx_DLL) _xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_
	SetModuleHandle(HANDLE(AfxGetStaticModuleState()->m_hCurrentInstanceHandle));

#endif // _AFXEXT.
#else // _AFXDLL
//----- MFC STATIC_xZkqqHx_iCpAiOgHiCkEiPoKiNiH_xHqqkZx_ -----

//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// MFC _xZkqqHx_iCpA_xHqqkZx_ _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiDiKiDjDiDeOiClHiCoJiPoKiNiH_xHqqkZx_
//	SetModuleHandle(HANDLE(AfxGetApp()->m_hInstance));
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// MFC _xZkqqHx_iCpA_xHqqkZx_ _xZkqqHx_iDfIiDfOiDgFiDeCiDgCiDeOiDiKiDjDiDeOiClHiCoJiPoKiNiHiCmNiBeB_xHqqkZx_AfxGetStaticModuleState_xZkqqHx_iKnGjAjEiCmN_xHqqkZx_
	// _xZkqqHx_jCpBiLjPiClDiCoKiCmIiCkCiBeC_xHqqkZx_
	SetModuleHandle(HANDLE(AfxGetModuleState()->m_hCurrentInstanceHandle));

#endif // _AFXDLL
#else // _AFX
//----- MFC_xZkqqHx_iCpAiOgHiCoNiCmIiCkCiPoKiNiH_xHqqkZx_ -----

	// DllMain_xZkqqHx_iCkJiCoHjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_

#endif // _AFX

//----- 06.03.17 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		return S_OK;
	} // MolipInitialize.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MolipTerminate
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	DLL_xZkqqHx_iCpAiPeJjHlJiClHiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_S_OK_xZkqqHx_iBeBiOlIjEhDiCmIiCoHiCmO_xHqqkZx_S_FALSE_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	05.05.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	HRESULT	MolipTerminate ()
	{
		SetModuleHandle(NULL);
		return S_OK;
	} // MolipTerminate.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	CanUnloadNow
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmM_xHqqkZx_DLL_xZkqqHx_iCkKiJpAjFpKiJmCjEfMiCkJiCmHiCkEiCkJiCpAjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iJpAjFpKiJmCjEfMiCmIiCoHiCmO_xHqqkZx_ S_OK_xZkqqHx_iBeBjFhDiJmCiCmIiCoHiCmO_xHqqkZx_S_FALSE_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	HRESULT	CanUnloadNow ()
	{
	//	if (CA0::GetInstanceCount() != 0) return S_FALSE;
#ifdef COMPONENT_CLASS_CA0
		CANUNLOADNOW(COMPONENT_CLASS_CA0)
#endif
#ifdef COMPONENT_CLASS_CA1
		CANUNLOADNOW(COMPONENT_CLASS_CA1)
#endif
#ifdef COMPONENT_CLASS_CA2
		CANUNLOADNOW(COMPONENT_CLASS_CA2)
#endif
#ifdef COMPONENT_CLASS_CA3
		CANUNLOADNOW(COMPONENT_CLASS_CA3)
#endif
#ifdef COMPONENT_CLASS_CA4
		CANUNLOADNOW(COMPONENT_CLASS_CA4)
#endif
#ifdef COMPONENT_CLASS_CA5
		CANUNLOADNOW(COMPONENT_CLASS_CA5)
#endif
#ifdef COMPONENT_CLASS_CA6
		CANUNLOADNOW(COMPONENT_CLASS_CA6)
#endif
#ifdef COMPONENT_CLASS_CA7
		CANUNLOADNOW(COMPONENT_CLASS_CA7)
#endif
		return S_OK;
	} // CanUnloadNow.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MolipGetClassObject
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiClDiCoKiClNiDeDiDjDiDgGiDgCiDeOiDfIiCmMiDfCiDjDiDhMiBfLiDgMiDjDiDgHiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpA_xHqqkZx_
	 *			_xZkqqHx_iNoMjAkMiClFiCmEjFnEiClHiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	idxCompo:_xZkqqHx_iDfCiDjDiDhMiBfLiDgMiDjDiDgHiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			iid		:_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			ppv		:_xZkqqHx_iDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOpDiCkPiOoGiCoJjFmPjAjEiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jAkMiMpHiClFiClNiPoKiNiHiCmN_xHqqkZx_ S_OK_xZkqqHx_iBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.09.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	HRESULT	MolipGetClassObject (int idxCompo, const IID& iid, void** ppv)
	{
		switch (idxCompo)
		{
//		case 0:
//		  {
//			CA0* pCA0 = new CA0;
//			if (pCA0 == NULL)
//			{
//				return E_OUTOFMEMORY;
//			}
//			// _xZkqqHx_jHhGiLiBiCmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiCpAiOoGjDlOiBeC_xHqqkZx_
//			HRESULT hr = pCA0->QueryInterface(iid, ppv);
//			pCA0->Release();
//			return hr;
//		  }

#ifdef COMPONENT_CLASS_CA0
		MOLIPGETCLASSOBJECT(0, COMPONENT_CLASS_CA0)
#endif
#ifdef COMPONENT_CLASS_CA1
		MOLIPGETCLASSOBJECT(1, COMPONENT_CLASS_CA1)
#endif
#ifdef COMPONENT_CLASS_CA2
		MOLIPGETCLASSOBJECT(2, COMPONENT_CLASS_CA2)
#endif
#ifdef COMPONENT_CLASS_CA3
		MOLIPGETCLASSOBJECT(3, COMPONENT_CLASS_CA3)
#endif
#ifdef COMPONENT_CLASS_CA4
		MOLIPGETCLASSOBJECT(4, COMPONENT_CLASS_CA4)
#endif
#ifdef COMPONENT_CLASS_CA5
		MOLIPGETCLASSOBJECT(5, COMPONENT_CLASS_CA5)
#endif
#ifdef COMPONENT_CLASS_CA6
		MOLIPGETCLASSOBJECT(6, COMPONENT_CLASS_CA6)
#endif
#ifdef COMPONENT_CLASS_CA7
		MOLIPGETCLASSOBJECT(7, COMPONENT_CLASS_CA7)
#endif
#ifdef COMPONENT_CLASS_CA8
		MOLIPGETCLASSOBJECT(8, COMPONENT_CLASS_CA8)
#endif
#ifdef COMPONENT_CLASS_CA9
		MOLIPGETCLASSOBJECT(9, COMPONENT_CLASS_CA9)
#endif
		case -1:
		default:
			return CLASS_E_CLASSNOTAVAILABLE;
		}
	} // MolipGetClassObject.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	RegisterServer
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmM_xHqqkZx_DLL_xZkqqHx_iCmMjDgPjIfOiCpAiNhDiCkEiBeC_xHqqkZx_regsvr32.exe_xZkqqHx_iCmJiCoGiCoJiDeDiDjDiDfIiDgHiBfLiDiLiOjOiCmJ_xHqqkZx_
	 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid			:DLL_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDiCiDfHiDiFiBfLiDiL_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
	 *			wcpModuleName	:DLL_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMjDgPjIfOjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
	 *			dwSupportApp	:_xZkqqHx_iDhGiDiJiDePiDeDiDjDiCkKjBmOiJjOiClHiCoJiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDiCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	DynamicDraw_xZkqqHx_iImIiKePiCkJiCoHiOmAiNhDiClDiCoKiCoJiPoKiNiHiBeBiDiNiBfLiDeKiDiLiDiBiDiCiDiKiBfLiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	HRESULT	RegisterServer (const GUID& guid, const wchar_t* wcpModuleName, DWORD dwSupportApp)
	{
		// DLL_xZkqqHx_iCpAiPiJiKpKiJlLiBeCiDiNiBfLiDeKiDiLiDiBiDiCiDiKiBfLiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
		MolipInitialize(DefaultFuncAllocate, DefaultFuncFree, NULL);
		// DLL_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
		_TCHAR tcaAppPath[_MAX_PATH];
		// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDhEiDeAiDeDiDiLjGlMiCpAiOoGjDlOiBeC_xHqqkZx_
// 05.06.01 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		::GetModuleFileName(HMODULE(m_hModule), tcaAppPath, _MAX_PATH);
		GetModulePath(tcaAppPath, _MAX_PATH);

		//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjGlMiCpAiNoMjAkM_xHqqkZx_ -----
		// _xZkqqHx_jHoBiBeG_xHqqkZx_"{XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX}"
		_TCHAR tcaCLSID[50];	// 40_xZkqqHx_jFlGiOjKjCpGjDhIiClOiCkKiBeBjHfNjHfEiCpAiOjNiClNiClJiCmEiBeC_xHqqkZx_
		_stprintf(tcaCLSID,	_T("{%08lX-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}"),
							guid.Data1, guid.Data2, guid.Data3,
							guid.Data4[0], guid.Data4[1], guid.Data4[2], guid.Data4[3],
							guid.Data4[4], guid.Data4[5], guid.Data4[6], guid.Data4[7]);
		// _xZkqqHx_jHoBiBeG_xHqqkZx_"CLSID\{6B73A07D-1F3A-4502-A920-57CFA19DE990}\PlugIn4.1\{XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX}"
		_TCHAR tcaSubKey[16400];	// 255_xZkqqHx_jFlGiOjKiCmMjAkHiMmAjDjJiCkAiCoJiCkKiBeBiCmGiCoIiCkAiCkGiClIjHfNjHfEiCpAiOjNiClNiClJiCmEiBeC_xHqqkZx_
//----- 06.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		_stprintf(tcaSubKey, _T("CLSID\\%s\\PlugIn4.0\\%s"), DYNAMIC_DRAW_CLSID_TSTR, tcaCLSID);
//
//----- 06.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		_stprintf(	tcaSubKey,
					_T("CLSID\\%s\\PlugIn%d.%d\\%s"),
					DYNAMIC_DRAW_CLSID_TSTR,
					FD_APP_MAJOR_VER,
					FD_APP_MINOR_VER,
					tcaCLSID);
//----- 06.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
		//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKjDgPjIfO_xHqqkZx_ -----
		HKEY hKey;
		DWORD dwDisposition;
		long lStatus = RegCreateKeyEx(HKEY_CLASSES_ROOT, tcaSubKey, 0L, _T(""),
							REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS | KEY_WRITE,
							NULL, &hKey, &dwDisposition);
		if (lStatus == ERROR_SUCCESS)
		{
			// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMiCpA_xHqqkZx__TCHAR_xZkqqHx_iMfOiCmJiBeC_xHqqkZx_
			tcstring tcsModuleName = (const _TCHAR*)WStrToTStr(wcpModuleName);
			// _xZkqqHx_iDhEiDeAiDeDiDiLjGlMjAnNjCoIiBeC_xHqqkZx_
			(void)RegSetValueEx(hKey, _T("FilePath"), 0, REG_SZ, (LPBYTE)(LPCTSTR)tcaAppPath,
								DWORD(_tcslen(tcaAppPath) + 1) * sizeof(_TCHAR));
			// _xZkqqHx_iDiCiDfHiDiFiBfLiDiLjGlMjAnNjCoIiBeC_xHqqkZx_
			(void)RegSetValueEx(hKey, _T("ModuleName"), 0, REG_SZ, (LPBYTE)tcsModuleName.c_str(),
								DWORD(tcsModuleName.length() + 1) * sizeof(_TCHAR));
			// _xZkqqHx_jBmOiJjOiDeBiDhGiDiKiDfAiBfLiDfGiDiHiDjDjAnNjCoIiBeC_xHqqkZx_
			(void)RegSetValueEx(hKey, _T("AppMode"), 0, REG_DWORD, (LPBYTE)&dwSupportApp, sizeof(dwSupportApp));
			RegCloseKey(hKey);
		}
		// DLL_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_
		MolipTerminate();
		return S_OK;
	} // RegisterServer.

	/*************************************************************************
	 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	UnregisterServer
	 *
	 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmM_xHqqkZx_DLL_xZkqqHx_iCmMjDgPjIfOiCpAjGjFiPmBiClHiCoJiBeC_xHqqkZx_regsvr32.exe_xZkqqHx_iCmJiCoGiCoJiDeBiDjDiDeDiDjDiDfIiDgHiBfLiDiLiOjOiCmJ_xHqqkZx_
	 *			_xZkqqHx_iOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	guid	:DLL_xZkqqHx_iDiCiDfHiDiFiBfLiDiLiCmMiDiCiDfHiDiFiBfLiDiL_xHqqkZx_CLSID_xZkqqHx_iCpAiOhHjCoIiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	DynamicDraw_xZkqqHx_iImIiKePiCkJiCoHiOmAiNhDiClDiCoKiCoJiPoKiNiHiBeBiDiNiBfLiDeKiDiLiDiBiDiCiDiKiBfLiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
	 *
	 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.05.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
	 *************************************************************************/
	HRESULT	UnregisterServer (const GUID& guid)
	{
		// DLL_xZkqqHx_iCpAiPiJiKpKiJlLiBeCiDiNiBfLiDeKiDiLiDiBiDiCiDiKiBfLiCpAiKiEiCoIjDjGiCmEiCoJiBeC_xHqqkZx_
		MolipInitialize(DefaultFuncAllocate, DefaultFuncFree, NULL);
		//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiDeMiBfLjGlMiCpAiNoMjAkM_xHqqkZx_ -----
		// _xZkqqHx_jHoBiBeG_xHqqkZx_"{XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX}"
		_TCHAR tcaCLSID[50];	// 40_xZkqqHx_jFlGiOjKjCpGjDhIiClOiCkKiBeBjHfNjHfEiCpAiOjNiClNiClJiCmEiBeC_xHqqkZx_
		_stprintf(tcaCLSID,	_T("{%08lX-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}"),
							guid.Data1, guid.Data2, guid.Data3,
							guid.Data4[0], guid.Data4[1], guid.Data4[2], guid.Data4[3],
							guid.Data4[4], guid.Data4[5], guid.Data4[6], guid.Data4[7]);
		// _xZkqqHx_jHoBiBeG_xHqqkZx_"CLSID\{6B73A07D-1F3A-4502-A920-57CFA19DE990}\PlugIn4.1"
		_TCHAR tcaSubKey[16400];	// 255_xZkqqHx_jFlGiOjKiCmMjAkHiMmAjDjJiCkAiCoJiCkKiBeBiCmGiCoIiCkAiCkGiClIjHfNjHfEiCpAiOjNiClNiClJiCmEiBeC_xHqqkZx_
//----- 06.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//		_stprintf(tcaSubKey, _T("CLSID\\%s\\PlugIn4.0"), DYNAMIC_DRAW_CLSID_TSTR);
//----- 06.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
		_stprintf(	tcaSubKey,
					_T("CLSID\\%s\\PlugIn%d.%d"),
					DYNAMIC_DRAW_CLSID_TSTR,
					FD_APP_MAJOR_VER,
					FD_APP_MINOR_VER);
//----- 06.12.06 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

		//----- HKEY_CLASSES_ROOT_xZkqqHx_iCmMiDiMiDfHiDfIiDgHiDiKjDgPjIfOiNoNiPjM_xHqqkZx_ -----
		HKEY hKey;
		long lStatus = RegOpenKeyEx(HKEY_CLASSES_ROOT, tcaSubKey,
									0, KEY_ALL_ACCESS, &hKey);
		if (lStatus == ERROR_SUCCESS)
		{
			(void)RegDeleteKey(hKey, tcaCLSID);
			RegCloseKey(hKey);
		}

		const _TCHAR* szaAppName[] =
			{ REG_APP_DYNAMICDRAW, REG_APP_HISTORICDRAW, REG_APP_HISTORYVIEWER, REG_APP_CHIPEDITOR, REG_APP_ARROWEDITOR };

		for (int iC = 0; iC < sizeof(szaAppName)/sizeof(szaAppName[0]); iC++)
		{
			//----- _xZkqqHx_iDiMiDfHiDfIiDgHiDiKiDeMiBfLjGlMiCpAiNoMjAkM_xHqqkZx_ -----
			// "Software\Fukushiro Soft\DynamicDraw4\AppName\PlugIn"
			// _xZkqqHx_iDeMiBfLjGlMiCpAiNoMjAkMiBeC_xHqqkZx_
			_stprintf(tcaSubKey, _T("%s\\%s\\PlugIn"), REG_COMPAPP_NAME, szaAppName[iC]);
			//----- HKEY_CURRENT_USER_xZkqqHx_iCmMiDiMiDfHiDfIiDgHiDiKjDgPjIfOiNoNiPjM_xHqqkZx_ -----
			lStatus = RegOpenKeyEx(HKEY_CURRENT_USER, (const _TCHAR*)tcaSubKey,
										0, KEY_ALL_ACCESS, &hKey);
			if (lStatus == ERROR_SUCCESS)
			{
				(void)RegDeleteValue(hKey, tcaCLSID);
				(void)RegDeleteKey(hKey, tcaCLSID);
				RegCloseKey(hKey);
			}
		}
		// DLL_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_
		MolipTerminate();
		return S_OK;
	} // UnregisterServer.

protected:
	FuncAllocate	m_pfnAllocate;		// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Allocate_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	FuncFree		m_pfnFree;			// _xZkqqHx_iDiBiDiCiDiKiBfL_xHqqkZx_Free_xZkqqHx_iKnGjAjEiBeC_xHqqkZx_
	IMpgMolipBase*	m_pIMolipBase;		// DynamicDraw_xZkqqHx_jGhLjBmMiDeDiDjDiDfOiDhEiDeGiBfLiDfIiBeC_xHqqkZx_
	HANDLE			m_hModule;			// Module Handle.
}; // class CMpgModule.

//----- 06.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//template<class T> CMpgModule* _FMpgGetModule ()
//{
//	static CMpgModule module;
//	return &module;
//};
//
//#define FMpgGetModule _FMpgGetModule<void>
//----- 06.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
//----- 06.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//template<class T> struct _CMpgGetModule
//{
//	static CMpgModule* _FMpgGetModule ()
//	{
//		return &s_module;
//	} // _FMpgGetModule.
//	static CMpgModule s_module;
//}; // _CMpgGetModule.
//
//// 06.03.05 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
////CMpgModule _CMpgGetModule<void>::s_module;
//
//#define FMpgGetModule() _CMpgGetModule<void>::_FMpgGetModule()
//----- 06.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
extern CMpgModule* FMpgGetModule ();
//----- 06.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
//----- 06.03.05 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

#endif//__MpgModule_h
