#ifndef __MpaCompo_0_h
#define __MpaCompo_0_h

/*************************************************************************
 * <File name>	MpaCompo_0.h
 *
 * <Summary>	This is a header code of the Component-0.
 *
 * <History>	01.08.10 Fukushiro M. Creation
 *************************************************************************/

/////////////////////////////////////////////////////////////////////////////////

class CA0 : public IMpgInterface
{
public:
	//----- Interface IPgInfo -----
	virtual const GUID&		GetComponentCLSID () const;
	virtual const wchar_t*	GetAuthorName () const;
	virtual const wchar_t* GetComponentName () const;
	virtual const wchar_t* GetVersionName () const;
	virtual const wchar_t* GetComment () const;
	virtual wchar_t        GetComponentShortcut () const;

	//----- Interface IPgMain -----
	virtual HRESULT	Initialize (IMpgMolipMain* pI);
	virtual HRESULT	Terminate ();
	virtual HRESULT	OnCommand (UINT nCmdID);
	virtual HRESULT	OnUpdateCommandUI (MfcCmdUI* pCmdUI);
	virtual HRESULT GetPopHint (WString& wstrHintText, UINT nCmdID);

	//----- CA domestic -----
	CA0 ();
	virtual ~CA0 ();

private:
	// Caution!
	// The size of the array 'm_adwCommandId' must be more than the amount of the commands
	// that are registered in the CA0::Initialize.
	DWORD	m_adwCommandId[5];		// Array of the command IDs.
}; // class CA0.

// Definition of the Component-0.
#define COMPONENT_CLASS_CA0	CA0

#endif//__MpaCompo_0_h
