/*************************************************************************
 * <File name>	MpaModule.cpp
 *
 * <Summary>	This is a source code of the plug-in module.
 *				One plug-in dll must include one plug-in module.
 *
 * <History>	01.08.10 Fukushiro M. Creation
 *************************************************************************/

#include "stdafx.h"
#include <assert.h>			// For assert.
#include "MpaModule.h"		// This header.

// A CLSID for the plug-in module.
// Each plug-in module must have a unique CLSID.
// You can get the unique CLSID using 'guidgen.exe'.
// Caution!
// This CLSID must be different from the value of PG_COMPONENT_CLSID.
----- Modify below -----
// {7A736A4A-1397-48E5-9BA1-4BE393B9E307}
static const GUID PG_MODULE_CLSID = FMpgGuid(0x7a736a4a, 0x1397, 0x48e5, 0x9b, 0xa1, 0x4b, 0xe3, 0x93, 0xb9, 0xe3, 0x7);
----- End of modification -----

// Specification of the applications that this plug-in is supporting.
// The value is a combination of the following.
// FD_APPMODE_DYNAMICDRAW	:Dynamic Draw.
// FD_APPMODE_CHIPEDITOR	:Chip Editor.
// FD_APPMODE_ARROWEDITOR	:Arrow Editor.
// FD_APPMODE_HISTORYVIEWER	:History Manager.
// FD_APPMODE_HISTORICDRAW	:Dynamic Draw Professional.

// If this plug-in supports Dynamic Draw only, the following value is set.
static const WORD PG_MODULE_APP = FD_APPMODE_DYNAMICDRAW;

----- Modify below -----
// Name of the plug-in module.
static const wchar_t* PG_MODULE_NAME = L"StdSrc";

// Support information of the plug-in module.
static const wchar_t* PG_MODULE_SUPPORT_INFO = L"www.xxxx.yyy.co.jp/zzz/index.html";
----- End of modification -----

// Language identifiers that the plug-in module is supporting.
// If it supports Japanese, MAKELANGID(LANG_JAPANESE, SUBLANG_DEFAULT) must be described.
// The value 0 must be supplied at the end of the array.
// If the value 0 is described only, the plug-in module supports all languages.
// You can get the language id of the applicaion using IMpgMolipMain::GetAppLangId().

// If the plug-in supports English, the value 0 is described only.
static LANGID PG_MODULE_SUPPORT_LANG[] = { 0 };

#if defined(_AFXEXT)
// When MFC Extension DLL is used.

static AFX_EXTENSION_MODULE MpaModuleDLL = { NULL, NULL };

/*************************************************************************
 * <Function>	DllMain
 *
 * <Summary>	Main function of the DLL.
 *
 * <Parameters>	See Windows API specification.
 *
 * <Details>	When MFC Extension DLL is used.
 *
 * <History>	01.08.30 Fukushiro M. Creation
 *************************************************************************/
extern "C" int APIENTRY DllMain (HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	// Remove this if you use lpReserved
	UNREFERENCED_PARAMETER(lpReserved);

	// Registration of the module handle.
	FMpgGetModule()->Main(hInstance, dwReason);

	if (dwReason == DLL_PROCESS_ATTACH)
	{
		TRACE("PlugIn Initializing!\n");
		
		// Extension DLL one-time initialization.
		if (!AfxInitExtensionModule(MpaModuleDLL, hInstance))
			return 0;

		// Insert this DLL into the resource chain
		// NOTE: If this Extension DLL is being implicitly linked to by
		//  an MFC Regular DLL (such as an ActiveX Control)
		//  instead of an MFC application, then you will want to
		//  remove this line from DllMain and put it in a separate
		//  function exported from this Extension DLL.  The Regular DLL
		//  that uses this Extension DLL should then explicitly call that
		//  function to initialize this Extension DLL.  Otherwise,
		//  the CDynLinkLibrary object will not be attached to the
		//  Regular DLL's resource chain, and serious problems will
		//  result.

		new CDynLinkLibrary(MpaModuleDLL);
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		TRACE("PlugIn Terminating!\n");
		// Terminate the library before destructors are called
		AfxTermExtensionModule(MpaModuleDLL);
	}
	return 1;   // ok
} // DllMain.

#elif !defined(_AFX)
// When MFC is not used.

/*************************************************************************
 * <Function>	DllMain
 *
 * <Summary>	Main function of the DLL.
 *
 * <Parameters>	See Windows API specification.
 *
 * <Details>	When MFC is not used.
 *
 * <History>	01.08.02 Fukushiro M. Creation
 *************************************************************************/
extern "C" BOOL APIENTRY DllMain (	HANDLE hModule,
									DWORD ul_reason_for_call,
									LPVOID lpReserved)
{
	// Registration of the module handle.
	return FMpgGetModule()->Main(hModule, ul_reason_for_call);
} // DllMain.
#endif //!defined(_AFX)

// When Standard MFC DLL or static MFC library is used,
// you don't have to define DllMain.

// Definition for MolipSDK.
// The following must be described at the end of the 'MpaModule.cpp' only.
#include "MpgMolipSdk.cpp"

