#include "stdafx.h"
#include "2NewFDObjAny.h"	// For NewFDObjAny.
#include "2ChipRec.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2ChipRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiPoOjFpB_xHqqkZx_
 *************************************************************************/
class MC2ChipRec
{
public:
	MC2ChipRec ();
	MC2ChipRec (MC2ObjBase* objbpChip, VOID* pBits, const char* pName);
	void OutStream (MC2ARCHIVE& ar) const;
	void InStream (MC2ARCHIVE& ar);

public:
	MC2ObjBase*	m_objbpChipMaster;
	void*				m_pBits;
	char				m_sName[MD2_FD_ENV_NAME_LEN];
};

MC2ChipRec::MC2ChipRec () : m_objbpChipMaster(NULL), m_pBits(NULL)
{
// 06.03.26 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	m_sName[0] = _T('\0');
	m_sName[0] = '\0';
}

MC2ChipRec::MC2ChipRec (MC2ObjBase* objbpChip, VOID* pBits, const char* pName)
			: m_objbpChipMaster(objbpChip), m_pBits(pBits)
{
	if (m_sName != pName) _tcscpy(m_sName, pName);
}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipRec::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhNiDfIiDfOiBfLiDgAiDgCiDhGiCmMiPoOjFpBiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiCmM_xHqqkZx_MC2ARCHIVE.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ChipRec::OutStream (MC2ARCHIVE& ar) const
{
	ar << (short)(m_objbpChipMaster->Type());
	m_objbpChipMaster->OutStream(ar);
	ar.Write(m_sName, MD2_FD_ENV_NAME_LEN);
} // MC2ChipRec::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipRec::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MC2ChipRec_xZkqqHx_jCiGiCmJiDhNiDfIiDfOiBfLiDgAiDgCiDhGjFjEjFgJiCpAjAlGjAkMiClFiBeBjBkOjAkLiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *			_xZkqqHx_iClBiCmMiDhEiDeAiDeDiDiLjCiGiCmM_xHqqkZx_InStream_xZkqqHx_iKnGjAjEiBeB_xHqqkZx_InStreamSub_xZkqqHx_iKnGjAjEiCkJiCoHiOmAiNhDiClDiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDmHiCnNiNjOiCnO_xHqqkZx_MC2ARCHIVE.
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.16 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ChipRec::InStream (MC2ARCHIVE& ar)
{
	short nType;
	ar >> nType;
	m_objbpChipMaster = ::NewFDObjAny(static_cast<FTObjectType>(nType));
	m_objbpChipMaster->InStream(ar);
	ar.Read(m_sName, MD2_FD_ENV_NAME_LEN);
	m_sName[MD2_FD_ENV_NAME_LEN - 1] = '\0';
} // MC2ChipRec::InStream.

typedef vector< MC2ChipRec > MC2ChipRecVector;

static MC2ChipRecVector s_vChipRec;		// _xZkqqHx_iDgAiDgCiDhG_xHqqkZx_ID & _xZkqqHx_iPoOjFpBiKmHjHjNiDgFiBfLiDhFiDiL_xHqqkZx_.

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iDiNiBfLiDeKiDiLiKnGjAjE_xHqqkZx_.

//////////////////////////////////////////////////////////////////////////
// _xZkqqHx_iMpGiKeKiKnGjAjE_xHqqkZx_.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipTbl::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiCmMiPoOjFpBiCpA_xHqqkZx_ar_xZkqqHx_iCmJiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.03.03 Fukushiro M. MC2ARCHIVE_xZkqqHx_iCmJjBmOiJjOiBeC_xHqqkZx_
 *			99.11.01 Fukushiro M. static_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void MC2ChipTbl::OutStream (MC2ARCHIVE& ar)
{
	// _xZkqqHx_iDgAiDgCiDhGiCmMjDgPjIfOjAjEiCpAiPgPjHmN_xHqqkZx_.
	ar << static_cast<long>(s_vChipRec.size());

	MC2ChipRecVector::const_iterator iR;
	for (iR = s_vChipRec.begin(); iR != s_vChipRec.end(); iR++)
		(*iR).OutStream(ar);
} // MC2ChipTbl::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipTbl::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiCmMiPoOjFpBiCpAiDeBiBfLiDeKiDeDiDhFiCkJiCoHjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iDeBiBfLiDeKiDeDiDhF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.01.16 Fukushiro M. _xZkqqHx_jFjEjFgJiCmM_xHqqkZx_InStream_xZkqqHx_jCiGiCmFjFjEjFgJjDgPjIfOiClFiCmIiCkNiCmIiCmBiClN_xHqqkZx_
 *								_xZkqqHx_iClNiCnPiBeBjFhDjHhGiCmJiCmIiCmBiClNiIoKjFjEiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
 *			99.11.01 Fukushiro M. static_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void MC2ChipTbl::InStream (MC2ARCHIVE& ar)
{
	// _xZkqqHx_iDgAiDgCiDhGiCmMjDgPjIfOjAjEiCpAjDpMjHmN_xHqqkZx_.
	long lChips;
	ar >> lChips;
	while (0 < lChips--)
	{
		s_vChipRec.push_back(MC2ChipRec());
		s_vChipRec.back().InStream(ar);
	}
} // MC2ChipTbl::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ChipTbl::Clear
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgAiDgCiDhGiPoOjFpBiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jBiAiNoMjBmOiPnLiDgAiDgCiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCmGiClFiCmEiBeB_xHqqkZx_-1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *			99.11.01 Fukushiro M. static_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
short MC2ChipTbl::Clear ()
{
	/*----- _xZkqqHx_iDgAiDgCiDhGiLhJiCnBiDgAiDgCiDhGiPoOjFpBiCpAiKeKjFpK_xHqqkZx_ -----*/
	MC2ChipRecVector::iterator iChip;
	for (iChip = s_vChipRec.begin(); iChip != s_vChipRec.end(); iChip++)
	{
		if ((*iChip).m_pBits != NULL)
			delete[] (*iChip).m_pBits;
		if ((*iChip).m_objbpChipMaster != NULL)
			delete (*iChip).m_objbpChipMaster;
	}
	s_vChipRec.clear();
	// _xZkqqHx_jBiAiNoMjBmOiPnLiDgAiDgCiDhGiDeDiDjDiDgGiDgCiDeOiDfIiCmGiClFiCmEiBeB_xHqqkZx_-1_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
	return -1;
} // MC2ChipTbl::Clear.

