#include "stdafx.h"
#include "2RichText.h"	// For MC2RichText.
#include "2ObjFigure.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif
#define SUPER_CLASS MC2ObjBase

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjFigure
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDhEiDeAiDeDiDiLjDmHiCnNiNjOiCnNjHhAiDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_InStream_xZkqqHx_iCmFiPiJiKpKiJlLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	_xZkqqHx_jGlDiClF_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
MC2ObjFigure::MC2ObjFigure ()
{
	/*----- _xZkqqHx_iDiBiDjDiDgPjFmPjAjEiCpAiDgGiDhEiDeIiDiLiDgHjCgMiCmJiPiJiKpKiJlL_xHqqkZx_ -----*/
	m_byPenType				= FDPT_SOLID;
	m_psidPenStyle			= 0;
	m_mmfPenWeight			= FFUtilMathI->mmroundoff(0.5);
	m_scidPenForeSColor		= MD2_FD_COLOR_BLACK;
	m_ptidPenPattern		= static_cast<FD2PatternID>(-1);
	m_scidPenBackSColor		= MD2_FD_COLOR_WHITE;
	m_byBrushType			= FDBT_TRANSP;
	m_scidBrushForeSColor	= MD2_FD_COLOR_BLACK;
	m_ptidBrushPattern		= static_cast<FD2PatternID>(-1);
	m_scidBrushBackSColor	= MD2_FD_COLOR_WHITE;
	m_scidShadowSColor		= static_cast<FD2SColorID>(-1);
	m_byEMFHorzMap			= FDOF_EMFMAP_HORZ_SIZE;
	m_byEMFVertMap			= FDOF_EMFMAP_VERT_SIZE;
	m_emidEMFImage			= MD2_FD_NO_EMFIMAGE;
	m_byArrowFType			= FDUG_ARW_TYPE_FLAT;
	m_byArrowFParam0		= 0;
	m_byArrowFParam1		= 0;
	m_byArrowFParam2		= 0;
	m_byArrowBType			= FDUG_ARW_TYPE_FLAT;
	m_byArrowBParam0		= 0;
	m_byArrowBParam1		= 0;
	m_byArrowBParam2		= 0;
	m_pRichText = NULL;
} // MC2ObjFigure::MC2ObjFigure.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	IsKindOf
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
 *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
 *************************************************************************/
BOOL MC2ObjFigure::IsKindOf (FTObjectType nType) const
{
	if (nType == FDOJ_FIGURE) return TRUE;
	return SUPER_CLASS::IsKindOf(nType);
} // MC2ObjFigure::IsKindOf.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjFigure::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_MC2ARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. MC2ARCHIVE_xZkqqHx_iCpA_xHqqkZx_MC2ARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void MC2ObjFigure::OutStream (MC2ARCHIVE& ar)
{
	SUPER_CLASS::OutStream(ar);

	ar << m_psidPenStyle;			// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBeCjClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc_xZkqqHx_iBeC_xHqqkZx_
	ar << m_byPenPatternForStream;	// _xZkqqHx_iDhJiDjDiCmMiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	ar << m_byBrushPatternForStream;// _xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	ar << m_byTypeForStream;		// _xZkqqHx_iDhJiDjDiBeFiDhFiDiJiDfGiCmMiMfOiBeC_xHqqkZx_
	ar << m_mmfPenWeight;			// _xZkqqHx_iDhJiDjDiCmMjFjNiBeC_xHqqkZx_
	ar << m_scidPenForeSColor;		// _xZkqqHx_iDhJiDjDiCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar << m_wPenColorForStream;		// _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	ar << m_wBrsForeColForStream;	// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar << m_wBrsBackColForStream;	// _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	ar << m_scidShadowSColor;		// _xZkqqHx_iJgFiCmMjAeGiBeC_xHqqkZx_
	ar << m_wEMFInfoForStream;		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiPoOjFpBiBeC_xHqqkZx_
	ar << m_wArrowFForStream;		// _xZkqqHx_iKeKiOgOjGoOiIpDiPoOjFpBiBeC_xHqqkZx_
	ar << m_wArrowBForStream;		// _xZkqqHx_iPeJjHlJjGoOiIpDiPoOjFpBiBeC_xHqqkZx_

	if (m_pRichText != NULL)
	// RichText_xZkqqHx_iCkKiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
	{
		ar << BYTE(0x01);
		m_pRichText->OutStream(ar);
	} else
	// RichText_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
	{
		ar << BYTE(0x00);
	}
} // MC2ObjFigure::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjFigure::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_MC2ARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. MC2ARCHIVE_xZkqqHx_iCpA_xHqqkZx_MC2ARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void MC2ObjFigure::InStream (MC2ARCHIVE& ar)
{
	SUPER_CLASS::InStream(ar);

	ar >> m_psidPenStyle;			// _xZkqqHx_iDhJiDjDiCmMiDfIiDfOiDeDiDiLiBeCjClMjApM_xHqqkZx_,_xZkqqHx_jDfPjApM_xHqqkZx_,etc_xZkqqHx_iBeC_xHqqkZx_
	ar >> m_byPenPatternForStream;	// _xZkqqHx_iDhJiDjDiCmMiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	ar >> m_byBrushPatternForStream;// _xZkqqHx_iDhFiDiJiDfGiCmMiDhAiDfOiBfLiDjDiBeC_xHqqkZx_
	ar >> m_byTypeForStream;		// _xZkqqHx_iDhJiDjDiBeFiDhFiDiJiDfGiCmMiMfOiBeC_xHqqkZx_
	ar >> m_mmfPenWeight;			// _xZkqqHx_iDhJiDjDiCmMjFjNiBeC_xHqqkZx_
	ar >> m_scidPenForeSColor;		// _xZkqqHx_iDhJiDjDiCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar >> m_wPenColorForStream;		// _xZkqqHx_iDhJiDjDiCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	ar >> m_wBrsForeColForStream;	// _xZkqqHx_iDhFiDiJiDfGiCmMjBePiMgJjAeGiBeC_xHqqkZx_
	ar >> m_wBrsBackColForStream;	// _xZkqqHx_iDhFiDiJiDfGiCmMjEhHiMgJjAeGiBeC_xHqqkZx_
	ar >> m_scidShadowSColor;		// _xZkqqHx_iJgFiCmMjAeGiBeC_xHqqkZx_
	ar >> m_wEMFInfoForStream;		// _xZkqqHx_iDiBiDfOiDhEiDeAiDeDiDiLiPoOjFpBiBeC_xHqqkZx_
	ar >> m_wArrowFForStream;		// _xZkqqHx_iKeKiOgOjGoOiIpDiPoOjFpBiBeC_xHqqkZx_
	ar >> m_wArrowBForStream;		// _xZkqqHx_iPeJjHlJjGoOiIpDiPoOjFpBiBeC_xHqqkZx_

	BYTE byIsRTF;
	ar >> byIsRTF;
	if (byIsRTF)
	// RichText_xZkqqHx_iCkKiCkAiCoJiPoKiNiHiBeC_xHqqkZx_
	{
		if (m_pRichText == NULL)
			m_pRichText = new MC2RichText();
		m_pRichText->InStream(ar);
	} else
	// RichText_xZkqqHx_iCkKjGlDiCkCiPoKiNiHiBeC_xHqqkZx_
	{
		if (m_pRichText != NULL)
		{
			delete m_pRichText;
			m_pRichText = NULL;
		}
	}
} // MC2ObjFigure::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjFigure::~MC2ObjFigure
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *************************************************************************/
MC2ObjFigure::~MC2ObjFigure ()
{
	if (m_pRichText != NULL)
	{
		delete m_pRichText;
		m_pRichText = NULL;
	}
} // MC2ObjFigure::~MC2ObjFigure.

