#ifndef __3LayerManager_h
#define __3LayerManager_h

class MC3LayerRec
{
public:
	MC3LayerRec (const wchar_t* tcpName, WORD wFlag, MC3ObjBaseVector* pvLayer);
	void	Delete ();
	WString			m_strName;
	WORD			m_wFlag;
	MC3ObjBaseVector*	m_pvLayer;
}; // class MC3LayerRec.

typedef vector<MC3LayerRec>	MC3LayerRecVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC3LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iCmMjFjEjFgJiCmM_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCpAiKmHjHjNiClHiCoJiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.04.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC3LayerManager
{
public:
	MC3LayerManager (MC3ObjBaseVector& vBottomLayer, MC3ObjBaseVector& vTopLayer);
	virtual ~MC3LayerManager ();
	virtual void	DeleteAll ();
	virtual WString& GetName ();

	virtual void	OutStream (CArchive& ar) const;
	virtual void	InStream (CArchive& ar);

	virtual void	AppendToLZOrder (DWORD dwLayerIdx, MC3ObjBase* pObj);
	virtual DWORD	GetLayerSize () const;

	virtual void	InsertLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag);

	virtual MC3ObjBaseVector*	GetObjOrder (DWORD dwLayerIdx) const;

protected:
	WString				m_strName;
	MC3LayerRecVector	m_vLayerTable;
	DWORD				m_dwCurLayerIdx;
}; // class MC3LayerManager.

#endif//__3LayerManager_h

