#include "stdafx.h"
//#include "3ObjBase.h"			// For MC3ObjBase.
#include "3NewFDObjAny.h"	// For NewFDObjAny.
#include "3LayerManager.h"	// For MC3LayerManager.
#include "3SheetManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MC3SheetManager::MC3SheetManager ()
{
} // MC3SheetManager::MC3SheetManager.

MC3SheetManager::~MC3SheetManager ()
{
} // MC3SheetManager::~MC3SheetManager.

void MC3SheetManager::InStream (CArchive& ar)
{
	//----- _xZkqqHx_iDfGiBfLiDgHiCpAjDpMjHmN_xHqqkZx_ -----
	long lSheet;
	SheetID stid;
	// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
	ar >> lSheet;
	while (0 < lSheet--)
	{
		ar.Read(&stid, sizeof(stid));
		m_vFreqSheet.push_back(stid);
		MC3LayerManager* pRecSheet = new MC3LayerManager(m_vBottomLayer, m_vTopLayer);
		pRecSheet->InStream(ar);
		if (m_vSheet.size() <= stid)
			m_vSheet.resize(stid + 1, NULL);
		m_vSheet[stid] = pRecSheet;
	}
	MC3LayerManager* pTopSheet = m_vSheet[m_vFreqSheet.front()];
	DWORD dwTopLayer = pTopSheet->GetLayerSize() - 1;
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAjDpMjHmN_xHqqkZx_ -----
	DWORD dwObjSz;
	DWORD dwObjC;
	BYTE byType;
	MC3ObjBase* pObj;
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> dwObjSz;
	for (dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
	{
		ar >> byType;
		pObj = NewFDObjAny(FTObjectType(byType));
		pObj->InStream(ar);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
		pObj->RegisterObjForceID();
		// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
		pTopSheet->AppendToLZOrder(0, pObj);
	}
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> dwObjSz;
	for (dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
	{
		ar >> byType;
		pObj = NewFDObjAny(FTObjectType(byType));
		pObj->InStream(ar);
		// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
		pObj->RegisterObjForceID();
		// _xZkqqHx_jFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
		pTopSheet->AppendToLZOrder(dwTopLayer, pObj);
	}
} // MC3SheetManager::InStream.

void MC3SheetManager::OutStream (CArchive& ar)
{
	//----- _xZkqqHx_iDfGiBfLiDgHiCpAiPgPjHmN_xHqqkZx_ -----
	FDSheetIDVector::const_iterator iSheetID;
	// _xZkqqHx_iDfGiBfLiDgHiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << long(m_vFreqSheet.size());
	for (iSheetID = m_vFreqSheet.begin(); iSheetID != m_vFreqSheet.end(); iSheetID++)
	{
		ar.Write(&(*iSheetID), sizeof(*iSheetID));
		m_vSheet[*iSheetID]->OutStream(ar);
	}
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
	MC3ObjBaseVector::const_iterator iObj;
	// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << (DWORD)m_vBottomLayer.size();
	for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
	{
		ar << (BYTE)((*iObj)->Type());
		(*iObj)->OutStream(ar);
	}
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJiCmMjAjEiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << (DWORD)m_vTopLayer.size();
	for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
	{
		ar << (BYTE)((*iObj)->Type());
		(*iObj)->OutStream(ar);
	}
} // MC3SheetManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3SheetManager::DeleteAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHiDhNiDgMiBfLiDfHiDiDjCiGiCmMjBfDiCmEiCmMjFjEjFgJiCmMiNoNiPjMiPiIjHjNiCpAiOmAiNhDiClFiBeBiDfGiBfLiDgHiCpA_xHqqkZx_
 *			_xZkqqHx_iNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3SheetManager::DeleteAll ()
{
	//----- _xZkqqHx_jBfDiCmEiCmMiDfGiBfLiDgHiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	MC3LayerManagerPVector::iterator iZb;
	for (iZb = m_vSheet.begin(); iZb != m_vSheet.end(); iZb++)
		if (*iZb != NULL)
		{
			(*iZb)->DeleteAll();
			delete *iZb;
		}
	m_vSheet.clear();
	m_vFreqSheet.clear();
	//----- _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	MC3ObjBaseVector::iterator iObj;
	for (iObj = m_vBottomLayer.begin(); iObj != m_vBottomLayer.end(); iObj++)
	{
		delete *iObj;
	}
	m_vBottomLayer.clear();
	//----- _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAiNoNiPjMiBjFiDeOiDiKiDeB_xHqqkZx_ -----
	for (iObj = m_vTopLayer.begin(); iObj != m_vTopLayer.end(); iObj++)
	{
		delete *iObj;
	}
	m_vTopLayer.clear();
} // MC3SheetManager::DeleteAll.

