#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "4CanvasStat.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MC4CanvasStat::MC4CanvasStat ()
{
	//----- _xZkqqHx_jCgMiCmMiPiJiKpKiJlL_xHqqkZx_ -----
	m_lZoom256	= 256;		// _xZkqqHx_iDfJiBfLiDiAjCgMiBeC_xHqqkZx_
	m_stid		= 0;		// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iBeC_xHqqkZx_
	m_mmCenterX	= 0.0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
	m_mmCenterY	= 0.0;		// _xZkqqHx_iDeMiDiDiDjDiDgPiDfIjCiGjAfDiNmAjFfHiBeC_xHqqkZx_
} // MC4CanvasStat::MC4CanvasStat.

MC4CanvasStat::~MC4CanvasStat ()
{
} // MC4CanvasStat::~MC4CanvasStat.

void MC4CanvasStat::InStream (CArchive& ar)
{
	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
	DWORD dwSize;
	ar >> dwSize;
	BYTEVector vStream(dwSize);
	ar.Read(&vStream.front(), dwSize);
	const BYTE* pStreamHead = &vStream.front();
	while (pStreamHead != &(*vStream.end()))
	{
		BYTE byType;
		ReadData(byType, pStreamHead);
		switch (byType)
		{
		case FDGLST_ZOOM:		// _xZkqqHx_jEhLjHkGiBeC_xHqqkZx_
			ReadData(m_lZoom256, pStreamHead);
			break;
		case FDGLST_VIEW_POSITION:		// _xZkqqHx_iDfIiDeOiDiNiBfLiDiLiDeJiDhEiDfKiDgCiDgHiBeC_xHqqkZx_
		  {
			ReadData(m_stid, pStreamHead);
			ReadData(m_mmCenterX, pStreamHead);
			ReadData(m_mmCenterY, pStreamHead);
			break;
		  }
		default:
			// _xZkqqHx_iDhEiDeAiDeDiDiLiCkKjEgKjBlJiClFiCmEiCkCiCnMiClHiBeC_xHqqkZx_
// 06.02.27 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//			AfxThrowArchiveException(CArchiveException::badIndex, NULL);
			FFUtilErrI->ThrowMiscExceptionCode(FD_IDS_ERR_FILE_DESTROIED);
		}
	}
} // MC4CanvasStat::InStream.

void MC4CanvasStat::OutStream (CArchive& ar)
{
	//----- _xZkqqHx_iDhCiDiFiBfLiCmMjFnCiPfHiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPgPjHmNiClHiCoJ_xHqqkZx_ -----
	BYTEVector vStream;
	//----- _xZkqqHx_jEhLjHkG_xHqqkZx_  ------
	vStream << BYTE(FDGLST_ZOOM);
	vStream << m_lZoom256;
	//----- _xZkqqHx_iDhCiDiFiBfLiImKjChF_xHqqkZx_ -----
	vStream << BYTE(FDGLST_VIEW_POSITION);
	vStream << m_stid;
	vStream << m_mmCenterX;
	vStream << m_mmCenterY;

	// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << DWORD(vStream.size());
	// _xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiBeC_xHqqkZx_
	ar.Write(&vStream.front(), (long)vStream.size());
} // MC4CanvasStat::OutStream.
