#include "stdafx.h"
#include "resource.h"		// For IDS_.
#include "4ObjBase.h"		// For MC4ObjBase.
#include "4NewFDObjAny.h"	// For NewFDObjAny.
#include "4LayerManager.h"	// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerRec::MC4LayerRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName	:_xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiLjGiJmCiDhEiDiJiDePiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pvLayer	:_xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC4LayerRec::MC4LayerRec (const wchar_t* tcpName, WORD wFlag, MC4ObjBaseVector* pvLayer)
			: m_strName(tcpName), m_wFlag(wFlag), m_pvLayer(pvLayer)
{
} // MC4LayerRec::MC4LayerRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerRec::Delete
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiNoNiPjMiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeBiNmFiJlKiImKiDiMiDeDiDiEiBfLiCmMiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCmNiKePjFjEiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_jHfOiCkGiCoHiCoKiCoJiCmMiCmFiBeBiNoNiPjMiClFiCmIiCkCiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4LayerRec::Delete ()
{
	delete m_pvLayer;
	m_pvLayer = NULL;
} // MC4LayerRec::Delete.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::MC4LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	tcpName			:_xZkqqHx_iDfGiBfLiDgHjGlMiCpAiOhHjCoIiBeC_xHqqkZx_
 *			mpLZHash		:_xZkqqHx_iCgLiChJiDeJiBfLiDfPiBfL_xHqqkZx_->_xZkqqHx_iDiMiDeDiDiEiBfLiDgOiDgCiDfGiDiFiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vBottomLayer	:_xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *			vTopLayer		:_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLjFjEjFgJjEhKjHpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC4LayerManager::MC4LayerManager (MC4ObjBaseVector& vBottomLayer, MC4ObjBaseVector& vTopLayer)
{
	// _xZkqqHx_iNmFiJlKiImKiBeBiNmFiPoDiImKiDiMiDeDiDiEiBfLiCpAjAnNjCoIiBeC_xHqqkZx_
	m_vLayerTable.push_back(MC4LayerRec(L"", FDOZ_ON_DRAW, &vBottomLayer));
	m_vLayerTable.push_back(MC4LayerRec(L"", FDOZ_ON_DRAW, &vTopLayer));
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiNmFiPoDiImKiDiMiDeDiDiEiBfLiCmJjAnNjCoIiBeC_xHqqkZx_
	m_dwCurLayerIdx = DWORD(m_vLayerTable.size() - 1);
} // MC4LayerManager::MC4LayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::~MC4LayerManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC4LayerManager::~MC4LayerManager ()
{
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		m_vLayerTable[lC].Delete();
	}
	m_vLayerTable.clear();
} // MC4LayerManager::~MC4LayerManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::DeleteAll
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCpAjBfDiCmEiNoNiPjMiClFiBeBjDoAjHgFiCpAjBfDiCmEjGjFiPmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.16 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4LayerManager::DeleteAll ()
{
	//----- _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLjCiGiCmMiKgFiDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
	MC4ObjBaseVector::iterator iObj;
	for (long lC = 1; lC < long(GetLayerSize()) - 1; lC++)
	{
		MC4ObjBaseVector* pvObj = GetObjOrder(lC);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiCmMjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		for (iObj = pvObj->begin(); iObj != pvObj->end(); iObj++)
		{
			delete *iObj;
		}
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDiMiDfCiBfLiDgIiCpAiNoNiPjMiBeC_xHqqkZx_
		m_vLayerTable[lC].Delete();
	}
	// _xZkqqHx_iDiMiDeDiDiEiBfLiDgFiBfLiDhFiDiLiCpAiDeOiDiKiDeBiBeC_xHqqkZx_
	m_vLayerTable.clear();
} // MC4LayerManager::DeleteAll.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::GetName
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDfGiBfLiDgHjGlMiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.27 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
WString& MC4LayerManager::GetName ()
{
	return m_strName;
} // MC4LayerManager::GetName.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_iPgPjHmNjAoGiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4LayerManager::OutStream (CArchive& ar) const
{
	// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	ar.WriteString(m_strName);
	WriteString(ar, m_strName);
	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMiLeMjIfO_xHqqkZx_ -----
	MC4ObjBaseVector::iterator iObj;
	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << DWORD(m_vLayerTable.size() - 2);
	for (DWORD dwC = 1; dwC < m_vLayerTable.size() - 1; dwC++)
	{
		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAiPgPjHmNiBeC_xHqqkZx_
// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		ar.WriteString(m_vLayerTable[dwC].m_strName);
		WriteString(ar, m_vLayerTable[dwC].m_strName);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << m_vLayerTable[dwC].m_wFlag;
		// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << DWORD(m_vLayerTable[dwC].m_pvLayer->size());
		for (iObj = m_vLayerTable[dwC].m_pvLayer->begin();
			 iObj != m_vLayerTable[dwC].m_pvLayer->end(); iObj++)
		{
			// _xZkqqHx_jFjEjFgJiDfOiDeDiDhGiBjFjFjEjFgJiCpAiLeMjIfOiBeC_xHqqkZx_
			ar << BYTE((*iObj)->Type());
			(*iObj)->OutStream(ar);
		}
	}
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_vLayerTable.front().m_wFlag;
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_vLayerTable.back().m_wFlag;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_dwCurLayerIdx;
} // MC4LayerManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiBfLiDfOiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNiMlDiDeBiBfLiDeKiDeDiDhFiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.01.02 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4LayerManager::InStream (CArchive& ar)
{
	ASSERT(m_vLayerTable.size() == 2);
	// _xZkqqHx_iDfGiBfLiDgHjGlMiCpAjDpMjHmNiBeC_xHqqkZx_
// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//	ar.ReadString(m_strName);
	ReadString(ar, m_strName);
	//----- _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLiCmMjDgPjIfO_xHqqkZx_ -----
	WORD wFlag;
	WString wstrName;
	DWORD dwLayerSz;
	DWORD dwObjSz;
	BYTE byType;
	MC4ObjBase* pObj;
	// _xZkqqHx_jCiGiKnEiDiMiDeDiDiEiBfLjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar >> dwLayerSz;
	for (DWORD dwLayerC = 1; dwLayerC <= dwLayerSz; dwLayerC++)
	{
		// _xZkqqHx_iDiMiDeDiDiEiBfLjGlMiCpAjDpMjHmNiBeC_xHqqkZx_
// 06.05.11 Fukushiro M. 1_xZkqqHx_iNhDjFmPiNfI_xHqqkZx_ ()
//		ar.ReadString(wstrName);
		ReadString(ar, wstrName);
		// _xZkqqHx_iDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
		ar >> wFlag;
		// _xZkqqHx_iDiMiDeDiDiEiBfL_xHqqkZx_1_xZkqqHx_iCpAjBhNjDpMiBeC_xHqqkZx_
		InsertLayer(dwLayerC, wstrName.c_str(), wFlag);
		// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
		ar >> dwObjSz;
		for (DWORD dwObjC = 0; dwObjC < dwObjSz; dwObjC++)
		{
			ar >> byType;
			pObj = NewFDObjAny(FTObjectType(byType));
			pObj->InStream(ar);
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAiDgFiBfLiDhFiDiLiCmJiLkNjAkHjDgPjIfOiBeCiDePiDiLiBfLiDhGiCmMiPoKiNiHiCmNiBeBiDePiDiLiBfLiDhGiDiBiDjDiDgPiCoAjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
			pObj->RegisterObjForceID();
			// _xZkqqHx_jFjEjFgJiCpAiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiCmJjDgPjIfOiBeC_xHqqkZx_
			AppendToLZOrder(dwLayerC, pObj);
		}
	}
	// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_vLayerTable.front().m_wFlag;
	// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiDeBiDeOiDfKiDfIiDhEiDiJiDePiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_vLayerTable.back().m_wFlag;
	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_dwCurLayerIdx;
} // MC4LayerManager::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::InsertLayer
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiCmMiJlKiCmJiDiMiDeDiDiEiBfLiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jBhNjDpMiClHiCoJiDiMiDeDiDiEiBfLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeCjBhNjDpMiMoDiBeBiClBiCmM_xHqqkZx_
 *						 _xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJiCmIiCoJiBeC_xHqqkZx_
 *			tcpName, wFlag	:_xZkqqHx_iDiMiDeDiDiEiBfLiPoOjFpBiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.25 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4LayerManager::InsertLayer (DWORD dwLayerIdx, const wchar_t* tcpName, WORD wFlag)
{
	m_vLayerTable.insert(m_vLayerTable.begin() + dwLayerIdx,
						MC4LayerRec(tcpName, wFlag, new MC4ObjBaseVector));
} // MC4LayerManager::InsertLayer.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::AppendToLZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	LZ_xZkqqHx_iDeJiBfLiDfPiBfLiCmJjFjEjFgJiCpAjCmHiJmBiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_jCmHiJmBiClHiCoJiDiMiDeDiDiEiBfLiCpAiOhHjCoIiBeC_xHqqkZx_
 *			pObj		:_xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC4LayerManager::AppendToLZOrder (DWORD dwLayerIdx, MC4ObjBase* pObj)
{
	// _xZkqqHx_jCmHiJmBiClHiCoJjFjEjFgJiCmM_xHqqkZx_ZOrder_xZkqqHx_iCpAiLeMjIfOiBeC_xHqqkZx_
	DWORD dwZOrder = (DWORD)GetObjOrder(dwLayerIdx)->size();
	// _xZkqqHx_iChJiDeJiBfLiDfPiBfLiNmFiMoDiCmJjCmHiJmBiBeC_xHqqkZx_
	GetObjOrder(dwLayerIdx)->push_back(pObj);
} // MC4LayerManager::AppendToLZOrder.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::GetLayerSize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDiMiDeDiDiEiBfLjAjEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.20 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
DWORD MC4LayerManager::GetLayerSize () const
{
	return (DWORD)m_vLayerTable.size();
} // MC4LayerManager::GetLayerSize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC4LayerManager::GetObjOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iOhHjCoIiCmMiDiMiDeDiDiEiBfLiCmMjFjEjFgJjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	dwLayerIdx	:_xZkqqHx_iDiMiDeDiDiEiBfLiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_jFjEjFgJjHpBiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.17 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC4ObjBaseVector* MC4LayerManager::GetObjOrder (DWORD dwLayerIdx) const
{
	return m_vLayerTable[dwLayerIdx].m_pvLayer;
} // MC4LayerManager::GetObjOrder.

