#ifndef __Global_h
#define __Global_h

#pragma warning(disable: 4786)	// C4786_xZkqqHx_iMhIiNjAiCpAiPgPiCmIiCkNiClHiCoJiBeC_xHqqkZx_
#pragma warning(disable: 4503)	// C4503_xZkqqHx_iMhIiNjAiCpAiPgPiCmIiCkNiClHiCoJiBeC_xHqqkZx_

#include <vector>
#include <map>
#include "../ForSubCoreUtil.h"

// STL_xZkqqHx_iCmMjGlMjBePiLpDiKnEiCpAjAnNjCoIiBeC_xHqqkZx_
using namespace std;

class MC2ObjBase;
class MC2Document;

typedef vector<MC2ObjBase*>	MC2ObjBaseVector;

typedef BYTE		PatternIDV12;
typedef BYTE		PenStyleIDV12;

extern double	g_dZoom;
extern double	g_dDisplayPPM;	// Display_xZkqqHx_iCmMjIfPjHjN_xHqqkZx_pixel/mm_xZkqqHx_iCpA_xHqqkZx_LOGPIXELSX_xZkqqHx_iCmFiOoGjDlOiBeC_xHqqkZx_

#define D2L(a)  (0 < (a) ? (long)((a) + 0.5) : (long)((a) - 0.4))
// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeC_xHqqkZx_
inline long mm2lg (double a) { return D2L(g_dZoom * a); }
// _xZkqqHx_iDfIiDeKiDiJiBfLjCgMiCmMjFmPiKlHiBeC_xHqqkZx_
inline double lg2mm(long a)
	{
		return static_cast<double>(a) / g_dZoom;
	}

//----- TWIPS_xZkqqHx_iNmAjFfHiCkJiCoH_xHqqkZx_POINT_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
#define tw2pnt(a) (static_cast<double>(a) / 20.0)

//----- POINT_xZkqqHx_iNmAjFfHiCkJiCoH_xHqqkZx_TWIPS_xZkqqHx_iNmAjFfHiCnG_xHqqkZx_ -----
#define pnt2tw(a) D2L((a) * 20.0)

class MC2Document;

extern MC2Document*		g_pDoc;

//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//extern IMpgMolipMain*	g_pMolipMainI;
//#define FFMainI			g_pMolipMainI
//#define FFUtilErrI      g_pMolipMainI->GetUtilErrI()
//#define FFUtilMathI     g_pMolipMainI->GetUtilMathI()
//#define FFUtilFileI     g_pMolipMainI->GetUtilFileI()
//#define FFUtilFontI     g_pMolipMainI->GetUtilFontI()
//#define FFUtilStrI      g_pMolipMainI->GetUtilStrI()
//#define FFUtilPrintI    g_pMolipMainI->GetUtilPrintI()
//#define FFUtilCoordI    g_pMolipMainI->GetUtilCoordI()
//#define FFUtilZlibPngI  g_pMolipMainI->GetUtilZlibPngI()
//#define FFUtilMiscI     g_pMolipMainI->GetUtilMisc()
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#define MCARCHIVE CArchive

//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//struct MC2GpLinkRec;
//
//extern void operator << (CArchive& ar, const DBLPoint& mmpt);
//extern void operator << (CArchive& ar, const DBLRect& mmrt);
//extern void operator << (CArchive& ar, const MC2GpLinkRec& rec);
//extern void operator << (CArchive& ar, const CLSID& clsid);
//
//extern void operator >> (CArchive& ar, DBLPoint& mmpt);
//extern void operator >> (CArchive& ar, DBLRect& mmrt);
//extern void operator >> (CArchive& ar, MC2GpLinkRec& rec);
//extern void operator >> (CArchive& ar, CLSID& clsid);
//
//extern void FFReadString (CArchive& ar, WString& wstr);
//extern void FFWriteString (CArchive& ar, const WString& wstr);
//----- 06.05.12 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#endif//__Global_h
