#include "stdafx.h"
#include <float.h>			// For DBL_MAX.
#include "2NewFDObjAny.h"	// For NewFDObjAny.
#include "2ObjGroup.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif//SUPER_CLASS
#define SUPER_CLASS MC2ObjBase

///////////////////////////////////////////////////////////////////////////
// MC2GpLinkRec_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2GpLinkRec::MC2GpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2GpLinkRec::MC2GpLinkRec ()
	 : m_mlpFrom(0,0), m_mlpTo(0,0), m_wLinkKind(0)
{}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2GpLinkRec::MC2GpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2GpLinkRec::MC2GpLinkRec (const MC2LinkRec& rec)
			: m_mlpFrom(rec.mlpFrom), m_mlpTo(rec.mlpTo), m_wLinkKind(rec.wLinkKind)
{}


void operator << (CArchive& ar, const MC2GpLinkRec& rec)
{
	ar.Write(&rec, sizeof(rec));
}

void operator >> (CArchive& ar, MC2GpLinkRec& rec)
{
	ar.Read(&rec, sizeof(rec));
}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::MC2ObjGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_FDFoundDoc_xZkqqHx_iCmM_xHqqkZx_InStream_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
MC2ObjGroup::MC2ObjGroup ()
{
	m_lObjListSz = 0;
	m_pObjList = NULL;
	m_lLinkListSz = 0;
	m_pLinkList = NULL;
} // MC2ObjGroup::MC2ObjGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjArc::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType MC2ObjGroup::Type () const
{
	return FDOJ_GROUP;
} // MC2ObjGroup::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::OutStreamV3
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_MCARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. MCARCHIVE_xZkqqHx_iCpA_xHqqkZx_MCARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void MC2ObjGroup::OutStreamV3 (MCARCHIVE& ar)
{
	SUPER_CLASS::OutStreamV3(ar);
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjDoAjFjEjFgJiDgFiBfLiDhFiDiLiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_lObjListSz;
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiMfOiCmGjFjEjFgJiCpAiPgPjHmNiBeC_xHqqkZx_
		m_pObjList[lObjIdx]->OutByteTypeAndStream(ar);
	}
	//----- _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_lLinkListSz;
	long lLnkIdx;
	for (lLnkIdx = 0; lLnkIdx < m_lLinkListSz; lLnkIdx++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << m_pLinkList[lLnkIdx];
	}
} // MC2ObjGroup::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::InStreamV12
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_MCARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.16 Fukushiro M. _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *			99.03.03 Fukushiro M. MCARCHIVE_xZkqqHx_iCpA_xHqqkZx_MCARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *			99.10.26 Fukushiro M. RegisterObject_xZkqqHx_iCpAjGjFiPmBiBeCiDgAiDgCiDhGiCpAiOgHiCmBiClNiOjO_xHqqkZx_
 *									_xZkqqHx_jDpBiPgEjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *************************************************************************/
void MC2ObjGroup::InStreamV12 (MCARCHIVE& ar)
{
	SUPER_CLASS::InStreamV12(ar);

	long lObjIdx;
	if (m_pObjList != NULL)
	{
		//----- _xZkqqHx_iKpJjBlGiCmMjFjEjFgJiCpAjDgPjIfOjGjFiPmB_xHqqkZx_ -----
		for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
			m_pObjList[lObjIdx]->UnregisterObjID();
		//----- _xZkqqHx_iKpJjBlGiCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
		for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
			delete m_pObjList[lObjIdx];
		m_lObjListSz = 0;
		delete[] m_pObjList;
		m_pObjList = NULL;
	}
	if (m_pLinkList != NULL)
	{
		m_lLinkListSz = 0;
		delete[] m_pLinkList;
		m_pLinkList = NULL;
	}

	DBLRect mmrtResize;
	DBLRect mmrtOuter;
	ar >> mmrtResize;	// _xZkqqHx_iDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar >> mmrtOuter;	// _xZkqqHx_iNmEjFgAiJoGjHmMiIoGiBeC_xHqqkZx_
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjDoAjFjEjFgJiDgFiBfLiDhFiDiLiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	short nSize;
	ar >> nSize;
	m_lObjListSz = nSize;
	m_pObjList = new MC2ObjBase*[m_lObjListSz];
	short nType;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiMfOiCpAjDpMjHmNiBeC_xHqqkZx_
		ar >> nType;
		m_pObjList[lObjIdx] = NewFDObjAny(FTObjectType(nType));
		// _xZkqqHx_jFjEjFgJiCpAjDpMjHmNiBeC_xHqqkZx_
		m_pObjList[lObjIdx]->InStream(ar);
	}
} // MC2ObjGroup::InStreamV12.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::~MC2ObjGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
MC2ObjGroup::~MC2ObjGroup ()
{
	if (m_pObjList != NULL)
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		long lObjIdx;
		for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
			delete m_pObjList[lObjIdx];
		m_lObjListSz = 0;
		delete[] m_pObjList;
		m_pObjList = NULL;
	}
	if (m_pLinkList != NULL)
	{
		m_lLinkListSz = 0;
		delete[] m_pLinkList;
		m_pLinkList = NULL;
	}
} // MC2ObjGroup::~MC2ObjGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::RegisterObjForceID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiCgIiCgDiCpAjDgPjIfOiClHiCoJiBeCiClBiCmMjFjEjFgJiCmJjFhEiCkPiCoHiCoKiCmEiCkCiCoJiCgIiCgDiOkJjAgHiCpA_xHqqkZx_
 *			_xZkqqHx_iLkNjAkHjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmGiDgAiDgCiDhGiCmMjDgPjIfOiKnGiMfHiCmFiClBiCmMiKnGjAjEiCpAjAfGjAnNiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ObjGroup::RegisterObjForceID ()
{
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmMiKgFjFjEjFgJiCpAiLkNjAkHjDgPjIfO_xHqqkZx_ -----
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->RegisterObjForceID();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiClBiClBiCmFiClBiCmMjFjEjFgJiOkJjAgHiCmMjDgPjIfOiCkKjAkMiClDiCoKiCoJiBeC_xHqqkZx_
	SUPER_CLASS::RegisterObjForceID();
} // MC2ObjGroup::RegisterObjForceID ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	UnregisterObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_delete_xZkqqHx_jBePiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
void MC2ObjGroup::UnregisterObjID ()
{
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->UnregisterObjID();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	SUPER_CLASS::UnregisterObjID();
} // MC2ObjGroup::UnregisterObjID.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::GetMembers
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiBiDjDiDgPiBfLiCpAiOjNiCmCiPoKiNiHiCmNiBeBiDiBiDjDiDgPiBfLiCmMjFjEjFgJjEhKjHpBiCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ObjGroup::GetMembers (MC2ObjBaseVector& vObj) const
{
	vObj.clear();
	vObj.insert(vObj.end(), m_pObjList, m_pObjList + m_lObjListSz);
} // MC2ObjGroup::GetMembers.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::GetResizeFrame
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jAhNiMgAiCmMiDiKiDfEiDeDiDfJiDhEiDiMiBfLiDiAiCpAiLiBiCnPiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jCiNiInD_xHqqkZx_>	_xZkqqHx_jCgMiCmMjAlDiKgNiClDiCmGiOmAiNhDiCmMjBiBiClDiCkKiLiBiCnPiCoHiCoKiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDhEiDiMiBfLiDiAiDfEiDeDiDfJ_xHqqkZx_._xZkqqHx_iOmAiNmAjFfH_xHqqkZx_.
 *************************************************************************/
DBLRect MC2ObjGroup::GetResizeFrame () const
{
	DBLRect mmrtResize(DBL_MAX, DBL_MAX, -DBL_MAX, -DBL_MAX);
	DBLRect mmrtMembResize;
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCmMiDhEiDiMiBfLiDiAiCpAiOoGjDlOiClHiCoJiBeC_xHqqkZx_
		mmrtMembResize = m_pObjList[lObjIdx]->GetResizeFrame();
		if (mmrtMembResize.left < mmrtResize.left)
			mmrtResize.left = mmrtMembResize.left;
		if (mmrtMembResize.top < mmrtResize.top)
			mmrtResize.top = mmrtMembResize.top;
		if (mmrtResize.right < mmrtMembResize.right)
			mmrtResize.right = mmrtMembResize.right;
		if (mmrtResize.bottom < mmrtMembResize.bottom)
			mmrtResize.bottom = mmrtMembResize.bottom;
	}
	return mmrtResize;
} // MC2ObjGroup::GetResizeFrame.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2ObjGroup::SetGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmMiDiBiDjDiDgPiCpAjAnNjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	vObj	:_xZkqqHx_iDiBiDjDiDgPjFjEjFgJiPfHiNiHiCpAjAnNjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.08.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC2ObjGroup::SetGroup (const MC2ObjBaseVector& vObj)
{
	ASSERT(m_pObjList == NULL);
	m_lObjListSz = (long)vObj.size();
	m_pObjList = new MC2ObjBase*[m_lObjListSz];
	for (long lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_iDiBiDjDiDgPjFjEjFgJiCpAjAnNjCoIiBeC_xHqqkZx_
		m_pObjList[lObjIdx] = vObj[lObjIdx];
	}
} // MC2ObjGroup::SetGroup.

