#include "stdafx.h"
#include "2Document.h"			// For g_pDoc.
#include "2RichText.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//extern MC2MolipConvDllApp theApp;

#define CH_TAB	_T(0x09)
#define CH_SPC	_T(0x20)

#define FDWR_RETURN_WIDTH	fmmetol(1.0)

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myCodeToWChar
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpMjHmNiClDiCoKiClNjFlGiOjKiDfCiBfLiDgIiCpAiBeB_xHqqkZx_UNICODE_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_iCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wCode	:_xZkqqHx_jFlGiOjKiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_UNICODE_xZkqqHx_iCmMiPoKiNiHiCmGiBeB_xHqqkZx_MBCS_xZkqqHx_iCmMiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	UNICODE_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static wchar_t myCodeToWChar (WORD wCode)
{
	_TCHAR sz[3];
	if (wCode & 0xff00)
	{
		sz[0] = wCode >> 8;
		sz[1] = wCode & 0x00ff;
		sz[2] = _T('\0');
	} else
	{
		sz[0] = wCode & 0x00ff;
		sz[1] = _T('\0');
	}
	wchar_t wChar;
	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, sz, -1, &wChar, 1);
	return wChar;
} // myCodeToWChar.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	myWCharToCode
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jDpMjHmNiClDiCoKiClN_xHqqkZx_UNICODE_xZkqqHx_iCmM_xHqqkZx_wchar_t_xZkqqHx_jFlGiOjKiCpAiBeB_xHqqkZx_MBCS_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiCmJjFmPiKlHiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	wChar	:UNICODE_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiCpAiOhHjCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	MBCS_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx__UNICODE_xZkqqHx_iCmMiPoKiNiHiCmN_xHqqkZx_UNICODE_xZkqqHx_iCmMjFlGiOjKiDfCiBfLiDgIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.19 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
static WORD myWCharToCode (wchar_t wChar)
{
	_TCHAR szBuff[3];
	int iStrLen = WideCharToMultiByte(CP_ACP, 0, &wChar, 1, szBuff, 3, NULL, NULL);
	const _TCHAR* tcpStr = szBuff;
	WORD wCode = 0;
	while (0 < iStrLen--)
	{
		wCode = WORD(wCode << 8) | BYTE(*tcpStr);
		tcpStr++;
	}
	return wCode;
} // myWCharToCode.

////////////////////////////////////////////////////////////////////////////
// MC2StatCharV2

MC2StatCharV2::MC2StatCharV2 ()
{
	memset(this, 0, sizeof(*this));
} // MC2StatCharV2::MC2StatCharV2.

void MC2StatCharV2::InStreamV2 (MCARCHIVE& ar)
{
	ar >> m_wChar;			// _xZkqqHx_jFlGiOjKiDfCiBfLiDgI_xHqqkZx_.
	ar >> m_dwForStream;	// _xZkqqHx_jDpMiPgPjHmNjHhAiBeC_xHqqkZx_
	ar >> m_mmfAbcA;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcA_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	ar >> m_mmfAbcC;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcC_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	// UNICODE_xZkqqHx_iCmJjFmPiKlHiBeC_xHqqkZx_
	if (0x06 < m_wChar)
		m_wChar = myCodeToWChar(m_wChar);
} // MC2StatCharV2::InStreamV2.

////////////////////////////////////////////////////////////////////////////
// MC2StatChar

MC2StatChar::MC2StatChar ()
{
	memset(this, 0, sizeof(*this));
} // MC2StatChar::MC2StatChar.

void MC2StatChar::OutStreamV3 (MCARCHIVE& ar) const
{
	ar << m_wChar;			// _xZkqqHx_jFlGiOjKiDfCiBfLiDgI_xHqqkZx_.
	ar << m_dwForStream;	// _xZkqqHx_jDpMiPgPjHmNjHhAiBeC_xHqqkZx_
	ar << m_mmfAbcA;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcA_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
	ar << m_mmfAbcC;		// ABC_xZkqqHx_iNfMjBkCjBmMiCmM_xHqqkZx_abcC_xZkqqHx_iCmMjCgMiBeC_xHqqkZx_
} // MC2StatChar::OutStreamV2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatLine::MC2StatLine
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.11.19 Fukushiro M. _xZkqqHx_iDfCiDiBiDjDiDgHiNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2StatLine::MC2StatLine ()
{
	m_mmStartIndent	= 0.0;
	m_mmRightIndent	= 0.0;
	m_mmOffset		= 0.0;
	m_mmvTabs.clear();
	m_byAlignment	= FDRC_AL_LEFT;
	m_byLineType	= FDRC_LT_HEAD;
	m_nTwipLineAfter = 0;
	m_vStatChar.clear();
	m_mmY			= 0.0;
	m_mmfTMHeight	= 0.0;
	m_mmfTMAscent	= 0.0;
	m_mmfTMExternalLeading	= 0.0;
} // MC2StatLine::MC2StatLine.

void MC2StatLine::operator = (const MC2StatLine& sl)
{
	/*----- _xZkqqHx_jAoGjDkKiNhDiBeBiMhAjBlBiNhDiCmFjDkPiClGjCgMiCpAiOjNiCmCiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----*/
	m_mmStartIndent	= sl.m_mmStartIndent;
	m_mmRightIndent	= sl.m_mmRightIndent;
	m_mmOffset		= sl.m_mmOffset;
	m_mmvTabs		= sl.m_mmvTabs;
	m_byAlignment	= sl.m_byAlignment;

	/*----- _xZkqqHx_jAoGjDkKiNhDiBeBiMhAjBlBiNhDiCmFiInJiCmIiCoJjCgMiCpAiOjNiCmCiDiBiDjDiDgPjFmPjAjE_xHqqkZx_ -----*/
	m_byLineType			= sl.m_byLineType;
	m_nTwipLineAfter		= sl.m_nTwipLineAfter;
	m_vStatChar				= sl.m_vStatChar;
	m_mmY					= sl.m_mmY;
	m_mmfTMHeight			= sl.m_mmfTMHeight;
	m_mmfTMAscent			= sl.m_mmfTMAscent;
	m_mmfTMExternalLeading	= sl.m_mmfTMExternalLeading;
} // MC2StatLine::operator = (const MC2StatLine& sl).

void MC2StatLine::OutStreamV3 (MCARCHIVE& ar) const
{
	ar << m_mmStartIndent;			// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar << m_mmRightIndent;			// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar << m_mmOffset;				// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	//----- _xZkqqHx_iDfOiDhFiCmMiImKjChFiCmMjHpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << static_cast<WORD>(m_mmvTabs.size());
	doubleVector::const_iterator iTab;
	for (iTab = m_mmvTabs.begin(); iTab != m_mmvTabs.end(); iTab++)
		ar << *iTab;
	//----- _xZkqqHx_iClLiCmMjBlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << m_byAlignment;			// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgH_xHqqkZx_.
	ar << m_byLineType;				// _xZkqqHx_iNhDiCmMiDfOiDeDiDhG_xHqqkZx_(_xZkqqHx_jAoGjDkK_xHqqkZx_/_xZkqqHx_iMhAjBlB_xHqqkZx_)
	ar << m_nTwipLineAfter;			// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmMiDhMiDeDiDjDiDgHjAjEiBeC_xHqqkZx_
	//----- _xZkqqHx_jFlGiOjKjHpBiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << static_cast<WORD>(m_vStatChar.size());
	MC2StatCharVector::const_iterator i;
	for (i = m_vStatChar.begin(); i != m_vStatChar.end(); i++)
		(*i).OutStreamV3(ar);
	//----- _xZkqqHx_iClLiCmMjBlMiCpAiPjBiCkLiPgPiClH_xHqqkZx_ -----
	ar << m_mmY;					// _xZkqqHx_iNhDiCmMiPoDiCmMiNmAjFfH_xHqqkZx_.
	ar << m_mmfTMHeight;			// _xZkqqHx_jFlGiOjKiCmMiNiCiClD_xHqqkZx_.
	ar << m_mmfTMAscent;			// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCkJiCoHiNhDiCmMiPoDiCnMiCmFiCmMiNiCiClD_xHqqkZx_.
	ar << m_mmfTMExternalLeading;	// _xZkqqHx_jFlGiOjKiCmMiJlKiCmMiMiEiKnE_xHqqkZx_.
} // MC2StatLine::OutStreamV3.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2StatLine::InStreamV1V2
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jBkOjAkLiDgGiBfLiDfOiCmMjDpMjHmNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	:_xZkqqHx_jDpMjHmNjAoGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.04 Fukushiro M. MCARCHIVE_xZkqqHx_iCkJiCoH_xHqqkZx_MCARCHIVE_xZkqqHx_iCmJjFmPiNfIiBeC_xHqqkZx_
 *************************************************************************/
void MC2StatLine::InStreamV1V2 (MCARCHIVE& ar, CDC* pDC, CFont* pFont)
{
	ar >> m_mmStartIndent;			// _xZkqqHx_jAoGjDkKiNhDiCmMiNlGiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar >> m_mmRightIndent;			// _xZkqqHx_jAoGjDkKiBeFiMhAjBlBiNhDiCmMiJeFiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	ar >> m_mmOffset;				// _xZkqqHx_iMhAjBlBiNhDiCmMiDeDiDjDiDgGiDjDiDgH_xHqqkZx_.
	//----- _xZkqqHx_iDfOiDhFiCmMiImKjChFiCmMjHpBiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	m_mmvTabs.clear();
	WORD wSize;
	double mmTab;
	ar >> wSize;
	long lC;
	for (lC = 0; lC < wSize; lC++)
	{
		ar >> mmTab;
		m_mmvTabs.push_back(mmTab);
	}
	//----- _xZkqqHx_iClLiCmMjBlMiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	ar >> m_byAlignment;			// _xZkqqHx_iDeBiDiJiDeDiDjDiDiBiDjDiDgH_xHqqkZx_.
	ar >> m_byLineType;				// _xZkqqHx_iNhDiCmMiDfOiDeDiDhG_xHqqkZx_(_xZkqqHx_jAoGjDkK_xHqqkZx_/_xZkqqHx_iMhAjBlB_xHqqkZx_)
	WORD wPointLineAfter;
	ar >> wPointLineAfter;		// _xZkqqHx_iNhDiKnEiBgJiNhDiCmMiJlKiBgKiCmMiDhMiDeDiDjDiDgHjAjEiBeC_xHqqkZx_
	m_nTwipLineAfter = (short)pnt2tw(wPointLineAfter);

	//----- _xZkqqHx_jFlGiOjKjHpBiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	m_vStatChar.clear();

	BYTE byUnderline = BYTE(-1);	// _xZkqqHx_iJlKjApMiBeC_xHqqkZx_
	BYTE byStrikeOut = BYTE(-1);	// _xZkqqHx_iOoGiPmBiClFjApMiBeC_xHqqkZx_
	short nAfterSpace = -1;			// _xZkqqHx_jFlGiOjKiMoDiKnEiKhFiBeC_xHqqkZx_
	ar >> wSize;
	for (lC = 0; lC < wSize; lC++)
	{
		MC2StatCharV2 sc2;
		sc2.InStreamV2(ar);
		//----- AfterSpace_xZkqqHx_iCpAjAnNjCoIiClFiCmEiCkIiCkN_xHqqkZx_ -----
		if (nAfterSpace != 0)
		{
			nAfterSpace = 0;
			MC2StatChar sc3;
			sc3.m_wChar = FDRCH_AFTERSPACE;
			sc3.m_nAfterSpace = 0;
			sc3.m_mmfAbcA = 0.0;
			sc3.m_mmfAbcC = 0.0;
			m_vStatChar.push_back(sc3);
		}
		if (sc2.m_wChar == FDRCH_V2_FONT)
		//----- FONT ID _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			MC2StatChar sc3;
			sc3.m_wChar = FDRCH_FONT_AND_OFFSET;
			// V3_xZkqqHx_iCmFiCmNiBeB_xHqqkZx_Underline,StrikeOut_xZkqqHx_iCpAiDhEiDeIiDjDiDgHiPoOjFpBiCkJiCoHjFlGiOjKiPoOjFpBiCnGiInKjDkOiClFiClNiBeC_xHqqkZx_
			// _xZkqqHx_iClBiCmMiClNiCnPiBeB_xHqqkZx_V1,V2_xZkqqHx_iCmFiCmNiInJiCmIiCoJiDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iCmMiDhEiDeIiDjDiDgHiCmFiCoA_xHqqkZx_V3_xZkqqHx_iCmFiCmNjDkPiClG_xHqqkZx_
			// _xZkqqHx_iDhEiDeIiDjDiDgHiCmJiCmIiCoJiPoKiNiHiCkKiCkAiCoJiBeC_xHqqkZx_
			sc3.m_foidFont = g_pDoc->m_env->FindSameFont(sc2.m_foidFont);
			sc3.m_wOffset = 0;
			sc3.m_mmfAbcA = 0.0;
			sc3.m_mmfAbcC = 0.0;
			m_vStatChar.push_back(sc3);
			// V1,V2_xZkqqHx_iCmFiDhEiDeIiDjDiDgH_xHqqkZx_ID_xZkqqHx_iCkKjFmPiCoNiCmBiClNiPoKiNiHiCmNiBeBiJlKjApMiBeFiOoGiPmBiClFjApMiCkKjFmPiCoNiCmBiClN_xHqqkZx_
			// _xZkqqHx_iJmCjEfMjAkLiCkKiCkAiCoJiBeC_xHqqkZx_
			BYTE byUL = (g_pDoc->m_env->m_vSFont[sc2.m_foidFont]->m_dwEffects & CFE_UNDERLINE) ? 1 : 0;
			BYTE bySO = (g_pDoc->m_env->m_vSFont[sc2.m_foidFont]->m_dwEffects & CFE_STRIKEOUT) ? 1 : 0;
			if (byUnderline != byUL || byStrikeOut != bySO)
			{
				byUnderline = byUL;
				byStrikeOut = bySO;
				MC2StatChar sc3;
				sc3.m_wChar = FDRCH_LINES_AND_CROSSSTAT;
				sc3.m_byUnderline = byUnderline;
				sc3.m_byStrikeOut = byStrikeOut;
				sc3.m_byCrossStat = 0;
				sc3.m_mmfAbcA = 0.0;
				sc3.m_mmfAbcC = 0.0;
				m_vStatChar.push_back(sc3);
			}
		} else
		if (sc2.m_wChar == FDRCH_V2_OFFSET)
		//----- OFFSET _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
		} else
		if (sc2.m_wChar == FDRCH_V2_SCOLOR)
		//----- SCOLOR ID _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			MC2StatChar sc3;
			sc3.m_wChar = FDRCH_COLORREF;
			sc3.m_crColor = g_pDoc->m_env->scid2cref(sc2.m_scidSColor);
			sc3.m_mmfAbcA = 0.0;
			sc3.m_mmfAbcC = 0.0;
			m_vStatChar.push_back(sc3);
		} else
		if (sc2.m_wChar == FDRCH_V2_PRESPACE)
		//----- _xZkqqHx_jBePiKnEiKhF_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			MC2StatChar sc3;
			sc3.m_wChar = FDRCH_PRESPACE;
			sc3.m_mmfPreSpace = sc2.m_mmfPreSpace;
			sc3.m_mmfAbcA = 0.0;
			sc3.m_mmfAbcC = 0.0;
			m_vStatChar.push_back(sc3);
		} else
		if (sc2.m_wChar == FDRCH_RETURN)
		//----- _xZkqqHx_iJpMiNhD_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// V1,V2_xZkqqHx_iCmFiCmNiBeBiJpMiNhDiCmJjFjNiCkKjGlDiCkCiBeCiClBiCoKiCpAiLlIjAlDiClHiCoJiBeC_xHqqkZx_
			MC2StatChar sc3;
			sc3.m_wChar = sc2.m_wChar;
			sc3.m_mmfWidth = FDWR_RETURN_WIDTH;
			sc3.m_mmfAbcA = 0.0;
			sc3.m_mmfAbcC = 0.0;
			m_vStatChar.push_back(sc3);
		} else
		if (sc2.m_wChar == CH_SPC)
		//----- _xZkqqHx_iLpDjEjC_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			// V1,V2_xZkqqHx_iCmFiCmNiBeBiLpDjEjCiCmM_xHqqkZx_m_mmfAbcC_xZkqqHx_iCkKjFiJiCmMjCgMiCpAiOjNiCmCiClNiCnPiBeBiClBiCoKiCpA_xHqqkZx_0_xZkqqHx_iCmJiLlIjAlDiClHiCoJiBeC_xHqqkZx_
			MC2StatChar sc3;
			sc3.m_wChar = sc2.m_wChar;
			sc3.m_mmfWidth = sc2.m_mmfWidth;
			sc3.m_mmfAbcA = 0.0;
			sc3.m_mmfAbcC = 0.0;
			m_vStatChar.push_back(sc3);
		} else
		//----- _xZkqqHx_jFiBjCmKiCmMjFlGiOjK_xHqqkZx_ _xZkqqHx_iCmMiPoKiNiH_xHqqkZx_ -----
		{
			MC2StatChar sc3;
			sc3.m_wChar = sc2.m_wChar;
			sc3.m_mmfWidth = sc2.m_mmfWidth;
			sc3.m_mmfAbcA = sc2.m_mmfAbcA;
			sc3.m_mmfAbcC = sc2.m_mmfAbcC;
			m_vStatChar.push_back(sc3);
		}
	}
	//----- _xZkqqHx_iClLiCmMjBlMiCpAjDmHiCnNiNjOiCnO_xHqqkZx_ -----
	ar >> m_mmY;					// _xZkqqHx_iNhDiCmMiPoDiCmMiNmAjFfH_xHqqkZx_.
	ar >> m_mmfTMHeight;			// _xZkqqHx_jFlGiOjKiCmMiNiCiClD_xHqqkZx_.
	ar >> m_mmfTMAscent;			// _xZkqqHx_iDhIiBfLiDfIiDiJiDeDiDjDiCkJiCoHiNhDiCmMiPoDiCnMiCmFiCmMiNiCiClD_xHqqkZx_.
	ar >> m_mmfTMExternalLeading;	// _xZkqqHx_jFlGiOjKiCmMiJlKiCmMiMiEiKnE_xHqqkZx_.
} // MC2StatLine::InStreamV1V2.

void MC2StatLineVector::OutStreamV3 (MCARCHIVE& ar) const
{
	//----- _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiCpAiPgPjHmN_xHqqkZx_ -----
	ar << static_cast<long>(size());
	MC2StatLineVector::const_iterator iL;
	for (iL = begin(); iL != end(); iL++) (*iL).OutStreamV3(ar);
} // MC2StatLineVector::OutStreamV2.

void MC2StatLineVector::InStreamV2 (MCARCHIVE& ar)
{
	//----- _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_iKpJjBlGiCmMjFlGiOjKjHpBiPoOjFpBiCpAiNoNiPjMiBeC_xHqqkZx_
	clear();
	long lSize;
	ar >> lSize;
	while (0 < lSize--)
	{
		push_back(MC2StatLine());
		back().InStreamV1V2(ar, NULL, NULL);
	}
} // MC2StatLineVector::InStreamV2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2RichText::MC2RichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2RichText::MC2RichText ()
{
	m_mmMarginL = 0.5;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmMarginT = 0.5;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmMarginR = 0.5;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmMarginB = 0.5;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	m_mmrtText.SetRect(0,0,0,0);
	m_dAngle = 0.0;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_
	m_dwVertAlign = FDRC_AL_TOP;	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	m_vpLine = new MC2StatLineVector;
} // MC2RichText::MC2RichText.

void MC2RichText::OutStreamV3 (MCARCHIVE& ar)
{
	ar << m_mmMarginL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginR;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmMarginB;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar << m_mmrtText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar << m_dAngle;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_
	ar << m_dwVertAlign;// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	// _xZkqqHx_jFlGiOjKjHpBiPoOjFpBiCpAiPgPjHmNiBeC_xHqqkZx_
	m_vpLine->OutStreamV3(ar);
} // MC2RichText::OutStreamV2.

void MC2RichText::InStreamV2 (MCARCHIVE& ar)
{
	ar >> m_mmMarginL;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiNlGiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginT;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiPoDiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginR;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJeFiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmMarginB;	// _xZkqqHx_iDgFiDeMiDfIiDgHjHmMiIoGiCmMiJlKiDhNiBfLiDfHiDjD_xHqqkZx_.
	ar >> m_mmrtText;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiDhEiDiMiBfLiDiAiBeC_xHqqkZx_
	ar >> m_dAngle;	// _xZkqqHx_iDgFiDeMiDfIiDgHiCmMiKhAjDhIiBeC_xHqqkZx_
	// _xZkqqHx_jAiCjClMjFpLiMpMiCmMiDeBiDiJiDeDiDjDiDiBiDjDiDgHiBeC_xHqqkZx_
	ar >> m_dwVertAlign;
	// _xZkqqHx_iKpJjBlGiCmMjFlGiOjKjHpBiPoOjFpBiCpAiNoNiPjMiClFiBeBjDkPiOjOiCmJjFlGiOjKjHpBiPoOjFpBiCpAjDpMjHmNiBeC_xHqqkZx_
	m_vpLine->InStreamV2(ar);
} // MC2RichText::InStreamV2.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC2RichText::~MC2RichText
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfO_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.06.23 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC2RichText::~MC2RichText ()
{
	delete m_vpLine;
} // MC2RichText::~MC2RichText.

