#ifndef __SheetManager_h
#define __SheetManager_h

#include "2LayerManager.h"// For MC2ObjectLZHashMap.

class MC2LayerManager;
typedef vector<MC2LayerManager*> MC2LayerManagerPVector;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2SheetManager
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	Document_xZkqqHx_iCmMiDfGiBfLiDgHiCpAiKmHjHjNiClHiCoJiDeOiDiJiDfIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.14 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2SheetManager
{
public:
	MC2SheetManager ();
	virtual	~MC2SheetManager ();
	virtual void	Initialize ();
	virtual void	Clear ();
	virtual void	DeleteAll ();
	virtual void	OutStreamV3 (MCARCHIVE& ar) const;
	virtual MC2LayerManager*	GetSheet (SheetID stid) const;
	virtual MC2LayerManager*	GetFrontSheet () const;
	virtual BOOL	IsEmpty () const;

	virtual void	InsertSheet (SheetID& stidNew, const wchar_t* tcpName, SheetID stid, DWORD dwIdx);

	virtual SheetID	GetFreeSheetID () const;
	virtual SheetID	SheetIndexToID (DWORD dwIndex) const;
	virtual SheetID	GetSheetIDSize () const;
	virtual DWORD	GetSheetIndexSize () const;

protected:
	MC2LayerManagerPVector	m_vSheet;			// _xZkqqHx_iDfGiBfLiDgHiDgFiBfLiDhFiDiLiBeC_xHqqkZx_
	FDSheetIDVector		m_vFreqSheet;		// _xZkqqHx_iDfGiBfLiDgH_xHqqkZx_ID_xZkqqHx_iCmMiPiHiPjIiBeC_xHqqkZx_
	MC2ObjectLZHashMap	m_mpObjToLZHash;	// _xZkqqHx_jFjEjFgJ_xHqqkZx_->Layer,ZOrder_xZkqqHx_iCmMiDgOiDgCiDfGiDiFiBeC_xHqqkZx_
	MC2ObjBaseVector	m_vBottomLayer;		// _xZkqqHx_iNmFiJlKiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	MC2ObjBaseVector	m_vTopLayer;		// _xZkqqHx_iNmFiPoDiImKiDiMiDeDiDiEiBfLiBeC_xHqqkZx_
	SheetID				m_stidCurrentSheet;	// _xZkqqHx_iDeKiDiMiDjDiDgHiDiMiDeDiDiEiBfLiDhNiDgMiBfLiDfHiDiDiBeC_xHqqkZx_
}; // class MC2SheetManager.

#endif//__SheetManager_h

