#ifndef __ZOrder_h
#define __ZOrder_h

class MC2ObjBase;

typedef vector <const MC2ObjBaseVector*>	ConstMC2ObjBaseVPV;

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2ZOrderIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MC2ZOrder_xZkqqHx_iCmMiPiHjFpLiMpMiCmM_xHqqkZx_Iterator_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct MC2ZOrderIterator
{
	void operator ++ (int)
		{
			iV1++;
			if (iV1 == (*iV2)->end())
			{
				for (iV2++; iV2 != pvvObj->end(); iV2++)
				{
					if (!(*iV2)->empty())
					{
						iV1 = (*iV2)->begin();
						break;
					}
				}
			}
		}
	MC2ObjBase* operator * ()
		{
			return *iV1;
		}
	BOOL	IsEnd () const
		{
			return (iV2 == pvvObj->end());
		}

	const ConstMC2ObjBaseVPV*			pvvObj;
	ConstMC2ObjBaseVPV::const_iterator	iV2;
	MC2ObjBaseVector::const_iterator	iV1;
}; // struct MC2ZOrderIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2ZOrderReverseIterator
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	MC2ZOrder_xZkqqHx_iCmMiLhEjFpLiMpMiCmM_xHqqkZx_Iterator_xZkqqHx_iBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct MC2ZOrderReverseIterator
{
	void operator ++ (int)
		{
			iV1++;
			if (iV1 == (*iV2)->rend())
			{
				for (iV2++; iV2 != pvvObj->rend(); iV2++)
				{
					if (!(*iV2)->empty())
					{
						iV1 = (*iV2)->rbegin();
						break;
					}
				}
			}
		}

	MC2ObjBase* operator * ()
		{
			return *iV1;
		}
	BOOL	IsEnd () const
		{
			return (iV2 == pvvObj->rend());
		}

	const ConstMC2ObjBaseVPV*					pvvObj;
	ConstMC2ObjBaseVPV::const_reverse_iterator	iV2;
	MC2ObjBaseVector::const_reverse_iterator	iV1;
}; // struct MC2ZOrderReverseIterator.

/*************************************************************************
 * <_xZkqqHx_iDeOiDiJiDfI_xHqqkZx_>	MC2ZOrder
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFkBjAjEiCmMjFjEjFgJjHpBiCpAjBkJiCmLiCmEiBeB_xHqqkZx_Z_xZkqqHx_iDeJiBfLiDfPiBfLiCmGiClFiCmEiKmHjHjNiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	00.12.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
class MC2ZOrder
{
public:
	void	Begin (MC2ZOrderIterator& i) const;
	void	Rbegin (MC2ZOrderReverseIterator& i) const;
	BOOL	IsEmpty() const;
	DWORD	Size () const;
	MC2ObjBase*	Front () const;
	void	GetAllOrder (MC2ObjBaseVector& vObj) const;
	void	PushBack (const MC2ObjBaseVector* vObj);
protected:
	ConstMC2ObjBaseVPV	m_vvZOrder;
}; // class MC2ZOrder.

#endif//__ZOrder_h
