#include "stdafx.h"
#include "3NewFDObjAny.h"	// For NewFDObjAny.
#include "3LinkManager.h"	// For MC3LinkRec.
#include "3ObjGroup.h"		// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#ifdef SUPER_CLASS
#undef SUPER_CLASS
#endif

#define SUPER_CLASS MC3ObjBase

///////////////////////////////////////////////////////////////////////////
// MC3GpLinkRec_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iNfMjBkCjBmM_xHqqkZx_>	MC3GpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDiKiDjDiDeOiCmMiDiMiDfCiBfLiDgIiCpAiKmHjHjNiClHiCoJiClNiCnPiCmMiDeOiDiJiDfIiBeC_xHqqkZx_MC3LinkRec_xZkqqHx_iNfMjBkCjBmMiCkJiCoH_xHqqkZx_
 *			_xZkqqHx_iNmAjFfHiPoOjFpBiCpAiPjMiCkCiClNiOgDiCoIiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
struct MC3GpLinkRec
{
	MC3GpLinkRec ();
	MC3GpLinkRec (const MC3LinkRec& rec);

	MC3MolipRec	m_mlpFrom;		// _xZkqqHx_iDiKiDjDiDeOiMlDiDiCiDiKiDhGiBeC_xHqqkZx_
	MC3MolipRec	m_mlpTo;		// _xZkqqHx_iDiKiDjDiDeOjAoGiDiCiDiKiDhGiBeC_xHqqkZx_
	WORD		m_wLinkKind;	// mmptOffset_xZkqqHx_iCmMiOoNjHnOiBeC_xHqqkZx_FDLMLinkKind_xZkqqHx_iCmMiCfAiCmCiBeC_xHqqkZx_
}; // struct MC3GpLinkRec.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3GpLinkRec::MC3GpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC3GpLinkRec::MC3GpLinkRec ()
	 : m_mlpFrom(0,0), m_mlpTo(0,0), m_wLinkKind(0)
{}

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3GpLinkRec::MC3GpLinkRec
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	01.04.30 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC3GpLinkRec::MC3GpLinkRec (const MC3LinkRec& rec)
			: m_mlpFrom(rec.m_mlpFrom), m_mlpTo(rec.m_mlpTo), m_wLinkKind(rec.m_wLinkKind)
{}

void operator << (CArchive& ar, const MC3GpLinkRec& rec)
{
	ar.Write(&rec, sizeof(rec));
}

void operator >> (CArchive& ar, MC3GpLinkRec& rec)
{
	ar.Read(&rec, sizeof(rec));
}

///////////////////////////////////////////////////////////////////////////
// MC3ObjGroup_xZkqqHx_iDiBiDjDiDgPiKnGjAjEiBeC_xHqqkZx_

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjGroup::MC3ObjGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDfCiDjDiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_FDFoundDoc_xZkqqHx_iCmM_xHqqkZx_InStream_xZkqqHx_iCmFjFeLjHhGiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	98.11.16 Fukushiro M. _xZkqqHx_jFmPjAjEiCmMiPiJiKpKiJlLiCpAjCmHiJmB_xHqqkZx_.Tool_xZkqqHx_iCmFjAlGjAkMiClDiCoKiClNiOjOiCmMiInH_xHqqkZx_.
 *************************************************************************/
MC3ObjGroup::MC3ObjGroup ()
{
	m_lObjListSz = 0;
	m_pObjList = NULL;
	m_lLinkListSz = 0;
	m_pLinkList = NULL;
} // MC3ObjGroup::MC3ObjGroup.

//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
///*************************************************************************
// * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjGroup::IsKindOf
// *
// * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCkKiClBiCmMiMfOiBeBiIlNiCkCiCmNiClBiCmMiMfOiCmMiDfEiDhFiDeOiDiJiDfIiCmMiMfOiCkJiCmHiCkEiCkJiCpAjClCiCnHiCoJiBeC_xHqqkZx_
// *
// * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	nType	: _xZkqqHx_jClCiCnHiCoJiMfOiCpAiOhHjCoIiBeC_xHqqkZx_
// *
// * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	TRUE	: nType_xZkqqHx_iMfOiBeBiIlNiCkCiCmNiClLiCmMiDfEiDhFiDeOiDiJiDfIiCmMiPoKiNiH_xHqqkZx_
// *			FALSE	: _xZkqqHx_iClLiCkEiCmFiCmIiCkCiPoKiNiH_xHqqkZx_
// *************************************************************************/
//BOOL MC3ObjGroup::IsKindOf (FTObjectType nType) const
//{
//	if (nType == FDOJ_GROUP) return TRUE;
//	return SUPER_CLASS::IsKindOf(nType);
//} // MC3ObjGroup::IsKindOf.
//----- 05.06.13 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjArc::Type
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iClBiCmMiDeOiDiJiDfIiCmMiMfOiCpAjFnEiClH_xHqqkZx_.
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDeOiDiJiDfIiCmMiMfO_xHqqkZx_
 *************************************************************************/
FTObjectType MC3ObjGroup::Type () const
{
	return FDOJ_GROUP;
} // MC3ObjGroup::Type.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjGroup::OutStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPjBiCkLiPgPiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_iPjBiCkLiPgPiClFjHhAiCmM_xHqqkZx_MCARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_MCARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *************************************************************************/
void MC3ObjGroup::OutStream (MCARCHIVE& ar)
{
	SUPER_CLASS::OutStream(ar);
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjDoAjFjEjFgJiDgFiBfLiDhFiDiLiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_lObjListSz;
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiMfOiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << BYTE(m_pObjList[lObjIdx]->Type());
		// _xZkqqHx_jFjEjFgJiCpAiPgPjHmNiBeC_xHqqkZx_
		m_pObjList[lObjIdx]->OutStream(ar);
	}
	//----- _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmN_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmNiBeC_xHqqkZx_
	ar << m_lLinkListSz;
	long lLnkIdx;
	for (lLnkIdx = 0; lLnkIdx < m_lLinkListSz; lLnkIdx++)
	{
		// _xZkqqHx_iDiKiDjDiDeOiCpAiPgPjHmNiBeC_xHqqkZx_
		ar << m_pLinkList[lLnkIdx];
	}
} // MC3ObjGroup::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjGroup::InStream
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiPpDjBnEiCpAiDfIiDgHiDiKiBfLiDiAiCkJiCoHjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	ar	: _xZkqqHx_jDmHiCnNiNjOiCnNjHhAiCmM_xHqqkZx_MCARCHIVE
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.01.16 Fukushiro M. _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmMjDgPjIfOiPiIjHjNiCpAjCmHiJmBiBeC_xHqqkZx_
 *			99.03.03 Fukushiro M. CArchive_xZkqqHx_iCpA_xHqqkZx_MCARCHIVE_xZkqqHx_iCmJiPeDjAlDiBeC_xHqqkZx_
 *			99.10.26 Fukushiro M. RegisterObject_xZkqqHx_iCpAjGjFiPmBiBeCiDgAiDgCiDhGiCpAiOgHiCmBiClNiOjO_xHqqkZx_
 *									_xZkqqHx_jDpBiPgEjDgPjIfOiClDiCoKiCoJiBeC_xHqqkZx_
 *************************************************************************/
void MC3ObjGroup::InStream (MCARCHIVE& ar)
{
	SUPER_CLASS::InStream(ar);

	long lObjIdx;
	if (m_pObjList != NULL)
	{
		//----- _xZkqqHx_iKpJjBlGiCmMjFjEjFgJiCpAjDgPjIfOjGjFiPmB_xHqqkZx_ -----
		for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
			m_pObjList[lObjIdx]->UnregisterObjID();
		//----- _xZkqqHx_iKpJjBlGiCmMjFjEjFgJiCpAiNoNiPjM_xHqqkZx_ -----
		for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
			delete m_pObjList[lObjIdx];
		m_lObjListSz = 0;
		delete[] m_pObjList;
		m_pObjList = NULL;
	}
	if (m_pLinkList != NULL)
	{
		m_lLinkListSz = 0;
		delete[] m_pLinkList;
		m_pLinkList = NULL;
	}

	//----- _xZkqqHx_iDePiDiLiBfLiDhGjDoAjFjEjFgJiDgFiBfLiDhFiDiLiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_jFjEjFgJjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_lObjListSz;
	m_pObjList = new MC3ObjBase*[m_lObjListSz];
	BYTE byType;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
	{
		// _xZkqqHx_jFjEjFgJiCmMiMfOiCpAjDpMjHmNiBeC_xHqqkZx_
		ar >> byType;
		m_pObjList[lObjIdx] = NewFDObjAny(FTObjectType(byType));
		// _xZkqqHx_jFjEjFgJiCpAjDpMjHmNiBeC_xHqqkZx_
		m_pObjList[lObjIdx]->InStream(ar);
	}

	//----- _xZkqqHx_iDiKiDjDiDeOiDgFiBfLiDhFiDiLiCpAjDpMjHmN_xHqqkZx_ -----
	// _xZkqqHx_iDiKiDjDiDeOjAjEiCpAjDpMjHmNiBeC_xHqqkZx_
	ar >> m_lLinkListSz;
	m_pLinkList = new MC3GpLinkRec[m_lLinkListSz];
	long lLnkIdx;
	for (lLnkIdx = 0; lLnkIdx < m_lLinkListSz; lLnkIdx++)
	{
		ar >> m_pLinkList[lLnkIdx];
	}
	// _xZkqqHx_iClBiClBiCmJ_xHqqkZx_CalcOuterFrame_xZkqqHx_iCpAjDpMiCoKiClNiCkCiCmGiClBiCoLiClOiCkKiBeBiImIiJlKiCmMjHjNjHfCiCmFjFhDiJmCiBeC_xHqqkZx_
	// CalcOuterFrame_xZkqqHx_jCiGiCmFiMmEiCmOiCoKiCoJ_xHqqkZx_GetOuterFrame_xZkqqHx_iCmNiBeBjDgPjIfOiDhJiDjDiCmMjBlOiClDiCmIiCmHiCpAiOfBiPmGiClHiCoJiBeC_xHqqkZx_
	// OnPaste_xZkqqHx_iCmF_xHqqkZx_ _xZkqqHx_jDgPjIfOiDhJiDjDiCmMjBlOiClDiCpAiOfBiPmGiClHiCoJiCmGiBeBjGkCiClOjDgPjIfOiPiIjHjNiCkKiPeJiCoNiCmBiCmEiCkCiCmIiCkC_xHqqkZx_
	// _xZkqqHx_iPpDjBnEiCmFiOfBiPmGiClDiCoKiCmEiClFiCnMiCkEiClNiCnPiBeBjHiOiClPiCoJiBeC_xHqqkZx_
} // MC3ObjGroup::InStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjGroup::~MC3ObjGroup
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgGiDfIiDgHiDiJiDeOiDfOiBeC_xHqqkZx_
 *************************************************************************/
MC3ObjGroup::~MC3ObjGroup ()
{
	if (m_pObjList != NULL)
	{
		// _xZkqqHx_iDePiDiLiBfLiDhGjDoAiCmMjFjEjFgJiCpAiNoNiPjMiBeC_xHqqkZx_
		long lObjIdx;
		for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
			delete m_pObjList[lObjIdx];
		m_lObjListSz = 0;
		delete[] m_pObjList;
		m_pObjList = NULL;
	}
	if (m_pLinkList != NULL)
	{
		m_lLinkListSz = 0;
		delete[] m_pLinkList;
		m_pLinkList = NULL;
	}
} // MC3ObjGroup::~MC3ObjGroup.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjGroup::RegisterObjForceID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_jFjEjFgJiCmMiCgIiCgDiCpAjDgPjIfOiClHiCoJiBeCiClBiCmMjFjEjFgJiCmJjFhEiCkPiCoHiCoKiCmEiCkCiCoJiCgIiCgDiOkJjAgHiCpA_xHqqkZx_
 *			_xZkqqHx_iLkNjAkHjDgPjIfOiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iJpAjAoA_xHqqkZx_>	_xZkqqHx_iDePiDiLiBfLiDhGiCmGiDgAiDgCiDhGiCmMjDgPjIfOiKnGiMfHiCmFiClBiCmMiKnGjAjEiCpAjAfGjAnNiClFiClNiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.10.26 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3ObjGroup::RegisterObjForceID ()
{
	//----- _xZkqqHx_iDePiDiLiBfLiDhGjCiGiCmMiKgFjFjEjFgJiCpAiLkNjAkHjDgPjIfO_xHqqkZx_ -----
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->RegisterObjForceID();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeCiClBiClBiCmFiClBiCmMjFjEjFgJiOkJjAgHiCmMjDgPjIfOiCkKjAkMiClDiCoKiCoJiBeC_xHqqkZx_
	SUPER_CLASS::RegisterObjForceID();
} // MC3ObjGroup::RegisterObjForceID ().

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ObjGroup::UnregisterObjID
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iPeJjHlJiPiIjHjNiBeC_xHqqkZx_delete_xZkqqHx_jBePiCmJiOmAiNhDiClHiCoJiBeC_xHqqkZx_
 *************************************************************************/
void MC3ObjGroup::UnregisterObjID ()
{
	long lObjIdx;
	for (lObjIdx = 0; lObjIdx < m_lObjListSz; lObjIdx++)
		m_pObjList[lObjIdx]->UnregisterObjID();
	// Superclass_xZkqqHx_iKnGjAjEiOmAiNhDiBeC_xHqqkZx_
	SUPER_CLASS::UnregisterObjID();
} // MC3ObjGroup::UnregisterObjID.

