#include "stdafx.h"
#include "3Document.h"			// For MC3Document.

#include "3ToolSelect.h"			// For g_toolSelect.
#include "3ToolSelEdit.h"			// For g_toolSelEdit.
#include "3ToolRotate.h"			// For g_toolRotate.
#include "3ToolZoom.h"				// For g_toolZoom.
#include "3ToolRect.h"				// For g_toolRect.
#include "3ToolRRect.h"			// For g_toolRRect.
#include "3ToolArc.h"				// For g_toolArc.
#include "3ToolLine.h"				// For g_toolLine.
#include "3ToolPoint.h"			// For g_toolPoint.
#include "3ToolLineEdit.h"			// For g_toolLineEdit.
#include "3ToolRichEdit.h"			// For g_toolRichEdit.
#include "3ToolRichText.h"			// For g_toolRichText.
#include "3ToolChip.h"				// For g_toolChip.
#include "3ToolChipPut.h"			// For g_toolChipPut.
#include "3ToolPolyEdit.h"			// For g_toolPolyEdit.
#include "3ToolRoundRectEdit.h"	// For g_toolRoundRectEdit.
#include "3ToolArcEdit.h"			// For g_toolArcEdit.
#include "3ToolOleEdit.h"			// For g_toolOleEdit.
#include "3ToolLink.h"				// For g_toolLink.
#include "3ToolWidePoly.h"			// For g_toolWidePoly.
#include "3ToolWideBezier.h"		// For g_toolWideBezier.
#include "3ToolTextPut.h"			// for g_toolTextPut.
#include "3ToolLabelPut.h"			// for g_toolLabelPut.
#include "3ToolGroupEdit.h"			// For g_toolGroupEdit.
#include "3ToolArrowTmpl.h"			// For MC3ToolArrowTmpl.
#include "3ObjBase.h"				// For MC3ObjBase.
#include "3ToolManager.h"			// This header.

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

MC3ToolManager::MC3ToolManager ()
{
} // MC3ToolManager::MC3ToolManager.

MC3ToolManager::~MC3ToolManager ()
{
} // MC3ToolManager::~MC3ToolManager.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ToolManager::Initialize
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDhNiDgMiBfLiDfHiDiDjCiGiCmMiDgDiBfLiDiLiCpAiPiJiKpKiJlLiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3ToolManager::Initialize (MC3Document* pDoc)
{
	////////////////// _xZkqqHx_iDgDiBfLiDiL_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiL_xHqqkZx_ ////////////////////////
	// _xZkqqHx_iImIiJlKiCmMiDgFiBfLiDhFiDiLiCmNiBeBiDgDiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCmMiPiHjEnEiCmJjFmAiCpBiCmFiCkCiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDgDiBfLiDiLiCpAjCmHiJmBiBeFiNoNiPjMiClHiCoJiOjOiCoAiBeBiClLiCmMiPiHiPjIiCpAiLlGiCoNiClFiCmEiCmNiCkCiCkPiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iDgDiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCmNiBeBiDgDiBfLiDiLiPoOjFpBiCmMjFnLjBlGiBeFjDmHiCnNiNjOiCnNiCmJiOgHjHhAiClHiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDgDiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCmNiBeBiDgDiBfLiDiLiCmMjDoAjFjEjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iCmGiClFiCmEiCoAiOgHiCoNiCoKiCoJiBeC_xHqqkZx_
	// _xZkqqHx_iDgDiBfLiDiLiCmMjDoAjFjEjFjEjFgJiCmMiClNiCnPiBeBjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCmM_xHqqkZx_ [0, FD_MAX_TOOL_ID)_xZkqqHx_iCpAiKgNjFnLiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCkEiClHiCoJiClBiCmGiCmJiCoGiCoIiBeBiDgDiBfLiDiLiCkKjBjNiCkGiClNiPoKiNiHiCmFiCoAiBeBiMmDiCkCiDgGiBfLiDfOiCpA_xHqqkZx_
	// _xZkqqHx_jDmHiCnNiNjOiCnOiOjOiCmJjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCkKiDgPiDgCiDgFiDeCiDjDiDePiClFiCmIiCkCiBeC_xHqqkZx_

	// _xZkqqHx_jCiNiInDiBeJiBeJ_xHqqkZx_
	// ../MolipSDK/MpgMolipExport.h_xZkqqHx_iCmM_xHqqkZx_FDTLIDX_XXXX_xZkqqHx_iCmGjIeBjDkOiClFiCmEiCkCiCoJiClBiCmGiCmJjCiNiInDiBeC_xHqqkZx_

	m_pTool			[ 0] = new MC3ToolSelect();
	m_pTool			[ 1] = new MC3ToolSelEdit();
	m_pTool			[ 2] = new MC3ToolRotate();
	m_pTool			[ 3] = new MC3ToolZoom();
	m_pTool			[ 4] = new MC3ToolChip();
	m_pTool			[ 5] = new MC3ToolLine();
	m_pTool			[ 6] = new MC3ToolRect();
	m_pTool			[ 7] = new MC3ToolRoundRect();
	m_pTool			[ 8] = new MC3ToolArrowTmpl<MC3ToolPoly>();
	m_pTool			[ 9] = new MC3ToolArrowTmpl<MC3ToolBezier>();
	m_pTool			[10] = new MC3ToolArc();
	m_pTool			[11] = new MC3ToolRichText();
	m_pTool			[12] = new MC3ToolPoint();
	m_pTool			[13] = new MC3ToolLabelPut();
	m_pTool			[14] = new MC3ToolLink();
	m_pTool			[15] = new MC3ToolArrowTmpl<MC3ToolPoly>();
	m_pTool			[16] = new MC3ToolArrowTmpl<MC3ToolBezier>();
	m_pTool			[17] = new MC3ToolArrowTmpl<MC3ToolWidePoly>();
	m_pTool			[18] = new MC3ToolArrowTmpl<MC3ToolWideBezier>();
	m_pTool			[19] = new MC3ToolArrowTmpl<MC3ToolWidePoly>();
	m_pTool			[20] = new MC3ToolArrowTmpl<MC3ToolWideBezier>();
	m_pTool			[21] = new MC3ToolTextPut();
	m_pTool			[22] = new MC3ToolChipPut();
	m_pTool			[23] = NULL;
	m_pTool			[24] = new MC3ToolPolyEdit();
	m_pTool			[25] = new MC3ToolLineEdit();
	m_pTool			[26] = new MC3ToolRoundRectEdit();
	m_pTool			[27] = new MC3ToolArcEdit();
	m_pTool			[28] = new MC3ToolRichEdit();
	m_pTool			[29] = new MC3ToolOleEdit();
	m_pTool			[30] = new MC3ToolGroupEdit();
	m_pTool			[31] = NULL;
	m_pTool			[32] = NULL;
	m_pTool			[33] = NULL;
	m_pTool			[34] = NULL;
	m_pTool			[35] = NULL;
	m_pTool			[36] = NULL;
	m_pTool			[37] = NULL;
	m_pTool			[38] = NULL;
	m_pTool			[39] = NULL;

	for (int iTool = 0; iTool < FD_MAX_TOOL_ID; iTool++)
	{
		if (GetTool(iTool) != NULL)
			GetTool(iTool)->OnViewCreate();
	}

	// DeleteContents _xZkqqHx_iCmFiNhDiCoNiCoKiCoJiPiIjHjNiCpAiInKjDkOiBeC_xHqqkZx_
	for (iTool = 0; iTool < FD_MAX_TOOL_ID; iTool++)
	{
		//----- _xZkqqHx_iDgDiBfLiDiLiCmMiPiJiKpKiJlLiCpAiClHiCoJ_xHqqkZx_ ------
		if (GetTool(iTool) != NULL)
			GetTool(iTool)->InitContents();

		//----- _xZkqqHx_iDgDiBfLiDiLiCmMjDoAjFjEjFjEjFgJiCpAjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCmJjDgPjIfOiClHiCoJ_xHqqkZx_ ------
		if (GetTool(iTool) == NULL ||
			GetTool(iTool)->GetInsideObject() == NULL)
		{
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCpAiDiKiDfFiBfLiDhFiClHiCoJiInHiCmJiLfFjFjEjFgJiCpAjDgPjIfOiBeC_xHqqkZx_
			pDoc->RegisterObject((MC3ObjBase*)(-1), DWORD(iTool));
		} else
		{
			// _xZkqqHx_jDoAjFjEjFjEjFgJiCmJjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjAnNjCoIiBeC_xHqqkZx_
			((MC3ObjBase*)GetTool(iTool)->GetInsideObject())->SetObjID(DWORD(iTool));
			// _xZkqqHx_jFjEjFgJ_xHqqkZx_ID_xZkqqHx_iCpAjFjEjFgJ_xHqqkZx_ID_xZkqqHx_iDgFiBfLiDhFiDiLiCmJjDgPjIfOiBeC_xHqqkZx_
			pDoc->RegisterObject((MC3ObjBase*)GetTool(iTool)->GetInsideObject(),
									DWORD(iTool));
		}
	}
} // MC3ToolManager::Initialize.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ToolManager::Terminate
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiDhNiDgMiBfLiDfHiDiDjCiGiCmMiDgDiBfLiDiLiCmMiPeJjHlJiPiIjHjNiCpAiNhDiCkEiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	02.12.13 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
void MC3ToolManager::Terminate ()
{
	for (int iTool = 0; iTool < FD_MAX_TOOL_ID; iTool++)
	{
		if (GetTool(iTool) != NULL)
			GetTool(iTool)->OnViewDestroy();
	}

	//----- _xZkqqHx_iDgDiBfLiDiLiCmMiNoNiPjM_xHqqkZx_ -----
	for (int iC = 0; iC < FD_MAX_TOOL_ID; iC++)
	{
		if (m_pTool[iC] != NULL)
		{
			delete m_pTool[iC];
			m_pTool[iC] = NULL;
		}
	}
} // MC3ToolManager::Terminate.

void MC3ToolManager::InStream (MCARCHIVE& ar)
{
//----- 05.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	BYTE byTool;
//	WORD wDataSize;
//	for (;;)
//	{
//		// _xZkqqHx_iDgDiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		ar >> byTool;
//		// _xZkqqHx_iPeJjHlJiDhNiBfLiDeOiCmIiCoHiCmOiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
//		if (byTool == BYTE(-1)) break;
//		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
//		ar >> wDataSize;
//		// _xZkqqHx_jBmOiJjOiClHiCoJiDgDiBfLiDiLiCkKjGlDiCkCiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeC_xHqqkZx_
//		if (GetTool(byTool) == NULL)
//		{
//			BYTEVector vData(wDataSize);
//			ar.Read(&vData.front(), wDataSize);
//		} else
//		{
//			// _xZkqqHx_iDgDiBfLiDiLiCmJiDfIiDgHiDiKiBfLiDiAiCpAjDpMjHmNiClHiCoJiBeC_xHqqkZx_
//			GetTool(byTool)->InStream(ar);
//		}
//	}
//----- 05.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	// V3->V4_xZkqqHx_iCmFiDgDiBfLiDiLiCmMjDoAjFjEjFjEjFgJiCmM_xHqqkZx_ID_xZkqqHx_iCmMiCnDiCoIjFpLiCpAjFmPiNfIiClFiClNiClNiCnPiBeB_xHqqkZx_
	// _xZkqqHx_iDgDiBfLiDiLjDoAjFjEjFjEjFgJiCmMiDgGiBfLiDfOiCmNiMnNiKlHjAkLiCkKiCmGiCoKiCmIiCkCiBeC_xHqqkZx_
	// _xZkqqHx_iClBiCmMiClNiCnPiBeBjBfDiCmEiCmMiDgGiBfLiDfOiCpAiDfIiDeMiDgCiDhGiClHiCoJiBeC_xHqqkZx_
	BYTE byTool;
	WORD wDataSize;
	for (;;)
	{
		// _xZkqqHx_iDgDiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		ar >> byTool;
		// _xZkqqHx_iPeJjHlJiDhNiBfLiDeOiCmIiCoHiCmOiDiLiBfLiDhGiCpAiPeJjHlJiBeC_xHqqkZx_
		if (byTool == BYTE(-1)) break;
		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAjDmHiCnNiNjOiCnOiBeC_xHqqkZx_
		ar >> wDataSize;
		// _xZkqqHx_iDfIiDeMiDgCiDhGiBeC_xHqqkZx_
		BYTEVector vData(wDataSize);
		ar.Read(&vData.front(), wDataSize);
	}
//----- 05.07.14 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
} // MC3ToolManager::InStream.

void MC3ToolManager::OutStream (MCARCHIVE& ar)
{
//----- 05.07.14 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	//----- _xZkqqHx_iDgDiBfLiDiLiCmMjDoAjFjEjFjEjFgJiCpAiDfIiDgHiDiKiBfLiDiAiCmJiPgPjHmNiClHiCoJ_xHqqkZx_ ------
//	for (int iTool = 0; iTool < FD_MAX_TOOL_ID; iTool++)
//	{
//		// _xZkqqHx_iCgIiCgDiCmJjBmOiJjOiClHiCoJiDgDiBfLiDiLiCkKjGlDiCkCiPoKiNiHiCmNiDfIiDeMiDgCiDhGiBeCiDgDiBfLiDiLiCgIiCgDiCpA_xHqqkZx_
//		// _xZkqqHx_iPgPjHmNiClHiCoJiCmMiCmFiDfIiDeMiDgCiDhGiClFiCmEiCoAjDmHiCnNiNjOiCnNiCmJjGoCjBoIiCmNjGlDiCkCiBeC_xHqqkZx_
//		if (GetTool(iTool) == NULL) continue;
//		// _xZkqqHx_iDiBiDiCiDiKiDhEiDeAiDeDiDiLiCpAjAlGjAkMiBeC_xHqqkZx_
//		CMemFile fileWork;
//		CArchive arWork(&fileWork, CArchive::store);
//		arWork.m_pDocument = ar.m_pDocument;
//		GetTool(iTool)->OutStream(arWork);
//		// _xZkqqHx_iDeBiBfLiDeKiDeDiDhFiCpAjFmCiClGiCoJiBeC_xHqqkZx_
//		arWork.Close();
//		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCmMiOoGjDlOiBeC_xHqqkZx_
//		const WORD wDataSize = WORD(fileWork.GetLength());
//		// CMemFile_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiCpAjAnIiCoIjHkDiClHiBeC_xHqqkZx_
//		BYTE* pData = fileWork.Detach();
//		// _xZkqqHx_iDgDiBfLiDiL_xHqqkZx_ID_xZkqqHx_iCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//		ar << BYTE(iTool);
//		// _xZkqqHx_iDgGiBfLiDfOiDfEiDeDiDfJiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//		ar << wDataSize;
//		// _xZkqqHx_iDgGiBfLiDfOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
//		ar.Write(pData, wDataSize);
//		// CMemFile_xZkqqHx_iCmMiDgPiDgCiDhEiDeAiCpAiJpAjFpKiBeC_xHqqkZx_
//		free(pData);
//	}
//----- 05.07.14 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	// _xZkqqHx_iPeJjHlJiDhNiBfLiDeOiCpAiPgPjHmNiClHiCoJiBeC_xHqqkZx_
	ar << BYTE(-1);
} // MC3ToolManager::OutStream.

/*************************************************************************
 * <_xZkqqHx_iKnGjAjE_xHqqkZx_>	MC3ToolManager::GetTool
 *
 * <_xZkqqHx_iLeAjEfM_xHqqkZx_>	_xZkqqHx_iDeDiDjDiDgGiDgCiDeOiDfIiCmJjBmOiJjOiClHiCoJiDgDiBfLiDiLiCpAjFnEiClHiBeCjGlDiCkCiPoKiNiHiCmN_xHqqkZx_NULL_xZkqqHx_iCpAjFnEiClHiBeC_xHqqkZx_
 *
 * <_xZkqqHx_iIpIjAjE_xHqqkZx_>	lIndex	:_xZkqqHx_iDgDiBfLiDiLiCmMiDeDiDjDiDgGiDgCiDeOiDfIiCpAiOhHjCoIiClHiCoJiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jFnEjCgM_xHqqkZx_>	_xZkqqHx_iDgDiBfLiDiLiBeC_xHqqkZx_
 *
 * <_xZkqqHx_jHjKjHpA_xHqqkZx_>	99.05.10 Fukushiro M. _xZkqqHx_iNoMjAkM_xHqqkZx_
 *************************************************************************/
MC3ToolBase* MC3ToolManager::GetTool (long lIndex) const
{
	return m_pTool[lIndex];
} // MC3ToolManager::GetTool.
