/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#ifndef CSRECT_H
#define CSRECT_H

class CSRect {

public :
	double left, top, right, bottom;

public :
	CSRect( double init_left, double init_top, double init_right, double init_bottom ) 
		: left( init_left ), top( init_top ), right( init_right ), bottom( init_bottom ) {}
	CSRect(void) 
		: left( 0 ), top( 0 ), right( 0 ), bottom( 0 ) {}

	void SetRect( double new_left, double new_top, double new_right, double new_bottom ) {
		left = new_left;
		top = new_top;
		right = new_right;
		bottom = new_bottom; 
	}

	double Width() { return (right-left+1); }
	double Height() { return (bottom-top+1); }

	void InflateRect( double dx, double dy ) {
		//left  -= dx / 2; top    -= dy / 2; 
		//right += dx / 2; bottom += dy / 2; 
		right += dx; bottom += dy; 
	}

	// CRect _xZkqqHx_iCmG_xHqqkZx_ rect2 _xZkqqHx_iCmFiOhHjCoIiClDiCoKiClNiOgMiKhAiMgAiCmMiMpAiNlHjFjEjFkKiCmM_xHqqkZx_ CRect _xZkqqHx_iCpAjFnEiClFiCnMiClHiBeC_xHqqkZx_
	CSRect operator&( const CSRect& rect2 ) const {
		CSRect resultRect( 0, 0, -1, -1 );
		if ( right < rect2.left || rect2.right < left ) {
			// _xZkqqHx_iPgEiCmIiCoIjGlDiClF_xHqqkZx_
		} else { 
			if ( left <= rect2.left && rect2.left <= right ) {
				// rect2_xZkqqHx_iCmM_xHqqkZx_left_xZkqqHx_iCkK_xHqqkZx_this_xZkqqHx_iCmMjCiGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_
				resultRect.left = rect2.left;
			} else {
				resultRect.left = left;
			}
			if ( left <= rect2.right && rect2.right <= right ) {
				// rect2_xZkqqHx_iCmM_xHqqkZx_right_xZkqqHx_iCkK_xHqqkZx_this_xZkqqHx_iCmMjCiGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_
				resultRect.right = rect2.right;
			} else {
				resultRect.right = right;
			}
		} // if ( right < rect2.left || rect2.right < left )
		if ( bottom < rect2.top || rect2.bottom < top ) {
			// _xZkqqHx_iPgEiCmIiCoIjGlDiClF_xHqqkZx_
		} else { 
			if ( top <= rect2.top && rect2.top <= bottom ) {
				// rect2_xZkqqHx_iCmM_xHqqkZx_top_xZkqqHx_iCkK_xHqqkZx_this_xZkqqHx_iCmMjCiGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_
				resultRect.top = rect2.top;
			} else {
				resultRect.top = top;
			}
			if ( top <= rect2.bottom && rect2.bottom <= bottom ) {
				// rect2_xZkqqHx_iCmM_xHqqkZx_bottom_xZkqqHx_iCkK_xHqqkZx_this_xZkqqHx_iCmMjCiGiCmJiKnMiCnMiCoKiCoJ_xHqqkZx_
				resultRect.bottom = rect2.bottom;
			} else {
				resultRect.bottom = bottom;
			}
		} // if ( bottom < rect2.top || rect2.bottom < top )
		return resultRect;
	} // operator&

	bool IsRectEmpty() {
		if ( right - left < 0.0 || bottom - top < 0.0 ) {
			return true;
		} else {
			return false;
		}
	}
};


#endif // CSRECT_H
