// OptionDlg.cpp : _xZkqqHx_iDeDiDjDiDhGiDiKiDiBiDjDiDgFiBfLiDfGiDiHiDjD_xHqqkZx_ _xZkqqHx_iDhEiDeAiDeDiDiL_xHqqkZx_
//

/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#include "stdafx.h"
// 06.06.29 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//#include "MpgExtern.h"
#include "pgsvgexport.h"
#include "resource.h"
#include "SvgExportOption.h"
#include "OptionDlg.h"
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#include "FCArrowExpType.h"
//#include "FCArrowExp.h"
//#include "DBLMath.h"		// For DBLPoint.
//#include "DBLPoint.h"		// For DBLPoint.
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
#include "SvgExportInfo.h"
#include ".\optiondlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionDlg _xZkqqHx_iDfPiDeDiDeBiDiNiDeP_xHqqkZx_


COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COptionDlg::IDD, pParent)
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	,_printWidePolySkelton(false)
{
	//{{AFX_DATA_INIT(COptionDlg)
	m_digitNum = _T("");
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	m_widePolyOutlineUnit = _T("");
	m_printComment = -1;
	m_base64Png = -1;
	m_backpictAsPng = -1;
	m_oleTrans = -1;
	m_textPos = -1;
	m_widePolyType = -1;
	m_dpiEdit = _T("");
	m_htmlCheck = FALSE;
	//}}AFX_DATA_INIT
}


void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionDlg)
	DDX_CBString(pDX, IDC_DIGIT_NUM, m_digitNum);
	DDV_MaxChars(pDX, m_digitNum, 1);
	DDX_CBIndex(pDX, IDC_COMMENT_COMBO, m_printComment);
	DDX_CBIndex(pDX, IDC_BASEE64PNG_COMBO, m_base64Png);
	DDX_CBIndex(pDX, IDC_BACKPICT_AS_PNG_COMBO, m_backpictAsPng);
	DDX_CBIndex(pDX, IDC_OLE_TRANS_COMBO, m_oleTrans);
	DDX_CBIndex(pDX, IDC_TEXTPOS_COMBO, m_textPos);
	DDX_CBIndex(pDX, IDC_WIDEPOLY_COMBO, m_widePolyType);
	DDX_Text(pDX, IDC_DPI_EDIT, m_dpiEdit);
	DDX_Check(pDX, IDC_HTML_CHECK, m_htmlCheck);
	//}}AFX_DATA_MAP
	// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
	//	DDX_CBString(pDX, IDC_WIDEPOLY_OUTLINE_COMBO, m_widePolyOutlineUnit);
}


BEGIN_MESSAGE_MAP(COptionDlg, CDialog)
	//{{AFX_MSG_MAP(COptionDlg)
	ON_BN_CLICKED(IDC_DEFAULT_BUTTON, OnDefaultButton)
	ON_BN_CLICKED(IDC_HTML_CHECK, OnHtmlCheck)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	ON_CBN_SELCHANGE(IDC_WIDEPOLY_COMBO, OnSelchangeWidepolyCombo)

/////////////////////////////////////////////////////////////////////////////
// COptionDlg _xZkqqHx_iDiBiDgCiDfKiBfLiDfH_xHqqkZx_ _xZkqqHx_iDgOiDjDiDgIiDiJ_xHqqkZx_

//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//// _xZkqqHx_iNjMiKgJiCmMiCnN_xHqqkZx_
//#define WIDEPOLY_SKELTON_ONLY	0
//
//// _xZkqqHx_jHnGiKhDiCmMiCnN_xHqqkZx_
//#define WIDEPOLY_OUTLINE_ONLY	2
//
//// _xZkqqHx_iNjMiKgJiBhLjHnGiKhD_xHqqkZx_
//#define WIDEPOLY_SKELTON_AND_OUTLINE	1
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
// _xZkqqHx_jHnGiKhDiCpAiPgPjHmNiBeC_xHqqkZx_
#define WIDEPOLY_OUTPUT_SHAPE	0
// _xZkqqHx_iNjMiKgJiCpAiPgPjHmNiBeC_xHqqkZx_
#define WIDEPOLY_OUTPUT_SKELTON	1
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// _xZkqqHx_iDfPiDeDiDeBiDiNiDePiCmMjCgMiCpAiDeJiDhGiDfGiDiHiDjDiCmJjAnNjCoI_xHqqkZx_
int COptionDlg::setSvgExportOption(SvgExportOption *svgExportOption)
{
	sscanf( m_digitNum, "%d", &svgExportOption->_digitNum );

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	sscanf( this->m_widePolyOutlineUnit, "%lf", &svgExportOption->_widePolyOutlineUnit );

	switch ( m_widePolyType ) {
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	case WIDEPOLY_SKELTON_ONLY :
//		svgExportOption->_shouldPrintWidePolyOutline = false;
//		svgExportOption->_shouldPrintWidePolySkelton = true;
//		break;
//	case WIDEPOLY_SKELTON_AND_OUTLINE :
//		svgExportOption->_shouldPrintWidePolyOutline = true;
//		svgExportOption->_shouldPrintWidePolySkelton = true;
//		break;
//	case WIDEPOLY_OUTLINE_ONLY :
//		svgExportOption->_shouldPrintWidePolyOutline = true;
//		svgExportOption->_shouldPrintWidePolySkelton = false;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	case WIDEPOLY_OUTPUT_SHAPE:		// _xZkqqHx_jHnGiKhDiCpAiPgPjHmNiBeC_xHqqkZx_
		svgExportOption->_shouldPrintWidePolySkelton = false;
		break;
	case WIDEPOLY_OUTPUT_SKELTON:	// // _xZkqqHx_iNjMiKgJiCpAiPgPjHmNiBeC_xHqqkZx_
		svgExportOption->_shouldPrintWidePolySkelton = true;
		break;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----
	}

	if ( m_printComment ) {
		svgExportOption->_printComment = true;
	} else {
		svgExportOption->_printComment = false;
	}

	if ( m_base64Png ) {
		svgExportOption->_printBase64Png = false;
	} else {
		svgExportOption->_printBase64Png = true;
	}

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (m_backpictAsPng)
		svgExportOption->_printBackpictAsPng = false;
	else
		svgExportOption->_printBackpictAsPng = true;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if ( this->m_oleTrans ) {
		svgExportOption->_useOleTrans = true;
	} else {
		svgExportOption->_useOleTrans = false;
	}

	if ( this->m_textPos ) {
		svgExportOption->_textPosEach = true;
	} else {
		svgExportOption->_textPosEach = false;
	}

	if ( m_htmlCheck ) {
		svgExportOption->_htmlOutput = true;
	} else {
		svgExportOption->_htmlOutput = false;
	}

	svgExportOption->_dpi = atoi( (LPCTSTR)m_dpiEdit );

	return SVGEXPORT_OK;

} // end of COptionDlg::setSvgExportOption



// _xZkqqHx_iDeJiDhGiDfGiDiHiDjDiCmMjCgMiCpAiDfPiDeDiDeBiDiNiDePiCmJjAnNjCoI_xHqqkZx_
int COptionDlg::getSvgExportOption(SvgExportOption *svgExportOption)
{
	char buffer[256];
	sprintf( buffer, "%d", svgExportOption->_digitNum );
	m_digitNum = buffer;

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	sprintf( buffer, "%lf", svgExportOption->_widePolyOutlineUnit );
//	m_widePolyOutlineUnit = buffer;
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIjBeP_xHqqkZx_ ()-----
//	if ( svgExportOption->_shouldPrintWidePolyOutline ) {
//		if ( svgExportOption->_shouldPrintWidePolySkelton ) {
//			m_widePolyType = 1; // _xZkqqHx_iNjMiKgJiBhLjHnGiKhD_xHqqkZx_
//		} else {
//			m_widePolyType = 2; // _xZkqqHx_jHnGiKhDiCmMiCnN_xHqqkZx_
//		}
//	} else {
//		if ( svgExportOption->_shouldPrintWidePolySkelton ) {
//			m_widePolyType = 0; // _xZkqqHx_iNjMiKgJiCmMiCnN_xHqqkZx_
//		} else {
//			m_widePolyType = 2; // _xZkqqHx_jGhLjDjGiCmNiClBiCoKiCmNiCkAiCoIiCkGiCmIiCkCiCkPiCmH_xHqqkZx_
//		}
//	}
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiMoD_xHqqkZx_ ()-----
	if (svgExportOption->_shouldPrintWidePolySkelton)
		m_widePolyType = 1; // _xZkqqHx_iNjMiKgJ_xHqqkZx_
	else
		m_widePolyType = 0; // _xZkqqHx_jHnGiKhD_xHqqkZx_
//----- 06.07.04 Fukushiro M. _xZkqqHx_jFmPiNfIiPeJ_xHqqkZx_ ()-----

// 06.07.04 Fukushiro M. 1_xZkqqHx_iNhDiNoNiPjM_xHqqkZx_ ()
//	_printWidePolySkelton = svgExportOption->_shouldPrintWidePolySkelton;

	if ( svgExportOption->_printComment ) {
		m_printComment = 1;
	} else {
		m_printComment = 0;
	}

	if ( svgExportOption->_printBase64Png ) {
		m_base64Png = 0;
	} else {
		m_base64Png = 1;
	}
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	if (svgExportOption->_printBackpictAsPng)
		m_backpictAsPng = 0;
	else
		m_backpictAsPng = 1;
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	if ( svgExportOption->_useOleTrans ) {
		m_oleTrans = 1;
	} else {
		m_oleTrans = 0;
	}

	if ( svgExportOption->_textPosEach ) {
		m_textPos = 1;
	} else {
		m_textPos = 0;
	}

	if ( svgExportOption->_htmlOutput ) {
		m_htmlCheck = TRUE;
	} else {
		m_htmlCheck = FALSE;
	}

	char numStr[20];
	itoa( svgExportOption->_dpi, numStr, 10 );
	m_dpiEdit = numStr;

	return SVGEXPORT_OK;

} // end of COptionDlg::getSvgExportOption


//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void COptionDlg::OnWidepolySkeltonOffRadio() 
//{
//	// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJiDfCiDjDiDgHiDiNiBfLiDiLjCmKjCgNiDgOiDjDiDgIiDiJjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
//	_printWidePolySkelton = false;
//}
//
//void COptionDlg::OnWidepolySkeltonOnRadio() 
//{
//	// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJiDfCiDjDiDgHiDiNiBfLiDiLjCmKjCgNiDgOiDjDiDgIiDiJjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
//	_printWidePolySkelton = true;
//}
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----





BOOL COptionDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJiPiJiKpKiJlLiCmMjFoCjBkLiPiIjHjNiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
///*
//	if ( SvgExportInfo::svgExportOption._shouldPrintWidePolySkelton ) {
//		CButton *radio = (CButton*)GetDlgItem( IDC_WIDEPOLY_SKELTON_ON_RADIO );
//		radio->SetCheck(1);
//	} else {
//		CButton *radio = (CButton*)GetDlgItem( IDC_WIDEPOLY_SKELTON_OFF_RADIO );
//		radio->SetCheck(1);
//	}
//*/
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----
	OnHtmlCheck();
	CEdit *dpiEdit = (CEdit*)GetDlgItem( IDC_DPI_EDIT );
	CSpinButtonCtrl *dpiSpin = (CSpinButtonCtrl*)GetDlgItem( IDC_DPI_SPIN );
	CString numStr;
	dpiEdit->GetWindowText( numStr );
	dpiSpin->SetRange( 1, 1000 );
	dpiSpin->SetPos( atoi( (LPCTSTR)numStr ) );

	return TRUE;  // _xZkqqHx_iDfCiDjDiDgHiDiNiBfLiDiLiCmJiDhEiDeIiBfLiDeKiDfIiCpAjAnNjCoIiClFiCmIiCkCiCmGiCkLiBeBjGnPiCoIjCgMiCmN_xHqqkZx_ TRUE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
	              // _xZkqqHx_jHoBiKeP_xHqqkZx_: OCX _xZkqqHx_iDhGiDiNiDhAiDgFiDeC_xHqqkZx_ _xZkqqHx_iDhJiBfLiDfHiCmMjGnPiCoIjCgMiCmN_xHqqkZx_ FALSE _xZkqqHx_iCmGiCmIiCoIiCnMiClH_xHqqkZx_
}

void COptionDlg::OnDefaultButton() 
{
	// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJiDfCiDjDiDgHiDiNiBfLiDiLjCmKjCgNiDgOiDjDiDgIiDiJjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_

	// _xZkqqHx_jFjNiNeMjApM_xHqqkZx_

//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//	CComboBox *comboBox = (CComboBox*)GetDlgItem( IDC_WIDEPOLY_OUTLINE_COMBO );
//	comboBox->SetCurSel( 5 );
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

	CComboBox* comboBox = (CComboBox*)GetDlgItem( IDC_WIDEPOLY_COMBO );
	comboBox->SetCurSel(WIDEPOLY_OUTPUT_SHAPE);

	// PNG
	comboBox = (CComboBox*)GetDlgItem( IDC_BASEE64PNG_COMBO );
	comboBox->SetCurSel( 0 );

//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiOgO_xHqqkZx_ ()-----
	comboBox = (CComboBox*)GetDlgItem(IDC_BACKPICT_AS_PNG_COMBO);
	comboBox->SetCurSel(0);
//----- 06.07.04 Fukushiro M. _xZkqqHx_jCmHiJmBiPeJ_xHqqkZx_ ()-----

	comboBox = (CComboBox*)GetDlgItem( IDC_OLE_TRANS_COMBO );
	comboBox->SetCurSel( 0 );

	// text
	comboBox = (CComboBox*)GetDlgItem( IDC_TEXTPOS_COMBO );
	comboBox->SetCurSel( 0 );

	// comment
	comboBox = (CComboBox*)GetDlgItem( IDC_COMMENT_COMBO );
	comboBox->SetCurSel( 1 );

	// _xZkqqHx_jAlIjDhI_xHqqkZx_
	comboBox = (CComboBox*)GetDlgItem( IDC_DIGIT_NUM );
	comboBox->SetCurSel( 6 );

}


//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//void COptionDlg::OnSelchangeWidepolyCombo() 
//{
//	// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJiDfCiDjDiDgHiDiNiBfLiDiLjCmKjCgNiDgOiDjDiDgIiDiJjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
//	CComboBox *comboBox = (CComboBox*)GetDlgItem( IDC_WIDEPOLY_OUTLINE_COMBO );
//
//	// _xZkqqHx_iCkEiBfLiCpBiBeBiCkEiCnMiCkNjBeJjBpAiClFiClNjCgMiCkKiOoGiCoKiCmIiCkCiCmIiCjP_xHqqkZx_
//	int sel = comboBox->GetCurSel();
//	switch ( sel ) {
//	case WIDEPOLY_OUTLINE_ONLY :
//		comboBox->EnableWindow( TRUE );
//		break;
//	case WIDEPOLY_SKELTON_ONLY :
//		comboBox->EnableWindow( FALSE );
//		break;
//	case WIDEPOLY_SKELTON_AND_OUTLINE :
//		comboBox->EnableWindow( TRUE );
//	}
//	
//}
//----- 06.07.04 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


void COptionDlg::OnHtmlCheck() 
{
	// TODO: _xZkqqHx_iClBiCmMiImKjChFiCmJiDfCiDjDiDgHiDiNiBfLiDiLjCmKjCgNiDgOiDjDiDgIiDiJjHhAiCmMiDfCiBfLiDgIiCpAjCmHiJmBiClFiCmEiCkNiClOiClDiCkC_xHqqkZx_
	CButton *htmlCheck = (CButton*)GetDlgItem( IDC_HTML_CHECK );
	CStatic *dpiStatic = (CStatic*)GetDlgItem( IDC_DPI_STATIC );
	CEdit *dpiEdit = (CEdit*)GetDlgItem( IDC_DPI_EDIT );
	CSpinButtonCtrl *dpiSpin = (CSpinButtonCtrl*)GetDlgItem( IDC_DPI_SPIN );
	if ( htmlCheck->GetCheck() ) {
		dpiStatic->EnableWindow( TRUE );
		dpiEdit->EnableWindow( TRUE );
		dpiSpin->EnableWindow( TRUE );
	} else {
		dpiStatic->EnableWindow( FALSE );
		dpiEdit->EnableWindow( FALSE );
		dpiSpin->EnableWindow( FALSE );
	}
	
}

