/*
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is "SVG Export" plug-in for DynamicDraw.

The Initial Developer of the Original Code is FUKUSHIRO Masayuki.

Copyright (C) 2001,2002  FUKUSHIRO Masayuki ( yt3m-fksr@asahi-net.or.jp ), 
HIROSAWA Masashi ( hirosawa@cam.hi-ho.ne.jp ). 
All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms
of the GNU General Public License Version 2 (the "GPL"), in which case
the provisions of the GPL are applicable instead of those above.  If you
wish to allow use of your version of this file only under the terms of
the GPL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the
GPL.

Alternatively, the contents of this file may be used under the terms
of the New BSD License (the "BSDL"), in which case the provisions
of the BSDL are applicable instead of those above.  If you wish
to allow use of your version of this file only under the terms of
the BSDL and not to allow others to use your version of this file under
the MPL, indicate your decision by deleting the provisions above and
replace them with the notice and other provisions required by the BSDL.

If you do not delete the provisions above, a recipient may use
your version of this file under any of the MPL, the GPL or the BSDL.
*/

#include <stdio.h>
#include "stdafx.h"
#include "png.h"

//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#include "MpgExtern.h"		// For Global.
//#include "DBLMath.h"		// For DBLPoint.
//#include "DBLPoint.h"		// For DBLPoint.
//#include "FCLinkManagerExpType.h"	// For FCLinkRecVector.
//#include "FCObjectExp.h"
//#include "DBLRect.h"		// For DBLRect.
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----

#include "SvgExportOption.h"
#include "SvgExportInfo.h"


//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiOgO_xHqqkZx_ ()-----
//#ifdef _DEBUG
//#	include "FCObjectExpType.h"
//#endif // _DEBUG
//----- 06.06.29 Fukushiro M. _xZkqqHx_iNoNiPjMiPeJ_xHqqkZx_ ()-----


static FILE *SSvgExportFptr = NULL;



void writeFile( png_structp png_ptr, png_bytep data, png_size_t length ) {

	fwrite( data, 1, length, SSvgExportFptr );

} // end of writeFile



void flushFile( png_structp png_ptr ) {

	fflush( SSvgExportFptr );

} // end of writeFile



// base64_xZkqqHx_jFmPiKlH_xHqqkZx_
void encodeBase64( char *writeBuffer, char *base64buffer ) {

	static char *map = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

	writeBuffer[0] = map[ ( base64buffer[0] & 0xFC ) >> 2 ];
	writeBuffer[1] = map[ (( base64buffer[0] & 0x03 ) << 4) | (( base64buffer[1] & 0xF0 ) >> 4) ];
	writeBuffer[2] = map[ (( base64buffer[1] & 0x0F ) << 2) | (( base64buffer[2] & 0xC0 ) >> 6) ];
	writeBuffer[3] = map[ base64buffer[2] & 0x3F ];

} // end of encodeBase64



static char SBase64buffer[3]; // base64_xZkqqHx_jFmPiKlHjBePiCmMiCfCiDgPiDeDiDgHiDgGiBfLiDfO_xHqqkZx_
static int SLeftBytes = 0; // _xZkqqHx_jGkCjFmPiKlHiCmMiDgGiBfLiDfOiDgPiDeDiDgHjAjE_xHqqkZx_
static char SWriteBuffer[4]; // base64_xZkqqHx_jFmPiKlHiClDiCoKiClNiCfDiDgPiDeDiDgHiDgGiBfLiDfO_xHqqkZx_

void initBase64File( FILE *fptr ) {

	SSvgExportFptr = fptr;

	SLeftBytes = 0;

} // end of initBase64File


void writeBase64File( png_bytep data, png_size_t length ) {

	int modLength = length + SLeftBytes;

	for ( int srcDataIndex = 0; srcDataIndex + 2 - SLeftBytes < length;  ) {

		// 3_xZkqqHx_iDgPiDeDiDgHiCpAiPiAjEpF_xHqqkZx_
		memcpy( SBase64buffer + SLeftBytes, data + srcDataIndex, 3 - SLeftBytes );
		srcDataIndex += 3 - SLeftBytes;
		SLeftBytes = 0;

		// base64_xZkqqHx_jFmPiKlH_xHqqkZx_
		encodeBase64( SWriteBuffer, SBase64buffer );

		// 4_xZkqqHx_iDgPiDeDiDgHiPjBiCkLiNjOiCnN_xHqqkZx_
		fwrite( SWriteBuffer, 1, 4, SSvgExportFptr );

	} // for

	SLeftBytes = modLength % 3;

	if ( SLeftBytes ) {
		// _xZkqqHx_iOgDiCoIiDgPiDeDiDgHiCmNiKgJjEfLiClFiCmEiCkIiCkN_xHqqkZx_
		memcpy( SBase64buffer, data + length - SLeftBytes, SLeftBytes );
	}

} // end of writeBase64File



void writeBase64PngFile( png_structp png_ptr, png_bytep data, png_size_t length ) {

	writeBase64File( data, length );

} // end of writeBase64File



// _xZkqqHx_iOgDiCmBiClNiDgGiBfLiDfOiCpAiPjBiCkLiNjOiCnO_xHqqkZx_
void writeBase64FileLeftBytes() {

	if ( 0 == SLeftBytes ) {
		return;
	}

	// 3_xZkqqHx_iDgPiDeDiDgHiCmJjGjOiClNiCmIiCkCiDgPiDeDiDgHiCmJiCePiCpAiPjBiCkLiNjOiCnO_xHqqkZx_
	memset( SBase64buffer + SLeftBytes, 0x00, 3 - SLeftBytes );

	// base64_xZkqqHx_jFmPiKlH_xHqqkZx_
	encodeBase64( SWriteBuffer, SBase64buffer );

	fwrite( SWriteBuffer, 1, 3, SSvgExportFptr );

	for ( ; SLeftBytes < 3; SLeftBytes++ ) {
		fputc( '=', SSvgExportFptr );
	}

} // end of writeBase64FileLeftBytes




void pngErrorFunc(png_structp, png_const_charp) {

	int i = 0;

}


int pngSave( FILE *fptr, CDC *pDC, FCObjDynabase *objectExp, int pxWidth, int pxHeight,
			bool setTransparent, COLORREF transColor, bool saveAsBase64 ) {

	png_bytep dptr = NULL;
	png_bytep *data_ptr = NULL;
	png_structp png_ptr = NULL;
	png_infop info_ptr = NULL;
	int bit_depth = 8, color_type = PNG_COLOR_TYPE_RGB, 
		interlace_type = PNG_INTERLACE_NONE;
	DBLRect	outerFrame;
	int pixelBytes = 3;


	initBase64File( fptr );

	// png_struct_xZkqqHx_iNoMjAkM_xHqqkZx_
	//png_ptr = png_create_write_struct( PNG_LIBPNG_VER_STRING, NULL, NULL, NULL );
	png_ptr = png_create_write_struct( PNG_LIBPNG_VER_STRING, NULL, pngErrorFunc, NULL );
	if ( NULL == png_ptr ) {
		goto SVGEXPORT_PNG_SAVE_ERROR;
	}

	// info_ptr_xZkqqHx_iNoMjAkM_xHqqkZx_
	info_ptr = png_create_info_struct( png_ptr );
	if ( NULL == info_ptr ) {
		goto SVGEXPORT_PNG_SAVE_ERROR;
	}

	if (setjmp(png_jmpbuf(png_ptr))) {
		goto SVGEXPORT_PNG_SAVE_ERROR;
	}

	// _xZkqqHx_iDfCiBfLiDiLiDgPiDgCiDeOiKnGjAjEiCmMjAnNjCoI_xHqqkZx_
	if ( saveAsBase64 ) {
		png_set_write_fn( png_ptr, NULL, writeBase64PngFile, flushFile );
	} else {
		png_set_write_fn( png_ptr, NULL, writeFile, flushFile );
	}

	png_uint_32 width, height;

	outerFrame = objectExp->GetOuterFrame();
	width = (png_uint_32)pxWidth;
	height = (png_uint_32)pxHeight;

	if ( setTransparent ) {
		pixelBytes = 4;
		color_type = PNG_COLOR_TYPE_RGB_ALPHA;
	}

	png_set_IHDR( png_ptr, info_ptr, width, height, bit_depth, color_type,
		interlace_type, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE );

	png_write_info(png_ptr, info_ptr);

	//----------- _xZkqqHx_iJoGjBgGjAnNjCoI_xHqqkZx_ -----------------

	int x, y;
	data_ptr = new png_bytep[height];
	if ( NULL == data_ptr ) {
		goto SVGEXPORT_PNG_SAVE_ERROR;
	}
	for ( y = 0; y < (int)height; y++ ) {
		data_ptr[y] = NULL; // for error recovery
	}
	for ( y = 0; y < (int)height; y++ ) {
		data_ptr[y] = new png_byte[width*pixelBytes];
		if ( NULL == data_ptr[y] ) {
			goto SVGEXPORT_PNG_SAVE_ERROR;
		}
	}

	if ( setTransparent ) {
		// _xZkqqHx_iDlPiDgAiDiDiDjDiDgMiDiLjBmOiJjO_xHqqkZx_
		for ( y = 0; y < (int)height; y++ ) {
			dptr = data_ptr[y];
			for ( x = 0; x < (int)width; x++ ) {
				COLORREF color = pDC->GetPixel( x, y );
				*dptr++ = GetRValue( color );
				*dptr++ = GetGValue( color );
				*dptr++ = GetBValue( color );
				if ( color == transColor ) {
					*dptr++ = 0; // _xZkqqHx_jDkHjGlO_xHqqkZx_
				} else {
					*dptr++ = 255; // _xZkqqHx_jFhDjDkHjGlO_xHqqkZx_
				}
			} // for x
		} // for y
	} else { // if _useOleTrans
		// _xZkqqHx_iDlPiDgAiDiDiDjDiDgMiDiLjEpBjBmOiJjO_xHqqkZx_
		for ( y = 0; y < (int)height; y++ ) {
			dptr = data_ptr[y];
			for ( x = 0; x < (int)width; x++ ) {
				COLORREF color = pDC->GetPixel( x, y );
				*dptr++ = GetRValue( color );
				*dptr++ = GetGValue( color );
				*dptr++ = GetBValue( color );
			} // for x
		} // for y
	} // if _useOleTrans

	// PNG_xZkqqHx_iDhEiDeAiDeDiDiLiPjBiCkLiNjOiCnN_xHqqkZx_
	png_write_image( png_ptr, data_ptr );

	png_write_end( png_ptr, info_ptr );

	png_destroy_write_struct( &png_ptr, &info_ptr );

	if ( saveAsBase64 ) {
		// _xZkqqHx_iOgDiCoIiDgGiBfLiDfOiPjBiCkLiNjOiCnN_xHqqkZx_
		writeBase64FileLeftBytes();
	}

	// close
	SSvgExportFptr = NULL;

	for ( y = 0; y < (int)height; y++ ) {
		delete [] data_ptr[y];
	}
	delete [] data_ptr;

	return SVGEXPORT_OK;

SVGEXPORT_PNG_SAVE_ERROR:
	SSvgExportFptr = NULL;
	if ( png_ptr ) {
		if ( info_ptr ) {
			png_destroy_write_struct( &png_ptr, &info_ptr );
		} else {
			png_destroy_read_struct( &png_ptr, NULL, NULL );
		}
	}

	return SVGEXPORT_CONTINUABLE_ERROR;

} // end of pngSave


