#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/.root

PROJECT=$1
JOBNET=$2
JOBNET_HOME=${ROOT}/project/${PROJECT}/${JOBNET}
CONTROLLER_EXE=${JOBNET_HOME}/controller.sh
CLUSTER_CONTROLLER_EXE=${JOBNET_HOME}/cluster_controller.sh
PROF=${JOBNET_HOME}/jobnet.prof
ENABLE_FLAG=${JOBNET_HOME}/.enabled

if [ "${PROJECT}" = "" -o "${JOBNET}" = "" ];then
 echo "usage: enable_jobnet.sh <PROJECT> <JOBNET>"
 exit 1
fi

if [ ! -f ${JOBNET_HOME}/jobnet.prof ];then
 echo "jobnet is not exist"
 exit 1
fi

crontab -l | grep -v ${CONTROLLER_EXE} > ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
  echo "maybe permission is wrong ${JOBNET_HOME}/.crontab_tmp"
  exit 1
fi

grep -v ${JOBNET_HOME}/log ${ROOT}/utilities/jobnet.list > ${ROOT}/utilities/.jobnet.list.tmp
chmod 766 ${ROOT}/utilities/.jobnet.list.tmp
cp -f ${ROOT}/utilities/.jobnet.list.tmp ${ROOT}/utilities/jobnet.list

#crontab update
crontab ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
 echo "disable was failed, please check cron"
fi

echo "-------------------------------------------------------------"
echo "JOBNET:${JOBNET} disabled succesfully"
echo "please check crontab -l "
rm -f ${ENABLE_FLAG}

## cluster_check
IFCONFIG=/usr/sbin/ifconfig
LINUX=`uname -a | grep Linux`

if [ "${LINUX}" ];then
  IFCONFIG=/sbin/ifconfig
fi

. ${ROOT}/project/${PROJECT}/${JOBNET}/cluster.conf
. ${ROOT}/cluster/global.conf

if [ "${CLUSTER}" = yes  -o "${DISPATCH}" = yes  ];then

 if [ "${CONTROLLER}" ];then
 for RHOST in ${CONTROLLER}
  do
    IP_ADDR_CHECK=`${IFCONFIG} -a | grep ${RHOST}`
    if [ "${IP_ADDR_CHECK}" = "" ];then

      if [ "${CLUSTER_USER}" = "" ];then
        CRON_CHECK=`ssh -p ${SSH_PORT} ${RHOST} crontab -l | grep ${CONTROLLER_EXE}`
      else
        CRON_CHECK=`ssh -l ${CLUSTER_USER} -i /home/${CLUSTER_USER}/.ssh/id_rsa -p ${SSH_PORT} ${RHOST} crontab -l | grep ${CONTROLLER_EXE}`
      fi

      if [ "${CRON_CHECK}" ];then
       echo "notice: please execute \"disable_jobnet.sh ${PROJECT} ${JOBNET}\" on remote server too"
      fi

    fi

   done
 fi
fi
echo "-------------------------------------------------------------"

rm ${JOBNET_HOME}/.crontab_tmp

exit 0
