#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/.root

DISABLE_JOBS=no


if [ ! -d "${ROOT}/que/error" ];then
 echo "ERROR user is not correct, please execute this command by job user"
exit 1
fi

crontab -l > ${SCRIPT_DIR}/.crontab
chmod 766 ${SCRIPT_DIR}/.crontab

for DISABLE_JOB in `find /home/naruo/e-cron/project -name controller.sh`
do

  CRON_CHECK=`grep ${DISABLE_JOB} ${SCRIPT_DIR}/.crontab`
  if [ "${CRON_CHECK}" = "" ];then
    echo ${DISABLE_JOB}
    DISABLE_JOBS=yes
  fi

done


if [ "${DISABLE_JOBS}" = "no" ];then
 echo "There is no disable jobnet"
fi
