#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

t load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/../.root


PROJECT=$1
JOBNET=$2
JOBNET_HOME=${ROOT}/project/${PROJECT}/${JOBNET}
CONTROLLER_EXE=${JOBNET_HOME}/controller.sh
JOBNET_LOG=${JOBNET_HOME}/log/jobnet_log_`date +%Y%m%d`

if [ "${PROJECT}" = "" -o "${JOBNET}" = "" ];then
 echo "usage: kill_jobnet.sh <PROJECT> <JOBNET>"
 exit 1
fi

if [ ! -f ${JOBNET_HOME}/jobnet.prof ];then
 echo "jobnet is not exist"
 exit 1
fi

## kill process
PID=`ps -ef | grep "/bin/sh ${CONTROLLER_EXE}" | grep -v grep | awk '{print $2}'`

if [ $? = 0 ];then
echo "-------------------------------------------------------------"
  echo "jobnet ${JOBNET} killed succesfully"
  echo "jobnet manually killed" >> ${JONET_LOG}
echo "-------------------------------------------------------------"
else
  echo "kill_jobnet.sh failed"
  exit 1
fi

exit 0
