#!/bin/sh

# Copyright (c) 2014 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


## param setting
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
UNAME=`uname -n`
TIME=`date +%s`
LOG_DIR=${SCRIPT_DIR}/../log
DETECTED_MESSAGES=${LOG_DIR}/detected_message_`date +%Y%m%d`
ERROR_TMP=${SCRIPT_DIR}/.error_tmp

if [ ! -f ${DETECTED_MESSAGES} ];then
  touch ${DETECTED_MESSAGES}
fi

JOB=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $NF } END {print field }'`
JOBNET=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $(NF-1) } END {print field }'`
PROJECT=`echo ${SCRIPT_DIR} | awk -F [/] '{field = $(NF-2) } END {print field}'`


## jobnet prof load
grep -v SCHEDULE ${SCRIPT_DIR}/../jobnet.prof > ${SCRIPT_DIR}/.jobnet_tmp
chmod 777 ${SCRIPT_DIR}/.jobnet_tmp
. ${SCRIPT_DIR}/.jobnet_tmp


## conf load
. ${SCRIPT_DIR}/../../../../.root


## log check

cat ${SCRIPT_DIR}/monitor.conf | grep -v "^$" | grep -v ^#  > ${SCRIPT_DIR}/.monitor.conf.tmp
chmod 777 ${SCRIPT_DIR}/.monitor.conf.tmp

while read CONTEXT
do
  FULL_PATH=`echo $CONTEXT | awk -F":" '{print $1}'`
  FILE_NAME=`echo $FULL_PATH | awk -F"/" '{print $NF}'`
  MESSAGE=`echo $CONTEXT | awk -F":" '{print $2}'`
  MONITOR_ERROR_QUE=${ROOT}/que/monitor/${UNAME}_error_`date +%Y%m%d`
  MONITOR_STATUS_QUE=${ROOT}/que/monitor/${UNAME}_${FILE_NAME}_status

  grep "${MESSAGE}" ${FULL_PATH} > ${ERROR_TMP}

  if [ $? = 0 ];then
    while read ERROR
    do

      grep "${ERROR}" ${DETECTED_MESSAGES}

      if [ $? != 0 ];then
        echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${FULL_PATH}:${MESSAGE}" >> ${MONITOR_ERROR_QUE}
        SED_MESSAGE=`echo $MESSAGE | sed -e "s/ /_/"`
        echo "`date +%Y/%m/%d` `date +%H:%M:%S` ${PROJECT} ${JOBNET} ERROR ${FULL_PATH}:${SED_MESSAGE}" > ${MONITOR_STATUS_QUE} 
        echo "${ERROR}" >> ${DETECTED_MESSAGES}

        if [ "${MAIL_ADDR}" ];then
          TIME=`date +%s`
          MAIL_QUE=${ROOT}/que/mail/${PROJECT}_${JOBNET}_${JOB}_${FILE_NAME}_${TIME}
          echo "MAIL_ADDR:${MAIL_ADDR}" > ${MAIL_QUE}
          echo "SUBJECT: log erorr detected ${FULL_PATH} ${UNAME}">> ${MAIL_QUE}
          echo "${ERROR}" >> ${MAIL_QUE}
        fi
      fi
    done < ${ERROR_TMP}
  fi
done < ${SCRIPT_DIR}/.monitor.conf.tmp

find ${SCRIPT_DIR} -type f -name *.tmp -mtime +0 |  xargs rm -f
exit 0