/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.seasar.extension.jdbc.WhereClause;
import org.seasar.extension.jdbc.exception.NonArrayInConditionRuntimeException;
import org.seasar.extension.jdbc.exception.NonBooleanIsNullConditionRuntimeException;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConditionType {
    EQ{

        public String getCondition(String name) {
            return this.getCondition(null, name);
        }

        public String getCondition(String tableAlias, String columnName) {
            return this.getCondition(tableAlias, columnName, null);
        }

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " = ?";
        }
    }
    ,
    NE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " <> ?";
        }
    }
    ,
    LT{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " < ?";
        }
    }
    ,
    LE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " <= ?";
        }
    }
    ,
    GT{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " > ?";
        }
    }
    ,
    GE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " >= ?";
        }
    }
    ,
    IN{

        @Override
        public boolean isTarget(Object value) {
            Object[] values;
            this.assertArrayInCondition("in", value);
            if (!super.isTarget(value) || !value.getClass().isArray() || Array.getLength(value) == 0) {
                return false;
            }
            for (Object element : values = (Object[])Object[].class.cast(value)) {
                if (!super.isTarget(element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.getInConditionInternal(this.makeName(tableAlias, columnName), "in", value);
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            Object[] values = (Object[])value;
            paramList.addAll(Arrays.asList(values));
            return values.length;
        }
    }
    ,
    NOT_IN{

        @Override
        public boolean isTarget(Object value) {
            Object[] values;
            this.assertArrayInCondition("not in", value);
            if (!super.isTarget(value) || !value.getClass().isArray() || Array.getLength(value) == 0) {
                return false;
            }
            for (Object element : values = (Object[])Object[].class.cast(value)) {
                if (!super.isTarget(element)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.getInConditionInternal(this.makeName(tableAlias, columnName), "not in", value);
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            Object[] values = (Object[])value;
            paramList.addAll(Arrays.asList(values));
            return values.length;
        }
    }
    ,
    LIKE{

        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ?";
        }
    }
    ,
    LIKE_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ? escape ?";
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            Object[] values = (Object[])Object[].class.cast(value);
            super.addValue(valueList, values[0]);
            super.addValue(valueList, values[1]);
            return 2;
        }
    }
    ,
    STARTS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ?";
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, value + "%");
        }
    }
    ,
    STARTS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ? escape '$'";
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, value + "%");
        }
    }
    ,
    ENDS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ?";
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value);
        }
    }
    ,
    ENDS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ? escape '$'";
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value);
        }
    }
    ,
    CONTAINS{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ?";
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value + "%");
        }
    }
    ,
    CONTAINS_ESCAPE{

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " like ? escape '$'";
        }

        @Override
        public int addValue(List<Object> valueList, Object value) {
            return super.addValue(valueList, "%" + value + "%");
        }
    }
    ,
    IS_NULL{

        @Override
        public boolean isTarget(Object value) {
            this.assertBooleanIsNullCondition("is null", value);
            return super.isTarget(value) && Boolean.TRUE.equals(value);
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " is null";
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            return 0;
        }
    }
    ,
    IS_NOT_NULL{

        @Override
        public boolean isTarget(Object value) {
            this.assertBooleanIsNullCondition("is not null", value);
            return super.isTarget(value) && Boolean.TRUE.equals(value);
        }

        @Override
        public String getCondition(String tableAlias, String columnName, Object value) {
            return this.makeName(tableAlias, columnName) + " is not null";
        }

        @Override
        public int addValue(List<Object> paramList, Object value) {
            return 0;
        }
    };


    public static ConditionType getConditionType(String name) {
        if (NE.hasSuffix(name)) {
            return NE;
        }
        if (LT.hasSuffix(name)) {
            return LT;
        }
        if (LE.hasSuffix(name)) {
            return LE;
        }
        if (GT.hasSuffix(name)) {
            return GT;
        }
        if (GE.hasSuffix(name)) {
            return GE;
        }
        if (NOT_IN.hasSuffix(name)) {
            return NOT_IN;
        }
        if (IN.hasSuffix(name)) {
            return IN;
        }
        if (LIKE.hasSuffix(name)) {
            return LIKE;
        }
        if (STARTS.hasSuffix(name)) {
            return STARTS;
        }
        if (ENDS.hasSuffix(name)) {
            return ENDS;
        }
        if (CONTAINS.hasSuffix(name)) {
            return CONTAINS;
        }
        if (IS_NULL.hasSuffix(name)) {
            return IS_NULL;
        }
        if (IS_NOT_NULL.hasSuffix(name)) {
            return IS_NOT_NULL;
        }
        return EQ;
    }

    public String getSuffix() {
        return "_" + this.name();
    }

    public boolean hasSuffix(String name) {
        return name.endsWith(this.getSuffix());
    }

    public String removeSuffix(String s) {
        String suffix = this.getSuffix();
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - this.getSuffix().length());
        }
        return s;
    }

    public int addCondition(String name, Object value, WhereClause whereClause, List<Object> valueList) {
        return this.addCondition(null, name, value, whereClause, valueList);
    }

    public int addCondition(String tableAlias, String columnName, Object value, WhereClause whereClause, List<Object> valueList) {
        if (this.isTarget(value)) {
            whereClause.addAndSql(this.getCondition(tableAlias, columnName, value));
            return this.addValue(valueList, value);
        }
        return 0;
    }

    public boolean isTarget(Object value) {
        return value != null;
    }

    public String getCondition(String name, Object value) {
        return this.getCondition(null, name, value);
    }

    public abstract String getCondition(String var1, String var2, Object var3);

    public int addValue(List<Object> valueList, Object value) {
        valueList.add(value);
        return 1;
    }

    protected String makeName(String tableAlias, String columnName) {
        if (StringUtil.isEmpty((String)tableAlias)) {
            return columnName;
        }
        return tableAlias + "." + columnName;
    }

    protected String getInConditionInternal(String name, String conditionName, Object value) {
        int size = Array.getLength(value);
        StringBuilder buf = new StringBuilder(30);
        buf.append(name);
        buf.append(" ").append(conditionName).append(" (");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    protected void assertArrayInCondition(String conditionName, Object value) {
        if (value != null && !value.getClass().isArray()) {
            throw new NonArrayInConditionRuntimeException(conditionName, value.getClass());
        }
    }

    protected void assertBooleanIsNullCondition(String conditionName, Object value) {
        if (value != null && value.getClass() != Boolean.class) {
            throw new NonBooleanIsNullConditionRuntimeException(conditionName, value.getClass());
        }
    }
}

