/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.extension.jdbc.AutoSelect;
import org.seasar.extension.jdbc.ColumnMeta;
import org.seasar.extension.jdbc.ConditionType;
import org.seasar.extension.jdbc.DbmsDialect;
import org.seasar.extension.jdbc.EntityMapper;
import org.seasar.extension.jdbc.EntityMeta;
import org.seasar.extension.jdbc.FromClause;
import org.seasar.extension.jdbc.IterationCallback;
import org.seasar.extension.jdbc.JoinColumnMeta;
import org.seasar.extension.jdbc.JoinMeta;
import org.seasar.extension.jdbc.JoinType;
import org.seasar.extension.jdbc.OrderByClause;
import org.seasar.extension.jdbc.OrderByItem;
import org.seasar.extension.jdbc.PropertyMapper;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectClause;
import org.seasar.extension.jdbc.SelectForUpdateType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.Where;
import org.seasar.extension.jdbc.WhereClause;
import org.seasar.extension.jdbc.exception.BaseJoinNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.EntityColumnNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.IllegalIdPropertySizeRuntimeException;
import org.seasar.extension.jdbc.exception.JoinDuplicatedRuntimeException;
import org.seasar.extension.jdbc.exception.PropertyNotFoundRuntimeException;
import org.seasar.extension.jdbc.exception.VersionPropertyNotExistsRuntimeException;
import org.seasar.extension.jdbc.handler.BeanAutoResultSetHandler;
import org.seasar.extension.jdbc.handler.BeanIterationAutoResultSetHandler;
import org.seasar.extension.jdbc.handler.BeanListAutoResultSetHandler;
import org.seasar.extension.jdbc.handler.ObjectResultSetHandler;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.mapper.AbstractEntityMapper;
import org.seasar.extension.jdbc.mapper.AbstractRelationshipEntityMapper;
import org.seasar.extension.jdbc.mapper.EntityMapperImpl;
import org.seasar.extension.jdbc.mapper.ManyToOneEntityMapperImpl;
import org.seasar.extension.jdbc.mapper.OneToManyEntityMapperImpl;
import org.seasar.extension.jdbc.mapper.OneToOneEntityMapperImpl;
import org.seasar.extension.jdbc.mapper.PropertyMapperImpl;
import org.seasar.extension.jdbc.query.AbstractSelect;
import org.seasar.extension.jdbc.util.QueryTokenizer;
import org.seasar.extension.jdbc.where.ComplexWhere;
import org.seasar.extension.jdbc.where.SimpleWhere;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSelectImpl<T>
extends AbstractSelect<T, AutoSelect<T>>
implements AutoSelect<T> {
    protected List<JoinMeta> joinMetaList = new ArrayList<JoinMeta>();
    protected int tableIndex;
    protected Map<String, String> tableAliasMap = new HashMap<String, String>();
    protected Map<String, EntityMeta> entityMetaMap = new HashMap<String, EntityMeta>();
    protected String entityName;
    protected SelectClause selectClause = new SelectClause();
    protected FromClause fromClause = new FromClause();
    protected WhereClause whereClause = new WhereClause();
    protected OrderByClause orderByClause = new OrderByClause();
    protected String orderBy = "";
    protected String forUpdate = "";
    protected SelectForUpdateType forUpdateType;
    protected Map<String, String> forUpdateTargets = CollectionsUtil.newLinkedHashMap();
    protected int forUpdateWaitSeconds = 0;
    protected String hint;
    protected List<ValueType> valueTypeList = new ArrayList<ValueType>(50);
    protected int selectListIndex;
    protected Map<String, AbstractEntityMapper> entityMapperMap = new HashMap<String, AbstractEntityMapper>();
    protected List<Object> whereParams = new ArrayList<Object>();
    protected Map<String, ? extends Object> conditions;
    protected String criteria;
    protected Object[] criteriaParams = new Object[0];
    protected String[] criteriaPropertyNames = new String[0];
    protected List<PropertyMeta> idPropertyMetaList;
    protected Object[] idProperties;
    protected PropertyMeta versionPropertyMeta;
    protected Object versionProperty;

    public AutoSelectImpl(JdbcManagerImplementor jdbcManager, Class<T> baseClass) {
        super(jdbcManager, baseClass);
    }

    @Override
    public AutoSelect<T> innerJoin(CharSequence name) {
        return this.join(name, JoinType.INNER);
    }

    @Override
    public AutoSelect<T> innerJoin(CharSequence name, String condition, Object ... params) {
        return this.join(name, JoinType.INNER, condition, params);
    }

    @Override
    public AutoSelect<T> innerJoin(CharSequence name, Where condition) {
        return this.join(name, JoinType.INNER, condition);
    }

    @Override
    public AutoSelect<T> innerJoin(CharSequence name, boolean fetch) {
        return this.join(name, JoinType.INNER, fetch);
    }

    @Override
    public AutoSelect<T> innerJoin(CharSequence name, boolean fetch, String condition, Object ... params) {
        return this.join(name, JoinType.INNER, fetch, condition, params);
    }

    @Override
    public AutoSelect<T> innerJoin(CharSequence name, boolean fetch, Where condition) {
        return this.join(name, JoinType.INNER, fetch, condition);
    }

    @Override
    public AutoSelect<T> leftOuterJoin(CharSequence name) {
        return this.join(name, JoinType.LEFT_OUTER);
    }

    @Override
    public AutoSelect<T> leftOuterJoin(CharSequence name, String condition, Object ... params) {
        return this.join(name, JoinType.LEFT_OUTER, condition, params);
    }

    @Override
    public AutoSelect<T> leftOuterJoin(CharSequence name, Where condition) {
        return this.join(name, JoinType.LEFT_OUTER, condition);
    }

    @Override
    public AutoSelect<T> leftOuterJoin(CharSequence name, boolean fetch) {
        return this.join(name, JoinType.LEFT_OUTER, fetch);
    }

    @Override
    public AutoSelect<T> leftOuterJoin(CharSequence name, boolean fetch, String condition, Object ... params) {
        return this.join(name, JoinType.LEFT_OUTER, fetch, condition, params);
    }

    @Override
    public AutoSelect<T> leftOuterJoin(CharSequence name, boolean fetch, Where condition) {
        return this.join(name, JoinType.LEFT_OUTER, fetch, condition);
    }

    @Override
    public AutoSelect<T> join(CharSequence name, JoinType joinType) {
        return this.join(name, joinType, true);
    }

    @Override
    public AutoSelect<T> join(CharSequence name, JoinType joinType, String condition, Object ... params) {
        return this.join(name, joinType, true, condition, params);
    }

    @Override
    public AutoSelect<T> join(CharSequence name, JoinType joinType, Where condition) {
        return this.join(name, joinType, true, condition);
    }

    @Override
    public AutoSelect<T> join(CharSequence name, JoinType joinType, boolean fetch) {
        this.joinMetaList.add(new JoinMeta(((Object)name).toString(), joinType, fetch));
        return this;
    }

    @Override
    public AutoSelect<T> join(CharSequence name, JoinType joinType, boolean fetch, String condition, Object ... params) {
        this.joinMetaList.add(new JoinMeta(((Object)name).toString(), joinType, fetch, condition, params));
        return this;
    }

    @Override
    public AutoSelect<T> join(CharSequence name, JoinType joinType, boolean fetch, Where condition) {
        this.joinMetaList.add(new JoinMeta(((Object)name).toString(), joinType, fetch, condition.getCriteria(), condition.getParams(), condition.getPropertyNames()));
        return this;
    }

    protected int getJoinMetaSize() {
        return this.joinMetaList.size();
    }

    protected JoinMeta getJoinMeta(int index) {
        return this.joinMetaList.get(index);
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareTarget();
        this.prepareJoins();
        this.prepareIdVersion();
        this.prepareWhere();
        this.prepareConditions();
        this.prepareCriteria();
        this.prepareOrderBy();
        this.prepareForUpdate();
        this.prepareParams();
        this.prepareSql();
    }

    protected void prepareTarget() {
        String tableAlias = this.prepareTableAlias(null);
        EntityMeta entityMeta = this.prepareEntityMeta(this.baseClass, null);
        this.entityName = entityMeta.getName();
        ArrayList<PropertyMapper> propertyMapperList = new ArrayList<PropertyMapper>(50);
        ArrayList<Integer> idIndexList = new ArrayList<Integer>();
        this.prepareEntity(entityMeta, tableAlias, propertyMapperList, idIndexList);
        PropertyMapper[] propertyMappers = this.toPropertyMapperArray(propertyMapperList);
        int[] idIndices = this.toIdIndexArray(idIndexList);
        this.entityMapperMap.put(null, new EntityMapperImpl(this.baseClass, propertyMappers, idIndices));
        String lockHint = this.getLockHint(null);
        if (StringUtil.isEmpty((String)lockHint)) {
            this.fromClause.addSql(entityMeta.getTableMeta().getFullName(), tableAlias);
        } else {
            this.fromClause.addSql(entityMeta.getTableMeta().getFullName(), tableAlias, lockHint);
        }
    }

    protected void prepareEntity(EntityMeta em, String tableAlias, List<PropertyMapper> propertyMapperList, List<Integer> idIndexList) {
        if (this.count) {
            List<PropertyMeta> propertyMetaList = em.getIdPropertyMetaList();
            String selectItem = propertyMetaList.isEmpty() ? "count(*)" : "count(" + tableAlias + "." + propertyMetaList.get(0).getColumnMeta().getName() + ")";
            this.selectClause.addSql(selectItem);
            this.valueTypeList.add(this.jdbcManager.getDialect().getValueType(Long.class, false, null));
        } else {
            for (int i = 0; i < em.getPropertyMetaSize(); ++i) {
                PropertyMeta pm = em.getPropertyMeta(i);
                if (pm.isTransient() || pm.isRelationship()) continue;
                this.selectClause.addSql(tableAlias, pm.getColumnMeta().getName());
                this.valueTypeList.add(this.jdbcManager.getDialect().getValueType(pm));
                propertyMapperList.add(new PropertyMapperImpl(pm.getField(), this.selectListIndex));
                if (pm.isId()) {
                    idIndexList.add(new Integer(this.selectListIndex));
                }
                ++this.selectListIndex;
            }
        }
    }

    protected String getTableAlias(String join) {
        return this.tableAliasMap.get(join);
    }

    protected String createTableAlias() {
        return "T" + ++this.tableIndex + "_";
    }

    protected String prepareTableAlias(String join) {
        String tableAlias = this.createTableAlias();
        this.tableAliasMap.put(join, tableAlias);
        return tableAlias;
    }

    protected EntityMeta getEntityMeta(String join) {
        return this.entityMetaMap.get(join);
    }

    protected EntityMeta prepareEntityMeta(Class<?> entityClass, String join) {
        EntityMeta entityMeta = null;
        try {
            entityMeta = this.jdbcManager.getEntityMetaFactory().getEntityMeta(entityClass);
        }
        catch (RuntimeException e) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            this.logger.log("ESSR0711", new Object[]{this.baseClass.getName()});
            throw e;
        }
        this.entityMetaMap.put(join, entityMeta);
        return entityMeta;
    }

    protected ValueType[] getValueTypes() {
        return this.valueTypeList.toArray(new ValueType[this.valueTypeList.size()]);
    }

    protected PropertyMapperImpl[] toPropertyMapperArray(List<PropertyMapper> propertyMapperList) {
        return propertyMapperList.toArray(new PropertyMapperImpl[propertyMapperList.size()]);
    }

    protected int[] toIdIndexArray(List<Integer> idIndexList) {
        int[] idIndices = new int[idIndexList.size()];
        for (int i = 0; i < idIndices.length; ++i) {
            idIndices[i] = idIndexList.get(i);
        }
        return idIndices;
    }

    protected AbstractEntityMapper getEntityMapper(String join) {
        return this.entityMapperMap.get(join);
    }

    protected void prepareJoins() {
        for (JoinMeta joinMeta : this.joinMetaList) {
            this.prepareJoin(joinMeta);
        }
    }

    protected void prepareJoin(JoinMeta joinMeta) {
        block7: {
            String baseTableAlias;
            String tableAlias = this.prepareTableAlias(joinMeta.getName());
            String[] names = this.splitBaseAndProperty(joinMeta.getName());
            EntityMeta baseEntityMeta = this.getBaseEntityMeta(joinMeta.getName(), names[0]);
            AbstractEntityMapper baseEntityMapper = this.getBaseEntityMapper(joinMeta.getName(), names[0]);
            PropertyMeta propertyMeta = this.getPropertyMeta(baseEntityMeta, joinMeta.getName(), names[1]);
            Class<?> relationshipClass = propertyMeta.getRelationshipClass();
            EntityMeta inverseEntityMeta = this.getInverseEntityMeta(relationshipClass, joinMeta.getName());
            PropertyMeta inversePropertyMeta = this.getInversePropertyMeta(inverseEntityMeta, propertyMeta);
            String fkTableAlias = baseTableAlias = this.getTableAlias(names[0]);
            String pkTableAlias = tableAlias;
            List<JoinColumnMeta> joinColumnMetaList = propertyMeta.getJoinColumnMetaList();
            if (propertyMeta.getMappedBy() != null) {
                fkTableAlias = tableAlias;
                pkTableAlias = baseTableAlias;
                joinColumnMetaList = inversePropertyMeta.getJoinColumnMetaList();
            }
            if (joinMeta.isFetch()) {
                ArrayList<PropertyMapper> propertyMapperList = new ArrayList<PropertyMapper>(50);
                ArrayList<Integer> idIndexList = new ArrayList<Integer>();
                if (!this.count) {
                    this.prepareEntity(inverseEntityMeta, tableAlias, propertyMapperList, idIndexList);
                }
                PropertyMapper[] propertyMappers = this.toPropertyMapperArray(propertyMapperList);
                int[] idIndices = this.toIdIndexArray(idIndexList);
                AbstractRelationshipEntityMapper remapper = this.createRelationshipEntityMapper(relationshipClass, propertyMappers, idIndices, propertyMeta, inversePropertyMeta);
                this.entityMapperMap.put(joinMeta.getName(), remapper);
                baseEntityMapper.addRelationshipEntityMapper(remapper);
            }
            String lockHint = this.getLockHint(joinMeta.getName());
            this.jdbcManager.getDialect().setupJoin(this.fromClause, this.whereClause, joinMeta.getJoinType(), inverseEntityMeta.getTableMeta().getFullName(), tableAlias, fkTableAlias, pkTableAlias, joinColumnMetaList, lockHint, this.convertCriteria(joinMeta.getCondition()));
            if (StringUtil.isEmpty((String)joinMeta.getCondition())) break block7;
            Object[] params = joinMeta.getConditionParams();
            String[] propertyNames = joinMeta.getConditionPropertyNames();
            if (propertyNames == null) {
                for (Object param : params) {
                    this.addParam(param);
                }
            } else {
                for (int i = 0; i < params.length; ++i) {
                    this.prepareParams(propertyNames[i], params[i]);
                }
            }
        }
    }

    protected String[] splitBaseAndProperty(String name) {
        String[] ret = new String[2];
        int index = name.lastIndexOf(46);
        if (index < 0) {
            ret[1] = name;
        } else {
            ret[0] = name.substring(0, index);
            ret[1] = name.substring(index + 1);
        }
        return ret;
    }

    protected EntityMeta getBaseEntityMeta(String join, String base) throws BaseJoinNotFoundRuntimeException {
        EntityMeta baseEntityMeta = this.getEntityMeta(base);
        if (baseEntityMeta == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new BaseJoinNotFoundRuntimeException(this.entityName, join, base);
        }
        return baseEntityMeta;
    }

    protected AbstractEntityMapper getBaseEntityMapper(String join, String baseJoin) throws BaseJoinNotFoundRuntimeException {
        AbstractEntityMapper baseEntityMapper = this.getEntityMapper(baseJoin);
        if (baseEntityMapper == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new BaseJoinNotFoundRuntimeException(this.entityName, join, baseJoin);
        }
        return baseEntityMapper;
    }

    protected PropertyMeta getPropertyMeta(EntityMeta baseEntityMeta, String fullPropertyName, String propertyName) throws RuntimeException {
        PropertyMeta pm = null;
        try {
            pm = baseEntityMeta.getPropertyMeta(propertyName);
        }
        catch (RuntimeException e) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            this.logger.log("ESSR0708", new Object[]{this.entityName, fullPropertyName});
            throw e;
        }
        return pm;
    }

    protected EntityMeta getInverseEntityMeta(Class<?> relationshipClass, String join) throws RuntimeException, JoinDuplicatedRuntimeException {
        EntityMeta inverseEntityMeta = null;
        try {
            inverseEntityMeta = this.jdbcManager.getEntityMetaFactory().getEntityMeta(relationshipClass);
        }
        catch (RuntimeException e) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            this.logger.log("ESSR0710", new Object[]{this.entityName, join});
            throw e;
        }
        if (this.entityMetaMap.put(join, inverseEntityMeta) != null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new JoinDuplicatedRuntimeException(this.entityName, join);
        }
        return inverseEntityMeta;
    }

    protected PropertyMeta getInversePropertyMeta(EntityMeta inverseEntityMeta, PropertyMeta relationshipPropertyMeta) {
        if (relationshipPropertyMeta.getMappedBy() != null) {
            return inverseEntityMeta.getPropertyMeta(relationshipPropertyMeta.getMappedBy());
        }
        return inverseEntityMeta.getMappedByPropertyMeta(relationshipPropertyMeta.getName(), this.baseClass);
    }

    protected AbstractRelationshipEntityMapper createRelationshipEntityMapper(Class<?> relationshipClass, PropertyMapper[] propertyMappers, int[] idIndices, PropertyMeta propertyMeta, PropertyMeta inversePropertyMeta) {
        Field inverseField = inversePropertyMeta != null ? inversePropertyMeta.getField() : null;
        switch (propertyMeta.getRelationshipType()) {
            case ONE_TO_ONE: {
                return new OneToOneEntityMapperImpl(relationshipClass, propertyMappers, idIndices, propertyMeta.getField(), inverseField);
            }
            case ONE_TO_MANY: {
                return new OneToManyEntityMapperImpl(relationshipClass, propertyMappers, idIndices, propertyMeta.getField(), inverseField);
            }
            case MANY_TO_ONE: {
                return new ManyToOneEntityMapperImpl(relationshipClass, propertyMappers, idIndices, propertyMeta.getField(), inverseField);
            }
        }
        throw new IllegalStateException(propertyMeta.getRelationshipType().toString());
    }

    protected String toSql() {
        String hintComment = !StringUtil.isEmpty((String)this.hint) ? this.jdbcManager.getDialect().getHintComment(this.convertEntityNameToTableAlias(this.hint)) : "";
        StringBuilder sb = new StringBuilder(7 + hintComment.length() + this.selectClause.getLength() + this.fromClause.getLength() + this.whereClause.getLength() + this.orderByClause.getLength());
        return sb.append("select ").append(hintComment).append(this.selectClause.toSql()).append(this.fromClause.toSql()).append(this.whereClause.toSql()).append(this.orderByClause.toSql()).toString();
    }

    @Override
    public AutoSelect<T> where(String criteria, Object ... params) {
        if (criteria == null) {
            throw new NullPointerException("criteria");
        }
        this.criteria = criteria;
        if (params == null) {
            throw new NullPointerException("params");
        }
        for (Object o : params) {
            this.whereParams.add(o);
        }
        return this;
    }

    @Override
    public AutoSelect<T> where(Where where) {
        if (where == null) {
            throw new NullPointerException("where");
        }
        String criteria = where.getCriteria();
        if (StringUtil.isEmpty((String)criteria)) {
            return this;
        }
        this.criteria = criteria;
        this.criteriaParams = where.getParams();
        this.criteriaPropertyNames = where.getPropertyNames();
        return this;
    }

    @Override
    public AutoSelect<T> where(Where ... wheres) {
        if (wheres == null) {
            throw new NullPointerException("whereList");
        }
        if (wheres.length > 0) {
            ComplexWhere where = new ComplexWhere();
            for (Where w : wheres) {
                where.and(w);
            }
            String criteria = where.getCriteria().trim();
            if (StringUtil.isEmpty((String)criteria)) {
                return this;
            }
            this.criteria = criteria;
            this.criteriaParams = where.getParams();
            this.criteriaPropertyNames = where.getPropertyNames();
        }
        return this;
    }

    @Override
    public AutoSelect<T> where(Map<String, ? extends Object> conditions) {
        if (conditions == null) {
            throw new NullPointerException("conditions");
        }
        this.conditions = conditions;
        return this;
    }

    @Override
    public AutoSelect<T> id(Object ... idProperties) {
        if (idProperties == null) {
            throw new NullPointerException("idProperties");
        }
        EntityMeta entityMeta = this.jdbcManager.getEntityMetaFactory().getEntityMeta(this.baseClass);
        this.idPropertyMetaList = entityMeta.getIdPropertyMetaList();
        if (this.idPropertyMetaList.size() != idProperties.length) {
            throw new IllegalIdPropertySizeRuntimeException(entityMeta.getName(), this.idPropertyMetaList.size(), idProperties.length);
        }
        this.idProperties = idProperties;
        return this;
    }

    @Override
    public AutoSelect<T> version(Object versionProperty) {
        if (versionProperty == null) {
            throw new NullPointerException("versionProperty");
        }
        EntityMeta entityMeta = this.jdbcManager.getEntityMetaFactory().getEntityMeta(this.baseClass);
        if (!entityMeta.hasVersionPropertyMeta()) {
            throw new VersionPropertyNotExistsRuntimeException(entityMeta.getName());
        }
        this.versionPropertyMeta = entityMeta.getVersionPropertyMeta();
        this.versionProperty = versionProperty;
        return this;
    }

    protected void prepareWhere() {
        for (Object param : this.whereParams) {
            this.addParam(param);
        }
    }

    protected void prepareConditions() {
        if (this.conditions == null || this.conditions.size() == 0) {
            return;
        }
        WhereClause whereTerm = new WhereClause();
        for (Map.Entry<String, ? extends Object> e : this.conditions.entrySet()) {
            this.prepareCondition(whereTerm, e.getKey(), e.getValue());
        }
        this.whereClause.addAndSql("(");
        this.whereClause.addSql(whereTerm.toSql().substring(" where ".length()));
        this.whereClause.addSql(")");
    }

    protected void prepareCondition(WhereClause whereTerm, String name, Object value) {
        ConditionType conditionType = ConditionType.getConditionType(name);
        String pname = conditionType.removeSuffix(name);
        String[] names = this.splitBaseAndProperty(pname);
        String tableAlias = this.getTableAlias(names[0]);
        if (tableAlias == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            this.logger.log("ESSR0716", new Object[]{name});
            throw new BaseJoinNotFoundRuntimeException(this.entityName, pname, names[0]);
        }
        EntityMeta baseEntityMeta = this.getBaseEntityMeta(pname, names[0]);
        PropertyMeta propertyMeta = this.getPropertyMeta(baseEntityMeta, pname, names[1]);
        ColumnMeta columnMeta = propertyMeta.getColumnMeta();
        if (columnMeta == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            this.logger.log("ESSR0716", new Object[]{name});
            throw new EntityColumnNotFoundRuntimeException(this.entityName, propertyMeta.getName());
        }
        String columnName = columnMeta.getName();
        ArrayList<Object> valueList = CollectionsUtil.newArrayList();
        int size = conditionType.addCondition(tableAlias, columnName, value, whereTerm, valueList);
        for (int i = 0; i < size; ++i) {
            this.addParam(valueList.get(i), propertyMeta.getPropertyClass(), this.jdbcManager.getDialect().getValueType(propertyMeta));
        }
    }

    protected void prepareCriteria() {
        if (this.criteria == null) {
            return;
        }
        this.whereClause.addAndSql("(");
        this.whereClause.addSql(this.convertCriteria(this.criteria));
        this.whereClause.addSql(")");
    }

    protected void prepareIdVersion() {
        int i;
        if (this.idProperties == null) {
            if (this.versionProperty != null) {
                this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
                throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0758", null));
            }
            return;
        }
        SimpleWhere where = new SimpleWhere();
        for (i = 0; i < this.idProperties.length; ++i) {
            where.eq(this.idPropertyMetaList.get(i).getName(), this.idProperties[i]);
        }
        if (this.versionProperty != null) {
            where.eq(this.versionPropertyMeta.getName(), this.versionProperty);
        }
        this.whereClause.addSql(this.convertCriteria(where.getCriteria()));
        for (i = 0; i < this.idProperties.length; ++i) {
            this.prepareParams(this.idPropertyMetaList.get(i).getName(), this.idProperties[i]);
        }
        if (this.versionProperty != null) {
            this.prepareParams(this.versionPropertyMeta.getName(), this.versionProperty);
        }
    }

    protected void prepareParams() {
        for (int i = 0; i < this.criteriaParams.length; ++i) {
            String name = this.criteriaPropertyNames[i];
            Object value = this.criteriaParams[i];
            this.prepareParams(name, value);
        }
    }

    protected void prepareParams(String name, Object value) {
        String[] names = this.splitBaseAndProperty(name);
        EntityMeta entityMeta = this.getEntityMeta(names[0]);
        if (entityMeta == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            this.logger.log("ESSR0716", new Object[]{name});
            throw new BaseJoinNotFoundRuntimeException(this.entityName, name, names[0]);
        }
        if (!entityMeta.hasPropertyMeta(names[1])) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new PropertyNotFoundRuntimeException(this.entityName, name);
        }
        PropertyMeta pm = entityMeta.getPropertyMeta(names[1]);
        ValueType valueType = this.jdbcManager.getDialect().getValueType(pm);
        this.addParam(value, value.getClass(), valueType);
    }

    protected void prepareSql() {
        this.executedSql = this.convertLimitSql(this.toSql()) + this.forUpdate;
    }

    @Override
    protected ResultSetHandler createResultListResultSetHandler() {
        return new BeanListAutoResultSetHandler(this.getValueTypes(), this.getEntityMapper(), this.executedSql, this.limit);
    }

    @Override
    protected ResultSetHandler createSingleResultResultSetHandler() {
        if (this.count) {
            return new ObjectResultSetHandler(this.valueTypeList.get(0), this.executedSql);
        }
        return new BeanAutoResultSetHandler(this.getValueTypes(), this.getEntityMapper(), this.executedSql);
    }

    @Override
    protected ResultSetHandler createIterateResultSetHandler(IterationCallback<T, ?> callback) {
        return new BeanIterationAutoResultSetHandler(this.getValueTypes(), this.getEntityMapper(), this.executedSql, this.limit, callback);
    }

    protected EntityMapper getEntityMapper() {
        return (EntityMapper)((Object)this.getEntityMapper(null));
    }

    @Override
    public AutoSelect<T> orderBy(String orderBy) {
        if (orderBy == null) {
            throw new NullPointerException("orderBy");
        }
        this.orderBy = orderBy;
        return this;
    }

    @Override
    public AutoSelect<T> orderBy(OrderByItem ... orderByItems) {
        if (orderByItems == null) {
            throw new NullPointerException("orderByItems");
        }
        if (orderByItems.length > 0) {
            StringBuilder buf = new StringBuilder(20 * orderByItems.length);
            for (OrderByItem item : orderByItems) {
                buf.append(item.getCriteria()).append(", ");
            }
            buf.setLength(buf.length() - 2);
            this.orderBy = new String(buf);
        }
        return this;
    }

    protected void prepareOrderBy() {
        if (StringUtil.isEmpty((String)this.orderBy)) {
            return;
        }
        this.orderByClause.addSql(this.convertCriteria(this.orderBy, true));
    }

    protected String convertCriteria(String str) {
        return this.convertCriteria(str, false);
    }

    protected String convertCriteria(String str, boolean convertAlias) {
        if (StringUtil.isEmpty((String)str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(20 + str.length());
        QueryTokenizer tokenizer = new QueryTokenizer(str);
        int type = tokenizer.nextToken();
        while (type != -1) {
            String token = tokenizer.getToken();
            if (type == -2) {
                String[] names = this.splitBaseAndProperty(token);
                String tableAlias = this.getTableAlias(names[0]);
                EntityMeta entityMeta = this.getEntityMeta(names[0]);
                if (entityMeta == null || !entityMeta.hasPropertyMeta(names[1])) {
                    sb.append(token);
                } else {
                    String alias;
                    PropertyMeta pm = entityMeta.getPropertyMeta(names[1]);
                    String itemName = tableAlias + "." + pm.getColumnMeta().getName();
                    if (convertAlias && !StringUtil.isEmpty((String)(alias = this.selectClause.getColumnAlias(itemName)))) {
                        itemName = alias;
                    }
                    sb.append(itemName);
                }
            } else {
                sb.append(token);
            }
            type = tokenizer.nextToken();
        }
        return sb.toString();
    }

    protected String convertEntityNameToTableAlias(String str) {
        StringBuilder buf = new StringBuilder(20 + str.length());
        QueryTokenizer tokenizer = new QueryTokenizer(str);
        int type = tokenizer.nextToken();
        while (type != -1) {
            String token = tokenizer.getToken();
            if (type == -2) {
                String tableAlias = this.getTableAlias(token.equals(this.entityName) ? null : token);
                if (StringUtil.isEmpty((String)tableAlias)) {
                    buf.append(token);
                } else {
                    buf.append(tableAlias);
                }
            } else {
                buf.append(token);
            }
            type = tokenizer.nextToken();
        }
        return new String(buf);
    }

    @Override
    public AutoSelect<T> forUpdate() {
        DbmsDialect dialect = this.getJdbcManager().getDialect();
        if (!dialect.supportsForUpdate(SelectForUpdateType.NORMAL, false)) {
            EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
            throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0746", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
        }
        this.forUpdateType = SelectForUpdateType.NORMAL;
        return this;
    }

    @Override
    public AutoSelect<T> forUpdate(String ... propertyNames) {
        if (propertyNames == null) {
            throw new NullPointerException("properties");
        }
        if (propertyNames.length == 0) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new EmptyRuntimeException("properties");
        }
        DbmsDialect dialect = this.getJdbcManager().getDialect();
        if (!dialect.supportsForUpdate(SelectForUpdateType.NORMAL, true)) {
            EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
            throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0747", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
        }
        this.forUpdateType = SelectForUpdateType.NORMAL;
        this.setupForUpdateTargets(propertyNames);
        return this;
    }

    @Override
    public AutoSelect<T> forUpdateNowait() {
        DbmsDialect dialect = this.getJdbcManager().getDialect();
        if (!dialect.supportsForUpdate(SelectForUpdateType.NOWAIT, false)) {
            EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
            throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0748", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
        }
        this.forUpdateType = SelectForUpdateType.NOWAIT;
        return this;
    }

    @Override
    public AutoSelect<T> forUpdateNowait(String ... propertyNames) {
        if (propertyNames == null) {
            throw new NullPointerException("properties");
        }
        if (propertyNames.length == 0) {
            throw new EmptyRuntimeException("properties");
        }
        DbmsDialect dialect = this.getJdbcManager().getDialect();
        if (!dialect.supportsForUpdate(SelectForUpdateType.NOWAIT, true)) {
            EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
            throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0749", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
        }
        this.forUpdateType = SelectForUpdateType.NOWAIT;
        this.setupForUpdateTargets(propertyNames);
        return this;
    }

    @Override
    public AutoSelect<T> forUpdateWait(int seconds) {
        DbmsDialect dialect = this.getJdbcManager().getDialect();
        if (!dialect.supportsForUpdate(SelectForUpdateType.WAIT, false)) {
            EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
            throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0750", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
        }
        this.forUpdateType = SelectForUpdateType.WAIT;
        this.forUpdateWaitSeconds = seconds;
        return this;
    }

    @Override
    public AutoSelect<T> forUpdateWait(int seconds, String ... propertyNames) {
        if (propertyNames == null) {
            throw new NullPointerException("properties");
        }
        if (propertyNames.length == 0) {
            throw new EmptyRuntimeException("properties");
        }
        DbmsDialect dialect = this.getJdbcManager().getDialect();
        if (!dialect.supportsForUpdate(SelectForUpdateType.WAIT, true)) {
            EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
            throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0751", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
        }
        this.forUpdateType = SelectForUpdateType.WAIT;
        this.forUpdateWaitSeconds = seconds;
        this.setupForUpdateTargets(propertyNames);
        return this;
    }

    @Override
    public AutoSelect<T> hint(String hint) {
        this.hint = hint;
        return this;
    }

    protected void prepareForUpdate() {
        if (this.forUpdateType == null) {
            this.forUpdate = "";
            return;
        }
        if (this.limit > 0 || this.offset > 0) {
            throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0754", null));
        }
        DbmsDialect dialect = this.getJdbcManager().getDialect();
        for (JoinMeta joinMeta : this.joinMetaList) {
            switch (joinMeta.getJoinType()) {
                case INNER: {
                    if (dialect.supportsInnerJoinForUpdate()) break;
                    this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
                    EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
                    throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0763", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
                }
                case LEFT_OUTER: {
                    if (dialect.supportsOuterJoinForUpdate()) break;
                    this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
                    EntityMeta entityMeta = this.getJdbcManager().getEntityMetaFactory().getEntityMeta(this.baseClass);
                    throw new UnsupportedOperationException(MessageFormatter.getMessage((String)"ESSR0752", (Object[])new Object[]{entityMeta.getName(), dialect.getName()}));
                }
            }
        }
        int length = this.forUpdateTargets.size();
        Pair[] aliases = new Pair[length];
        int i = 0;
        for (Map.Entry<String, String> entry : this.forUpdateTargets.entrySet()) {
            aliases[i++] = this.toAliasPair(entry.getKey(), entry.getValue());
        }
        this.forUpdate = dialect.getForUpdateString(this.forUpdateType, this.forUpdateWaitSeconds, aliases);
    }

    protected String getLockHint(String baseName) {
        if (this.forUpdateType == null) {
            return "";
        }
        if (!this.forUpdateTargets.isEmpty() && !this.forUpdateTargets.containsKey(baseName)) {
            return "";
        }
        return this.jdbcManager.getDialect().getLockHintString(this.forUpdateType, this.forUpdateWaitSeconds);
    }

    protected void setupForUpdateTargets(String[] propertyNames) {
        for (String propertyName : propertyNames) {
            String[] names = this.splitBaseAndProperty(propertyName);
            this.forUpdateTargets.put(names[0], names[1]);
        }
    }

    protected Pair<String, String> toAliasPair(String baseName, String propertyName) {
        String tableAlias = this.getTableAlias(baseName);
        EntityMeta entityMeta = this.entityMetaMap.get(baseName);
        if (entityMeta == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            this.logger.log("ESSR0716", new Object[]{baseName});
            throw new BaseJoinNotFoundRuntimeException(this.entityName, baseName + "." + propertyName, baseName);
        }
        PropertyMeta propertyMeta = entityMeta.getPropertyMeta(propertyName);
        ColumnMeta columnMeta = propertyMeta.getColumnMeta();
        if (columnMeta == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new PropertyNotFoundRuntimeException(this.entityName, baseName == null ? propertyName : baseName + "." + propertyName);
        }
        String columnAlias = columnMeta.getName();
        return Pair.pair(tableAlias, columnAlias);
    }
}

