/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import jp.sourceforge.ea2ddl.dao.allcommon.bhv.BehaviorReadable;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFinder {
    protected static String _dbfluteDiconName = "dbflute.dicon";

    private BFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <BEHAVIOR_TYPE extends BehaviorReadable> BEHAVIOR_TYPE find(Class<BEHAVIOR_TYPE> behaviorType) {
        BFinder.assertObjectNotNull("behaviorType", behaviorType);
        if (!SingletonS2ContainerFactory.hasContainer()) {
            Class<BFinder> clazz = BFinder.class;
            // MONITORENTER : jp.sourceforge.ea2ddl.dao.allcommon.BFinder.class
            if (!SingletonS2ContainerFactory.hasContainer()) {
                String configFile = _dbfluteDiconName;
                if (!ResourceUtil.isExist((String)configFile)) {
                    String msg = "S2Container is not initialized! Confirm your initializer and your dicon files.";
                    throw new IllegalStateException(msg);
                }
                SingletonS2ContainerFactory.setConfigPath((String)configFile);
                SingletonS2ContainerFactory.init();
            }
            // MONITOREXIT : clazz
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        BehaviorReadable behavior = (BehaviorReadable)container.getComponent(behaviorType);
        return (BEHAVIOR_TYPE)behavior;
    }

    public static void setDBFluteDiconName(String dbfluteDiconName) {
        _dbfluteDiconName = dbfluteDiconName;
    }

    protected static void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        BFinder.assertObjectNotNull("variableName", variableName);
        BFinder.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }
}

