/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheAbstractSelector {
    protected S2Container _container;

    public <COMPONENT> COMPONENT getComponent(Class<COMPONENT> componentType) {
        this.assertObjectNotNull("componentType", componentType);
        this.assertObjectNotNull("_container", this._container);
        try {
            return (COMPONENT)this._container.getComponent(componentType);
        }
        catch (ComponentNotFoundRuntimeException e) {
            Object component;
            try {
                component = this._container.getRoot().getComponent(componentType);
            }
            catch (ComponentNotFoundRuntimeException ignored) {
                throw e;
            }
            this._container = this._container.getRoot();
            return (COMPONENT)component;
        }
    }

    public void destroy() {
        this._container = null;
    }

    protected String initUncap(String str) {
        return String.valueOf(str.substring(0, 1).toLowerCase()) + str.substring(1);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public void setContainer(S2Container container) {
        this._container = container;
    }
}

