/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import jp.sourceforge.ea2ddl.dao.allcommon.CacheAbstractSelector;
import jp.sourceforge.ea2ddl.dao.allcommon.DaoReadable;
import jp.sourceforge.ea2ddl.dao.allcommon.DaoSelector;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMetaInstanceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheDaoSelector
extends CacheAbstractSelector
implements DaoSelector {
    @Override
    public <DAO extends DaoReadable> DAO select(Class<DAO> daoType) {
        return (DAO)((DaoReadable)this.getComponent(daoType));
    }

    @Override
    public DaoReadable byName(String tableFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("tableFlexibleName", tableFlexibleName);
        DBMeta dbmeta = DBMetaInstanceHandler.findDBMeta(tableFlexibleName);
        return this.select(this.getDaoType(dbmeta));
    }

    protected Class<DaoReadable> getDaoType(DBMeta dbmeta) {
        Class<DaoReadable> daoType;
        String daoTypeName = dbmeta.getDaoTypeName();
        if (daoTypeName == null) {
            String msg = "The dbmeta.getDaoTypeName() should not return null: dbmeta=" + dbmeta;
            throw new IllegalStateException(msg);
        }
        try {
            daoType = Class.forName(daoTypeName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("The class does not exist: " + daoTypeName, e);
        }
        return daoType;
    }
}

