/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon;

import jp.sourceforge.ea2ddl.dao.allcommon.jdbc.StatementConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBFluteConfig {
    private static final Log _log = LogFactory.getLog(DBFluteConfig.class);
    private static final DBFluteConfig _instance = new DBFluteConfig();
    protected StatementConfig _defaultStatementConfig;
    protected boolean _conditionBeanFormatSql = true;
    protected boolean _queryLogLevelInfo;
    protected boolean _executeStatusLogLevelInfo;
    protected UniqueConstraintDeterminator _uniqueConstraintDeterminator;
    protected boolean _sqlExceptionOldStyleHandling = false;
    protected String _logDateFormat;
    protected String _logTimestampFormat;
    protected String _outsideSqlPackage;
    protected boolean _internalDebug;
    protected boolean _locked = true;

    private DBFluteConfig() {
    }

    public static DBFluteConfig getInstance() {
        return _instance;
    }

    public StatementConfig getDefaultStatementConfig() {
        return this._defaultStatementConfig;
    }

    public void setDefaultStatementConfig(StatementConfig defaultStatementConfig) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting defaultStatementConfig: " + defaultStatementConfig));
        }
        this._defaultStatementConfig = defaultStatementConfig;
    }

    public boolean isConditionBeanFormatSql() {
        return this._conditionBeanFormatSql;
    }

    public void setConditionBeanFormatSql(boolean conditionBeanFormatSql) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting conditionBeanFormatSql: " + conditionBeanFormatSql));
        }
        this._conditionBeanFormatSql = conditionBeanFormatSql;
    }

    public boolean isQueryLogLevelInfo() {
        return this._queryLogLevelInfo;
    }

    public void setQueryLogLevelInfo(boolean queryLogLevelInfo) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting queryLogLevelInfo: " + queryLogLevelInfo));
        }
        this._queryLogLevelInfo = queryLogLevelInfo;
    }

    public boolean isExecuteStatusLogLevelInfo() {
        return this._executeStatusLogLevelInfo;
    }

    public void setExecuteStatusLogLevelInfo(boolean executeStatusLogLevelInfo) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting executeStatusLogLevelInfo: " + executeStatusLogLevelInfo));
        }
        this._executeStatusLogLevelInfo = executeStatusLogLevelInfo;
    }

    public UniqueConstraintDeterminator getUniqueConstraintDeterminator() {
        return this._uniqueConstraintDeterminator;
    }

    public void setUniqueConstraintDeterminator(UniqueConstraintDeterminator uniqueConstraintDeterminator) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting uniqueConstraintDeterminator: " + uniqueConstraintDeterminator));
        }
        this._uniqueConstraintDeterminator = uniqueConstraintDeterminator;
    }

    public boolean isSqlExceptionOldStyleHandling() {
        return this._sqlExceptionOldStyleHandling;
    }

    public void setSqlExceptionOldStyleHandling(boolean sqlExceptionOldStyleHandling) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting sqlExceptionOldStyleHandling: " + sqlExceptionOldStyleHandling));
        }
        this._sqlExceptionOldStyleHandling = sqlExceptionOldStyleHandling;
    }

    public String getLogDateFormat() {
        return this._logDateFormat;
    }

    public void setLogDateFormat(String logDateFormat) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting logDateFormat: " + logDateFormat));
        }
        this._logDateFormat = logDateFormat;
    }

    public String getLogTimestampFormat() {
        return this._logTimestampFormat;
    }

    public void setLogTimestampFormat(String logTimestampFormat) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting logTimestampFormat: " + logTimestampFormat));
        }
        this._logTimestampFormat = logTimestampFormat;
    }

    public String getOutsideSqlPackage() {
        return this._outsideSqlPackage;
    }

    public void setOutsideSqlPackage(String outsideSqlPackage) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting outsideSqlPackage: " + outsideSqlPackage));
        }
        this._outsideSqlPackage = outsideSqlPackage;
    }

    public boolean isInternalDebug() {
        return this._internalDebug;
    }

    public void setInternalDebug(boolean internalDebug) {
        this.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("...Setting internalDebug: " + internalDebug));
        }
        this._internalDebug = internalDebug;
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void lock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Locking the config of dbflute!");
        }
        this._locked = true;
    }

    public void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"...Unlocking the config of dbflute!");
        }
        this._locked = false;
    }

    protected void assertNotLocked() {
        if (!this.isLocked()) {
            return;
        }
        String msg = "The config of dbflute is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    public void clear() {
        this._defaultStatementConfig = null;
        this._conditionBeanFormatSql = true;
        this._queryLogLevelInfo = false;
        this._executeStatusLogLevelInfo = false;
        this._logDateFormat = null;
        this._logTimestampFormat = null;
        this._internalDebug = false;
    }

    public static interface UniqueConstraintDeterminator {
        public boolean isUniqueConstraintException(Throwable var1);
    }
}

