/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.bhv;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.AbstractBehaviorReadable;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.BehaviorWritable;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.batch.TokenFileReflectionFailure;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.batch.TokenFileReflectionOption;
import jp.sourceforge.ea2ddl.dao.allcommon.bhv.batch.TokenFileReflectionResult;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityAlreadyDeletedException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityAlreadyUpdatedException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityDuplicatedException;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.MapStringBuilderImpl;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.FileTokenizingCallback;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.FileTokenizingHeaderInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.FileTokenizingOption;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.FileTokenizingRowResource;
import jp.sourceforge.ea2ddl.dao.allcommon.helper.token.file.impl.FileTokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBehaviorWritable
extends AbstractBehaviorReadable
implements BehaviorWritable {
    @Override
    public void create(Entity entity) {
        this.doCreate(entity);
    }

    protected abstract void doCreate(Entity var1);

    @Override
    public void modify(Entity entity) {
        this.doModify(entity);
    }

    protected abstract void doModify(Entity var1);

    @Override
    public void modifyNonstrict(Entity entity) {
        this.doModifyNonstrict(entity);
    }

    protected abstract void doModifyNonstrict(Entity var1);

    @Override
    public void createOrModify(Entity entity) {
        this.assertEntityNotNull(entity);
        this.doCreateOrUpdate(entity);
    }

    protected abstract void doCreateOrUpdate(Entity var1);

    @Override
    public void createOrModifyNonstrict(Entity entity) {
        this.assertEntityNotNull(entity);
        this.doCreateOrUpdateNonstrict(entity);
    }

    protected abstract void doCreateOrUpdateNonstrict(Entity var1);

    @Override
    public void remove(Entity entity) {
        this.assertEntityNotNull(entity);
        this.callRemove(entity);
    }

    protected abstract void doRemove(Entity var1);

    protected <ENTITY extends Entity> void helpUpdateInternally(ENTITY entity, InternalUpdateCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
        int updatedCount = callback.callbackDelegateUpdate(entity);
        if (updatedCount == 0) {
            String msg = "The entity was Not Found! it has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (updatedCount > 1) {
            String msg = "The entity was Too Many! it has been duplicated. It should be the only one! But the updatedCount=" + updatedCount;
            msg = String.valueOf(msg) + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    protected <ENTITY extends Entity> void helpUpdateNonstrictInternally(ENTITY entity, InternalUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int updatedCount = callback.callbackDelegateUpdateNonstrict(entity);
        if (updatedCount == 0) {
            String msg = "The entity was Not Found! it has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (updatedCount > 1) {
            String msg = "The entity was Too Many! it has been duplicated. It should be the only one! But the updatedCount=" + updatedCount;
            msg = String.valueOf(msg) + ": entity=" + entity;
        }
    }

    protected <ENTITY extends Entity, CB_TYPE extends ConditionBean> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateCallback<ENTITY, CB_TYPE> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            Object exception = null;
            try {
                callback.callbackUpdate(entity);
            }
            catch (EntityAlreadyUpdatedException e) {
                if (e.getRows() == 0) {
                    exception = e;
                }
            }
            catch (EntityAlreadyDeletedException e) {
                exception = e;
            }
            catch (OptimisticLockColumnValueNullException e) {
                exception = e;
            }
            if (exception != null) {
                CB_TYPE cb = callback.callbackNewMyConditionBean();
                cb.acceptPrimaryKeyMapString(this.getDBMeta().extractPrimaryKeyMapString(entity));
                if (callback.callbackSelectCount(cb) == 0) {
                    callback.callbackInsert(entity);
                } else {
                    throw exception;
                }
            }
        }
    }

    protected <ENTITY extends Entity> void helpInsertOrUpdateInternally(ENTITY entity, InternalInsertOrUpdateNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        if (!entity.hasPrimaryKeyValue()) {
            callback.callbackInsert(entity);
        } else {
            try {
                callback.callbackUpdateNonstrict(entity);
            }
            catch (EntityAlreadyUpdatedException e) {
                callback.callbackInsert(entity);
            }
            catch (EntityAlreadyDeletedException e) {
                callback.callbackInsert(entity);
            }
        }
    }

    protected <ENTITY extends Entity> void helpDeleteInternally(ENTITY entity, InternalDeleteCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        this.assertEntityHasVersionNoValue(entity);
        this.assertEntityHasUpdateDateValue(entity);
        int deletedCount = callback.callbackDelegateDelete(entity);
        if (deletedCount == 0) {
            String msg = "The entity was Not Found! The entity has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (deletedCount > 1) {
            String msg = "The deleted entity was duplicated. It should be the only one! But the deletedCount=" + deletedCount;
            msg = String.valueOf(msg) + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictInternally(ENTITY entity, InternalDeleteNonstrictCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            String msg = "The entity was Not Found! The entity has already been deleted: entity=" + entity;
            throw new EntityAlreadyDeletedException(msg);
        }
        if (deletedCount > 1) {
            String msg = "The deleted entity was duplicated. It should be the only one! But the deletedCount=" + deletedCount;
            msg = String.valueOf(msg) + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    protected <ENTITY extends Entity> void helpDeleteNonstrictIgnoreDeletedInternally(ENTITY entity, InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY> callback) {
        this.assertEntityNotNull(entity);
        int deletedCount = callback.callbackDelegateDeleteNonstrict(entity);
        if (deletedCount == 0) {
            return;
        }
        if (deletedCount > 1) {
            String msg = "The deleted entity was duplicated. It should be the only one! But the deletedCount=" + deletedCount;
            msg = String.valueOf(msg) + ": entity=" + entity;
            throw new EntityDuplicatedException(msg);
        }
    }

    @Override
    public int[] lumpCreate(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callCreateList(entityList);
    }

    @Override
    public int[] lumpModify(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callModifyList(entityList);
    }

    @Override
    public int[] lumpRemove(List<Entity> entityList) {
        this.assertListNotNullAndNotEmpty(entityList);
        return this.callRemoveList(entityList);
    }

    protected void injectSequenceToPrimaryKeyIfNeeds(Entity entity) {
        DBMeta dbmeta = entity.getDBMeta();
        if (!dbmeta.hasSequence() || dbmeta.hasTwoOrMorePrimaryKeys() || entity.hasPrimaryKeyValue()) {
            return;
        }
        BigDecimal sequenceValue = this.readNextVal();
        String columnDbName = dbmeta.getPrimaryUniqueInfo().getFirstColumn().getColumnDbName();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(columnDbName, sequenceValue.toString());
        dbmeta.acceptPrimaryKeyMap(entity, map);
    }

    public TokenFileReflectionExecutor tokenFileReflection() {
        return new TokenFileReflectionExecutor();
    }

    protected int callCreate(Entity entity) {
        if (!this.processBeforeInsert(entity)) {
            return 1;
        }
        return this.getDaoWritable().create(entity);
    }

    protected boolean processBeforeInsert(Entity entity) {
        if (!this.determineExecuteInsert(entity)) {
            return false;
        }
        this.assertEntityNotNull(entity);
        this.frameworkFilterEntityOfInsert(entity);
        this.filterEntityOfInsert(entity);
        this.assertEntityOfInsert(entity);
        return true;
    }

    protected int callModify(Entity entity) {
        if (!this.processBeforeUpdate(entity)) {
            return 1;
        }
        return this.getDaoWritable().modifyModifiedOnly(entity);
    }

    protected boolean processBeforeUpdate(Entity entity) {
        if (!this.determineExecuteUpdate(entity)) {
            return false;
        }
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfUpdate(entity);
        this.filterEntityOfUpdate(entity);
        this.assertEntityOfUpdate(entity);
        return true;
    }

    protected int callRemove(Entity entity) {
        if (!this.processBeforeDelete(entity)) {
            return 1;
        }
        return this.getDaoWritable().remove(entity);
    }

    protected boolean processBeforeDelete(Entity entity) {
        if (!this.determineExecuteDelete(entity)) {
            return false;
        }
        this.assertEntityNotNullAndHasPrimaryKeyValue(entity);
        this.frameworkFilterEntityOfDelete(entity);
        this.filterEntityOfDelete(entity);
        this.assertEntityOfDelete(entity);
        return true;
    }

    protected boolean determineExecuteInsert(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfInsert(Entity targetEntity) {
        this.injectSequenceToPrimaryKeyIfNeeds(targetEntity);
        this.setupCommonColumnOfInsertIfNeeds(targetEntity);
    }

    protected void setupCommonColumnOfInsertIfNeeds(Entity targetEntity) {
    }

    protected void filterEntityOfInsert(Entity targetEntity) {
    }

    protected void assertEntityOfInsert(Entity entity) {
    }

    protected boolean determineExecuteUpdate(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfUpdate(Entity targetEntity) {
        this.setupCommonColumnOfUpdateIfNeeds(targetEntity);
    }

    protected void setupCommonColumnOfUpdateIfNeeds(Entity targetEntity) {
    }

    protected void filterEntityOfUpdate(Entity targetEntity) {
    }

    protected void assertEntityOfUpdate(Entity entity) {
    }

    protected boolean determineExecuteDelete(Entity entity) {
        return true;
    }

    protected void frameworkFilterEntityOfDelete(Entity targetEntity) {
    }

    protected void filterEntityOfDelete(Entity targetEntity) {
    }

    protected void assertEntityOfDelete(Entity entity) {
    }

    public int[] callCreateList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeInsertInternally(entityList);
        return this.getDaoWritable().createList(entityList);
    }

    public int[] callModifyList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeUpdateInternally(entityList);
        return this.getDaoWritable().modifyList(entityList);
    }

    public int[] callRemoveList(List<Entity> entityList) {
        this.assertObjectNotNull("entityList", entityList);
        this.helpFilterBeforeDeleteInternally(entityList);
        return this.getDaoWritable().removeList(entityList);
    }

    protected void assertEntityHasVersionNoValue(Entity entity) {
        if (!this.getDBMeta().hasVersionNo()) {
            return;
        }
        if (this.hasVersionNoValue(entity)) {
            return;
        }
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The value of 'version no' on the entity was Not Found!" + this.getLineSeparator() + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm the existence of the value of 'version no' on the entity." + this.getLineSeparator();
        msg = String.valueOf(msg) + "You called the method in which the check for optimistic lock is indispensable. " + this.getLineSeparator();
        msg = String.valueOf(msg) + "So 'version no' is required on the entity. " + this.getLineSeparator();
        msg = String.valueOf(msg) + "In addition, please confirm the necessity of optimistic lock. It might possibly be unnecessary." + this.getLineSeparator() + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Entity]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "entity to string = " + entity + this.getLineSeparator();
        msg = String.valueOf(msg) + "entity to map    = " + entity.getDBMeta().convertToColumnValueMap(entity) + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */" + this.getLineSeparator();
        throw new OptimisticLockColumnValueNullException(msg);
    }

    protected void assertEntityHasUpdateDateValue(Entity entity) {
        if (!this.getDBMeta().hasUpdateDate()) {
            return;
        }
        if (this.hasUpdateDateValue(entity)) {
            return;
        }
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "The value of 'update date' on the entity was Not Found!" + this.getLineSeparator() + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm the existence of the value of 'update date' on the entity." + this.getLineSeparator();
        msg = String.valueOf(msg) + "You called the method in which the check for optimistic lock is indispensable. " + this.getLineSeparator();
        msg = String.valueOf(msg) + "So 'update date' is required on the entity. " + this.getLineSeparator();
        msg = String.valueOf(msg) + "In addition, please confirm the necessity of optimistic lock. It might possibly be unnecessary." + this.getLineSeparator() + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Entity]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "entity to string = " + entity + this.getLineSeparator();
        msg = String.valueOf(msg) + "entity to map    = " + entity.getDBMeta().convertToColumnValueMap(entity) + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */" + this.getLineSeparator();
        throw new OptimisticLockColumnValueNullException(msg);
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeInsertInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeInsert(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeUpdateInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeUpdate(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    protected <ENTITY extends Entity> List<ENTITY> helpFilterBeforeDeleteInternally(List<ENTITY> entityList) {
        ArrayList<Entity> filteredList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (!this.processBeforeDelete(entity)) continue;
            filteredList.add(entity);
        }
        return filteredList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteCallback<ENTITY extends Entity> {
        public int callbackDelegateDelete(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalDeleteNonstrictIgnoreDeletedCallback<ENTITY extends Entity> {
        public int callbackDelegateDeleteNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalInsertOrUpdateCallback<ENTITY extends Entity, CB_TYPE extends ConditionBean> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdate(ENTITY var1);

        public CB_TYPE callbackNewMyConditionBean();

        public int callbackSelectCount(CB_TYPE var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalInsertOrUpdateNonstrictCallback<ENTITY extends Entity> {
        public void callbackInsert(ENTITY var1);

        public void callbackUpdateNonstrict(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalUpdateCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdate(ENTITY var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InternalUpdateNonstrictCallback<ENTITY extends Entity> {
        public int callbackDelegateUpdateNonstrict(ENTITY var1);
    }

    public static class OptimisticLockColumnValueNullException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public OptimisticLockColumnValueNullException(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TokenFileReflectionExecutor {
        public TokenFileReflectionResult reflectTokenFile(String filename, TokenFileReflectionOption tokenFileReflectionOption) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("filename", filename);
            this.assertFileTokenReflectionOption(tokenFileReflectionOption);
            TokenFileReflectionResult result = this.buildTokenFileReflectionResult();
            FileTokenizingCallback fileTokenizingCallback = this.buildFileTokenReflectionFileTokenizingCallback(tokenFileReflectionOption, result);
            FileTokenizingOption fileTokenizingOption = this.buildFileTokenReflectionFileTokenizingOption(tokenFileReflectionOption);
            FileTokenImpl fileToken = new FileTokenImpl();
            fileToken.tokenize(filename, fileTokenizingCallback, fileTokenizingOption);
            return result;
        }

        public TokenFileReflectionResult reflectTokenFile(InputStream inputStream, TokenFileReflectionOption tokenFileReflectionOption) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertObjectNotNull("inputStream", inputStream);
            this.assertFileTokenReflectionOption(tokenFileReflectionOption);
            TokenFileReflectionResult result = this.buildTokenFileReflectionResult();
            FileTokenizingCallback fileTokenizingCallback = this.buildFileTokenReflectionFileTokenizingCallback(tokenFileReflectionOption, result);
            FileTokenizingOption fileTokenizingOption = this.buildFileTokenReflectionFileTokenizingOption(tokenFileReflectionOption);
            FileTokenImpl fileToken = new FileTokenImpl();
            fileToken.tokenize(inputStream, fileTokenizingCallback, fileTokenizingOption);
            return result;
        }

        protected void assertFileTokenReflectionOption(TokenFileReflectionOption tokenFileReflectionOption) {
            AbstractBehaviorWritable.this.assertObjectNotNull("tokenFileReflectionOption", tokenFileReflectionOption);
            String encoding = tokenFileReflectionOption.getEncoding();
            String delimiter = tokenFileReflectionOption.getDelimiter();
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            AbstractBehaviorWritable.this.assertObjectNotNull("delimiter", delimiter);
        }

        protected TokenFileReflectionResult buildTokenFileReflectionResult() {
            TokenFileReflectionResult result = new TokenFileReflectionResult();
            ArrayList<TokenFileReflectionFailure> failureList = new ArrayList<TokenFileReflectionFailure>();
            result.setFailureList(failureList);
            return result;
        }

        protected FileTokenizingCallback buildFileTokenReflectionFileTokenizingCallback(TokenFileReflectionOption tokenFileReflectionOption, final TokenFileReflectionResult result) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertObjectNotNull("tokenFileReflectionOption", tokenFileReflectionOption);
            String encoding = tokenFileReflectionOption.getEncoding();
            String delimiter = tokenFileReflectionOption.getDelimiter();
            final boolean interruptIfError = tokenFileReflectionOption.isInterruptIfError();
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            AbstractBehaviorWritable.this.assertObjectNotNull("delimiter", delimiter);
            final List<TokenFileReflectionFailure> failureList = result.getFailureList();
            AbstractBehaviorWritable.this.assertObjectNotNull("failureList", failureList);
            FileTokenizingCallback fileTokenizingCallback = new FileTokenizingCallback(){

                public void handleRowResource(FileTokenizingRowResource fileTokenizingRowResource) {
                    FileTokenizingHeaderInfo fileTokenizingHeaderInfo = fileTokenizingRowResource.getFileTokenizingHeaderInfo();
                    List<String> columnNameList = fileTokenizingHeaderInfo.getColumnNameList();
                    List<String> valueList = fileTokenizingRowResource.getValueList();
                    if (result.getColumnNameList() == null) {
                        result.setColumnNameList(columnNameList);
                    }
                    Entity entity = null;
                    try {
                        entity = TokenFileReflectionExecutor.this.createEntityByStringValueList(columnNameList, valueList);
                        AbstractBehaviorWritable.this.doCreateOrUpdateNonstrict(entity);
                        result.incrementSuccessCount();
                    }
                    catch (RuntimeException e) {
                        if (interruptIfError) {
                            throw e;
                        }
                        TokenFileReflectionFailure failure = new TokenFileReflectionFailure();
                        failure.setColumnNameList(columnNameList);
                        failure.setValueList(valueList);
                        failure.setRowString(fileTokenizingRowResource.getRowString());
                        failure.setRowNumber(fileTokenizingRowResource.getRowNumber());
                        failure.setLineNumber(fileTokenizingRowResource.getLineNumber());
                        if (entity != null) {
                            failure.setEntity(entity);
                        }
                        failure.setException(e);
                        failureList.add(failure);
                    }
                }
            };
            return fileTokenizingCallback;
        }

        protected Entity createEntityByStringValueList(List<String> columnNameList, List<String> valueList) {
            MapStringBuilderImpl builder = new MapStringBuilderImpl();
            builder.setMsMapMark("map:");
            builder.setMsStartBrace("@{");
            builder.setMsEndBrace("@}");
            builder.setMsDelimiter("@;");
            builder.setMsEqual("@=");
            builder.setColumnNameList(columnNameList);
            String mapString = builder.buildFromList(valueList);
            Entity entity = AbstractBehaviorWritable.this.getDBMeta().newEntity();
            AbstractBehaviorWritable.this.getDBMeta().acceptColumnValueMapString(entity, mapString);
            return entity;
        }

        protected FileTokenizingOption buildFileTokenReflectionFileTokenizingOption(TokenFileReflectionOption tokenFileReflectionOption) throws FileNotFoundException, IOException {
            AbstractBehaviorWritable.this.assertObjectNotNull("tokenFileReflectionOption", tokenFileReflectionOption);
            String encoding = tokenFileReflectionOption.getEncoding();
            String delimiter = tokenFileReflectionOption.getDelimiter();
            AbstractBehaviorWritable.this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
            AbstractBehaviorWritable.this.assertObjectNotNull("delimiter", delimiter);
            FileTokenizingOption fileTokenizingOption = new FileTokenizingOption();
            fileTokenizingOption.setEncoding(encoding);
            fileTokenizingOption.setDelimiter(delimiter);
            if (tokenFileReflectionOption.isHandleEmptyAsNull()) {
                fileTokenizingOption.handleEmptyAsNull();
            }
            return fileTokenizingOption;
        }
    }
}

