/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.DBFluteConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.SimplePagingBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.FromToOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.InScopeOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.LikeSearchOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.grouping.GroupingOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.grouping.GroupingRowEndDeterminer;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.grouping.GroupingRowResource;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.grouping.GroupingRowSetupper;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.PageNumberLink;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.PageNumberLinkSetupper;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClause;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseDb2;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseDefault;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseDerby;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseFirebird;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseH2;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseMySql;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseOracle;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClausePostgreSql;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause.SqlClauseSqlServer;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityAlreadyDeletedException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityDuplicatedException;
import jp.sourceforge.ea2ddl.dao.allcommon.jdbc.CursorHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlparser.InternalSqlParser;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionBeanContext {
    private static final Log _log = LogFactory.getLog(ConditionBeanContext.class);
    private static final ThreadLocal<ConditionBean> _threadLocal = new ThreadLocal();
    public static final String DB_NAME_DERBY = "derby";
    public static final String DB_NAME_H2 = "h2";
    public static final String DB_NAME_ORACLE = "oracle";
    public static final String DB_NAME_MYSQL = "mysql";
    public static final String DB_NAME_POSTGRESQL = "postgresql";
    public static final String DB_NAME_FIREBIRD = "firebird";
    public static final String DB_NAME_MSSQL = "mssql";
    public static final String DB_NAME_SYBASE = "sybase";
    public static final String DB_NAME_DB2 = "db2";
    protected static final Map<String, String> _driverHintDatabaseProductNameMap;
    private static String _databaseProductName;

    static {
        Map<String, String> tmpMap = Collections.synchronizedMap(new LinkedHashMap());
        tmpMap.put("org.apache.derby", DB_NAME_DERBY);
        tmpMap.put("org.h2", DB_NAME_H2);
        tmpMap.put(DB_NAME_ORACLE, DB_NAME_ORACLE);
        tmpMap.put(DB_NAME_MYSQL, DB_NAME_MYSQL);
        tmpMap.put(DB_NAME_POSTGRESQL, DB_NAME_POSTGRESQL);
        tmpMap.put(DB_NAME_FIREBIRD, DB_NAME_FIREBIRD);
        tmpMap.put("sqlserver", DB_NAME_MSSQL);
        tmpMap.put(DB_NAME_SYBASE, DB_NAME_SYBASE);
        tmpMap.put(DB_NAME_DB2, DB_NAME_DB2);
        _driverHintDatabaseProductNameMap = Collections.unmodifiableMap(tmpMap);
    }

    public static ConditionBean getConditionBeanOnThread() {
        return _threadLocal.get();
    }

    public static void setConditionBeanOnThread(ConditionBean cb) {
        if (cb == null) {
            String msg = "The argument[cb] must not be null.";
            throw new IllegalArgumentException(msg);
        }
        _threadLocal.set(cb);
    }

    public static boolean isExistConditionBeanOnThread() {
        return _threadLocal.get() != null;
    }

    public static void clearConditionBeanOnThread() {
        _threadLocal.set(null);
    }

    public static void initialize() {
        boolean debugEnabled = _log.isDebugEnabled();
        StringBuilder sb = new StringBuilder();
        Class clazz = SimplePagingBean.class;
        if (debugEnabled) {
            sb.append("  ...Loading class of " + clazz.getName() + " by " + clazz.getClassLoader().getClass()).append(ConditionBeanContext.getLineSeparator());
        }
        clazz = FromToOption.class;
        clazz = LikeSearchOption.class;
        clazz = InScopeOption.class;
        clazz = GroupingOption.class;
        clazz = GroupingRowEndDeterminer.class;
        clazz = GroupingRowResource.class;
        clazz = GroupingRowSetupper.class;
        clazz = PageNumberLink.class;
        clazz = PageNumberLinkSetupper.class;
        clazz = CursorHandler.class;
        if (debugEnabled) {
            sb.append("  ...Loading class of ...and so on");
        }
        if (debugEnabled) {
            _log.debug((Object)("{Initialize against the ClassLoader Headache}" + ConditionBeanContext.getLineSeparator() + sb));
        }
    }

    public static boolean isTheArgumentConditionBean(Object dtoInstance) {
        return dtoInstance instanceof ConditionBean;
    }

    public static boolean isTheTypeConditionBean(Class<?> dtoClass) {
        return ConditionBean.class.isAssignableFrom(dtoClass);
    }

    public static boolean setupDatabaseProductNameByDriverClassName(String driverClassName) {
        Set<String> keySet = _driverHintDatabaseProductNameMap.keySet();
        for (String driverHint : keySet) {
            if (driverClassName.indexOf(driverHint) < 0) continue;
            String databaseProductName = _driverHintDatabaseProductNameMap.get(driverHint);
            ConditionBeanContext.setDatabaseProductName(databaseProductName);
            return true;
        }
        return false;
    }

    public static String getDatabaseProductName() {
        return _databaseProductName;
    }

    public static void setDatabaseProductName(String name) {
        if (_databaseProductName != null) {
            String msg = "Already set up: current=" + _databaseProductName + " your=" + name;
            throw new IllegalStateException(msg);
        }
        _databaseProductName = name;
    }

    public static SqlClause createSqlClause(ConditionBean cb) {
        String tableSqlName = cb.getTableSqlName();
        SqlClause sqlClause = ConditionBeanContext.createSqlClause(tableSqlName);
        if (DBFluteConfig.getInstance().isConditionBeanFormatSql()) {
            sqlClause.makeFormatClauseEffective();
        }
        return sqlClause;
    }

    public static SqlClause createSqlClause(String tableDbName) {
        String databaseProductName = ConditionBeanContext.getDatabaseProductName();
        if (databaseProductName == null) {
            return new SqlClauseDefault(tableDbName);
        }
        String name = databaseProductName.toLowerCase();
        if (name.equalsIgnoreCase(DB_NAME_DERBY)) {
            return new SqlClauseDerby(tableDbName);
        }
        if (name.equalsIgnoreCase(DB_NAME_H2)) {
            return new SqlClauseH2(tableDbName);
        }
        if (name.equalsIgnoreCase(DB_NAME_ORACLE)) {
            return new SqlClauseOracle(tableDbName);
        }
        if (name.equalsIgnoreCase(DB_NAME_FIREBIRD)) {
            return new SqlClauseFirebird(tableDbName);
        }
        if (name.equalsIgnoreCase(DB_NAME_MYSQL)) {
            return new SqlClauseMySql(tableDbName);
        }
        if (name.equalsIgnoreCase(DB_NAME_POSTGRESQL)) {
            return new SqlClausePostgreSql(tableDbName);
        }
        if (name.equalsIgnoreCase(DB_NAME_MSSQL)) {
            return new SqlClauseSqlServer(tableDbName);
        }
        if (name.equalsIgnoreCase(DB_NAME_DB2)) {
            return new SqlClauseDb2(tableDbName);
        }
        return new SqlClauseDefault(tableDbName);
    }

    public static void throwEntityAlreadyDeletedException(Object searchKey4Log) {
        String msg = "Look! Read the message below." + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "The entity was Not Found! it has already been deleted!" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm the existence of your target record on your database." + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "Does the target record really created before this operation?" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "Has the target record been deleted by other thread?" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "It is precondition that the record exists on your database." + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + ConditionBeanContext.getLineSeparator();
        if (searchKey4Log != null && searchKey4Log instanceof ConditionBean) {
            ConditionBean cb = (ConditionBean)searchKey4Log;
            msg = String.valueOf(msg) + "[Executed SQL for Display]" + ConditionBeanContext.getLineSeparator() + cb.toDisplaySql() + ConditionBeanContext.getLineSeparator();
        } else {
            msg = String.valueOf(msg) + "[Search Condition]" + ConditionBeanContext.getLineSeparator() + searchKey4Log + ConditionBeanContext.getLineSeparator();
        }
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new EntityAlreadyDeletedException(msg);
    }

    public static void throwEntityDuplicatedException(String resultCountString, Object searchKey4Log, Throwable cause) {
        String msg = "Look! Read the message below." + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "The entity was Too Many! it has been duplicated. It should be the only one! But the resultCount=" + resultCountString + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm your search condition. Does it really select the only one?" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + "Please confirm your database. Does it really exist the only one?" + ConditionBeanContext.getLineSeparator();
        msg = String.valueOf(msg) + ConditionBeanContext.getLineSeparator();
        if (searchKey4Log != null && searchKey4Log instanceof ConditionBean) {
            ConditionBean cb = (ConditionBean)searchKey4Log;
            msg = String.valueOf(msg) + "[Executed SQL for Display]" + ConditionBeanContext.getLineSeparator() + cb.toDisplaySql() + ConditionBeanContext.getLineSeparator();
        } else {
            msg = String.valueOf(msg) + "[Search Condition]" + ConditionBeanContext.getLineSeparator() + searchKey4Log + ConditionBeanContext.getLineSeparator();
        }
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        if (cause != null) {
            throw new EntityDuplicatedException(msg, cause);
        }
        throw new EntityDuplicatedException(msg);
    }

    public static String convertConditionBean2DisplaySql(ConditionBean cb) {
        String twoWaySql = cb.isLimitSelect_PKOnly() ? cb.getSqlClause().getClausePKOnly() : cb.getSqlClause().getClause();
        return InternalSqlParser.convertTwoWaySql2DisplaySql(twoWaySql, cb);
    }

    public static boolean isUniqueConstraintException(String sqlState, Integer errorCode) {
        return ConditionBeanContext.createSqlClause("dummy").isUniqueConstraintException(sqlState, errorCode);
    }

    public static boolean isOracle() {
        return ConditionBeanContext.createSqlClause("dummy") instanceof SqlClauseOracle;
    }

    public static boolean isPostgreSql() {
        return ConditionBeanContext.createSqlClause("dummy") instanceof SqlClausePostgreSql;
    }

    protected static String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }
}

