/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean;

import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ListResultBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.mapping.EntityDtoMapper;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.group.PageGroupBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.group.PageGroupOption;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.range.PageRangeBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.pagenavi.range.PageRangeOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagingResultBean<ENTITY>
extends ListResultBean<ENTITY> {
    private static final long serialVersionUID = 1L;
    protected int _pageSize;
    protected int _currentPageNumber;
    protected PageGroupBean _pageGroupBean;
    protected PageGroupOption _pageGroupOption;
    protected PageRangeBean _pageRangeBean;
    protected PageRangeOption _pageRangeOption;

    public int getAllPageCount() {
        return this.calculateAllPageCount(this._allRecordCount, this._pageSize);
    }

    public int getCurrentStartRecordNumber() {
        return this.calculateCurrentStartRecordNumber(this._currentPageNumber, this._pageSize);
    }

    public int getCurrentEndRecordNumber() {
        return this.calculateCurrentEndRecordNumber(this._currentPageNumber, this._pageSize);
    }

    public int getPageGroupSize() {
        return this._pageGroupOption != null ? this._pageGroupOption.getPageGroupSize() : 0;
    }

    public void setPageGroupSize(int pageGroupSize) {
        PageGroupOption option = new PageGroupOption();
        option.setPageGroupSize(pageGroupSize);
        this.setPageGroupOption(option);
    }

    public void setPageGroupOption(PageGroupOption pageGroupOption) {
        this._pageGroupOption = pageGroupOption;
    }

    public PageGroupBean pageGroup() {
        this.assertPageGroupValid();
        if (this._pageGroupBean == null) {
            this._pageGroupBean = new PageGroupBean();
        }
        this._pageGroupBean.setPageGroupOption(this._pageGroupOption);
        this._pageGroupBean.setCurrentPageNumber(this.getCurrentPageNumber());
        this._pageGroupBean.setAllPageCount(this.getAllPageCount());
        return this._pageGroupBean;
    }

    protected void assertPageGroupValid() {
        if (this._pageGroupOption == null) {
            String msg = "The pageGroupOption should not be null. Please invoke setPageGroupOption().";
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 0) {
            String msg = "The pageGroupSize should be greater than 1. But the value is zero.";
            msg = String.valueOf(msg) + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 1) {
            String msg = "The pageGroupSize should be greater than 1. But the value is one.";
            msg = String.valueOf(msg) + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
    }

    public int getPageRangeSize() {
        return this._pageRangeOption != null ? this._pageRangeOption.getPageRangeSize() : 0;
    }

    public void setPageRangeSize(int pageRangeSize) {
        PageRangeOption option = new PageRangeOption();
        option.setPageRangeSize(pageRangeSize);
        this.setPageRangeOption(option);
    }

    public void setPageRangeOption(PageRangeOption pageRangeOption) {
        this._pageRangeOption = pageRangeOption;
    }

    public PageRangeBean pageRange() {
        this.assertPageRangeValid();
        if (this._pageRangeBean == null) {
            this._pageRangeBean = new PageRangeBean();
        }
        this._pageRangeBean.setPageRangeOption(this._pageRangeOption);
        this._pageRangeBean.setCurrentPageNumber(this.getCurrentPageNumber());
        this._pageRangeBean.setAllPageCount(this.getAllPageCount());
        return this._pageRangeBean;
    }

    protected void assertPageRangeValid() {
        if (this._pageRangeOption == null) {
            String msg = "The pageRangeOption should not be null. Please invoke setPageRangeOption().";
            throw new IllegalStateException(msg);
        }
        int pageRangeSize = this._pageRangeOption.getPageRangeSize();
        if (pageRangeSize == 0) {
            String msg = "The pageRangeSize should be greater than 1. But the value is zero.";
            throw new IllegalStateException(msg);
        }
    }

    public boolean isExistPrePage() {
        return this._allRecordCount > 0 && this._currentPageNumber > 1;
    }

    public boolean isExistNextPage() {
        return this._allRecordCount > 0 && this._currentPageNumber < this.getAllPageCount();
    }

    @Override
    public <DTO> PagingResultBean<DTO> mappingList(EntityDtoMapper<ENTITY, DTO> entityDtoMapper) {
        ListResultBean<DTO> ls = super.mappingList(entityDtoMapper);
        PagingResultBean<DTO> mappingList = new PagingResultBean<DTO>();
        mappingList.setSelectedList(ls.getSelectedList());
        mappingList.setTableDbName(this.getTableDbName());
        mappingList.setAllRecordCount(this.getAllRecordCount());
        mappingList.setOrderByClause(this.getOrderByClause());
        mappingList.setPageSize(this.getPageSize());
        mappingList.setCurrentPageNumber(this.getCurrentPageNumber());
        mappingList.setPageRangeOption(this._pageRangeOption);
        mappingList.setPageGroupOption(this._pageGroupOption);
        return mappingList;
    }

    protected int calculateAllPageCount(int allRecordCount, int pageSize) {
        if (allRecordCount == 0) {
            return 1;
        }
        int pageCountBase = allRecordCount / pageSize;
        if (allRecordCount % pageSize > 0) {
            ++pageCountBase;
        }
        return pageCountBase;
    }

    protected int calculateCurrentStartRecordNumber(int currentPageNumber, int pageSize) {
        return (currentPageNumber - 1) * pageSize + 1;
    }

    protected int calculateCurrentEndRecordNumber(int currentPageNumber, int pageSize) {
        return this.calculateCurrentStartRecordNumber(currentPageNumber, pageSize) + this._selectedList.size() - 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.getCurrentPageNumber()).append("/").append(this.getAllPageCount());
        sb.append(" of ").append(this.getAllRecordCount());
        sb.append(" ").append(this.isExistPrePage()).append("/").append(this.isExistNextPage());
        if (this._pageGroupOption != null) {
            sb.append(" group:{").append(this.getPageGroupSize()).append(",").append(this.pageGroup().createPageNumberList()).append("}");
        }
        if (this._pageRangeOption != null) {
            sb.append(" range:{").append(this.getPageRangeSize()).append(",").append(this._pageRangeOption.isFillLimit());
            sb.append(",").append(this.pageRange().createPageNumberList()).append("}");
        }
        sb.append(" list=").append(this.getSelectedList() != null ? Integer.valueOf(this.getSelectedList().size()) : null);
        sb.append(" page=").append(this.getPageSize());
        sb.append("}");
        sb.append(":selectedList=").append(this.getSelectedList());
        return sb.toString();
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public void setPageSize(int pageSize) {
        this._pageSize = pageSize;
    }

    public int getCurrentPageNumber() {
        return this._currentPageNumber;
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this._currentPageNumber = currentPageNumber;
    }
}

