/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.coption.parts;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class SplitOptionParts {
    protected String _split;
    protected String _splitContainedDelimiter;
    protected int _splitLimitCount;

    public boolean isSplit() {
        return this._split != null;
    }

    public void splitBySpace() {
        this._split = " ";
    }

    public void splitBySpace(int splitLimitCount) {
        this._split = " ";
        this._splitLimitCount = splitLimitCount;
    }

    public void splitBySpaceContainsDoubleByte() {
        this._split = " ";
        this._splitContainedDelimiter = "\u3000";
    }

    public void splitBySpaceContainsDoubleByte(int splitLimitCount) {
        this._split = " ";
        this._splitContainedDelimiter = "\u3000";
        this._splitLimitCount = splitLimitCount;
    }

    public void splitByPipeLine() {
        this._split = "|";
    }

    public void splitByPipeLine(int splitLimitCount) {
        this._split = "|";
        this._splitLimitCount = splitLimitCount;
    }

    public String[] generateSplitValueArray(String value) {
        if (value == null) {
            String msg = "The argument[value] should not be null of empty: " + value;
            throw new IllegalArgumentException(msg);
        }
        value = this.repalceContainedDelimiterToRealDelimiter(value);
        StringTokenizer st = new StringTokenizer(value, this._split);
        String[] tokenizedValues = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            tokenizedValues[count] = st.nextToken();
            ++count;
        }
        String[] values = this.removeInvalidValue(tokenizedValues);
        if (this._splitLimitCount > 0 && values.length > this._splitLimitCount) {
            String[] realValues = new String[this._splitLimitCount];
            int i = 0;
            while (i < values.length) {
                if (i == this._splitLimitCount) break;
                realValues[i] = values[i];
                ++i;
            }
            return realValues;
        }
        return values;
    }

    protected String repalceContainedDelimiterToRealDelimiter(String value) {
        if (value == null) {
            return value;
        }
        if (this._splitContainedDelimiter == null) {
            return value;
        }
        if (this._split == null) {
            return value;
        }
        return this.replace(value, this._splitContainedDelimiter, this._split);
    }

    protected String[] removeInvalidValue(String[] values) {
        ArrayList<String> ls = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            if (value != null && !value.equals("")) {
                ls.add(value);
            }
            ++i;
        }
        String[] resultArray = new String[ls.size()];
        int i2 = 0;
        while (i2 < ls.size()) {
            resultArray[i2] = (String)ls.get(i2);
            ++i2;
        }
        return resultArray;
    }

    protected final String replace(String text, String fromText, String toText) {
        if (text == null || fromText == null || toText == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(100);
        int pos = 0;
        int pos2 = 0;
        while (true) {
            if ((pos = text.indexOf(fromText, pos2)) == 0) {
                buf.append(toText);
                pos2 = fromText.length();
                continue;
            }
            if (pos <= 0) break;
            buf.append(text.substring(pos2, pos));
            buf.append(toText);
            pos2 = pos + fromText.length();
        }
        buf.append(text.substring(pos2));
        return buf.toString();
    }

    public Object createDeepCopy() {
        SplitOptionParts deepCopy = new SplitOptionParts();
        deepCopy._split = this._split;
        deepCopy._splitContainedDelimiter = this._splitContainedDelimiter;
        deepCopy._splitLimitCount = this._splitLimitCount;
        return deepCopy;
    }
}

