/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.cbean.sqlclause;

import java.util.HashSet;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ColumnInfo;

public interface WhereClauseSimpleFilter {
    public static final String BIND_COMMENT_BEGIN_PART = "/*dto";
    public static final String BIND_COMMENT_END_PART = "*/null";
    public static final String EMBEDDED_COMMENT_BEGIN_PART = "/*$dto";
    public static final String EMBEDDED_COMMENT_END_PART = "*/null";
    public static final String EMBEDDED_COMMENT_QUOTED_BEGIN_PART = "'/*$dto";
    public static final String EMBEDDED_COMMENT_QUOTED_END_PART = "*/'dummy''";

    public String filterClauseElement(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhereClauseToEmbeddedQuotedSimpleFilter
    extends WhereClauseToEmbeddedSimpleFilter {
        public WhereClauseToEmbeddedQuotedSimpleFilter(ColumnInfo filterTargetColumnInfo) {
            super(filterTargetColumnInfo);
        }

        public WhereClauseToEmbeddedQuotedSimpleFilter(Set<ColumnInfo> filterTargetColumnInfoSet) {
            super(filterTargetColumnInfoSet);
        }

        @Override
        protected String toEmbedded(String clauseElement) {
            clauseElement = this.replace(clauseElement, WhereClauseSimpleFilter.BIND_COMMENT_BEGIN_PART, WhereClauseSimpleFilter.EMBEDDED_COMMENT_QUOTED_BEGIN_PART);
            clauseElement = this.replace(clauseElement, "*/null", WhereClauseSimpleFilter.EMBEDDED_COMMENT_QUOTED_END_PART);
            return clauseElement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhereClauseToEmbeddedSimpleFilter
    implements WhereClauseSimpleFilter {
        protected Set<ColumnInfo> _filterTargetColumnInfoSet;

        public WhereClauseToEmbeddedSimpleFilter(ColumnInfo filterTargetColumnInfo) {
            this._filterTargetColumnInfoSet = new HashSet<ColumnInfo>();
            this._filterTargetColumnInfoSet.add(filterTargetColumnInfo);
        }

        public WhereClauseToEmbeddedSimpleFilter(Set<ColumnInfo> filterTargetColumnInfoSet) {
            this._filterTargetColumnInfoSet = filterTargetColumnInfoSet;
        }

        @Override
        public String filterClauseElement(String clauseElement) {
            if (this._filterTargetColumnInfoSet == null || this._filterTargetColumnInfoSet.isEmpty()) {
                return this.toEmbedded(clauseElement);
            }
            for (ColumnInfo columnInfo : this._filterTargetColumnInfoSet) {
                if (!this.isTargetClause(clauseElement, columnInfo.getColumnDbName())) continue;
                return this.toEmbedded(clauseElement);
            }
            return clauseElement;
        }

        protected boolean isTargetClause(String clauseElement, String columnDbName) {
            return clauseElement.indexOf("." + columnDbName + " ") >= 0;
        }

        protected String toEmbedded(String clauseElement) {
            clauseElement = this.replace(clauseElement, WhereClauseSimpleFilter.BIND_COMMENT_BEGIN_PART, WhereClauseSimpleFilter.EMBEDDED_COMMENT_BEGIN_PART);
            clauseElement = this.replace(clauseElement, "*/null", "*/null");
            return clauseElement;
        }

        protected final String replace(String text, String fromText, String toText) {
            if (text == null || fromText == null || toText == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer(100);
            int pos = 0;
            int pos2 = 0;
            while (true) {
                if ((pos = text.indexOf(fromText, pos2)) == 0) {
                    buf.append(toText);
                    pos2 = fromText.length();
                    continue;
                }
                if (pos <= 0) break;
                buf.append(text.substring(pos2, pos));
                buf.append(toText);
                pos2 = pos + fromText.length();
            }
            buf.append(text.substring(pos2));
            return buf.toString();
        }
    }
}

