/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.hierarchy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.hierarchy.HierarchyRequest;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.hierarchy.HierarchyRequestElement;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.hierarchy.HierarchySourceColumn;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.hierarchy.HierarchySourceIterator;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.hierarchy.HierarchySourceRow;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ColumnInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ForeignInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.ReferrerInfo;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info.RelationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyArranger<LOCAL_ENTITY extends Entity> {
    public List<LOCAL_ENTITY> arrangeHierarchy(HierarchyRequest<LOCAL_ENTITY> request) {
        ArrayList<Entity> localTableList = new ArrayList<Entity>();
        HashMap<String, Entity> alreadyRegisteredEntityMap = new HashMap<String, Entity>();
        HierarchySourceIterator sourceIterator = request.getSourceIterator();
        while (sourceIterator.hasNext()) {
            Entity localEntity;
            HierarchySourceRow sourceRow = sourceIterator.next();
            TopInfo<LOCAL_ENTITY> topInfo = new TopInfo<LOCAL_ENTITY>();
            topInfo.setHierarchyRequest(request);
            topInfo.setSourceRow(sourceRow);
            topInfo.setAlreadyRegisteredEntityMap(alreadyRegisteredEntityMap);
            Map<String, Object> primaryKeyMap = this.extractTopPrimaryKeyMapFromSource(topInfo);
            String alreadyRegisteredKey = this.buildTopAlreadyRegisteredKey(primaryKeyMap);
            if (alreadyRegisteredEntityMap.containsKey(alreadyRegisteredKey)) {
                localEntity = (Entity)alreadyRegisteredEntityMap.get(alreadyRegisteredKey);
                topInfo.setLocalEntity(localEntity);
            } else {
                localEntity = this.newLocalEntity(request.getDestinationDBMeta());
                topInfo.setLocalEntity(localEntity);
                localTableList.add(localEntity);
                alreadyRegisteredEntityMap.put(alreadyRegisteredKey, localEntity);
            }
            this.doColumnLoop(topInfo);
        }
        Set alreadyRegisteredEntityKeySet = alreadyRegisteredEntityMap.keySet();
        for (String key : alreadyRegisteredEntityKeySet) {
            Entity currentRegisteredEntity = (Entity)alreadyRegisteredEntityMap.get(key);
            currentRegisteredEntity.clearModifiedPropertyNames();
        }
        return localTableList;
    }

    protected String buildTopAlreadyRegisteredKey(Map<String, Object> primaryKeyMap) {
        return "$top$:" + primaryKeyMap;
    }

    protected void doColumnLoop(TopInfo<LOCAL_ENTITY> topInfo) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Entity localEntity = topInfo.getLocalEntity();
        List<HierarchyRequestElement> requestElementList = request.getRequestElementList();
        for (HierarchyRequestElement requestElement : requestElementList) {
            List<String> relationPropertyNameList = requestElement.getRelationPropertyNameList();
            if (relationPropertyNameList == null || relationPropertyNameList.isEmpty()) {
                HierarchySourceColumn sourceColumn = requestElement.getSourceColumnInfo();
                HierarchySourceRow sourceRow = topInfo.getSourceRow();
                Object sourceColumnValue = this.extractColumnValueFromSource(sourceRow, sourceColumn);
                ColumnInfo destinationColumnInfo = requestElement.getDestinationColumnInfo();
                this.injectColumnValueToDestinationIfNotNull(localEntity, destinationColumnInfo, sourceColumnValue);
                continue;
            }
            this.doRelationLoop(topInfo, requestElement, relationPropertyNameList);
        }
    }

    protected void doRelationLoop(TopInfo<LOCAL_ENTITY> topInfo, HierarchyRequestElement requestElement, List<String> relationPropNameList) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Map<String, Entity> alreadyRegisteredEntityMap = topInfo.getAlreadyRegisteredEntityMap();
        Entity localEntity = topInfo.getLocalEntity();
        DBMeta localDBMeta = request.getDestinationDBMeta();
        String localRelationPath = "$top$";
        StringBuilder relationPropKeyStringBuilder = new StringBuilder();
        int relationLoopCount = 0;
        for (String relationPropName : relationPropNameList) {
            String alreadyRegisteredEntityKey;
            Map<String, Object> targetPrimaryKeyMap;
            if (relationPropKeyStringBuilder.length() > 0) {
                relationPropKeyStringBuilder.append("_");
            }
            relationPropKeyStringBuilder.append(relationPropName);
            String targetRelationPath = relationPropKeyStringBuilder.toString();
            RelationInfo relationInfo = localDBMeta.findRelationInfo(relationPropName);
            if (!relationInfo.isReferrer()) {
                Entity foreignEntity;
                ForeignInfo foreignInfo = localDBMeta.findForeignInfo(relationPropName);
                String foreignPropName = foreignInfo.getForeignPropertyName();
                if (this.isNotExistPrimaryKey(topInfo, targetRelationPath)) break;
                targetPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, targetRelationPath);
                alreadyRegisteredEntityKey = String.valueOf(targetRelationPath) + ":" + targetPrimaryKeyMap.toString();
                if (!alreadyRegisteredEntityMap.containsKey(alreadyRegisteredEntityKey)) {
                    foreignEntity = foreignInfo.getForeignDBMeta().newEntity();
                    this.injectForeignEntity(localEntity, foreignPropName, foreignEntity);
                    this.injectForeignPrimaryKey(foreignEntity, targetPrimaryKeyMap);
                    this.injectLocalForeignKey(topInfo, localEntity, foreignInfo, targetRelationPath);
                    alreadyRegisteredEntityMap.put(alreadyRegisteredEntityKey.toString(), foreignEntity);
                } else {
                    foreignEntity = alreadyRegisteredEntityMap.get(alreadyRegisteredEntityKey);
                    this.injectForeignEntity(localEntity, foreignPropName, foreignEntity);
                }
            } else {
                ReferrerInfo referrerInfo = localDBMeta.findReferrerInfo(relationPropName);
                List<Entity> referrerList = this.extractReferrerList(localEntity, referrerInfo);
                if (referrerList == null) {
                    String msg = "The referrer list should not be null: localEntity=" + localEntity + " referrerInfo=" + referrerInfo;
                    throw new IllegalStateException(msg);
                }
                if (this.isNotExistPrimaryKey(topInfo, targetRelationPath)) break;
                targetPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, targetRelationPath);
                alreadyRegisteredEntityKey = String.valueOf(targetRelationPath) + ":" + targetPrimaryKeyMap.toString();
                if (!alreadyRegisteredEntityMap.containsKey(alreadyRegisteredEntityKey)) {
                    Entity referrerEntity = relationInfo.getTargetDBMeta().newEntity();
                    referrerList.add(referrerEntity);
                    this.injectReferrerPrimaryKey(referrerEntity, targetPrimaryKeyMap);
                    this.injectReferrerForeignKey(topInfo, referrerEntity, referrerInfo, localRelationPath);
                    alreadyRegisteredEntityMap.put(alreadyRegisteredEntityKey.toString(), referrerEntity);
                }
            }
            localEntity = alreadyRegisteredEntityMap.get(alreadyRegisteredEntityKey);
            localDBMeta = localEntity.getDBMeta();
            localRelationPath = targetRelationPath;
            if (relationLoopCount == relationPropNameList.size() - 1) {
                this.doLastLoopInjection(topInfo, requestElement, localEntity, targetPrimaryKeyMap);
            }
            ++relationLoopCount;
        }
    }

    protected boolean isNotExistPrimaryKey(TopInfo<LOCAL_ENTITY> topInfo, String relationPath) {
        Map<String, Object> primaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, relationPath);
        Set<String> keySet = primaryKeyMap.keySet();
        for (String key : keySet) {
            Object value = primaryKeyMap.get(key);
            if (value != null) continue;
            return true;
        }
        return false;
    }

    protected void doLastLoopInjection(TopInfo<LOCAL_ENTITY> topInfo, HierarchyRequestElement requestElement, Entity localEntity, Map<String, Object> primaryKeyMap) {
        HierarchySourceColumn sourceColumnInfo;
        HierarchySourceRow sourceRow;
        Object sourceColumnValue;
        ColumnInfo destinationColumnInfo = requestElement.getDestinationColumnInfo();
        if (!primaryKeyMap.containsKey(destinationColumnInfo.getColumnDbName()) && (sourceColumnValue = this.extractColumnValueFromSource(sourceRow = topInfo.getSourceRow(), sourceColumnInfo = requestElement.getSourceColumnInfo())) != null) {
            this.injectColumnValueToDestinationIfNotNull(localEntity, destinationColumnInfo, sourceColumnValue);
        }
    }

    protected Map<String, Object> extractTopPrimaryKeyMapFromSource(TopInfo<LOCAL_ENTITY> topInfo) {
        return this.extractPrimaryKeyMapFromSource(topInfo, "$top$");
    }

    protected Map<String, Object> extractPrimaryKeyMapFromSource(TopInfo<LOCAL_ENTITY> topInfo, String relationPath) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        HierarchySourceRow sourceRow = topInfo.getSourceRow();
        List<HierarchyRequestElement> primaryKeyElement = request.findPrimaryKeyElement(relationPath);
        LinkedHashMap<String, Object> primaryKeyMap = new LinkedHashMap<String, Object>();
        for (HierarchyRequestElement element : primaryKeyElement) {
            HierarchySourceColumn sourcePrimaryKey = element.getSourceColumnInfo();
            Object sourcePrimaryKeyValue = this.extractColumnValueFromSource(sourceRow, sourcePrimaryKey);
            primaryKeyMap.put(element.getDestinationColumnInfo().getColumnDbName(), sourcePrimaryKeyValue);
        }
        return primaryKeyMap;
    }

    protected Object extractColumnValueFromSource(HierarchySourceRow sourceRow, HierarchySourceColumn sourceColumn) {
        return sourceRow.extractColumnValue(sourceColumn);
    }

    protected List<Entity> extractReferrerList(Entity entity, ReferrerInfo referrerInfo) {
        return (List)this.invoke(referrerInfo.findGetter(), entity, new Object[0]);
    }

    protected void injectColumnValueToDestinationIfNotNull(Entity entity, ColumnInfo columnInfo, Object columnValue) {
        if (columnValue != null) {
            this.injectColumnValueToDestination(entity, columnInfo.getColumnDbName(), columnValue);
        }
    }

    protected void injectColumnValueToDestination(Entity entity, String columnDbName, Object columnValue) {
        if (columnValue == null) {
            String msg = "The argument[columnValue] should not be null: ";
            msg = String.valueOf(msg) + " table=" + entity.getTableDbName() + " column=" + columnDbName;
            throw new IllegalStateException(msg);
        }
        this.invoke(entity.getDBMeta().findColumnInfo(columnDbName).findSetter(), entity, new Object[]{columnValue});
    }

    protected void injectColumnValueMapToDestination(Entity entity, Map<String, Object> columnValueMap) {
        Set<String> columnNameSet = columnValueMap.keySet();
        for (String columnName : columnNameSet) {
            Object columnValue = columnValueMap.get(columnName);
            this.injectColumnValueToDestination(entity, columnName, columnValue);
        }
    }

    protected void injectForeignEntity(Entity entity, String foreignPropName, Entity foreignEntity) {
        String capPropReferrerName = this.initCap(foreignPropName);
        Method method = this.findMethod(entity.getClass(), "set" + capPropReferrerName, new Class[]{foreignEntity.getDBMeta().getEntityType()});
        this.invoke(method, entity, new Object[]{foreignEntity});
    }

    protected void injectReferrerList(Entity entity, ReferrerInfo referrerInfo, List<Entity> referrerList) {
        this.invoke(referrerInfo.findSetter(), entity, new Object[]{referrerList});
    }

    protected void injectForeignPrimaryKey(Entity foreignEntity, Map<String, Object> foreigPrimaryKeyMap) {
        this.injectColumnValueMapToDestination(foreignEntity, foreigPrimaryKeyMap);
    }

    protected void injectReferrerPrimaryKey(Entity referrerEntity, Map<String, Object> referrerPrimaryKeyMap) {
        this.injectColumnValueMapToDestination(referrerEntity, referrerPrimaryKeyMap);
    }

    protected void injectLocalForeignKey(TopInfo<LOCAL_ENTITY> topInfo, Entity localEntity, ForeignInfo foreignInfo, String foreignRelationPath) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Map<String, Object> foreignPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, foreignRelationPath);
        List<HierarchyRequestElement> primaryKeyElementList = request.findPrimaryKeyElement(foreignRelationPath);
        HashMap<String, Object> localForeignKeyMap = new HashMap<String, Object>();
        for (HierarchyRequestElement foreignElement : primaryKeyElementList) {
            String foreignPrimaryKeyColumnName = foreignElement.getDestinationColumnInfo().getColumnDbName();
            ColumnInfo localForeignKeyInfo = foreignInfo.findLocalByForeign(foreignPrimaryKeyColumnName);
            Object localForeignKeyValue = foreignPrimaryKeyMap.get(foreignPrimaryKeyColumnName);
            localForeignKeyMap.put(localForeignKeyInfo.getColumnDbName(), localForeignKeyValue);
        }
        this.injectColumnValueMapToDestination(localEntity, localForeignKeyMap);
    }

    protected void injectReferrerForeignKey(TopInfo<LOCAL_ENTITY> topInfo, Entity referrerEntity, ReferrerInfo referrerInfo, String localRelationPath) {
        HierarchyRequest<LOCAL_ENTITY> request = topInfo.getHierarchyRequest();
        Map<String, Object> localPrimaryKeyMap = this.extractPrimaryKeyMapFromSource(topInfo, localRelationPath);
        List<HierarchyRequestElement> primaryKeyElementList = request.findPrimaryKeyElement(localRelationPath);
        HashMap<String, Object> referrerForeignKeyMap = new HashMap<String, Object>();
        for (HierarchyRequestElement localElement : primaryKeyElementList) {
            String localPrimaryKeyName = localElement.getDestinationColumnInfo().getColumnDbName();
            ColumnInfo referrerForeignKeyInfo = referrerInfo.findReferrerByLocal(localPrimaryKeyName);
            Object referrerForeignKeyValue = localPrimaryKeyMap.get(localPrimaryKeyName);
            referrerForeignKeyMap.put(referrerForeignKeyInfo.getColumnDbName(), referrerForeignKeyValue);
        }
        this.injectColumnValueMapToDestination(referrerEntity, referrerForeignKeyMap);
    }

    protected LOCAL_ENTITY newLocalEntity(DBMeta destinationDBMeta) {
        Entity localEntity;
        try {
            localEntity = destinationDBMeta.getEntityType().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        return (LOCAL_ENTITY)localEntity;
    }

    protected String initCap(String name) {
        String capPropReferrerName = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return capPropReferrerName;
    }

    private Method findMethod(Class clazz, String methodName, Class[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    private Object invoke(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (RuntimeException e) {
            String lineSeparator = System.getProperty("line.separator");
            Class[] parameterTypes = method.getParameterTypes();
            String msg = "Invoking method threw the exception:" + lineSeparator;
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * *" + lineSeparator;
            msg = String.valueOf(msg) + "[" + method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()]" + lineSeparator;
            msg = String.valueOf(msg) + " methodArgTypes     = {" + this.createTypeViewFromTypeArray(parameterTypes) + "}" + lineSeparator;
            msg = String.valueOf(msg) + " specifiedArgValues = {" + this.createValueViewFromValueArray(args) + "}" + lineSeparator;
            msg = String.valueOf(msg) + " specifiedArgTypes  = {" + this.createTypeViewFromValueArray(args) + "}" + lineSeparator;
            if (parameterTypes.length > 0 && args.length > 0 && args[0] != null && !parameterTypes[0].equals(args[0].getClass())) {
                msg = String.valueOf(msg) + " " + lineSeparator;
                String compareString = "{" + parameterTypes[0] + " -- " + args[0].getClass() + "}";
                msg = String.valueOf(msg) + " *Warning! The argType is ummatched: " + compareString + lineSeparator;
            }
            msg = String.valueOf(msg) + "* * * * * * * * * */" + lineSeparator;
            throw new RuntimeException(msg, e);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            String msg = "target=" + target + " method=" + method + "-" + Arrays.asList(args);
            throw new RuntimeException(msg, ex);
        }
        catch (IllegalAccessException ex) {
            String msg = "target=" + target + " method=" + method + "-" + Arrays.asList(args);
            throw new RuntimeException(msg, ex);
        }
    }

    private String createValueViewFromValueArray(Object[] array) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            Object value = array[i];
            if (sb.length() == 0) {
                sb.append(value);
            } else {
                sb.append(", ").append(value);
            }
            ++i;
        }
        return sb.toString();
    }

    private String createTypeViewFromValueArray(Object[] array) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            String typeName;
            Object value = array[i];
            String string = typeName = value != null ? value.getClass().getSimpleName() : "null";
            if (sb.length() == 0) {
                sb.append(typeName);
            } else {
                sb.append(", ").append(typeName);
            }
            ++i;
        }
        return sb.toString();
    }

    private String createTypeViewFromTypeArray(Class[] array) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            Class type = array[i];
            if (sb.length() == 0) {
                sb.append(type.getSimpleName());
            } else {
                sb.append(", ").append(type.getSimpleName());
            }
            ++i;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TopInfo<LOCAL_ENTITY extends Entity> {
        private HierarchyRequest<LOCAL_ENTITY> hierarchyRequest;
        private HierarchySourceRow sourceRow;
        private Entity localEntity;
        private Map<String, Entity> alreadyRegisteredEntityMap;

        protected TopInfo() {
        }

        public HierarchySourceRow getSourceRow() {
            return this.sourceRow;
        }

        public void setSourceRow(HierarchySourceRow sourceRow) {
            this.sourceRow = sourceRow;
        }

        public Entity getLocalEntity() {
            return this.localEntity;
        }

        public void setLocalEntity(Entity localEntity) {
            this.localEntity = localEntity;
        }

        public Map<String, Entity> getAlreadyRegisteredEntityMap() {
            return this.alreadyRegisteredEntityMap;
        }

        public void setAlreadyRegisteredEntityMap(Map<String, Entity> alreadyRegisteredEntityMap) {
            this.alreadyRegisteredEntityMap = alreadyRegisteredEntityMap;
        }

        public HierarchyRequest<LOCAL_ENTITY> getHierarchyRequest() {
            return this.hierarchyRequest;
        }

        public void setHierarchyRequest(HierarchyRequest<LOCAL_ENTITY> hierarchyRequest) {
            this.hierarchyRequest = hierarchyRequest;
        }
    }
}

