/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.info;

import java.lang.reflect.Method;
import java.util.Arrays;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnInfo {
    protected DBMeta dbmeta;
    protected String columnDbName;
    protected String propertyName;
    protected Class<?> propertyType;
    protected boolean primary;
    protected Integer columnSize;
    protected Integer columnDecimalDigits;
    protected DBMeta.OptimisticLockType optimisticLockType;

    public ColumnInfo(DBMeta dbmeta, String columnDbName) {
        this(dbmeta, columnDbName, null, null, false, null, null);
    }

    public ColumnInfo(DBMeta dbmeta, String columnDbName, String propertyName, Class<?> propertyType, boolean primary, Integer columnSize) {
        this(dbmeta, columnDbName, propertyName, propertyType, primary, columnSize, null);
    }

    public ColumnInfo(DBMeta dbmeta, String columnDbName, String propertyName, Class<?> propertyType, boolean primary, Integer columnSize, Integer columnDecimalDigits) {
        this(dbmeta, columnDbName, propertyName, propertyType, primary, columnSize, columnDecimalDigits, DBMeta.OptimisticLockType.NONE);
    }

    public ColumnInfo(DBMeta dbmeta, String columnDbName, String propertyName, Class<?> propertyType, boolean primary, Integer columnSize, Integer columnDecimalDigits, DBMeta.OptimisticLockType optimisticLockType) {
        this.dbmeta = dbmeta;
        this.columnDbName = columnDbName;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
        this.primary = primary;
        this.columnSize = columnSize;
        this.columnDecimalDigits = columnDecimalDigits;
        this.optimisticLockType = optimisticLockType;
    }

    public String buildInitCapPropertyName() {
        return this.initCap(this.propertyName);
    }

    public Method findSetter() {
        return this.findMethod(this.dbmeta.getEntityType(), "set" + this.buildInitCapPropertyName(), new Class[]{this.propertyType});
    }

    public Method findGetter() {
        return this.findMethod(this.dbmeta.getEntityType(), "get" + this.buildInitCapPropertyName(), new Class[0]);
    }

    public boolean isOptimisticLock() {
        return this.isVersionNo() || this.isUpdateDate();
    }

    public boolean isVersionNo() {
        return DBMeta.OptimisticLockType.VERSION_NO == this.optimisticLockType;
    }

    public boolean isUpdateDate() {
        return DBMeta.OptimisticLockType.UPDATE_DATE == this.optimisticLockType;
    }

    protected String initCap(String name) {
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    protected Method findMethod(Class<?> clazz, String methodName, Class<?>[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            String msg = "class=" + clazz + " method=" + methodName + "-" + Arrays.asList(argTypes);
            throw new RuntimeException(msg, ex);
        }
    }

    public int hashCode() {
        return this.dbmeta.hashCode() + this.columnDbName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo target = (ColumnInfo)obj;
        if (this.dbmeta == null || target.getDBMeta() == null) {
            return false;
        }
        if (!this.dbmeta.equals(target.getDBMeta())) {
            return false;
        }
        if (this.columnDbName == null || target.getColumnDbName() == null) {
            return false;
        }
        return this.columnDbName.equals(target.getColumnDbName());
    }

    public String toString() {
        return String.valueOf(this.dbmeta.getTableDbName()) + "." + this.columnDbName;
    }

    public DBMeta getDBMeta() {
        return this.dbmeta;
    }

    public void setDBMeta(DBMeta dbmeta) {
        this.dbmeta = dbmeta;
    }

    public String getColumnDbName() {
        return this.columnDbName;
    }

    public void setColumnDbName(String columnDbName) {
        this.columnDbName = columnDbName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public Integer getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(Integer columnSize) {
        this.columnSize = columnSize;
    }

    public Integer getColumnDecimalDigits() {
        return this.columnDecimalDigits;
    }

    public void setColumnDecimalDigits(Integer columnDecimalDigits) {
        this.columnDecimalDigits = columnDecimalDigits;
    }
}

