/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.FetchNarrowingBean;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.DangerousResultSizeException;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicHandler;
import org.seasar.extension.jdbc.impl.ResultSetWrapper;

public class FetchNarrowingResultSetWrapper
extends ResultSetWrapper {
    protected ResultSet _resultSet;
    protected FetchNarrowingBean _fetchNarrowingBean;
    protected long _fetchCounter;
    protected long _requestCounter;
    protected boolean _offsetByCursorForcedly;
    protected boolean _limitByCursorForcedly;
    protected boolean _skipToCursorEnd;

    public FetchNarrowingResultSetWrapper(ResultSet resultSet, FetchNarrowingBean fetchNarrowingBean, boolean offsetByCursorForcedly, boolean limitByCursorForcedly) {
        super(resultSet);
        this._resultSet = resultSet;
        this._fetchNarrowingBean = fetchNarrowingBean;
        this._offsetByCursorForcedly = offsetByCursorForcedly;
        this._limitByCursorForcedly = limitByCursorForcedly;
        this.skip();
    }

    protected void skip() {
        if (!this.isAvailableSkipRecord()) {
            return;
        }
        int skipStartIndex = this.getFetchNarrowingSkipStartIndex();
        if (this.isScrollableCursor()) {
            try {
                if (skipStartIndex == 0) {
                    this._resultSet.beforeFirst();
                } else {
                    this._resultSet.absolute(skipStartIndex);
                }
                this._fetchCounter = this._resultSet.getRow();
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        } else {
            try {
                while (this._fetchCounter < (long)skipStartIndex) {
                    if (!this._resultSet.next()) {
                        this._skipToCursorEnd = true;
                        break;
                    }
                    ++this._fetchCounter;
                }
            }
            catch (SQLException e) {
                this.handleSQLException(e, null);
            }
        }
    }

    protected boolean isAvailableSkipRecord() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isOffsetByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingSkipStartIndexEffective();
    }

    public boolean next() throws SQLException {
        boolean hasNext = super.next();
        ++this._requestCounter;
        if (!this.isAvailableLimitLoopCount()) {
            this.checkSafetyResult(hasNext);
            return hasNext;
        }
        if (hasNext && this._fetchCounter < (long)(this.getFetchNarrowingSkipStartIndex() + this.getFetchNarrowingLoopCount())) {
            ++this._fetchCounter;
            this.checkSafetyResult(true);
            return true;
        }
        return false;
    }

    protected boolean isAvailableLimitLoopCount() {
        if (!this.isFetchNarrowingEffective()) {
            return false;
        }
        if (this.isLimitByCursorForcedly()) {
            return true;
        }
        return this.isFetchNarrowingLoopCountEffective();
    }

    protected void checkSafetyResult(boolean hasNext) {
        if (hasNext && this.getSafetyMaxResultSize() > 0 && this._requestCounter > (long)(this.getSafetyMaxResultSize() + 1)) {
            String msg = "You have already been in Danger Zone!";
            msg = String.valueOf(msg) + " Please confirm your query or data of table: safetyMaxResultSize=" + this.getSafetyMaxResultSize();
            throw new DangerousResultSizeException(msg, this.getSafetyMaxResultSize());
        }
    }

    protected boolean isFetchNarrowingEffective() {
        return this._fetchNarrowingBean.isFetchNarrowingEffective();
    }

    protected boolean isFetchNarrowingSkipStartIndexEffective() {
        return this._fetchNarrowingBean.isFetchNarrowingSkipStartIndexEffective();
    }

    protected boolean isFetchNarrowingLoopCountEffective() {
        return this._fetchNarrowingBean.isFetchNarrowingLoopCountEffective();
    }

    protected int getFetchNarrowingSkipStartIndex() {
        return this._fetchNarrowingBean.getFetchNarrowingSkipStartIndex();
    }

    protected int getFetchNarrowingLoopCount() {
        return this._fetchNarrowingBean.getFetchNarrowingLoopCount();
    }

    public int getSafetyMaxResultSize() {
        return this._fetchNarrowingBean.getSafetyMaxResultSize();
    }

    protected boolean isScrollableCursor() {
        try {
            return this._resultSet.getType() != 1003;
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return false;
        }
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        new InternalBasicHandler.SQLExceptionHandler().handleSQLException(e, statement);
    }

    public boolean isOffsetByCursorForcedly() {
        return this._offsetByCursorForcedly;
    }

    public boolean isLimitByCursorForcedly() {
        return this._limitByCursorForcedly;
    }

    public boolean isSkipToCursorEnd() {
        return this._skipToCursorEnd;
    }
}

