/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.sql.DatabaseMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.impl.BeanMetaDataFactoryImpl;
import org.seasar.dao.impl.BeanMetaDataImpl;

public class S2BeanMetaDataFactoryImpl
extends BeanMetaDataFactoryImpl {
    protected Map<Class<? extends Entity>, BeanMetaData> _metaMap = Collections.synchronizedMap(new HashMap());

    public BeanMetaData createBeanMetaData(Class beanClass) {
        BeanMetaData cachedMeta = this.findCachedMeta(beanClass);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(beanClass);
    }

    public BeanMetaData createBeanMetaData(Class beanClass, int relationNestLevel) {
        BeanMetaData cachedMeta = this.findCachedMeta(beanClass);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(beanClass, relationNestLevel);
    }

    public BeanMetaData createBeanMetaData(DatabaseMetaData dbMetaData, Class beanClass, int relationNestLevel) {
        BeanMetaData cachedMeta = this.findOrCreateCachedMetaIfNeeds(dbMetaData, beanClass, relationNestLevel);
        if (cachedMeta != null) {
            return cachedMeta;
        }
        return super.createBeanMetaData(dbMetaData, beanClass, relationNestLevel);
    }

    protected BeanMetaData findCachedMeta(Class beanClass) {
        BeanMetaData cachedMeta;
        if (this.isDBFluteEntity(beanClass) && (cachedMeta = this.getMetaFromCache(beanClass)) != null) {
            return cachedMeta;
        }
        return null;
    }

    protected BeanMetaData findOrCreateCachedMetaIfNeeds(DatabaseMetaData dbMetaData, Class beanClass, int relationNestLevel) {
        if (this.isDBFluteEntity(beanClass)) {
            BeanMetaData cachedMeta = this.getMetaFromCache(beanClass);
            if (cachedMeta != null) {
                return cachedMeta;
            }
            return super.createBeanMetaData(dbMetaData, beanClass, 0);
        }
        return null;
    }

    protected BeanMetaDataImpl createBeanMetaDataImpl() {
        return new BeanMetaDataImpl(){

            public void initialize() {
                BeanMetaData cachedMeta;
                Class myBeanClass = this.getBeanClass();
                if (S2BeanMetaDataFactoryImpl.this.isDBFluteEntity(myBeanClass) && (cachedMeta = S2BeanMetaDataFactoryImpl.this.getMetaFromCache(myBeanClass)) == null) {
                    S2BeanMetaDataFactoryImpl.this._metaMap.put(myBeanClass, (BeanMetaData)this);
                }
                super.initialize();
            }
        };
    }

    protected boolean isDBFluteEntity(Class beanClass) {
        return Entity.class.isAssignableFrom(beanClass);
    }

    protected BeanMetaData getMetaFromCache(Class beanClass) {
        return this._metaMap.get(beanClass);
    }

    protected int getLimitRelationNestLevel() {
        return 2;
    }
}

