/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.BehaviorSelector;
import jp.sourceforge.ea2ddl.dao.allcommon.Entity;
import jp.sourceforge.ea2ddl.dao.allcommon.annotation.OutsideSql;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.dbmeta.DBMeta;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.BatchEntityAlreadyUpdatedException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityAlreadyDeletedException;
import jp.sourceforge.ea2ddl.dao.allcommon.exception.EntityDuplicatedException;
import jp.sourceforge.ea2ddl.dao.allcommon.jdbc.CursorHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.S2BeanMetaDataFactoryImpl;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.S2DaoPropertyTypeFactoryBuilderExtension;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.S2DaoSelectDynamicCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.rshandler.InternalBeanArrayMetaDataResultSetHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.rshandler.InternalBeanListMetaDataResultSetHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalAbstractAutoStaticCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalDeleteAutoStaticCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalDeleteBatchAutoStaticCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalDeleteQueryAutoDynamicCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalInsertAutoDynamicCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalInsertBatchAutoStaticCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalProcedureCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalUpdateAutoDynamicCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalUpdateBatchAutoStaticCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalUpdateDynamicCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalUpdateModifiedOnlyCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalUpdateQueryAutoDynamicCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalDeleteBatchAutoHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalUpdateBatchAutoHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureMetaData;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalProcedureMetaDataFactory;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalRelationRowCreator;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.various.InternalRowCreator;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanEnhancer;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.RelationPropertyTypeFactoryBuilder;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.TableNaming;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.ResultSetHandlerFactoryImpl;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2DaoMetaDataExtension
extends DaoMetaDataImpl {
    private static final Log _log = LogFactory.getLog(S2DaoMetaDataExtension.class);
    protected BeanEnhancer beanEnhancer;
    protected AnnotationReaderFactory annotationReaderFactory;
    protected ColumnNaming columnNaming;
    protected PropertyTypeFactoryBuilder propertyTypeFactoryBuilder;
    protected RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder;
    protected TableNaming tableNaming;
    protected BehaviorSelector _behaviorSelector;
    protected Object _methodInitializationLockMonitor = new Object();
    protected boolean _internalDebug;

    public void initialize() {
        this.beanClass = this.daoAnnotationReader.getBeanClass();
        this.daoInterface = this.getDaoInterface(this.daoClass);
        this.daoBeanDesc = BeanDescFactory.getBeanDesc((Class)this.daoClass);
        Connection conn = this.getConnection();
        try {
            DatabaseMetaData dbMetaData = this.getMetaData(conn);
            this.dbms = DbmsManager.getDbms((String)this.getDatabaseProductName(dbMetaData));
        }
        finally {
            this.close(conn);
        }
        this.beanMetaData = this.beanMetaDataFactory.createBeanMetaData(this.daoInterface, this.beanClass);
        this.checkSingleRowUpdateForAll = this.daoAnnotationReader.isCheckSingleRowUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlCommand getSqlCommand(String methodName) throws MethodNotFoundRuntimeException {
        SqlCommand cmd = (SqlCommand)this.sqlCommands.get(methodName);
        if (cmd != null) {
            return cmd;
        }
        Object object = this._methodInitializationLockMonitor;
        synchronized (object) {
            cmd = (SqlCommand)this.sqlCommands.get(methodName);
            if (cmd != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"...Getting sqlCommand as cache because the previous thread have already initilized.");
                }
                return cmd;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("...Initializing sqlCommand for " + methodName + "()."));
            }
            cmd = this.initializeSqlCommand(methodName);
        }
        return cmd;
    }

    protected SqlCommand initializeSqlCommand(String methodName) throws MethodNotFoundRuntimeException {
        SqlCommand cmd;
        OutsideSqlContext outsideSqlContext;
        if (OutsideSqlContext.isExistOutsideSqlContextOnThread() && (outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread()) != null && outsideSqlContext.isSpecifiedOutsideSql()) {
            return this.initializeSpecifiedOutsideSqlCommand(methodName, outsideSqlContext);
        }
        Method[] methods = this.daoBeanDesc.getMethods(methodName);
        if (methods.length == 1 && MethodUtil.isAbstract((Method)methods[0])) {
            this.setupMethod(methods[0]);
        }
        if ((cmd = (SqlCommand)this.sqlCommands.get(methodName)) != null) {
            return cmd;
        }
        throw new MethodNotFoundRuntimeException(this.daoClass, methodName, null);
    }

    protected SqlCommand initializeSpecifiedOutsideSqlCommand(String sqlCommandKey, OutsideSqlContext outsideSqlContext) throws MethodNotFoundRuntimeException {
        SqlCommand cmd;
        Method[] methods = this.daoBeanDesc.getMethods(outsideSqlContext.getMethodName());
        if (methods.length == 1 && MethodUtil.isAbstract((Method)methods[0])) {
            Method method = methods[0];
            if (this.isOutsideSqlDaoMethodSelect(method)) {
                this.setupSpecifiedOutsideSqlSelectCommand(sqlCommandKey, method, outsideSqlContext);
            } else if (this.isOutsideSqlDaoMethodCall(method)) {
                this.setupSpecifiedOutsideSqlCallCommand(sqlCommandKey, method, outsideSqlContext);
            } else {
                this.setupSpecifiedOutsideSqlExecuteCommand(sqlCommandKey, method, outsideSqlContext);
            }
        }
        if ((cmd = (SqlCommand)this.sqlCommands.get(sqlCommandKey)) != null) {
            return cmd;
        }
        String msg = "Internal Error! The sql-command is not found:";
        msg = String.valueOf(msg) + " sqlCommandKey=" + sqlCommandKey;
        msg = String.valueOf(msg) + " sqlCommands=" + this.sqlCommands;
        throw new IllegalStateException(msg);
    }

    protected boolean isOutsideSqlDaoMethodSelect(Method method) {
        return method.getName().startsWith("select");
    }

    protected boolean isOutsideSqlDaoMethodCall(Method method) {
        return method.getName().startsWith("call");
    }

    protected void setupMethodByAnnotation(Class daoInterface, Method method) {
        String sql = this.daoAnnotationReader.getSQL(method, this.dbms.getSuffix());
        this.assertSQLAnnotationUnsupported(method, sql);
        super.setupMethodByAnnotation(daoInterface, method);
    }

    protected void assertSQLAnnotationUnsupported(Method method, String sql) {
        if (sql != null) {
            this.throwS2DaoSQLAnnotationUnsupportedException(method, sql);
        }
    }

    protected void throwS2DaoSQLAnnotationUnsupportedException(Method method, String sql) {
        String msg = "Look! Read the message below." + this.getLineSeparator();
        msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Sorry, the SQL annotation of S2Dao is unsupported on DBFlute!" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Advice]" + this.getLineSeparator();
        msg = String.valueOf(msg) + "Please use outside-sql of behavior." + this.getLineSeparator();
        msg = String.valueOf(msg) + "  For example:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "    memberBhv.outsideSql().selectList(...)" + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "If you've got to use it, you can set the property:" + this.getLineSeparator();
        msg = String.valueOf(msg) + "{torque.isCompatibleS2DaoSQLAnnotationValid = true}" + this.getLineSeparator();
        msg = String.valueOf(msg) + "But pay attention to version up of DBFlute" + this.getLineSeparator();
        msg = String.valueOf(msg) + " because the property will not always supported at the future." + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[Method]" + this.getLineSeparator() + method + this.getLineSeparator();
        msg = String.valueOf(msg) + this.getLineSeparator();
        msg = String.valueOf(msg) + "[SQL]" + this.getLineSeparator() + sql + this.getLineSeparator();
        msg = String.valueOf(msg) + "* * * * * * * * * */";
        throw new UnsupportedOperationException(msg);
    }

    protected void setupMethodByAuto(Method method) {
        OutsideSql outsideSql = method.getAnnotation(OutsideSql.class);
        if (outsideSql != null) {
            String msg = "This method '" + method.getName() + "()' should use Outside Sql but the file was not found!";
            msg = String.valueOf(msg) + " Expected sql file name is '" + method.getDeclaringClass().getSimpleName() + "_" + method.getName() + ".sql'";
            throw new IllegalStateException(msg);
        }
        super.setupMethodByAuto(method);
    }

    protected void setupSelectMethodByAuto(Method method) {
        if (this.setupInternalSelectMethodSequenceNextVal(method)) {
            return;
        }
        if (this.setupInternalSelectMethodEntityByIdsForBuri(method)) {
            return;
        }
        String query = this.daoAnnotationReader.getQuery(method);
        this.assertQueryAnnotationUnsupported(method, query);
        String[] argNames = this.daoAnnotationReader.getArgNames(method);
        this.assertAutoQueryByArgsAnnotationUnsupported(method, argNames);
        ResultSetHandler handler = this.createResultSetHandler(method);
        SqlCommand cmd = this.setupInternalNonQuerySelectMethodByDto(method, handler);
        this.putSqlCommand(method.getName(), cmd);
    }

    protected boolean setupInternalSelectMethodSequenceNextVal(Method method) {
        if (!"selectNextVal".equals(method.getName())) {
            return false;
        }
        DBMeta dbmeta = this.findDBMeta();
        if (!dbmeta.hasSequence()) {
            String msg = "If the method 'selectNextVal()' exists, DBMeta.hasSequence() should return true:";
            msg = String.valueOf(msg) + " dbmeta.hasSequence()=" + dbmeta.hasSequence() + " method=" + method;
            throw new IllegalStateException(msg);
        }
        String nextValSql = dbmeta.getSequenceNextValSql();
        if (nextValSql == null) {
            String msg = "If the method 'selectNextVal()' exists, DBMeta.getSequenceNextValSql() should not return null:";
            msg = String.valueOf(msg) + " dbmeta.getSequenceNextValSql()=" + dbmeta.getSequenceNextValSql() + " method=" + method;
            throw new IllegalStateException(msg);
        }
        this.setupSelectMethodByManual(method, nextValSql);
        return true;
    }

    protected boolean setupInternalSelectMethodEntityByIdsForBuri(Method method) {
        if (!"getEntityByIds".equals(method.getName())) {
            return false;
        }
        ResultSetHandler handler = this.createResultSetHandler(method);
        String[] argNames = this.daoAnnotationReader.getArgNames(method);
        String query = this.daoAnnotationReader.getQuery(method);
        if (query == null) {
            String msg = "The method 'getEntityByIds()' should have QUERY annotation:";
            msg = String.valueOf(msg) + " method=" + method;
            throw new IllegalStateException(msg);
        }
        Class[] types = method.getParameterTypes();
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(handler, query);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(types);
        this.putSqlCommand(method.getName(), (SqlCommand)cmd);
        return true;
    }

    protected void assertQueryAnnotationUnsupported(Method method, String query) {
        if (query != null) {
            String msg = "Sorry! The QUERY annotation of S2Dao is unsupported on DBFlute:";
            msg = String.valueOf(msg) + " query=" + query + " method=" + method;
            throw new UnsupportedOperationException(msg);
        }
    }

    protected void assertAutoQueryByArgsAnnotationUnsupported(Method method, String[] argNames) {
        if (!this.isAutoSelectSqlByDto(method, argNames)) {
            String msg = "Sorry! The auto query by ARGS annotation of S2Dao is unsupported on DBFlute:";
            msg = String.valueOf(msg) + " argNames=" + argNames + " method=" + method;
            throw new UnsupportedOperationException(msg);
        }
    }

    protected SqlCommand setupInternalNonQuerySelectMethodByDto(Method method, ResultSetHandler handler) {
        Class[] argTypes = method.getParameterTypes();
        this.assertAutoQueryByDtoUnsupported(method, argTypes);
        S2DaoSelectDynamicCommand cmd = this.createCustomizeSelectDynamicCommand(handler);
        cmd.setArgNames(new String[]{"dto"});
        cmd.setArgTypes(argTypes);
        return cmd;
    }

    protected void assertAutoQueryByDtoUnsupported(Method method, Class[] argTypes) {
        Class firstArgType = argTypes[0];
        if (!ConditionBeanContext.isTheTypeConditionBean(firstArgType)) {
            String msg = "Sorry! The auto query by DTO of S2Dao is unsupported on DBFlute:";
            msg = String.valueOf(msg) + " dto=" + firstArgType + " method=" + method;
            throw new UnsupportedOperationException(msg);
        }
    }

    protected void setupInsertMethodByAuto(Method method) {
        Object command;
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        if (this.isUpdateSignatureForBean(method)) {
            InternalInsertAutoDynamicCommand cmd = new InternalInsertAutoDynamicCommand();
            cmd.setBeanMetaData(this.getBeanMetaData());
            cmd.setDataSource(this.dataSource);
            cmd.setPropertyNames(propertyNames);
            cmd.setStatementFactory(this.statementFactory);
            cmd.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate(method));
            command = cmd;
        } else {
            InternalInsertBatchAutoStaticCommand cmd;
            boolean returningRows = false;
            if (int[].class.isAssignableFrom(method.getReturnType())) {
                returningRows = true;
            }
            command = cmd = new InternalInsertBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.getBeanMetaData(), propertyNames, returningRows);
        }
        this.putSqlCommand(method.getName(), (SqlCommand)command);
    }

    protected void setupUpdateMethodByAuto(Method method) {
        Object cmd;
        if (this.isFirstArgumentConditionBean(method)) {
            InternalUpdateQueryAutoDynamicCommand cmd2 = new InternalUpdateQueryAutoDynamicCommand(this.dataSource, this.statementFactory);
            this.putSqlCommand(method.getName(), cmd2);
            return;
        }
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        if (this.isUpdateSignatureForBean(method)) {
            cmd = this.isUnlessNull(method.getName()) ? this.createInternalUpdateAutoDynamicCommand(method, propertyNames) : (this.isModifiedOnly(method.getName()) ? this.createInternalUpdateModifiedOnlyCommand(method, propertyNames) : this.createInternalUpdateAutoStaticCommand(method, propertyNames));
        } else {
            boolean returningRows = false;
            if (int[].class.isAssignableFrom(method.getReturnType())) {
                returningRows = true;
            }
            cmd = this.createInternalUpdateBatchAutoStaticCommand(method, propertyNames, returningRows);
        }
        this.putSqlCommand(method.getName(), (SqlCommand)cmd);
    }

    protected UpdateAutoStaticCommand createInternalUpdateAutoStaticCommand(Method method, String[] propertyNames) {
        UpdateAutoStaticCommand cmd = new UpdateAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames);
        cmd.setCheckSingleRowUpdate(this.isCheckSingleRowUpdate(method));
        return cmd;
    }

    protected InternalUpdateAutoDynamicCommand createInternalUpdateAutoDynamicCommand(Method method, String[] propertyNames) {
        InternalUpdateAutoDynamicCommand cmd = this.newUpdateAutoDynamicCommand(method, this.dataSource, this.statementFactory);
        cmd.setBeanMetaData(this.createBeanMetaData4UpdateDeleteByAuto(method));
        cmd.setPropertyNames(propertyNames);
        cmd.setCheckSingleRowUpdate(!this.isNonstrictMethod(method));
        cmd.setVersionNoAutoIncrementOnMemory(this.isUpdateVersionNoAutoIncrementOnMemory(method));
        return cmd;
    }

    protected InternalUpdateAutoDynamicCommand newUpdateAutoDynamicCommand(Method method, DataSource ds, StatementFactory sf) {
        return new InternalUpdateAutoDynamicCommand(ds, sf);
    }

    protected InternalUpdateModifiedOnlyCommand createInternalUpdateModifiedOnlyCommand(Method method, String[] propertyNames) {
        InternalUpdateModifiedOnlyCommand cmd = this.newInternalUpdateModifiedOnlyCommand(method, this.dataSource, this.statementFactory);
        cmd.setBeanMetaData(this.createBeanMetaData4UpdateDeleteByAuto(method));
        cmd.setPropertyNames(propertyNames);
        cmd.setCheckSingleRowUpdate(!this.isNonstrictMethod(method));
        cmd.setVersionNoAutoIncrementOnMemory(this.isUpdateVersionNoAutoIncrementOnMemory(method));
        return cmd;
    }

    protected InternalUpdateModifiedOnlyCommand newInternalUpdateModifiedOnlyCommand(Method method, DataSource ds, StatementFactory sf) {
        return new InternalUpdateModifiedOnlyCommand(ds, sf);
    }

    protected InternalUpdateBatchAutoStaticCommand createInternalUpdateBatchAutoStaticCommand(final Method method, String[] propertyNames, boolean returningRows) {
        return new InternalUpdateBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.createBeanMetaData4UpdateDeleteByAuto(method), propertyNames, returningRows, this.isUpdateVersionNoAutoIncrementOnMemory(method)){

            protected InternalUpdateBatchAutoHandler newInternalBatchAutoHandler() {
                return new InternalUpdateBatchAutoHandler(this.getDataSource(), this.getStatementFactory(), this.getBeanMetaData(), this.getPropertyTypes()){

                    @Override
                    protected int[] executeBatch(PreparedStatement ps, List<?> list) {
                        int[] result = super.executeBatch(ps, list);
                        try {
                            S2DaoMetaDataExtension.this.handleBatchUpdateResultWithOptimisticLock(ps, list, result, method);
                        }
                        catch (SQLException e) {
                            this.handleSQLException(e, ps, false);
                            return null;
                        }
                        return result;
                    }
                };
            }
        };
    }

    protected void setupDeleteMethodByAuto(Method method) {
        InternalAbstractAutoStaticCommand cmd;
        if (this.isFirstArgumentConditionBean(method)) {
            InternalDeleteQueryAutoDynamicCommand cmd2 = new InternalDeleteQueryAutoDynamicCommand(this.dataSource, this.statementFactory);
            this.putSqlCommand(method.getName(), cmd2);
            return;
        }
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        if (this.isUpdateSignatureForBean(method)) {
            cmd = this.createInternalDeleteAutoStaticCommand(method, propertyNames);
        } else {
            boolean returningRows = false;
            if (int[].class.isAssignableFrom(method.getReturnType())) {
                returningRows = true;
            }
            cmd = this.createInternalDeleteBatchAutoStaticCommand(method, propertyNames, returningRows);
        }
        this.putSqlCommand(method.getName(), cmd);
    }

    protected InternalDeleteAutoStaticCommand createInternalDeleteAutoStaticCommand(Method method, String[] propertyNames) {
        InternalDeleteAutoStaticCommand cmd = new InternalDeleteAutoStaticCommand(this.dataSource, this.statementFactory, this.createBeanMetaData4UpdateDeleteByAuto(method), propertyNames);
        cmd.setCheckSingleRowUpdate(!this.isNonstrictMethod(method));
        return cmd;
    }

    protected InternalDeleteBatchAutoStaticCommand createInternalDeleteBatchAutoStaticCommand(final Method method, String[] propertyNames, boolean returningRows) {
        return new InternalDeleteBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.createBeanMetaData4UpdateDeleteByAuto(method), propertyNames, returningRows){

            protected InternalDeleteBatchAutoHandler newInternalBatchAutoHandler() {
                return new InternalDeleteBatchAutoHandler(this.getDataSource(), this.getStatementFactory(), this.getBeanMetaData(), this.getPropertyTypes()){

                    @Override
                    protected int[] executeBatch(PreparedStatement ps, List<?> list) {
                        int[] result = super.executeBatch(ps, list);
                        try {
                            S2DaoMetaDataExtension.this.handleBatchUpdateResultWithOptimisticLock(ps, list, result, method);
                        }
                        catch (SQLException e) {
                            this.handleSQLException(e, ps, false);
                            return null;
                        }
                        return result;
                    }
                };
            }
        };
    }

    protected BeanMetaData createBeanMetaData4UpdateDeleteByAuto(Method method) {
        if (this.isNonstrictMethod(method)) {
            return this.createNonConcurrencyBmdFactory().createBeanMetaData(this.getBeanClass());
        }
        return this.getBeanMetaData();
    }

    protected boolean isUpdateVersionNoAutoIncrementOnMemory(Method method) {
        return !this.isNonstrictMethod(method);
    }

    protected boolean isNonstrictMethod(Method method) {
        return method.getName().contains("Nonstrict");
    }

    protected BeanMetaDataFactory createNonConcurrencyBmdFactory() {
        S2BeanMetaDataFactoryImpl nonConcurrencyBmdFactory = new S2BeanMetaDataFactoryImpl(){

            protected BeanMetaDataImpl createBeanMetaDataImpl() {
                return new BeanMetaDataImpl(){

                    public boolean hasVersionNoPropertyType() {
                        return false;
                    }

                    public boolean hasTimestampPropertyType() {
                        return false;
                    }
                };
            }
        };
        nonConcurrencyBmdFactory.setAnnotationReaderFactory(this.annotationReaderFactory);
        nonConcurrencyBmdFactory.setPropertyTypeFactoryBuilder(this.propertyTypeFactoryBuilder);
        nonConcurrencyBmdFactory.setRelationPropertyTypeFactoryBuilder(this.relationPropertyTypeFactoryBuilder);
        nonConcurrencyBmdFactory.setTableNaming(this.tableNaming);
        nonConcurrencyBmdFactory.setDataSource(this.dataSource);
        nonConcurrencyBmdFactory.setDaoNamingConvention(this.daoNamingConvention);
        nonConcurrencyBmdFactory.setBeanEnhancer(this.beanEnhancer);
        return nonConcurrencyBmdFactory;
    }

    protected boolean isFirstArgumentConditionBean(Method method) {
        Class<?>[] pmbTypes = method.getParameterTypes();
        return pmbTypes.length > 0 && ConditionBean.class.isAssignableFrom(pmbTypes[0]);
    }

    protected void handleBatchUpdateResultWithOptimisticLock(PreparedStatement ps, List<?> list, int[] result, Method method) throws SQLException {
        if (ConditionBeanContext.isOracle()) {
            int updateCount = ps.getUpdateCount();
            this.handleBatchUpdateResultWithOptimisticLockByUpdateCount(list, updateCount, method);
        } else {
            this.handleBatchUpdateResultWithOptimisticLockByResult(list, result, method);
        }
    }

    protected void handleBatchUpdateResultWithOptimisticLockByUpdateCount(List<?> list, int updateCount, Method method) {
        if (list.isEmpty()) {
            return;
        }
        if (updateCount < 0) {
            return;
        }
        int entityCount = list.size();
        if (updateCount < entityCount) {
            if (this.isNonstrictMethod(method)) {
                String msg = "The entity have already deleted:";
                msg = String.valueOf(msg) + " updateCount=" + updateCount;
                msg = String.valueOf(msg) + " entityCount=" + entityCount;
                msg = String.valueOf(msg) + " allEntities=" + list;
                throw new EntityAlreadyDeletedException(msg);
            }
            throw new BatchEntityAlreadyUpdatedException(list.get(0), 0, updateCount);
        }
    }

    protected void handleBatchUpdateResultWithOptimisticLockByResult(List<?> list, Object result, Method method) {
        if (list.isEmpty()) {
            return;
        }
        if (!(result instanceof int[])) {
            return;
        }
        int[] updatedCountArray = (int[])result;
        int entityCount = list.size();
        int index = 0;
        boolean alreadyUpdated = false;
        int[] nArray = updatedCountArray;
        int n = updatedCountArray.length;
        int n2 = 0;
        while (n2 < n) {
            int oneUpdateCount = nArray[n2];
            if (entityCount <= index) break;
            if (oneUpdateCount == 0) {
                alreadyUpdated = true;
                break;
            }
            if (oneUpdateCount > 1) {
                String msg = "The entity updated two or more records in batch update:";
                msg = String.valueOf(msg) + " entity=" + list.get(index);
                msg = String.valueOf(msg) + " updatedCount=" + oneUpdateCount;
                msg = String.valueOf(msg) + " allEntities=" + list;
                throw new EntityDuplicatedException(msg);
            }
            ++index;
            ++n2;
        }
        if (alreadyUpdated) {
            int updateCount = 0;
            int[] nArray2 = updatedCountArray;
            int n3 = updatedCountArray.length;
            n = 0;
            while (n < n3) {
                int oneUpdateCount = nArray2[n];
                updateCount += oneUpdateCount;
                ++n;
            }
            if (this.isNonstrictMethod(method)) {
                String msg = "The entity have already deleted:";
                msg = String.valueOf(msg) + " entity=" + list.get(index);
                msg = String.valueOf(msg) + " updateCount=" + updateCount;
                msg = String.valueOf(msg) + " allEntities=" + list;
                throw new EntityAlreadyDeletedException(msg);
            }
            throw new BatchEntityAlreadyUpdatedException(list.get(index), 0, updateCount);
        }
    }

    protected void setupSelectMethodByManual(Method method, String sql) {
        Class[] argTypes;
        Class[] pmbTypes = method.getParameterTypes();
        String[] argNames = this.daoAnnotationReader.getArgNames(method);
        if (pmbTypes != null && pmbTypes.length > 0 && CursorHandler.class.isAssignableFrom(pmbTypes[pmbTypes.length - 1])) {
            argTypes = new Class[pmbTypes.length - 1];
            int i = 0;
            while (i < pmbTypes.length - 1) {
                argTypes[i] = pmbTypes[i];
                ++i;
            }
        } else {
            argTypes = pmbTypes;
        }
        BeanMetaData myBeanMetaData = this.getOutsideSqlBeanMetaData(method);
        this.registerSqlCommand(method.getName(), method, sql, argNames, argTypes, myBeanMetaData);
    }

    protected BeanMetaData getOutsideSqlBeanMetaData(Method method) {
        Class beanClass4SelectMethodByManual = this.getOutsideSqlDefaultBeanClass(method);
        if (beanClass4SelectMethodByManual.equals(this.getBeanClass())) {
            return this.getBeanMetaData();
        }
        return this.createOutsideSqlCustomizeBeanMetaDataFactory().createBeanMetaData(this.getOutsideSqlDefaultBeanClass(method));
    }

    protected void setupUpdateMethodByManual(Method method, String sql) {
        super.setupUpdateMethodByManual(method, sql);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupSpecifiedOutsideSqlSelectCommand(String sqlCommandKey, Method method, OutsideSqlContext outsideSqlContext) {
        ResultSetHandler myResultSetHandler;
        Class[] classArray;
        String[] argNames;
        String[] stringArray;
        String sql = outsideSqlContext.readFilteredOutsideSql(this.getSqlFileEncoding(), this.dbms.getSuffix());
        Object pmb = outsideSqlContext.getParameterBean();
        Object resultTypeSpecification = outsideSqlContext.getResultTypeSpecification();
        if (pmb != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "pmb";
        } else {
            stringArray = argNames = new String[]{};
        }
        if (pmb != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = pmb.getClass();
        } else {
            classArray = new Class[]{};
        }
        Class[] argTypes = classArray;
        Class<?> lastestArguementType = method.getParameterTypes()[method.getParameterTypes().length - 1];
        if (Class.class.isAssignableFrom(lastestArguementType)) {
            Class customizeEntityType = (Class)resultTypeSpecification;
            BeanMetaData myBeanMetaData = this.createSpecifiedOutsideSqlCustomizeBeanMetaData(customizeEntityType);
            if (!List.class.isAssignableFrom(method.getReturnType())) throw new UnsupportedOperationException("The return type of method is unsupported: method.getReturnType()=" + method.getReturnType());
            myResultSetHandler = this.createSpecifiedOutsideSqlCustomizeBeanListResultSetHandler(myBeanMetaData, customizeEntityType);
        } else if (CursorHandler.class.isAssignableFrom(lastestArguementType)) {
            BeanMetaData myBeanMetaData = this.createSpecifiedOutsideSqlCursorBeanMetaData(method);
            myResultSetHandler = this.createSpecifiedOutsideSqlCursorResultSetHandler(myBeanMetaData);
        } else {
            String msg = "The lastestArguementType is unsupported:";
            msg = String.valueOf(msg) + " lastestArguementType=" + lastestArguementType;
            msg = String.valueOf(msg) + " method=" + method;
            throw new IllegalStateException(msg);
        }
        this.registerSqlCommand(sqlCommandKey, method, sql, argNames, argTypes, myResultSetHandler);
    }

    protected BeanMetaData createSpecifiedOutsideSqlCustomizeBeanMetaData(Class clazz) {
        return this.createOutsideSqlCustomizeBeanMetaDataFactory().createBeanMetaData(clazz);
    }

    protected ResultSetHandler createSpecifiedOutsideSqlCustomizeBeanListResultSetHandler(BeanMetaData specifiedBeanMetaData, Class<?> customizeEntityType) {
        ValueType valueType = ValueTypes.getValueType(customizeEntityType);
        if (valueType == null || !valueType.equals(ValueTypes.OBJECT)) {
            return new InternalObjectListResultSetHandler(valueType);
        }
        InternalRowCreator rowCreator = this.createSpecifiedOutsideSqlInternalRowCreator(specifiedBeanMetaData);
        InternalRelationRowCreator relationRowCreator = this.createSpecifiedOutsideSqlInternalRelationRowCreator(specifiedBeanMetaData);
        return new InternalBeanListMetaDataResultSetHandler(specifiedBeanMetaData, (RowCreator)rowCreator, (RelationRowCreator)relationRowCreator);
    }

    protected InternalRowCreator createSpecifiedOutsideSqlInternalRowCreator(BeanMetaData bmd) {
        Class clazz = bmd.getBeanClass();
        return InternalRowCreator.createInternalRowCreator(clazz);
    }

    protected InternalRelationRowCreator createSpecifiedOutsideSqlInternalRelationRowCreator(BeanMetaData bmd) {
        return new InternalRelationRowCreator();
    }

    protected BeanMetaData createSpecifiedOutsideSqlCursorBeanMetaData(Method method) {
        return this.createOutsideSqlCustomizeBeanMetaDataFactory().createBeanMetaData(this.getOutsideSqlDefaultBeanClass(method));
    }

    protected ResultSetHandler createSpecifiedOutsideSqlCursorResultSetHandler(BeanMetaData specifiedBeanMetaData) {
        return new ObjectResultSetHandler();
    }

    protected void setupSpecifiedOutsideSqlExecuteCommand(String sqlCommandKey, Method method, OutsideSqlContext outsideSqlContext) {
        Class[] classArray;
        String[] argNames;
        String[] stringArray;
        String sql = outsideSqlContext.readFilteredOutsideSql(this.getSqlFileEncoding(), this.dbms.getSuffix());
        Object pmb = outsideSqlContext.getParameterBean();
        if (pmb != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "pmb";
        } else {
            stringArray = argNames = new String[]{};
        }
        if (pmb != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = pmb.getClass();
        } else {
            classArray = new Class[]{};
        }
        Class[] argTypes = classArray;
        InternalUpdateDynamicCommand cmd = new InternalUpdateDynamicCommand(this.dataSource, this.statementFactory){

            public Object execute(Object[] args) {
                if (args.length != 3) {
                    String msg = "Internal Error! OutsideSqlDao.execute() should have 3 arguements: args.length=" + args.length;
                    throw new IllegalStateException(msg);
                }
                Object arg = args[1];
                return super.execute(new Object[]{arg});
            }
        };
        this.registerSqlCommand(sqlCommandKey, method, sql, argNames, argTypes, cmd);
    }

    protected void setupSpecifiedOutsideSqlCallCommand(String sqlCommandKey, Method method, OutsideSqlContext outsideSqlContext) {
        Object pmb = outsideSqlContext.getParameterBean();
        String procedureName = outsideSqlContext.getOutsideSqlPath();
        InternalProcedureMetaDataFactory factory = this.createInternalProcedureMetaDataFactory();
        factory.setValueTypeFactory(this.valueTypeFactory);
        Class<?> pmbType = pmb != null ? pmb.getClass() : null;
        InternalProcedureMetaData metaData = factory.createProcedureMetaData(procedureName, pmbType);
        InternalProcedureCommand cmd = this.createInternalProcedureCommand(method, metaData);
        this.putSqlCommand(sqlCommandKey, cmd);
    }

    protected InternalProcedureMetaDataFactory createInternalProcedureMetaDataFactory() {
        return new InternalProcedureMetaDataFactory();
    }

    protected InternalProcedureCommand createInternalProcedureCommand(Method method, InternalProcedureMetaData metaData) {
        ResultSetHandler resultSetHandler = this.createResultSetHandler(method);
        return new InternalProcedureCommand(this.dataSource, resultSetHandler, this.statementFactory, metaData);
    }

    protected BeanMetaDataFactory createOutsideSqlCustomizeBeanMetaDataFactory() {
        S2BeanMetaDataFactoryImpl originalBmdFactory = new S2BeanMetaDataFactoryImpl(){

            protected BeanMetaDataImpl createBeanMetaDataImpl() {
                return S2DaoMetaDataExtension.this.newOutsideSqlCustomizeBeanMetaDataImpl();
            }
        };
        originalBmdFactory.setAnnotationReaderFactory(this.annotationReaderFactory);
        originalBmdFactory.setPropertyTypeFactoryBuilder(this.createOutsideSqlPropertyTypeFactoryBuilder());
        originalBmdFactory.setRelationPropertyTypeFactoryBuilder(this.relationPropertyTypeFactoryBuilder);
        originalBmdFactory.setTableNaming(this.tableNaming);
        originalBmdFactory.setDataSource(this.dataSource);
        originalBmdFactory.setDaoNamingConvention(this.daoNamingConvention);
        originalBmdFactory.setBeanEnhancer(this.beanEnhancer);
        return originalBmdFactory;
    }

    protected BeanMetaDataImpl newOutsideSqlCustomizeBeanMetaDataImpl() {
        return new OutsideSqlCustomizeBeanMetaDataImpl();
    }

    protected S2DaoPropertyTypeFactoryBuilderExtension createOutsideSqlPropertyTypeFactoryBuilder() {
        S2DaoPropertyTypeFactoryBuilderExtension impl = new S2DaoPropertyTypeFactoryBuilderExtension();
        if (this.columnNaming == null) {
            String msg = "Internal Error! The columnNaming should not be null! {Failed to Injection!}";
            throw new IllegalStateException(msg);
        }
        impl.setColumnNaming(this.columnNaming);
        impl.setValueTypeFactory(this.valueTypeFactory);
        return impl;
    }

    protected Class getOutsideSqlDefaultBeanClass(Method method) {
        Class<?> retType = method.getReturnType();
        if (List.class.isAssignableFrom(retType)) {
            Class elementType = InternalMethodUtil.getElementTypeOfListFromReturnMethod(method);
            if (elementType != null) {
                return elementType;
            }
            return this.getBeanClass();
        }
        if (retType.isArray()) {
            return retType.getComponentType();
        }
        if (retType.isPrimitive() || !ValueTypes.getValueType(retType).equals(ValueTypes.OBJECT)) {
            return this.getBeanClass();
        }
        return retType;
    }

    protected void registerSqlCommand(String sqlCommandKey, Method method, String sql, String[] argNames, Class[] argTypes, BeanMetaData myBeanMetaData) {
        this.registerSqlCommand(sqlCommandKey, method, sql, argNames, argTypes, this.createResultSetHandler(myBeanMetaData, method));
    }

    protected void registerSqlCommand(String sqlCommandKey, Method method, String sql, String[] argNames, Class[] argTypes, ResultSetHandler myResultSetHandler) {
        S2DaoSelectDynamicCommand cmd = this.createCustomizeSelectDynamicCommand(myResultSetHandler);
        this.registerSqlCommand(sqlCommandKey, method, sql, argNames, argTypes, cmd);
    }

    protected void registerSqlCommand(String sqlCommandKey, Method method, String sql, String[] argNames, Class[] argTypes, S2DaoSelectDynamicCommand cmd) {
        cmd.setSql(sql);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(argTypes);
        this.sqlCommands.put(sqlCommandKey, cmd);
    }

    protected void registerSqlCommand(String sqlCommandKey, Method method, String sql, String[] argNames, Class[] argTypes, InternalUpdateDynamicCommand cmd) {
        cmd.setSql(sql);
        cmd.setArgNames(argNames);
        cmd.setArgTypes(argTypes);
        this.sqlCommands.put(sqlCommandKey, cmd);
    }

    protected void putSqlCommand(String methodName, SqlCommand cmd) {
        this.sqlCommands.put(methodName, cmd);
    }

    protected boolean isCheckSingleRowUpdate(Method method) {
        return this.checkSingleRowUpdateForAll & this.daoAnnotationReader.isCheckSingleRowUpdate(method);
    }

    protected S2DaoSelectDynamicCommand createCustomizeSelectDynamicCommand(ResultSetHandler handler) {
        return new S2DaoSelectDynamicCommand(this.dataSource, this.statementFactory, handler);
    }

    protected ResultSetHandler createResultSetHandler(Method method) {
        return this.resultSetHandlerFactory.getResultSetHandler(this.daoAnnotationReader, this.beanMetaData, method);
    }

    protected ResultSetHandler createResultSetHandler(BeanMetaData specifiedBeanMetaData, Method method) {
        return this.resultSetHandlerFactory.getResultSetHandler(this.daoAnnotationReader, specifiedBeanMetaData, method);
    }

    protected Connection getConnection() {
        if (this.dataSource == null) {
            throw new IllegalStateException("The dataSource should not be null!");
        }
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    protected DatabaseMetaData getMetaData(Connection conn) {
        try {
            return conn.getMetaData();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    protected String getDatabaseProductName(DatabaseMetaData dbMetaData) {
        try {
            return dbMetaData.getDatabaseProductName();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
            return null;
        }
    }

    protected void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            this.handleSQLException(e, null);
        }
    }

    protected void handleSQLException(SQLException e, Statement statement) {
        new InternalBasicHandler.SQLExceptionHandler().handleSQLException(e, statement);
    }

    protected DBMeta findDBMeta() {
        Entity entity;
        Class beanType = this.getBeanClass();
        if (beanType == null) {
            return null;
        }
        if (!Entity.class.isAssignableFrom(beanType)) {
            return null;
        }
        try {
            entity = (Entity)beanType.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        return entity.getDBMeta();
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }

    public String getSqlFileEncoding() {
        return this.sqlFileEncoding;
    }

    public BeanEnhancer getBeanEnhancer() {
        return this.beanEnhancer;
    }

    public void setBeanEnhancer(BeanEnhancer beanEnhancer) {
        this.beanEnhancer = beanEnhancer;
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public ColumnNaming getColumnNaming() {
        return this.columnNaming;
    }

    public void setColumnNaming(ColumnNaming columnNaming) {
        this.columnNaming = columnNaming;
    }

    public PropertyTypeFactoryBuilder getPropertyTypeFactoryBuilder() {
        return this.propertyTypeFactoryBuilder;
    }

    public void setPropertyTypeFactoryBuilder(PropertyTypeFactoryBuilder propertyTypeFactoryBuilder) {
        this.propertyTypeFactoryBuilder = propertyTypeFactoryBuilder;
    }

    public RelationPropertyTypeFactoryBuilder getRelationPropertyTypeFactoryBuilder() {
        return this.relationPropertyTypeFactoryBuilder;
    }

    public void setRelationPropertyTypeFactoryBuilder(RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder) {
        this.relationPropertyTypeFactoryBuilder = relationPropertyTypeFactoryBuilder;
    }

    public TableNaming getTableNaming() {
        return this.tableNaming;
    }

    public void setTableNaming(TableNaming tableNaming) {
        this.tableNaming = tableNaming;
    }

    public BehaviorSelector getBehaviorSelector() {
        return this._behaviorSelector;
    }

    public void setBehaviorSelector(BehaviorSelector behaviorSelector) {
        this._behaviorSelector = behaviorSelector;
    }

    public boolean isInternalDebug() {
        return this._internalDebug;
    }

    public void setInternalDebug(boolean internalDebug) {
        this._internalDebug = internalDebug;
    }

    protected static class InternalMethodUtil {
        protected InternalMethodUtil() {
        }

        public static Class getElementTypeOfListFromReturnMethod(Method method) {
            return InternalReflectionUtil.getElementTypeOfListFromReturnType(method);
        }
    }

    protected class InternalObjectListResultSetHandler
    implements ResultSetHandler {
        private ValueType valueType;

        public InternalObjectListResultSetHandler(ValueType valueType) {
            this.valueType = valueType;
        }

        public Object handle(ResultSet rs) throws SQLException {
            ArrayList<Object> ret = new ArrayList<Object>();
            while (rs.next()) {
                ret.add(this.valueType.getValue(rs, 1));
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InternalReflectionUtil {
        protected InternalReflectionUtil() {
        }

        public static Class<?> getElementTypeOfList(Type parameterizedList) {
            if (!(parameterizedList instanceof ParameterizedType)) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(parameterizedList);
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                return null;
            }
            Class rawClass = (Class)Class.class.cast(rawType);
            if (!rawClass.isAssignableFrom(List.class)) {
                return null;
            }
            Type[] actualTypeArgument = parameterizedType.getActualTypeArguments();
            if (actualTypeArgument == null || actualTypeArgument.length != 1) {
                return null;
            }
            if (!(actualTypeArgument[0] instanceof Class)) {
                return null;
            }
            return (Class)Class.class.cast(actualTypeArgument[0]);
        }

        public static Class<?> getElementTypeOfListFromParameterType(Method method, int parameterPosition) {
            Type[] pmbTypes = method.getGenericParameterTypes();
            return InternalReflectionUtil.getElementTypeOfList(pmbTypes[parameterPosition]);
        }

        public static Class<?> getElementTypeOfListFromReturnType(Method method) {
            return InternalReflectionUtil.getElementTypeOfList(method.getGenericReturnType());
        }
    }

    protected static class OutsideSqlCustomizeBeanMetaDataImpl
    extends BeanMetaDataImpl {
        protected OutsideSqlCustomizeBeanMetaDataImpl() {
        }
    }

    public static class ResultSetHandlerFactoryExtension
    extends ResultSetHandlerFactoryImpl {
        protected RowCreator createRowCreator() {
            return this.createInternalRowCreator(null);
        }

        protected RelationRowCreator createRelationRowCreator() {
            return this.createInternalRelationRowCreator(null);
        }

        protected ResultSetHandler createBeanListMetaDataResultSetHandler(BeanMetaData bmd) {
            InternalRowCreator rowCreator = this.createInternalRowCreator(bmd);
            InternalRelationRowCreator relationRowCreator = this.createInternalRelationRowCreator(bmd);
            return new InternalBeanListMetaDataResultSetHandler(bmd, (RowCreator)rowCreator, (RelationRowCreator)relationRowCreator);
        }

        protected ResultSetHandler createBeanArrayMetaDataResultSetHandler(BeanMetaData bmd) {
            InternalRowCreator rowCreator = this.createInternalRowCreator(bmd);
            InternalRelationRowCreator relationRowCreator = this.createInternalRelationRowCreator(bmd);
            return new InternalBeanArrayMetaDataResultSetHandler(bmd, (RowCreator)rowCreator, (RelationRowCreator)relationRowCreator);
        }

        protected InternalRowCreator createInternalRowCreator(BeanMetaData bmd) {
            Class clazz = bmd != null ? bmd.getBeanClass() : null;
            return InternalRowCreator.createInternalRowCreator(clazz);
        }

        protected InternalRelationRowCreator createInternalRelationRowCreator(BeanMetaData bmd) {
            return new InternalRelationRowCreator();
        }
    }
}

