/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.DBFluteConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.jdbc.StatementConfig;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.FetchNarrowingResultSetFactory;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.S2DaoMetaDataExtension;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqllog.InternalSqlLogRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanEnhancer;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.ColumnNaming;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.DaoNamingConvention;
import org.seasar.dao.DtoMetaDataFactory;
import org.seasar.dao.ProcedureMetaDataFactory;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.RelationPropertyTypeFactoryBuilder;
import org.seasar.dao.ResultSetHandlerFactory;
import org.seasar.dao.TableNaming;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.pager.PagingSqlRewriter;
import org.seasar.extension.dbcp.impl.XADataSourceImpl;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2DaoMetaDataFactoryImpl
implements DaoMetaDataFactory,
Disposable {
    private static final Log _log = LogFactory.getLog(S2DaoMetaDataFactoryImpl.class);
    public static final String xaDataSource_BINDING = "bindingType=may";
    public static final String dataSource_BINDING = "bindingType=must";
    public static final String annotationReaderFactory_BINDING = "bindingType=must";
    public static final String valueTypeFactory_BINDING = "bindingType=must";
    public static final String beanMetaDataFactory_BINDING = "bindingType=must";
    public static final String daoNamingConvention_BINDING = "bindingType=must";
    public static final String resultSetHandlerFactory_BINDING = "bindingType=must";
    public static final String dtoMetaDataFactory_BINDING = "bindingType=must";
    public static final String procedureMetaDataFactory_BINDING = "bindingType=must";
    public static final String pagingSQLRewriter_BINDING = "bindingType=may";
    protected DataSource dataSource;
    protected AnnotationReaderFactory annotationReaderFactory;
    protected ValueTypeFactory valueTypeFactory;
    protected BeanMetaDataFactory beanMetaDataFactory;
    protected DaoNamingConvention daoNamingConvention;
    protected ResultSetHandlerFactory resultSetHandlerFactory;
    protected DtoMetaDataFactory dtoMetaDataFactory;
    protected ProcedureMetaDataFactory procedureMetaDataFactory;
    protected PagingSqlRewriter pagingSqlRewriter;
    protected Map<String, DaoMetaData> daoMetaDataCache = new HashMap<String, DaoMetaData>();
    protected boolean initialized;
    protected boolean useDaoClassForLog;
    protected String sqlFileEncoding;
    protected BeanEnhancer beanEnhancer;
    protected ColumnNaming columnNaming;
    protected PropertyTypeFactoryBuilder propertyTypeFactoryBuilder;
    protected RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder;
    protected TableNaming tableNaming;
    protected Object _daoMetaDataInitializationLockMonitor = new Object();

    public S2DaoMetaDataFactoryImpl(DataSource dataSource, AnnotationReaderFactory annotationReaderFactory, XADataSource xaDataSource) {
        this.dataSource = dataSource;
        this.annotationReaderFactory = annotationReaderFactory;
        _log.info((Object)"/* * * * * * * * * * * * * * * * * * * * * * * * * * * * {DBFlute}");
        this.showInformation(dataSource, xaDataSource);
        ConditionBeanContext.initialize();
        this.initializeDatabaseProductNameOfContext(xaDataSource);
        StringBuilder sb = new StringBuilder();
        sb.append("{SqlLog Information}").append(S2DaoMetaDataFactoryImpl.getLineSeparator());
        sb.append("  [SqlLogRegistry]").append(S2DaoMetaDataFactoryImpl.getLineSeparator());
        Object sqlLogRegistry = InternalSqlLogRegistry.findContainerSqlLogRegistry();
        if (sqlLogRegistry != null) {
            InternalSqlLogRegistry.closeRegistration();
            sb.append("    SqlLogRegistry(org.seasar.extension.jdbc) is close! It's default for DBFlute.").append(S2DaoMetaDataFactoryImpl.getLineSeparator());
            sb.append("    If you want to use this, set SqlLogRegistry to SqlLogRegistryLocator at yourself.");
        } else {
            sb.append("    SqlLogRegistry(org.seasar.extension.jdbc) was not found!");
        }
        _log.info((Object)sb);
        DBFluteConfig.getInstance().lock();
        _log.info((Object)"* * * * */");
    }

    protected void showInformation(DataSource dataSource, XADataSource xaDataSource) {
        StringBuilder sb = new StringBuilder();
        if (xaDataSource != null && xaDataSource instanceof XADataSourceImpl) {
            XADataSourceImpl xaDataSourceImpl = (XADataSourceImpl)xaDataSource;
            String driverClassName = xaDataSourceImpl.getDriverClassName();
            String url = xaDataSourceImpl.getURL();
            String user = xaDataSourceImpl.getUser();
            sb.append("  [XADataSource]:").append(S2DaoMetaDataFactoryImpl.getLineSeparator());
            sb.append("    driver = " + driverClassName).append(S2DaoMetaDataFactoryImpl.getLineSeparator());
            sb.append("    url    = " + url).append(S2DaoMetaDataFactoryImpl.getLineSeparator());
            sb.append("    user   = " + user);
        }
        _log.info((Object)("{Injection Information}" + S2DaoMetaDataFactoryImpl.getLineSeparator() + sb));
    }

    protected void initializeDatabaseProductNameOfContext(XADataSource xaDataSource) {
        XADataSourceImpl xaDataSourceImpl;
        String driverClassName;
        if (this.getDatabaseProductNameFromContext() != null) {
            return;
        }
        if (xaDataSource != null && xaDataSource instanceof XADataSourceImpl && (driverClassName = (xaDataSourceImpl = (XADataSourceImpl)xaDataSource).getDriverClassName()) != null && this.setupDatabaseProductNameByDriverClassName(driverClassName)) {
            _log.info((Object)("...Initializing database product name from driverClassName: " + this.getDatabaseProductNameFromContext()));
            return;
        }
        _log.info((Object)"...Initializing database product name as default: Default");
        this.setDatabaseProductNameToContext("Default");
    }

    protected String getDatabaseProductNameFromContext() {
        return ConditionBeanContext.getDatabaseProductName();
    }

    protected void setDatabaseProductNameToContext(String name) {
        ConditionBeanContext.setDatabaseProductName(name);
    }

    protected boolean setupDatabaseProductNameByDriverClassName(String driverClassName) {
        return ConditionBeanContext.setupDatabaseProductNameByDriverClassName(driverClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaoMetaData getDaoMetaData(Class daoClass) {
        String key;
        DaoMetaData dmd;
        if (!this.initialized) {
            DisposableUtil.add((Disposable)this);
            this.initialized = true;
        }
        if ((dmd = this.getSynchronizedDaoMetaDataCache(key = daoClass.getName())) != null) {
            return dmd;
        }
        Object object = this._daoMetaDataInitializationLockMonitor;
        synchronized (object) {
            dmd = this.getSynchronizedDaoMetaDataCache(key);
            if (dmd != null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"...Getting daoMetaData as cache because the previous thread have already initilized.");
                }
                return dmd;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("...Creating daoMetaData for " + daoClass.getSimpleName() + "."));
            }
            DaoMetaData dmdi = this.createDaoMetaData(daoClass);
            this.putSynchronizedDaoMetaDataCache(key, dmdi);
        }
        dmd = this.getSynchronizedDaoMetaDataCache(key);
        if (dmd != null) {
            return dmd;
        }
        String msg = "The cache should have data meta data here: key=" + key + " cache=" + this.daoMetaDataCache;
        throw new IllegalStateException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSynchronizedDaoMetaDataCache(String key, DaoMetaData dmd) {
        Map<String, DaoMetaData> map = this.daoMetaDataCache;
        synchronized (map) {
            this.daoMetaDataCache.put(key, dmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DaoMetaData getSynchronizedDaoMetaDataCache(String key) {
        DaoMetaData dmd = null;
        Map<String, DaoMetaData> map = this.daoMetaDataCache;
        synchronized (map) {
            dmd = this.daoMetaDataCache.get(key);
        }
        return dmd;
    }

    protected DaoMetaData createDaoMetaData(Class<?> daoClass) {
        BeanDesc daoBeanDesc = BeanDescFactory.getBeanDesc(daoClass);
        DaoAnnotationReader daoAnnotationReader = this.annotationReaderFactory.createDaoAnnotationReader(daoBeanDesc);
        S2DaoMetaDataExtension daoMetaData = this.createDaoMetaDataExtension();
        daoMetaData.setDaoClass(daoClass);
        daoMetaData.setDataSource(this.dataSource);
        daoMetaData.setStatementFactory(this.createCustomizeStatememtFactory());
        daoMetaData.setResultSetFactory(this.createCustomizeResultSetFactory());
        daoMetaData.setValueTypeFactory(this.valueTypeFactory);
        daoMetaData.setBeanMetaDataFactory(this.getBeanMetaDataFactory());
        daoMetaData.setDaoNamingConvention(this.getDaoNamingConvention());
        daoMetaData.setUseDaoClassForLog(this.useDaoClassForLog);
        daoMetaData.setDaoAnnotationReader(daoAnnotationReader);
        daoMetaData.setProcedureMetaDataFactory(this.procedureMetaDataFactory);
        daoMetaData.setDtoMetaDataFactory(this.dtoMetaDataFactory);
        daoMetaData.setResultSetHandlerFactory(this.resultSetHandlerFactory);
        if (this.sqlFileEncoding != null) {
            daoMetaData.setSqlFileEncoding(this.sqlFileEncoding);
        }
        if (this.pagingSqlRewriter != null) {
            daoMetaData.setPagingSQLRewriter(this.pagingSqlRewriter);
        }
        daoMetaData.initialize();
        return daoMetaData;
    }

    protected S2DaoMetaDataExtension createDaoMetaDataExtension() {
        S2DaoMetaDataExtension dmdExtension = this.newDaoMetaDataExtension();
        dmdExtension.setBeanEnhancer(this.beanEnhancer);
        dmdExtension.setAnnotationReaderFactory(this.annotationReaderFactory);
        dmdExtension.setColumnNaming(this.columnNaming);
        dmdExtension.setPropertyTypeFactoryBuilder(this.propertyTypeFactoryBuilder);
        dmdExtension.setRelationPropertyTypeFactoryBuilder(this.relationPropertyTypeFactoryBuilder);
        dmdExtension.setTableNaming(this.tableNaming);
        dmdExtension.setInternalDebug(DBFluteConfig.getInstance().isInternalDebug());
        return dmdExtension;
    }

    protected S2DaoMetaDataExtension newDaoMetaDataExtension() {
        return new S2DaoMetaDataExtension();
    }

    protected ResultSetFactory createCustomizeResultSetFactory() {
        return new FetchNarrowingResultSetFactory();
    }

    protected StatementFactory createCustomizeStatememtFactory() {
        final StatementConfig defaultStatementConfig = DBFluteConfig.getInstance().getDefaultStatementConfig();
        final boolean internalDebug = DBFluteConfig.getInstance().isInternalDebug();
        return new StatementFactory(){

            public PreparedStatement createPreparedStatement(Connection con, String sql) {
                try {
                    StatementConfig config = this.findStatementConfigOnThread();
                    int resultSetType = config != null && config.hasResultSetType() ? config.getResultSetType() : (defaultStatementConfig != null && defaultStatementConfig.hasResultSetType() ? defaultStatementConfig.getResultSetType() : 1003);
                    int resultSetConcurrency = 1007;
                    if (internalDebug) {
                        _log.debug((Object)("...Creating prepareStatement(sql, " + resultSetType + ", " + 1007 + ")"));
                    }
                    PreparedStatement ps = con.prepareStatement(sql, resultSetType, 1007);
                    if (config != null && config.hasStatementOptions()) {
                        if (internalDebug) {
                            _log.debug((Object)("...Setting statement config as request: " + config));
                        }
                        this.reflectStatementOptions(config, ps);
                    } else {
                        this.reflectDefaultOptionsToStatementIfNeeds(ps);
                    }
                    return ps;
                }
                catch (SQLException e) {
                    this.handleSQLException(e, null);
                    return null;
                }
            }

            public CallableStatement createCallableStatement(Connection conn, String sql) {
                return this.prepareCall(conn, sql);
            }

            protected StatementConfig findStatementConfigOnThread() {
                StatementConfig config;
                if (ConditionBeanContext.isExistConditionBeanOnThread()) {
                    ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
                    config = cb.getStatementConfig();
                } else if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
                    OutsideSqlContext context = OutsideSqlContext.getOutsideSqlContextOnThread();
                    config = context.getStatementConfig();
                } else {
                    config = null;
                }
                return config;
            }

            protected void reflectDefaultOptionsToStatementIfNeeds(PreparedStatement ps) {
                if (defaultStatementConfig != null && defaultStatementConfig.hasStatementOptions()) {
                    if (internalDebug) {
                        _log.debug((Object)("...Setting statement config as default: " + defaultStatementConfig));
                    }
                    this.reflectStatementOptions(defaultStatementConfig, ps);
                    return;
                }
            }

            protected void reflectStatementOptions(StatementConfig config, PreparedStatement ps) {
                try {
                    if (config.hasQueryTimeout()) {
                        ps.setQueryTimeout(config.getQueryTimeout());
                    }
                    if (config.hasFetchSize()) {
                        ps.setFetchSize(config.getFetchSize());
                    }
                    if (config.hasMaxRows()) {
                        ps.setMaxRows(config.getMaxRows());
                    }
                }
                catch (SQLException e) {
                    this.handleSQLException(e, ps);
                }
            }

            protected CallableStatement prepareCall(Connection conn, String sql) {
                try {
                    return conn.prepareCall(sql);
                }
                catch (SQLException e) {
                    this.handleSQLException(e, null);
                    return null;
                }
            }

            protected void handleSQLException(SQLException e, Statement statement) {
                new InternalBasicHandler.SQLExceptionHandler().handleSQLException(e, statement);
            }
        };
    }

    public synchronized void dispose() {
        this.daoMetaDataCache.clear();
        this.initialized = false;
    }

    protected static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    protected BeanMetaDataFactory getBeanMetaDataFactory() {
        return this.beanMetaDataFactory;
    }

    public void setBeanMetaDataFactory(BeanMetaDataFactory beanMetaDataFactory) {
        this.beanMetaDataFactory = beanMetaDataFactory;
    }

    public DaoNamingConvention getDaoNamingConvention() {
        return this.daoNamingConvention;
    }

    public void setDaoNamingConvention(DaoNamingConvention daoNamingConvention) {
        this.daoNamingConvention = daoNamingConvention;
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setUseDaoClassForLog(boolean userDaoClassForLog) {
        this.useDaoClassForLog = userDaoClassForLog;
    }

    public void setResultSetHandlerFactory(ResultSetHandlerFactory resultSetHandlerFactory) {
        this.resultSetHandlerFactory = resultSetHandlerFactory;
    }

    public void setDtoMetaDataFactory(DtoMetaDataFactory dtoMetaDataFactory) {
        this.dtoMetaDataFactory = dtoMetaDataFactory;
    }

    public void setProcedureMetaDataFactory(ProcedureMetaDataFactory procedureMetaDataFactory) {
        this.procedureMetaDataFactory = procedureMetaDataFactory;
    }

    public void setPagingSQLRewriter(PagingSqlRewriter pagingSqlRewriter) {
        this.pagingSqlRewriter = pagingSqlRewriter;
    }

    public String getSqlFileEncoding() {
        return this.sqlFileEncoding;
    }

    public void setSqlFileEncoding(String encoding) {
        this.sqlFileEncoding = encoding;
    }

    public BeanEnhancer getBeanEnhancer() {
        return this.beanEnhancer;
    }

    public void setBeanEnhancer(BeanEnhancer beanEnhancer) {
        this.beanEnhancer = beanEnhancer;
    }

    public ColumnNaming getColumnNaming() {
        return this.columnNaming;
    }

    public void setColumnNaming(ColumnNaming columnNaming) {
        this.columnNaming = columnNaming;
    }

    public PropertyTypeFactoryBuilder getPropertyTypeFactoryBuilder() {
        return this.propertyTypeFactoryBuilder;
    }

    public void setPropertyTypeFactoryBuilder(PropertyTypeFactoryBuilder propertyTypeFactoryBuilder) {
        this.propertyTypeFactoryBuilder = propertyTypeFactoryBuilder;
    }

    public RelationPropertyTypeFactoryBuilder getRelationPropertyTypeFactoryBuilder() {
        return this.relationPropertyTypeFactoryBuilder;
    }

    public void setRelationPropertyTypeFactoryBuilder(RelationPropertyTypeFactoryBuilder relationPropertyTypeFactoryBuilder) {
        this.relationPropertyTypeFactoryBuilder = relationPropertyTypeFactoryBuilder;
    }

    public TableNaming getTableNaming() {
        return this.tableNaming;
    }

    public void setTableNaming(TableNaming tableNaming) {
        this.tableNaming = tableNaming;
    }
}

