/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ea2ddl.dao.allcommon.s2dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBean;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.ConditionBeanContext;
import jp.sourceforge.ea2ddl.dao.allcommon.cbean.outsidesql.OutsideSqlContext;
import jp.sourceforge.ea2ddl.dao.allcommon.jdbc.CursorHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlcommand.InternalAbstractDynamicCommand;
import jp.sourceforge.ea2ddl.dao.allcommon.s2dao.internal.sqlhandler.InternalBasicSelectHandler;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleStringUtil;
import jp.sourceforge.ea2ddl.dao.allcommon.util.SimpleSystemUtil;
import org.seasar.dao.CommandContext;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2DaoSelectDynamicCommand
extends InternalAbstractDynamicCommand {
    protected ResultSetHandler resultSetHandler;

    public S2DaoSelectDynamicCommand(DataSource dataSource, StatementFactory statementFactory, ResultSetHandler resultSetHandler) {
        super(dataSource, statementFactory);
        this.resultSetHandler = resultSetHandler;
    }

    protected S2DaoSelectDynamicCommand createMySelectDynamicCommand() {
        return new S2DaoSelectDynamicCommand(this.getDataSource(), this.getStatementFactory(), this.resultSetHandler);
    }

    public Object execute(Object[] args) {
        String finalClause;
        if (!ConditionBeanContext.isExistConditionBeanOnThread()) {
            if (OutsideSqlContext.isExistOutsideSqlContextOnThread()) {
                OutsideSqlContext outsideSqlContext = OutsideSqlContext.getOutsideSqlContextOnThread();
                if (outsideSqlContext.isDynamicBinding()) {
                    return this.executeOutsideSqlAsDynamic(args, outsideSqlContext);
                }
                return this.executeOutsideSqlAsStatic(args, outsideSqlContext);
            }
            return this.executeDefault(args);
        }
        ArrayList<Object> bindVariableList = new ArrayList<Object>(4);
        ArrayList<Class> bindVariableTypeList = new ArrayList<Class>(4);
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        if (cb.hasUnionQueryOrUnionAllQuery()) {
            String realClause = this.setupRealClause(args, bindVariableList, bindVariableTypeList);
            finalClause = cb.isSelectCountIgnoreFetchScope() ? "select count(*) from (" + realClause + ") dfmain" : realClause;
        } else {
            finalClause = cb.isSelectCountIgnoreFetchScope() ? this.setupRealSelectCountClause(args, bindVariableList, bindVariableTypeList) : this.setupRealClause(args, bindVariableList, bindVariableTypeList);
        }
        InternalBasicSelectHandler selectHandler = this.createBasicSelectHandler(finalClause, this.resultSetHandler);
        Object[] bindVariableArray = bindVariableList.toArray();
        selectHandler.setLoggingMessageSqlArgs(bindVariableArray);
        return selectHandler.execute(bindVariableArray, this.toClassArray(bindVariableTypeList));
    }

    protected Object executeDefault(Object[] args) {
        ResultSetHandler specifiedResultSetHandler = this.findSpecifiedResultSetHandler(args);
        Object[] filteredArgs = this.filterArgumentsForResultSetHandler(args);
        CommandContext ctx = this.apply(filteredArgs);
        InternalBasicSelectHandler selectHandler = this.createBasicSelectHandler(ctx.getSql(), specifiedResultSetHandler);
        Object[] bindVariableArray = ctx.getBindVariables();
        selectHandler.setLoggingMessageSqlArgs(bindVariableArray);
        return selectHandler.execute(bindVariableArray, ctx.getBindVariableTypes());
    }

    protected Object executeOutsideSqlAsStatic(Object[] args, OutsideSqlContext outsideSqlContext) {
        Object[] filteredArgs;
        ResultSetHandler specifiedResultSetHandler = this.findSpecifiedResultSetHandler(args);
        if (outsideSqlContext.isSpecifiedOutsideSql()) {
            Object parameterBean = outsideSqlContext.getParameterBean();
            filteredArgs = new Object[]{parameterBean};
        } else {
            filteredArgs = this.filterArgumentsForResultSetHandler(args);
        }
        CommandContext ctx = this.apply(filteredArgs);
        InternalBasicSelectHandler selectHandler = this.createBasicSelectHandler(ctx.getSql(), specifiedResultSetHandler);
        Object[] bindVariableArray = ctx.getBindVariables();
        selectHandler.setLoggingMessageSqlArgs(bindVariableArray);
        return selectHandler.execute(bindVariableArray, ctx.getBindVariableTypes());
    }

    protected Object executeOutsideSqlAsDynamic(Object[] args, OutsideSqlContext outsideSqlContext) {
        Object[] filteredArgs;
        Object parameterBean;
        Object firstArg = outsideSqlContext.isSpecifiedOutsideSql() ? (parameterBean = outsideSqlContext.getParameterBean()) : args[0];
        String filteredSql = this.getSql();
        if (firstArg != null) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(firstArg.getClass());
            int i = 0;
            while (i < beanDesc.getPropertyDescSize()) {
                String outsideSqlPiece;
                PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
                Class propertyType = propertyDesc.getPropertyType();
                if (propertyType.equals(String.class) && (outsideSqlPiece = (String)propertyDesc.getValue(firstArg)) != null) {
                    String embeddedComment = "/*$pmb." + propertyDesc.getPropertyName() + "*/";
                    filteredSql = this.replaceString(filteredSql, embeddedComment, outsideSqlPiece);
                }
                ++i;
            }
        }
        S2DaoSelectDynamicCommand outsideSqlCommand = this.createMySelectDynamicCommand();
        if (outsideSqlContext.isSpecifiedOutsideSql()) {
            outsideSqlCommand.setArgNames(new String[]{"pmb"});
            outsideSqlCommand.setArgTypes(new Class[]{firstArg != null ? firstArg.getClass() : Object.class});
        } else {
            outsideSqlCommand.setArgNames(this.getArgNames());
            outsideSqlCommand.setArgTypes(this.getArgTypes());
        }
        outsideSqlCommand.setSql(filteredSql);
        ResultSetHandler specifiedResultSetHandler = this.findSpecifiedResultSetHandler(args);
        if (outsideSqlContext.isSpecifiedOutsideSql()) {
            Object parameterBean2 = outsideSqlContext.getParameterBean();
            filteredArgs = new Object[]{parameterBean2};
        } else {
            filteredArgs = this.filterArgumentsForResultSetHandler(args);
        }
        CommandContext ctx = outsideSqlCommand.apply(filteredArgs);
        ArrayList<Object> bindVariableList = new ArrayList<Object>();
        ArrayList<Class> bindVariableTypeList = new ArrayList<Class>();
        this.addBindVariableInfo(ctx, bindVariableList, bindVariableTypeList);
        InternalBasicSelectHandler selectHandler = this.createBasicSelectHandler(ctx.getSql(), specifiedResultSetHandler);
        Object[] bindVariableArray = bindVariableList.toArray();
        selectHandler.setLoggingMessageSqlArgs(bindVariableArray);
        return selectHandler.execute(bindVariableArray, this.toClassArray(bindVariableTypeList));
    }

    protected Object[] filterArgumentsForResultSetHandler(Object[] args) {
        Object[] filteredArgs;
        if (args == null || args.length == 0) {
            return args;
        }
        if (args[args.length - 1] instanceof CursorHandler) {
            filteredArgs = new Object[args.length - 1];
            int i = 0;
            while (i < args.length - 1) {
                filteredArgs[i] = args[i];
                ++i;
            }
        } else {
            filteredArgs = args;
        }
        return filteredArgs;
    }

    protected ResultSetHandler findSpecifiedResultSetHandler(Object[] args) {
        if (args == null || args.length == 0) {
            return this.resultSetHandler;
        }
        if (args[args.length - 1] instanceof CursorHandler) {
            final CursorHandler cursorHandler = (CursorHandler)args[args.length - 1];
            return new ResultSetHandler(){

                public Object handle(ResultSet rs) throws SQLException {
                    return cursorHandler.handle(rs);
                }
            };
        }
        if (this.getArgTypes().length + 1 == args.length && args[args.length - 1] == null) {
            String msg = "System Level Exception!" + this.getLineSeparator();
            msg = String.valueOf(msg) + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.getLineSeparator();
            msg = String.valueOf(msg) + "The size of arg types have not been same as the size of arg objects:";
            msg = String.valueOf(msg) + " argTypes=" + this.getArgTypes().length + " args=" + args.length + this.getLineSeparator();
            msg = String.valueOf(msg) + "If the arguments contain ResultSetHandler, the argument value should not be null!" + this.getLineSeparator();
            int i = 0;
            while (i < args.length - 1) {
                msg = String.valueOf(msg) + "  args[" + i + "] -- " + args[i] + this.getLineSeparator();
                ++i;
            }
            msg = String.valueOf(msg) + "* * * * * * * * * */" + this.getLineSeparator();
            throw new IllegalStateException(msg);
        }
        return this.resultSetHandler;
    }

    protected String setupRealClause(Object[] args, List<Object> bindVariableList, List<Class> bindVariableTypeList) {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        S2DaoSelectDynamicCommand dynamicCommand = this.createMySelectDynamicCommand();
        dynamicCommand.setArgNames(this.getArgNames());
        dynamicCommand.setArgTypes(this.getArgTypes());
        if (cb.isLimitSelect_PKOnly()) {
            dynamicCommand.setSql(cb.getSqlClause().getClausePKOnly());
        } else {
            dynamicCommand.setSql(cb.getSqlClause().getClause());
        }
        CommandContext ctx = dynamicCommand.apply(args);
        String realClause = ctx.getSql();
        this.addBindVariableInfo(ctx, bindVariableList, bindVariableTypeList);
        return realClause;
    }

    protected String setupRealSelectCountClause(Object[] args, List<Object> bindVariableList, List<Class> bindVariableTypeList) {
        ConditionBean cb = ConditionBeanContext.getConditionBeanOnThread();
        S2DaoSelectDynamicCommand selectCountCommand = this.createMySelectDynamicCommand();
        selectCountCommand.setArgNames(this.getArgNames());
        selectCountCommand.setArgTypes(this.getArgTypes());
        String selectClause = "select count(*)";
        String fromWhereClause = cb.getSqlClause().getClauseFromWhereWithUnionTemplate();
        fromWhereClause = this.replaceString(fromWhereClause, cb.getSqlClause().getUnionSelectClauseMark(), "select count(*)");
        fromWhereClause = this.replaceString(fromWhereClause, cb.getSqlClause().getUnionWhereClauseMark(), "");
        fromWhereClause = this.replaceString(fromWhereClause, cb.getSqlClause().getUnionWhereFirstConditionMark(), "");
        String sql = cb.getSqlClause().filterSubQueryIndent("select count(*) " + fromWhereClause);
        selectCountCommand.setSql(sql);
        CommandContext ctx = selectCountCommand.apply(args);
        String realSelectCountClause = ctx.getSql();
        this.addBindVariableInfo(ctx, bindVariableList, bindVariableTypeList);
        return realSelectCountClause;
    }

    protected InternalBasicSelectHandler createBasicSelectHandler(String realSql, ResultSetHandler specifiedResultSetHandler) {
        return this.newBasicSelectHandler(realSql, specifiedResultSetHandler, this.getStatementFactory());
    }

    protected InternalBasicSelectHandler newBasicSelectHandler(String sql, ResultSetHandler resultSetHandler, StatementFactory statementFactory) {
        return new InternalBasicSelectHandler(this.getDataSource(), sql, resultSetHandler, statementFactory){

            protected void bindArgs(PreparedStatement ps, Object[] args, Class[] argTypes) {
                if (args == null) {
                    return;
                }
                int i = 0;
                while (i < args.length) {
                    ValueType valueType = this.findValueType(argTypes[i], args[i]);
                    try {
                        valueType.bindValue(ps, i + 1, args[i]);
                    }
                    catch (SQLException e) {
                        this.handleSQLException(e, ps);
                    }
                    ++i;
                }
            }

            protected ValueType findValueType(Class argType, Object arg) {
                ValueType valueType = ValueTypes.getValueType((Object)arg);
                if (valueType != null) {
                    return valueType;
                }
                valueType = ValueTypes.getValueType((Class)argType);
                if (valueType != null) {
                    return valueType;
                }
                String msg = "Unknown type\uff1aargType=" + argType + " args=" + arg;
                throw new IllegalStateException(msg);
            }
        };
    }

    protected Class[] toClassArray(List<Class> bindVariableTypeList) {
        Class[] bindVariableTypesArray = new Class[bindVariableTypeList.size()];
        int i = 0;
        while (i < bindVariableTypeList.size()) {
            Class bindVariableType;
            bindVariableTypesArray[i] = bindVariableType = bindVariableTypeList.get(i);
            ++i;
        }
        return bindVariableTypesArray;
    }

    protected void addBindVariableInfo(CommandContext ctx, List<Object> bindVariableList, List<Class> bindVariableTypeList) {
        Object[] bindVariables = ctx.getBindVariables();
        this.addBindVariableList(bindVariableList, bindVariables);
        Class[] bindVariableTypes = ctx.getBindVariableTypes();
        this.addBindVariableTypeList(bindVariableTypeList, bindVariableTypes);
    }

    protected void addBindVariableList(List<Object> bindVariableList, Object[] bindVariables) {
        int i = 0;
        while (i < bindVariables.length) {
            bindVariableList.add(bindVariables[i]);
            ++i;
        }
    }

    protected void addBindVariableTypeList(List<Class> bindVariableTypeList, Class[] bindVariableTypes) {
        int i = 0;
        while (i < bindVariableTypes.length) {
            bindVariableTypeList.add(bindVariableTypes[i]);
            ++i;
        }
    }

    protected final String replaceString(String text, String fromText, String toText) {
        return SimpleStringUtil.replace(text, fromText, toText);
    }

    protected String getLineSeparator() {
        return SimpleSystemUtil.getLineSeparator();
    }
}

